/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class RelayAction
extends AbstractAction
implements PropertyChangeListener {
    private boolean allowEnable = true;
    private Action targetAction;

    public RelayAction() {
        this((Action)null);
    }

    public RelayAction(Action targetAction) {
        this.setTargetAction(targetAction);
    }

    @Override
    public Object getValue(String key) {
        Object result = super.getValue(key);
        if (result == null && this.targetAction != null) {
            result = this.targetAction.getValue(key);
        }
        return result;
    }

    public Action getTargetAction() {
        return this.targetAction;
    }

    public final void setTargetAction(Action newTargetAction) {
        if (this.targetAction != null) {
            this.targetAction.removePropertyChangeListener(this);
        }
        this.targetAction = newTargetAction;
        if (this.targetAction != null) {
            this.targetAction.addPropertyChangeListener(this);
        }
        this.setEnabledInternal();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (this.targetAction != null && event.getSource() == this.targetAction && "enabled".equals(event.getPropertyName())) {
            this.setEnabledInternal();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.targetAction != null && this.targetAction.isEnabled()) {
            this.targetAction.actionPerformed(event);
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.allowEnable && this.targetAction.isEnabled();
    }

    @Override
    public void setEnabled(boolean allowEnable) {
        this.allowEnable = allowEnable;
        this.setEnabledInternal();
    }

    private void setEnabledInternal() {
        super.setEnabled(this.allowEnable && this.targetAction != null && this.targetAction.isEnabled());
    }
}

