/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.util.Comparator;
import java.util.Objects;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import modelobjects.util.DefaultComparator;
import modelobjects.util.ReverseComparator;
import modelobjects.util.swing.ModelPropertyTableColumn;

public abstract class TableColumnAdapter {
    private String headerLabel;
    private boolean editable;
    private Class columnClass;
    private int minWidth;
    private int maxWidth;
    private int prefWidth;
    private Comparator columnComparator;
    private Comparator rowComparator;
    private Comparator reverseRowComparator;
    private boolean columnIsSortable;
    private TableCellRenderer cellRenderer;
    private TableCellEditor cellEditor;

    protected TableColumnAdapter(String headerLabel, boolean editable, Class columnClass, int minimumWidth, int preferredWidth, int maximumWidth) {
        this(headerLabel, editable, columnClass, minimumWidth, preferredWidth, maximumWidth, null, null);
    }

    protected TableColumnAdapter(String headerLabel, boolean editable, Class columnClass, int minimumWidth, int preferredWidth, int maximumWidth, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.headerLabel = headerLabel;
        this.editable = editable;
        this.columnClass = columnClass;
        this.minWidth = minimumWidth;
        this.prefWidth = preferredWidth;
        this.maxWidth = maximumWidth;
        this.cellEditor = cellEditor;
        this.cellRenderer = cellRenderer;
        this.columnIsSortable = true;
    }

    public abstract Object getColumnValue(Object var1, int var2);

    public abstract void setColumnValue(Object var1, Object var2);

    public String getHeaderLabel() {
        return this.headerLabel;
    }

    public void setHeaderLabel(String headerLabel) {
        this.headerLabel = headerLabel;
    }

    public boolean isColumnEditable(Object rowModel) {
        return this.editable;
    }

    public void setColumnEditable(boolean editable) {
        this.editable = editable;
    }

    public Class getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(Class columnClass) {
        this.columnClass = columnClass;
    }

    public int getMinimumWidth() {
        return this.minWidth;
    }

    public void setMinimumWidth(int w) {
        this.minWidth = w;
    }

    public int getMaximumWidth() {
        return this.maxWidth;
    }

    public void setMaximumWidth(int w) {
        this.maxWidth = w;
    }

    public int getPreferredWidth() {
        return this.prefWidth;
    }

    public void setPreferredWidth(int w) {
        this.prefWidth = w;
    }

    public final TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public final void setCellRenderer(TableCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public ModelPropertyTableColumn makeModelPropertyTableColumn(int modelIndex) {
        return new ModelPropertyTableColumn(modelIndex, this);
    }

    public Comparator getColumnComparator() {
        if (this.columnComparator == null) {
            this.columnComparator = DefaultComparator.getInstance();
        }
        return this.columnComparator;
    }

    public void setColumnComparator(Comparator columnComparator) {
        this.columnComparator = columnComparator;
        this.rowComparator = new DefaultRowComparator(this);
        this.reverseRowComparator = ReverseComparator.makeReverseComparator(this.rowComparator);
    }

    public Comparator getRowComparator() {
        if (this.rowComparator == null) {
            this.rowComparator = new DefaultRowComparator(this);
            this.reverseRowComparator = ReverseComparator.makeReverseComparator(this.rowComparator);
        }
        return this.rowComparator;
    }

    public void setRowComparator(Comparator rowComparator) {
        this.rowComparator = rowComparator;
        this.reverseRowComparator = ReverseComparator.makeReverseComparator(rowComparator);
    }

    public Comparator getReverseRowComparator() {
        return this.reverseRowComparator;
    }

    public boolean isColumnSortable() {
        return this.columnIsSortable;
    }

    public void setColumnSortable(boolean sortable) {
        this.columnIsSortable = sortable;
    }

    public String toString() {
        return this.headerLabel;
    }

    public static class DefaultRowComparator
    implements Comparator {
        private TableColumnAdapter columnAdapter;
        private Comparator columnComparator;

        public DefaultRowComparator(TableColumnAdapter columnAdapter) {
            this.columnAdapter = columnAdapter;
            this.columnComparator = columnAdapter.getColumnComparator();
        }

        public int compare(Object row1, Object row2) {
            Object cell1 = this.columnAdapter.getColumnValue(row1, 0);
            Object cell2 = this.columnAdapter.getColumnValue(row2, 0);
            return this.columnComparator.compare(cell1, cell2);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj != null && this.getClass() == obj.getClass()) {
                DefaultRowComparator that = (DefaultRowComparator)obj;
                return this.columnAdapter == that.columnAdapter && this.columnComparator.equals(that.columnComparator);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.columnAdapter, this.columnComparator);
        }
    }
}

