/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import modelobjects.util.swing.IModelTableModel;

public class TableSorter
extends MouseAdapter {
    private JTable table;
    private boolean popupTrigger;

    public TableSorter(JTable table) {
        this.table = table;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.popupTrigger = event.isPopupTrigger();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.popupTrigger = event.isPopupTrigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.popupTrigger || event.getClickCount() != 1) {
            return;
        }
        IModelTableModel dm = (IModelTableModel)this.table.getModel();
        TableColumnModel cm = this.table.getColumnModel();
        int viewColumn = cm.getColumnIndexAtX(event.getX());
        int modelColumn = this.table.convertColumnIndexToModel(viewColumn);
        if (modelColumn != -1) {
            Object[] selectedObjects = this.getSelectedObjects(dm);
            try {
                this.table.getSelectionModel().setValueIsAdjusting(true);
                this.table.clearSelection();
                dm.sortByColumn(modelColumn);
                this.restoreObjectSelection(selectedObjects, dm);
            }
            finally {
                this.table.getSelectionModel().setValueIsAdjusting(false);
            }
            this.table.getTableHeader().repaint();
        }
    }

    protected Object[] getSelectedObjects(IModelTableModel tableModel) {
        int[] selectedRows = this.table.getSelectedRows();
        int num = selectedRows.length;
        Object[] selectedObjects = new Object[num];
        for (int i = 0; i < num; ++i) {
            selectedObjects[i] = tableModel.getRowModel(selectedRows[i]);
        }
        return selectedObjects;
    }

    protected void restoreObjectSelection(Object[] selectedObjects, IModelTableModel tableModel) {
        for (Object obj : selectedObjects) {
            int row;
            int n = row = obj == null ? -1 : tableModel.getIndexOf(obj);
            if (row < 0) continue;
            this.table.getSelectionModel().setValueIsAdjusting(true);
            this.table.addRowSelectionInterval(row, row);
        }
    }
}

