/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.swing;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TimeCodeCellEditor
extends DefaultCellEditor {
    private JTextField textField;
    private FieldValidator validator;
    private static Color GOOD = Color.white;
    private static Color BAD = new Color(255, 160, 160);
    private static DecimalFormat format1 = new DecimalFormat("#0");
    private static DecimalFormat format2 = new DecimalFormat("00");
    private static DecimalFormat format3 = new DecimalFormat("00.000");

    public static TimeCodeCellEditor makeInstance(int minSeconds, int maxSeconds) {
        return TimeCodeCellEditor.makeInstance(UIManager.getFont("TextField.font"), true, minSeconds, maxSeconds);
    }

    public static TimeCodeCellEditor makeInstance(Font font) {
        return TimeCodeCellEditor.makeInstance(font, false, 0.0, 86400.0);
    }

    public static TimeCodeCellEditor makeInstance(Font font, boolean wholeSeconds, double minSeconds, double maxSeconds) {
        JTextField textField = new JTextField(10);
        textField.setFont(font);
        textField.setHorizontalAlignment(4);
        FieldValidator validator = new FieldValidator(textField, wholeSeconds, minSeconds, maxSeconds);
        textField.getDocument().addDocumentListener(validator);
        return new TimeCodeCellEditor(textField, validator);
    }

    private TimeCodeCellEditor(JTextField textField, FieldValidator validator) {
        super(textField);
        this.textField = textField;
        this.validator = validator;
        this.setProperties();
    }

    private void setProperties() {
        this.setClickCountToStart(1);
        this.setTimeInSeconds(0.0);
    }

    public void setTimeInSeconds(double timeInSeconds) {
        if (timeInSeconds < 0.0) {
            throw new IllegalArgumentException("value must be non-negative");
        }
        this.textField.setText(TimeCodeCellEditor.getTimeString(timeInSeconds, this.validator.getWholeSeconds()));
    }

    public double getTimeInSeconds() {
        String text = this.textField.getText();
        if (!this.validator.checkText(text)) {
            throw new NumberFormatException(text + "is not a valid number");
        }
        if (!this.validator.checkRange(text)) {
            throw new NumberFormatException("'" + text + "' is outside the valid range of " + (long)this.validator.getMinSeconds() + " to " + (long)this.validator.getMaxSeconds());
        }
        return TimeCodeCellEditor.parseTimeIndex(text);
    }

    public static double parseTimeIndex(String timeString) {
        if (timeString == null || timeString.length() == 0) {
            return -1.0;
        }
        StringTokenizer toks = new StringTokenizer(timeString, ":.", true);
        double time = 0.0;
        int lastType = 0;
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            int c1 = tok.charAt(0);
            if (c1 == 58 || c1 == 46) {
                lastType = c1;
                continue;
            }
            time = lastType == 46 ? (time += Double.parseDouble("0." + tok)) : time * 60.0 + Double.parseDouble(tok);
            lastType = 49;
        }
        return time;
    }

    public static String getTimeString(double timeInSeconds, boolean wholeSeconds) {
        if (wholeSeconds) {
            return TimeCodeCellEditor.formatTime(timeInSeconds, format1, format2, format2);
        }
        return TimeCodeCellEditor.formatTime(timeInSeconds, format1, format2, format3);
    }

    public static String formatTime(double timeInSeconds, DecimalFormat hoursFormat, DecimalFormat minutesFormat, DecimalFormat secondsFormat) {
        if (timeInSeconds < 0.0) {
            return Double.toString(timeInSeconds);
        }
        long wholeSecs = (long)timeInSeconds;
        long hours = wholeSecs / 3600L;
        long minutes = wholeSecs / 60L % 60L;
        long justSecs = wholeSecs % 60L;
        double seconds = timeInSeconds - (double)wholeSecs + (double)justSecs;
        return hoursFormat.format(hours) + ":" + minutesFormat.format(minutes) + ":" + secondsFormat.format(seconds);
    }

    static class FieldValidator
    implements DocumentListener {
        private JTextField textField;
        private boolean wholeSeconds;
        private double minSeconds;
        private double maxSeconds;

        FieldValidator(JTextField textField, boolean wholeSeconds, double minSeconds, double maxSeconds) {
            this.textField = textField;
            this.wholeSeconds = wholeSeconds;
            this.minSeconds = minSeconds;
            this.maxSeconds = maxSeconds;
        }

        void checkDoc() {
            Color background = this.textField.getBackground();
            if (this.checkText(this.textField.getText()) && this.checkRange(this.textField.getText())) {
                if (background != GOOD) {
                    this.textField.setBackground(GOOD);
                }
            } else if (background != BAD) {
                this.textField.setBackground(BAD);
            }
        }

        boolean checkText(String text) {
            int n = text.length();
            for (int i = 0; i < n; ++i) {
                char c = text.charAt(i);
                if (c == ':' || c == '.' || c >= '0' && c <= '9') continue;
                return false;
            }
            StringTokenizer toks = new StringTokenizer(text, ":.", true);
            int numCount = 0;
            int colonCount = 0;
            int dotCount = 0;
            int lastType = 0;
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken();
                char c1 = tok.charAt(0);
                if (c1 == ':') {
                    if (lastType != 49) {
                        return false;
                    }
                    if (dotCount > 0 || colonCount > 1) {
                        return false;
                    }
                    ++colonCount;
                    lastType = 58;
                    continue;
                }
                if (c1 == '.') {
                    if (lastType != 49) {
                        return false;
                    }
                    if (dotCount > 0) {
                        return false;
                    }
                    if (this.wholeSeconds) {
                        return false;
                    }
                    ++dotCount;
                    lastType = 46;
                    continue;
                }
                if (lastType == 49) {
                    return false;
                }
                if (numCount > 4) {
                    return false;
                }
                if (colonCount > 0 && dotCount == 0 && Integer.parseInt(tok) > 59) {
                    return false;
                }
                ++numCount;
                lastType = 49;
            }
            return true;
        }

        boolean checkRange(String text) {
            double val = TimeCodeCellEditor.parseTimeIndex(text);
            return val >= this.minSeconds && val <= this.maxSeconds;
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.checkDoc();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.checkDoc();
        }

        public boolean getWholeSeconds() {
            return this.wholeSeconds;
        }

        public double getMinSeconds() {
            return this.minSeconds;
        }

        public double getMaxSeconds() {
            return this.maxSeconds;
        }
    }
}

