/*
 * Decompiled with CFR 0.152.
 */
package modelobjects.util.undo;

import javax.swing.undo.UndoManager;
import modelobjects.util.undo.CannotRedoException;
import modelobjects.util.undo.CannotUndoException;

public class PresentableUndoManager
extends UndoManager {
    private String presentationName;

    protected PresentableUndoManager(String presentationName) {
        this.presentationName = presentationName;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            IllegalStateException reason = new IllegalStateException("canUndo == false");
            throw new CannotUndoException(this.getUndoPresentationName(), reason);
        }
        super.undo();
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            IllegalStateException reason = new IllegalStateException("canRedo == false");
            throw new CannotRedoException(this.getRedoPresentationName(), reason);
        }
        super.redo();
    }

    public void clearEdits() {
        this.discardAllEdits();
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public String getUndoPresentationName() {
        return "undo " + this.presentationName;
    }

    @Override
    public String getRedoPresentationName() {
        return "redo " + this.presentationName;
    }
}

