/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.manager;

import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.AbstractComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.IState;
import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.CollectiveOpStatus;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IConnectorServer;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IGlobalFrameworkComponent;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.manager.CentralizedLogger;
import com.sonicsw.mf.framework.manager.CurrentDomainState;
import com.sonicsw.mf.framework.manager.DomainStateMonitor;
import com.sonicsw.mf.framework.manager.FaultDetector;
import com.sonicsw.mf.framework.util.NotificationForwarder;
import com.sonicsw.mf.framework.util.StateManager;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import java.io.IOException;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class AgentManager
extends AbstractFrameworkComponent
implements IGlobalFrameworkComponent,
INotificationHandler,
IGlobalComponentListener {
    private static boolean DEBUG = false;
    private String m_configID;
    private String m_primaryConfigID;
    private NotificationForwarder m_stateNotificationForwarder;
    public static final String STARTUP_NOTIFICATION_TYPE = "Startup";
    public static final String UNREACHABLE_NOTIFICATION_TYPE = "Unreachable";
    public static final String FAILOVER_NOTIFICATION_TYPE = "Failover";
    public static final String BACKUP_AGENT_MANAGER_TYPE = "MF_BACKUP_AGENT_MANAGER";
    public static final String CONFIG_ELEMENT_REFERENCES_ATTR = "CONFIG_ELEMENT_REFERENCES";
    public static final String PRIMARY_CONFIG_ELEMENT_REF_ATTR = "PRIMARY_AM_CONFIG_ELEMENT_REF";
    public static final String BACKUP_CONFIG_ELEMENT_REF_ATTR = "BACKUP_AM_CONFIG_ELEMENT_REF";
    private ITaskScheduler m_taskScheduler;
    private CurrentDomainState m_domainState;
    private DomainStateMonitor m_stateMonitor;
    private static final String LOGFAILURE_NOTIFICATION_TYPE = "Failure";
    private static final String LOGTHRESHOLD_NOTIFICATION_TYPE = "Threshold";
    private IPermissionsManager m_permissionsManager;
    private IMetricsRegistrar m_metricsRegistrar;
    private static final String MANAGER_TRACE_MASK_VALUES = "16=status polling,32=container unreachable,64=forwarded notifications,128=fault detection";
    public static final int TRACE_STATUS_POLLING = 16;
    public static final int TRACE_CONTAINER_UNREACHABLE = 32;
    public static final int TRACE_FORWARDED_NOTIFICATIONS = 64;
    public static final int TRACE_FAULT_DETECTION = 128;
    private static final String FAULT_TOLERANCE_ROLE_DEFAULT = "";
    private static final String FAULT_TOLERANCE_ROLE_PRIMARY = "PRIMARY";
    private static final String FAULT_TOLERANCE_ROLE_BACKUP = "BACKUP";
    private String m_uniqunessCallID;
    private Thread m_uniquenessCheckThread;
    private boolean m_uniquenessCallReceived;
    private boolean m_responseSent;
    private IConnectorServer m_connectorServer;
    private Object m_uniquenessCheckLockObj = new Object();
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    private boolean m_isNotFaultTolerant;
    boolean m_isPrimary;
    boolean m_isBackup;
    private boolean m_allowFailover = true;
    private boolean m_abortFailover = false;
    private String m_faultToleranceRole = "";
    private long m_faultDetectionInterval;
    private IStateManager m_faultToleranceStateManager;
    private String m_vmID = new VMID().toString();
    private FaultDetector m_faultDetector;
    private CentralizedLogger m_centralizedLogger;
    public static final long LATENCY_LEASE_LOCK = 5000L;
    public static final long LEASE_REQUEST_TIMEOUT_MIN = 10000L;
    private static final String[] LEASELOCK_SIGNATURE = new String[]{String.class.getName(), String.class.getName(), Integer.class.getName()};
    private static final ArrayList ATTRIBUTE_INFOS = new ArrayList();
    private static final ArrayList OPERATION_INFOS = new ArrayList();
    private static final ArrayList NOTIFICATION_INFOS = new ArrayList();
    private static CompositeType LOG_COMPOSITE_TYPE;
    private static String[] LOG_COMPOSITE_TYPE_ITEM_NAMES;

    public AgentManager() {
        this.m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        this.m_SdfMFTracingIntegration.register();
    }

    private void makeGlobalComponentUniquenessCall() {
        this.m_uniqunessCallID = new UID().toString();
        this.m_uniquenessCheckThread = new Thread("AGENT MANAGER - Uniqueness Checker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AgentManager.this.m_uniquenessCallReceived) {
                    try {
                        AgentManager.this.m_frameworkContext.makeGlobalComponentUniquenessCall("AGENT MANAGER", AgentManager.this.m_uniqunessCallID, AgentManager.this.m_isNotFaultTolerant ? null : AgentManager.this.m_faultToleranceRole);
                    }
                    catch (Exception e) {
                        throw AgentManager.this.createMFRuntimeException(e);
                    }
                    if (AgentManager.this.m_uniquenessCallReceived) {
                        return;
                    }
                    try {
                        Object e = AgentManager.this.m_uniquenessCheckLockObj;
                        synchronized (e) {
                            AgentManager.this.m_uniquenessCheckLockObj.wait(3000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this.m_uniquenessCheckThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uniquenessCheck(String containerID, String callID) {
        String thisContainerName = this.m_frameworkContext.getContainer().getContainerIdentity().getCanonicalName();
        Object object = this.m_uniquenessCheckLockObj;
        synchronized (object) {
            this.m_uniquenessCallReceived = true;
            this.m_uniquenessCheckLockObj.notifyAll();
        }
        if (this.m_responseSent) {
            return;
        }
        if (!containerID.equals(thisContainerName)) {
            String errMsg = "Domain has 2 active Agent Manager instances (both will be shutdown to allow configuration resolution):\n\n\tOne is in this container : " + thisContainerName + '\n' + '\t' + "The other is in container: " + containerID;
            this.m_context.logMessage(errMsg, 1);
            try {
                Thread.sleep(3000L);
                this.m_frameworkContext.makeGlobalComponentUniquenessCall("AGENT MANAGER", this.m_uniqunessCallID, this.m_isNotFaultTolerant ? null : this.m_faultToleranceRole);
                this.m_responseSent = true;
            }
            catch (Exception e) {
                throw this.createMFRuntimeException(e);
            }
            this.m_container.shutdown(6);
        }
        if (!callID.equals(this.m_uniqunessCallID)) {
            this.m_context.logMessage("There are two active Agent Manager instances in this container.", 1);
            this.m_container.shutdown(6);
        }
    }

    public String getGlobalID() {
        return "AGENT MANAGER";
    }

    public void init(IComponentContext context) {
        super.init(context);
        this.m_connectorServer = this.m_frameworkContext.getContainer().getConnectorServer();
        this.m_permissionsManager = this.m_frameworkContext.getPermissionsManager();
        this.m_centralizedLogger = new CentralizedLogger(context);
        this.readConfiguration(context);
        this.setTraceMask(super.getTraceMask());
        this.m_stateNotificationForwarder = new NotificationForwarder(this.m_frameworkContext);
        this.m_domainState = new CurrentDomainState(context.getConfigurations("/containers", true));
        this.m_taskScheduler = this.m_container.getTaskScheduler();
        try {
            if (this.m_isNotFaultTolerant) {
                this.m_container.addGlobalComponentSupport(this.getGlobalID(), null, (IGlobalComponentListener)this);
                this.m_container.addGlobalComponentSupport(this.getGlobalID(), FAULT_TOLERANCE_ROLE_PRIMARY, (IGlobalComponentListener)this);
            } else {
                this.m_context.logMessage(IContainer.NEWLINE + IContainer.NEWLINE + '\t' + "Fault tolerant role \"" + this.m_faultToleranceRole + "\"." + IContainer.NEWLINE, 4);
                this.m_container.addGlobalComponentSupport(this.getGlobalID(), this.m_faultToleranceRole, (IGlobalComponentListener)this);
            }
        }
        catch (Exception e) {
            String msgPrefix = this.m_isNotFaultTolerant ? FAULT_TOLERANCE_ROLE_DEFAULT : '[' + this.m_faultToleranceRole + "] ";
            this.m_context.logMessage(msgPrefix + "Failed communications initialization, trace follows...", (Throwable)e, 1);
            this.m_container.shutdown(9);
        }
        if (this.m_isNotFaultTolerant) {
            this.m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, 0);
        } else {
            this.m_faultToleranceStateManager = new StateManager(IFaultTolerantState.STATE_VALUES, 1);
            this.m_context.logMessage("Initial state: \"" + IFaultTolerantState.STATE_TEXT[1] + '\"', 3);
            this.m_faultToleranceStateManager.registerStateListener((IStateListener)new StateListener(), null);
            Object controller = null;
            controller = new ToActiveStateController();
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)1, (short)2, null);
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)3, (short)2, null);
            controller = new FromActiveStateController();
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)2, (short)1, null);
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)2, (short)3, null);
            controller = new WaitingStandbyStateController();
            this.m_faultToleranceStateManager.registerStateController((IStateController)controller, (short)1, (short)3, null);
            this.startFaultDetector();
        }
        this.makeGlobalComponentUniquenessCall();
        IMetricInfo[] domainStateMonitorMetricsInfo = DomainStateMonitor.getMetricsInfo();
        IMetricInfo[] infos = new IMetricInfo[domainStateMonitorMetricsInfo.length];
        System.arraycopy(domainStateMonitorMetricsInfo, 0, infos, 0, domainStateMonitorMetricsInfo.length);
        this.m_metricsRegistrar = this.m_context.initMetricsManagement(infos);
        DomainStateMonitor.initMetrics(this.m_metricsRegistrar);
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public synchronized void start() {
        if (this.m_state == 3) {
            return;
        }
        if (this.m_isNotFaultTolerant) {
            this.startDomainStateMonitor();
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        this.stopDomainStateMonitor();
        super.stop();
    }

    public synchronized void enableMetrics(IMetricIdentity[] ids) {
        DomainStateMonitor.enableMetrics(ids);
    }

    public synchronized void disableMetrics(IMetricIdentity[] ids) {
        DomainStateMonitor.disableMetrics(ids);
    }

    public void destroy() {
        this.m_container.removeGlobalComponentSupport(this.getGlobalID(), null);
        if (this.m_isNotFaultTolerant) {
            this.m_container.removeGlobalComponentSupport(this.getGlobalID(), FAULT_TOLERANCE_ROLE_PRIMARY);
        } else {
            this.m_container.removeGlobalComponentSupport(this.getGlobalID(), this.m_faultToleranceRole);
            this.stopFaultDetector();
            if (this.m_faultToleranceStateManager.getState(null) == 2) {
                this.releaseLock();
            }
        }
        this.m_domainState = null;
        if (this.m_centralizedLogger != null) {
            this.m_centralizedLogger.close();
        }
        super.destroy();
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        IElementIdentity id = elementChange.getElement().getIdentity();
        String configID = id.getName();
        if (configID.equals(this.m_primaryConfigID)) {
            this.handleAgentManagerElementChange(elementChange);
        } else if (configID.equals("/domain/domain")) {
            this.configureCentralizedLogging();
        } else if (configID.startsWith("/containers/")) {
            this.handleContainerElementChange(elementChange);
        }
    }

    private void handleAgentManagerElementChange(IElementChange elementChange) {
        if (elementChange.getChangeType() == 1) {
            IDeltaElement changeElement = (IDeltaElement)elementChange.getElement();
            IDeltaAttributeSet attrs = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
            String[] mods = attrs.getModifiedAttributesNames();
            this.handleChangeAgentManagerAttrs(mods, attrs);
            mods = attrs.getNewAttributesNames();
            this.handleChangeAgentManagerAttrs(mods, attrs);
            mods = attrs.getDeletedAttributesNames();
            this.handleDeletedAgentManagerAttrs(mods);
        }
    }

    private void handleChangeAgentManagerAttrs(String[] attributeNames, IDeltaAttributeSet modifiedAttrs) {
        try {
            Integer newMinThreads = null;
            Integer newMaxThreads = null;
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].equals("MIN_POLL_THREADS")) {
                    newMinThreads = (Integer)modifiedAttrs.getNewValue("MIN_POLL_THREADS");
                }
                if (!attributeNames[i].equals("MAX_POLL_THREADS")) continue;
                newMaxThreads = (Integer)modifiedAttrs.getNewValue("MAX_POLL_THREADS");
            }
            if (newMaxThreads != null && newMinThreads != null) {
                this.m_stateMonitor.setMinThreads((short)0);
                this.m_stateMonitor.setMaxThreads((short)50);
                this.m_stateMonitor.setMaxThreads(newMaxThreads.shortValue());
                this.m_stateMonitor.setMinThreads(newMinThreads.shortValue());
            } else {
                if (newMaxThreads != null) {
                    this.m_stateMonitor.setMaxThreads(newMaxThreads.shortValue());
                }
                if (newMinThreads != null) {
                    this.m_stateMonitor.setMinThreads(newMinThreads.shortValue());
                }
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying Agent Manager runtime from configuration change, trace follows...", (Throwable)e, 2);
        }
    }

    private void handleDeletedAgentManagerAttrs(String[] attributeNames) {
        try {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].equals("MIN_POLL_THREADS") && this.m_stateMonitor != null) {
                    this.m_stateMonitor.setMinThreads((short)0);
                }
                if (attributeNames[i].equals("MAX_POLL_THREADS") && this.m_stateMonitor != null) {
                    this.m_stateMonitor.setMaxThreads((short)50);
                }
                if (attributeNames[i].equals("REFRESH_INTERVAL") && this.m_metricsRegistrar != null) {
                    this.m_metricsRegistrar.setRefreshInterval(20000L);
                }
                if (attributeNames[i].equals("COLLECTION_INTERVAL") && this.m_metricsRegistrar != null) {
                    this.m_metricsRegistrar.setCollectionInterval(600000L);
                }
                if (!attributeNames[i].equals("REPEAT_ALERT_NOTIFICATIONS") || this.m_metricsRegistrar == null) continue;
                this.m_metricsRegistrar.setRepeatMetricAlerts(false);
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying Agent Manager runtime from configuration change [deletion]", (Throwable)e, 1);
        }
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + MANAGER_TRACE_MASK_VALUES;
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (!fromSDF) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
        if (this.m_stateNotificationForwarder != null) {
            this.m_stateNotificationForwarder.setDebug((this.m_traceMask & 0x40) > 0);
        }
    }

    public ICollectiveOpStatus invoke(String configID, String operationName, Object[] operationParams, String[] signature, Boolean sync, Long timeout) throws MFException {
        Iterator iterator;
        super.validateOnline();
        this.validateActive();
        configID = this.getStorageIDForCollection(configID);
        boolean isSync = sync;
        HashMap ids = this.getCollectionIDs(configID, true);
        HashSet canonicalNames = new HashSet(ids.keySet());
        ObjectName[] objectNames = new ObjectName[canonicalNames.size()];
        Iterator namesIterator = canonicalNames.iterator();
        int index = 0;
        while (namesIterator.hasNext()) {
            try {
                objectNames[index++] = new ObjectName(((CanonicalName)namesIterator.next()).getCanonicalName());
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
        CollectiveOpStatus permissionsManagerResults = this.m_permissionsManager.managePermissionCheck(objectNames, operationName);
        if (permissionsManagerResults != null) {
            block5: for (int i = 0; i < permissionsManagerResults.getCount(); ++i) {
                if (permissionsManagerResults.getThrowable(i) == null) continue;
                iterator = canonicalNames.iterator();
                while (iterator.hasNext()) {
                    CanonicalName canonicalName = (CanonicalName)iterator.next();
                    if (!canonicalName.getCanonicalName().equals(permissionsManagerResults.getComponentName(i))) continue;
                    iterator.remove();
                    continue block5;
                }
            }
        }
        if (canonicalNames.isEmpty()) {
            return permissionsManagerResults;
        }
        String[] remainingTargets = new String[canonicalNames.size()];
        iterator = canonicalNames.iterator();
        for (int i = 0; i < remainingTargets.length; ++i) {
            remainingTargets[i] = ((CanonicalName)iterator.next()).getCanonicalName();
        }
        try {
            ICollectiveOpStatus componentResults = this.m_frameworkContext.invoke(remainingTargets, operationName, operationParams, signature, sync.booleanValue(), timeout.longValue());
            if (permissionsManagerResults == null) {
                return isSync ? componentResults : null;
            }
            if (isSync && componentResults != null) {
                for (int i = 0; i < componentResults.getCount(); ++i) {
                    permissionsManagerResults.addResult(componentResults.getComponentName(i), componentResults.getReturnValue(i), componentResults.getThrowable(i));
                }
            }
            return permissionsManagerResults;
        }
        catch (Exception e) {
            if (e instanceof MFException) {
                throw (MFException)e;
            }
            MFException exception = new MFException("Failed invoke [" + operationName + "] on collection: " + configID);
            exception.setLinkedException(e);
            throw exception;
        }
    }

    private String getStorageIDForCollection(String configID) {
        String logical = this.m_frameworkContext.storageToLogical(configID);
        if (logical != null) {
            return configID;
        }
        IElement element = this.m_frameworkContext.getFSConfiguration(configID, false);
        if (element != null) {
            return element.getIdentity().getName();
        }
        return configID;
    }

    public ICollectiveOpStatus setAttribute(String configID, String attributeName, Object attributeValue, Boolean sync, Long timeout) throws MFException {
        super.validateOnline();
        this.validateActive();
        return this.internalSetAttributes(false, configID, new String[]{attributeName}, new Object[]{attributeValue}, sync, timeout);
    }

    public ICollectiveOpStatus setAttributes(String configID, String[] attributeNames, Object[] attributeValues, Boolean sync, Long timeout) throws MFException {
        super.validateOnline();
        this.validateActive();
        return this.internalSetAttributes(true, configID, attributeNames, attributeValues, sync, timeout);
    }

    public IState[] getCollectiveState() {
        super.validateOnline();
        this.validateActive();
        return this.m_domainState.getDomainState();
    }

    public IState[] getCollectiveState(String[] runtimeID) {
        super.validateOnline();
        this.validateActive();
        ArrayList<IContainerState> states = new ArrayList<IContainerState>();
        IContainerState[] containerStates = this.m_domainState.getDomainState();
        block0: for (int i = 0; i < runtimeID.length; ++i) {
            for (int j = 0; j < containerStates.length; ++j) {
                if (!containerStates[j].getRuntimeIdentity().getCanonicalName().equals(runtimeID[i])) continue;
                states.add(containerStates[j]);
                continue block0;
            }
        }
        IState[] runtimeStates = new IState[states.size()];
        return states.toArray(runtimeStates);
    }

    public IState[] getCollectiveState(String configID) throws MFException {
        super.validateOnline();
        this.validateActive();
        HashMap ids = this.getCollectionIDs(configID, false);
        IContainerState[] containerStates = this.m_domainState.getDomainState();
        ArrayList<IContainerState> collectiveState = new ArrayList<IContainerState>();
        for (Map.Entry entry : ids.entrySet()) {
            CanonicalName canonicalName = (CanonicalName)entry.getKey();
            String containerID = canonicalName.getDomainName() + '.' + canonicalName.getContainerName();
            IContainerState state = null;
            block1: for (int j = 0; j < containerStates.length; ++j) {
                if (containerStates[j].getRuntimeIdentity().getCanonicalName().equals(canonicalName.getCanonicalName())) {
                    state = containerStates[j];
                    break;
                }
                if (!containerStates[j].getRuntimeIdentity().getCanonicalName().equals(containerID)) continue;
                IComponentState[] componentStates = containerStates[j].getComponentStates();
                for (int k = 0; k < componentStates.length; ++k) {
                    if (!componentStates[k].getRuntimeIdentity().getCanonicalName().equals(canonicalName.getCanonicalName())) continue;
                    state = componentStates[k];
                    break block1;
                }
                break;
            }
            if (state == null) {
                ElementIdentity elementID = new ElementIdentity((String)entry.getValue(), null, null);
                if (canonicalName.getComponentName().length() == 0) {
                    state = new ContainerState(canonicalName, (IElementIdentity)elementID);
                    ((ContainerState)state).setState((short)0);
                } else {
                    state = new ComponentState(canonicalName, (IElementIdentity)elementID, 0, null, 0, null);
                }
            }
            collectiveState.add(state);
        }
        IState[] runtimeStates = new IState[collectiveState.size()];
        return collectiveState.toArray(runtimeStates);
    }

    public void suspendActiveRole(final Integer waitSeconds) throws MFException {
        short currentState = this.m_faultToleranceStateManager.getState(null);
        if (currentState != 2) {
            throw new MFException("Cannot suspend \"" + IFaultTolerantState.STATE_TEXT[2] + "\" state when Agent Manager is in a \"" + IFaultTolerantState.STATE_TEXT[currentState] + "\" state.");
        }
        Runnable suspender = new Runnable(){

            @Override
            public void run() {
                block4: {
                    long waitTime = waitSeconds == null || waitSeconds == 0 ? AgentManager.this.m_faultDetectionInterval : (long)(waitSeconds * 1000);
                    long startTime = System.currentTimeMillis();
                    if (AgentManager.this.m_faultDetector == null) break block4;
                    ((AbstractComponent)AgentManager.this).m_context.logMessage("Suspending \"" + IFaultTolerantState.STATE_TEXT[2] + "\" state for " + waitSeconds + " seconds...", 2);
                    AgentManager.this.m_faultDetector.suspendActiveState();
                    do {
                        try {
                            Thread.sleep(2500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (AgentManager.this.getContext().getContainer().isClosing()) break block4;
                    } while (System.currentTimeMillis() - startTime <= waitTime);
                    if (AgentManager.this.m_faultDetector != null) {
                        ((AbstractComponent)AgentManager.this).m_context.logMessage("...suspension complete", 3);
                        AgentManager.this.m_faultDetector.resumeAfterSuspend();
                    }
                }
            }
        };
        this.m_context.scheduleTask(suspender, new Date());
    }

    public String getFaultToleranceRole() {
        return this.m_faultToleranceRole;
    }

    public Short getFaultTolerantState() {
        return new Short(this.m_faultToleranceStateManager.getState(null));
    }

    public String getFaultTolerantStateString() {
        return IFaultTolerantState.STATE_TEXT[this.m_faultToleranceStateManager.getState(null)];
    }

    public Boolean getAllowFailover() {
        return this.m_isNotFaultTolerant ? null : new Boolean(this.m_allowFailover);
    }

    public void setAllowFailover(Boolean allowFailover) {
        if (this.m_isNotFaultTolerant) {
            throw new IllegalStateException("Setting of this attribute is not supported for a non-fault tolerant AgentManager");
        }
        boolean allow = allowFailover;
        if (allow != this.m_allowFailover) {
            if (this.m_faultToleranceStateManager.getState(null) != 2) {
                this.m_context.logMessage("Failover " + (allow ? "reenabled" : "disabled"), allow ? 3 : 2);
            }
            this.m_allowFailover = allow;
        }
    }

    public Integer getMaxPollingThreads() {
        if (this.m_stateMonitor != null) {
            return new Integer(this.m_stateMonitor.getMaxThreads());
        }
        IElement amElement = this.m_isBackup ? this.m_context.getConfiguration(this.m_primaryConfigID, true) : this.m_context.getConfiguration(true);
        IAttributeSet amAttributes = amElement.getAttributes();
        Integer maxPollThreads = (Integer)amAttributes.getAttribute("MAX_POLL_THREADS");
        if (maxPollThreads == null) {
            maxPollThreads = new Integer(50);
        }
        return maxPollThreads;
    }

    public Integer getMinPollingThreads() {
        if (this.m_stateMonitor != null) {
            return new Integer(this.m_stateMonitor.getMinThreads());
        }
        IElement amElement = this.m_isBackup ? this.m_context.getConfiguration(this.m_primaryConfigID, true) : this.m_context.getConfiguration(true);
        IAttributeSet amAttributes = amElement.getAttributes();
        Integer minPollThreads = (Integer)amAttributes.getAttribute("MIN_POLL_THREADS");
        if (minPollThreads == null) {
            minPollThreads = new Integer(0);
        }
        return minPollThreads;
    }

    public void handleNotification(INotification notification) {
        if (notification.getCategory() == 0) {
            this.handleSystemNotification(notification);
        }
    }

    public String getLogFile() {
        return this.m_centralizedLogger.getLogFile();
    }

    public void setLogFile(String path) throws Exception {
        this.m_centralizedLogger.setLogFile(path);
    }

    public Long getLogFileSize() {
        return new Long(this.m_centralizedLogger.length());
    }

    public Long getLogFileSizeThreshold() {
        return this.m_centralizedLogger.getLogFileSizeThreshold();
    }

    public void setLogFileSizeThreshold(Long thresholdSize) {
        this.m_centralizedLogger.setLogFileSizeThreshold(thresholdSize);
    }

    public Long getLogFileRolloverSizeThreshold() {
        return this.m_centralizedLogger.getLogFileRolloverSizeThreshold();
    }

    public void setLogFileRolloverSizeThreshold(Long thresholdSize) {
        this.m_centralizedLogger.setLogFileRolloverSizeThreshold(thresholdSize);
    }

    public Integer getLogFileRolloverTimeInterval() {
        return this.m_centralizedLogger.getLogFileRolloverTimeInterval();
    }

    public void setLogFileRolloverTimeInterval(Integer logFileRolloverTimeInterval) {
        this.m_centralizedLogger.setLogFileRolloverTimeInterval(logFileRolloverTimeInterval);
    }

    public synchronized void clearLogFile() {
        this.m_centralizedLogger.clearLogFile();
    }

    public synchronized void saveLogFile(String path) {
        this.m_centralizedLogger.saveLogFile(path);
    }

    public void attemptLogFileRollover() throws IOException {
        this.m_centralizedLogger.attemptLogFileRollover();
    }

    public String getLogExtract(Long fromPosition, Long readLength) {
        return this.m_centralizedLogger.getLogExtract(fromPosition, readLength);
    }

    public CompositeData getLogExtractAndLogFileSize(Long fromPosition, Long readLength) {
        return this.m_centralizedLogger.getLogExtractAndLogFileSize(fromPosition, readLength);
    }

    public synchronized void logMessage(String message) {
        this.m_centralizedLogger.logMessage(message);
    }

    public void recordAuditEvent(String source, String logger, String message) {
        if (new CanonicalName(source).getContainerName().equals(this.m_context.getComponentName().getContainerName())) {
            return;
        }
        this.m_frameworkContext.getAuditManager().recordEvent(logger, message);
    }

    IContainerState getContainerState(String container, long timeout) throws Exception {
        if (DEBUG) {
            System.out.println("AgentManager.getContainerState: " + container);
        }
        int i = 0;
        while (true) {
            long checkTime = System.currentTimeMillis();
            try {
                return (IContainerState)this.m_frameworkContext.invoke(container + ":ID=AGENT", "getContainerState", IEmptyArray.EMPTY_OBJECT_ARRAY, IEmptyArray.EMPTY_STRING_ARRAY, true, timeout);
            }
            catch (Exception e) {
                if (i < 1 && e instanceof InvokeTimeoutException) {
                    ContainerState containerState;
                    ++i;
                    if ((containerState = this.m_domainState.getContainerState(container)).getTimeStamp() > checkTime) continue;
                }
                this.sendContainerUnreachableNotification(container, checkTime);
                throw e;
            }
            break;
        }
    }

    void sendFailoverNotification() {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], FAILOVER_NOTIFICATION_TYPE, 2);
        notification.setLogType((short)1);
        notification.setAttribute("FaultToleranceRole", (Object)this.m_faultToleranceRole);
        this.m_context.sendNotification(notification);
    }

    private MFRuntimeException createMFRuntimeException(Exception e) {
        return new MFRuntimeException(e.toString());
    }

    private void handleSystemNotification(INotification notification) {
        if (notification.getSubCategory().equals(INotification.SUBCATEGORY_TEXT[0])) {
            this.handleSystemStateNotification(notification);
            if (!notification.getSourceIdentity().getCanonicalName().equals(this.m_frameworkContext.getComponentName().getCanonicalName()) && !notification.getEventName().equals(STARTUP_NOTIFICATION_TYPE)) {
                this.m_stateNotificationForwarder.handleNotification(notification);
            }
        }
    }

    private void handleSystemStateNotification(INotification notification) {
        String event = notification.getEventName();
        String type = notification.getType();
        long timestamp = notification.getTimeStamp();
        IComponentIdentity source = notification.getSourceIdentity();
        String sourceContainer = source.getDomainName() + '.' + source.getContainerName();
        if (DEBUG) {
            System.out.println("AgentManager.handleSystemStateNotification: " + source.getCanonicalName() + " -> " + event);
        }
        if (event.equals(STARTUP_NOTIFICATION_TYPE)) {
            if (source.getCanonicalName().equals(this.m_frameworkContext.getComponentName().getCanonicalName())) {
                return;
            }
            if (this.m_domainState.updateContainerState(sourceContainer, (short)3, timestamp)) {
                this.refreshContainerState(sourceContainer);
            }
            this.sendStartupNotification(sourceContainer);
            return;
        }
        if (type.equals("system.state.Shutdown")) {
            this.m_domainState.updateContainerState(sourceContainer, (short)1, timestamp);
            return;
        }
        if (type.equals("system.state.Load")) {
            this.m_domainState.updateContainerState(sourceContainer, (short)3, timestamp);
            this.refreshContainerState(sourceContainer);
            return;
        }
        if (type.equals("system.state.Unload")) {
            String componentID = (String)notification.getAttributes().get("ID");
            this.m_domainState.removeComponentState(sourceContainer, componentID, timestamp);
            return;
        }
        if (event.equals(IComponentState.STATE_TEXT[3])) {
            String lastError = (String)notification.getAttributes().get("LastError");
            Integer lastErrorLevel = new Integer((String)notification.getAttributes().get("LastErrorLevel"));
            if (this.m_domainState.updateComponentState(sourceContainer, source.getComponentName(), (short)3, lastError, lastErrorLevel, timestamp)) {
                this.refreshContainerState(sourceContainer);
            }
            return;
        }
        if (event.equals(IComponentState.STATE_TEXT[1])) {
            String lastError = (String)notification.getAttributes().get("LastError");
            Integer lastErrorLevel = new Integer((String)notification.getAttributes().get("LastErrorLevel"));
            if (this.m_domainState.updateComponentState(sourceContainer, source.getComponentName(), (short)1, lastError, lastErrorLevel, timestamp)) {
                this.refreshContainerState(sourceContainer);
            }
            return;
        }
        if (type.equals("system.state.ContainerState")) {
            IContainerState containerState = (IContainerState)notification.getAttributes().get("ContainerState");
            this.m_stateMonitor.handleContainerStateNotification(containerState, timestamp);
            return;
        }
        if (type.equals("system.state.Failure")) {
            HashMap attributes = notification.getAttributes();
            String childContainer = (String)attributes.get("Container");
            if (childContainer != null) {
                this.m_domainState.updateContainerState(childContainer, (short)1, timestamp);
            }
            return;
        }
    }

    private void refreshContainerState(String container) {
        if (this.m_stateMonitor != null) {
            this.m_stateMonitor.schedule(container);
        }
    }

    private void handleContainerElementChange(IElementChange elementChange) {
        if (elementChange.getElement() instanceof IElement) {
            IElement configuration = (IElement)elementChange.getElement();
            switch (elementChange.getChangeType()) {
                case 0: {
                    if (((IDirElement)configuration).isTemplate()) {
                        return;
                    }
                    this.m_domainState.addContainer(configuration);
                    ContainerIdentity containerID = new ContainerIdentity(configuration);
                    CanonicalName canonicalName = new CanonicalName(containerID.getDomainName(), containerID.getContainerName(), FAULT_TOLERANCE_ROLE_DEFAULT);
                    this.refreshContainerState(canonicalName.getCanonicalName());
                    break;
                }
                case 2: {
                    this.m_domainState.removeContainer(configuration.getIdentity().getName());
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.m_stateMonitor != null) {
                this.m_stateMonitor.reschedule();
            }
            return;
        }
        if (elementChange.getElement() instanceof IDeltaElement) {
            IDeltaElement delta = (IDeltaElement)elementChange.getElement();
            String configID = delta.getIdentity().getName();
            IElement configuration = this.m_context.getConfiguration(configID, true);
            switch (elementChange.getChangeType()) {
                case 1: {
                    IDeltaAttributeSet attrs = (IDeltaAttributeSet)delta.getDeltaAttributes();
                    String[] mods = attrs.getModifiedAttributesNames();
                    this.handleChangeContainerAttrs(mods, attrs, configuration);
                    mods = attrs.getNewAttributesNames();
                    this.handleChangeContainerAttrs(mods, attrs, configuration);
                    mods = attrs.getDeletedAttributesNames();
                    return;
                }
            }
            return;
        }
    }

    private void handleChangeContainerAttrs(String[] mods, IDeltaAttributeSet attrs, IElement configuration) {
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i].equals("MONITORING")) {
                if (this.m_stateMonitor == null) continue;
                ContainerIdentity containerID = new ContainerIdentity(configuration);
                CanonicalName canonicalName = new CanonicalName(containerID.getDomainName(), containerID.getContainerName(), FAULT_TOLERANCE_ROLE_DEFAULT);
                this.m_stateMonitor.reschedule(canonicalName.getCanonicalName());
                continue;
            }
            if (!mods[i].equals("CONTAINER_NAME")) continue;
            this.m_domainState.removeContainer(configuration.getIdentity().getName());
            this.m_domainState.addContainer(configuration);
            if (this.m_stateMonitor == null) continue;
            this.m_stateMonitor.reschedule();
        }
    }

    private void sendStartupNotification(String container) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], STARTUP_NOTIFICATION_TYPE, 3);
        notification.setLogType((short)0);
        notification.setAttribute("Container", (Object)container);
        this.m_context.sendNotification(notification);
    }

    private void sendContainerUnreachableNotification(String container, long checkTime) {
        if ((this.m_traceMask & 0x20) > 0) {
            this.m_context.logMessage("Container unreachable: " + container, 7);
        }
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], UNREACHABLE_NOTIFICATION_TYPE, 1);
        notification.setLogType((short)1);
        notification.setAttribute("Container", (Object)container);
        notification.setAttribute("CheckTime", (Object)new Date(checkTime));
        this.m_context.sendNotification(notification);
    }

    private HashMap getCollectionIDs(String configID, boolean appendAgentIDs) throws MFException {
        if (configID == null || configID.length() == 0) {
            throw new MFRuntimeException("Bad config identity: " + configID);
        }
        IElement collectionConfig = this.m_context.getConfiguration(configID, true);
        if (collectionConfig == null) {
            throw new MFException("Unknown collection: " + configID);
        }
        boolean isContainerCollection = AgentManager.isContainerCollection(collectionConfig);
        if (!isContainerCollection) {
            appendAgentIDs = false;
        }
        IAttributeSet attributes = collectionConfig.getAttributes();
        IAttributeSet idSet = (IAttributeSet)attributes.getAttribute(isContainerCollection ? "CONTAINERS" : "COMPONENTS");
        HashMap<CanonicalName, String> ids = new HashMap<CanonicalName, String>();
        for (IAttributeSet attrs : idSet.getAttributes().values()) {
            String runtimeID = (String)attrs.getAttribute(isContainerCollection ? "CONTAINER_RUNTIME_ID" : "COMPONENT_RUNTIME_ID");
            CanonicalName canonicalName = null;
            canonicalName = isContainerCollection && appendAgentIDs ? new CanonicalName(runtimeID + ":ID=" + "AGENT") : new CanonicalName(runtimeID);
            Reference configRef = (Reference)attrs.getAttribute(isContainerCollection ? "CONFIG_REF" : "CONFIG_REF");
            ids.put(canonicalName, configRef.getElementName());
        }
        return ids;
    }

    static boolean isContainerCollection(IElement collectionConfig) {
        return collectionConfig.getIdentity().getType().equals("MF_CONTAINER_COLLECTION");
    }

    static boolean isComponentCollection(IElement collectionConfig) {
        return collectionConfig.getIdentity().getType().equals("MF_COMPONENT_COLLECTION");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICollectiveOpStatus internalSetAttributes(boolean reportAttributes, String configID, String[] attributeNames, Object[] attributeValues, Boolean sync, Long timeout) throws MFException {
        Object canonicalName;
        long startTime = System.currentTimeMillis();
        configID = this.getStorageIDForCollection(configID);
        HashMap ids = this.getCollectionIDs(configID, true);
        HashSet canonicalNames = new HashSet(ids.keySet());
        boolean isSync = sync;
        Hashtable<String, Object[]> results = isSync ? new Hashtable<String, Object[]>(ids.size()) : null;
        IPermissionsManager permissionsManager = this.m_frameworkContext.getPermissionsManager();
        ObjectName[] objectNames = new ObjectName[canonicalNames.size()];
        Iterator namesIterator = canonicalNames.iterator();
        int index = 0;
        while (namesIterator.hasNext()) {
            try {
                objectNames[index++] = new ObjectName(((CanonicalName)namesIterator.next()).getCanonicalName());
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        }
        CollectiveOpStatus permissionsManagerResults = permissionsManager.managePermissionCheck(objectNames, "setAttributes");
        if (permissionsManagerResults != null) {
            block8: for (int i = 0; i < permissionsManagerResults.getCount(); ++i) {
                if (permissionsManagerResults.getThrowable(i) == null) continue;
                Iterator iterator = canonicalNames.iterator();
                while (iterator.hasNext()) {
                    CanonicalName canonicalName2 = (CanonicalName)iterator.next();
                    if (!canonicalName2.getCanonicalName().equals(permissionsManagerResults.getComponentName(i))) continue;
                    iterator.remove();
                    continue block8;
                }
            }
        }
        Iterator<Object> iterator = canonicalNames.iterator();
        while (iterator.hasNext()) {
            canonicalName = ((CanonicalName)iterator.next()).getCanonicalName();
            Runnable invoker = new Runnable((String)canonicalName, attributeNames, attributeValues, isSync, reportAttributes, results, ids){
                final /* synthetic */ String val$canonicalName;
                final /* synthetic */ String[] val$attributeNames;
                final /* synthetic */ Object[] val$attributeValues;
                final /* synthetic */ boolean val$isSync;
                final /* synthetic */ boolean val$reportAttributes;
                final /* synthetic */ Hashtable val$results;
                final /* synthetic */ HashMap val$ids;
                {
                    this.val$canonicalName = string;
                    this.val$attributeNames = stringArray;
                    this.val$attributeValues = objectArray;
                    this.val$isSync = bl;
                    this.val$reportAttributes = bl2;
                    this.val$results = hashtable;
                    this.val$ids = hashMap;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String[] rtnValue = null;
                    Exception ex = null;
                    try {
                        rtnValue = AgentManager.this.m_frameworkContext.setAttributes(this.val$canonicalName, this.val$attributeNames, this.val$attributeValues, this.val$isSync);
                        rtnValue = this.val$reportAttributes ? rtnValue : null;
                    }
                    catch (Exception e) {
                        ex = e;
                    }
                    Hashtable hashtable = this.val$results;
                    synchronized (hashtable) {
                        if (ex != null) {
                            this.val$results.put(this.val$canonicalName, new Object[]{null, ex});
                        } else if (this.val$isSync) {
                            this.val$results.put(this.val$canonicalName, new Object[]{rtnValue, null});
                        }
                        if (this.val$isSync && this.val$results.size() == this.val$ids.size()) {
                            this.val$results.notifyAll();
                        }
                    }
                }
            };
            this.m_taskScheduler.scheduleTask(invoker, false);
        }
        if (!isSync) {
            return permissionsManagerResults;
        }
        canonicalName = results;
        synchronized (canonicalName) {
            try {
                if (timeout <= 0L) {
                    while (results.size() < ids.size()) {
                        results.wait();
                    }
                } else {
                    long waitTime = timeout - (System.currentTimeMillis() - startTime);
                    while (waitTime > 0L && results.size() < ids.size()) {
                        results.wait(waitTime);
                        waitTime = timeout - (System.currentTimeMillis() - startTime);
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            iterator = ids.keySet().iterator();
            while (iterator.hasNext()) {
                String canonicalName3 = ((CanonicalName)iterator.next()).getCanonicalName();
                Object result = results.get(canonicalName3);
                if (result != null) continue;
                results.put(canonicalName3, new Object[]{null, new InvokeTimeoutException("Request timeout.")});
            }
        }
        Object[] entries = results.entrySet().toArray();
        CollectiveOpStatus collectiveOpStatus = permissionsManagerResults == null ? new CollectiveOpStatus(entries.length) : permissionsManagerResults;
        for (int i = 0; i < entries.length; ++i) {
            Map.Entry entry = (Map.Entry)entries[i];
            Object[] result = (Object[])entry.getValue();
            collectiveOpStatus.addResult((String)entry.getKey(), result[0], (Throwable)result[1]);
        }
        return collectiveOpStatus;
    }

    private void readConfiguration(IComponentContext context) {
        Reference backupRef;
        Object tmp = null;
        IElement amElement = context.getConfiguration(true);
        this.m_configID = amElement.getIdentity().getName();
        IAttributeSet amAttributes = amElement.getAttributes();
        IAttributeSet references = (IAttributeSet)amAttributes.getAttribute(CONFIG_ELEMENT_REFERENCES_ATTR);
        if (references != null && (backupRef = (Reference)references.getAttribute(BACKUP_CONFIG_ELEMENT_REF_ATTR)) != null) {
            this.m_faultToleranceRole = FAULT_TOLERANCE_ROLE_PRIMARY;
        }
        if (amElement.getIdentity().getType().equals(BACKUP_AGENT_MANAGER_TYPE)) {
            this.m_faultToleranceRole = FAULT_TOLERANCE_ROLE_BACKUP;
            IAttributeSet backupRefs = (IAttributeSet)amAttributes.getAttribute(CONFIG_ELEMENT_REFERENCES_ATTR);
            if (backupRefs == null) {
                throw new MFRuntimeException("Backup Agent Manager configuration " + this.m_configID + " does not reference a primary configuration");
            }
            Reference primaryRef = (Reference)backupRefs.getAttribute(PRIMARY_CONFIG_ELEMENT_REF_ATTR);
            if (primaryRef == null) {
                throw new MFRuntimeException("Backup Agent Manager configuration " + this.m_configID + " does not reference a primary configuration");
            }
            this.m_primaryConfigID = primaryRef.getElementName();
            IElement primaryEl = context.getConfiguration(this.m_primaryConfigID, true);
            amAttributes = primaryEl.getAttributes();
        } else {
            this.m_primaryConfigID = this.m_configID;
        }
        this.m_isNotFaultTolerant = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_DEFAULT);
        this.m_isPrimary = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_PRIMARY);
        this.m_isBackup = this.m_faultToleranceRole.equals(FAULT_TOLERANCE_ROLE_BACKUP);
        tmp = amAttributes.getAttribute("FAULT_DETECTION_INTERVAL");
        this.m_faultDetectionInterval = (tmp == null ? 5 : (Integer)tmp) * 1000;
        this.m_centralizedLogger.configure();
    }

    private synchronized void configureCentralizedLogging() {
        this.m_centralizedLogger.configure();
    }

    private void startDomainStateMonitor() {
        this.m_stateMonitor = new DomainStateMonitor(this, this.m_domainState, this.m_context);
        this.m_stateMonitor.setDaemon(true);
        try {
            IElement amElement = this.m_isBackup ? this.m_context.getConfiguration(this.m_primaryConfigID, true) : this.m_context.getConfiguration(true);
            IAttributeSet amAttributes = amElement.getAttributes();
            if (amAttributes != null) {
                Integer minThreads = (Integer)amAttributes.getAttribute("MIN_POLL_THREADS");
                Integer maxThreads = (Integer)amAttributes.getAttribute("MAX_POLL_THREADS");
                if (maxThreads != null) {
                    this.m_stateMonitor.setMaxThreads(maxThreads.shortValue());
                }
                if (minThreads != null) {
                    this.m_stateMonitor.setMinThreads(minThreads.shortValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_stateMonitor.start();
    }

    private void stopDomainStateMonitor() {
        if (this.m_stateMonitor != null) {
            this.m_stateMonitor.cleanup();
            this.m_stateMonitor = null;
        }
    }

    private void startFaultDetector() {
        this.m_faultDetector = new FaultDetector(this);
        this.m_faultDetector.setTestInterval(this.m_faultDetectionInterval);
        this.m_faultDetector.start();
    }

    private void stopFaultDetector() {
        if (this.m_faultDetector != null) {
            this.m_faultDetector.close();
            this.m_faultDetector = null;
        }
    }

    IStateManager getFaultToleranceStateManager() {
        return this.m_faultToleranceStateManager;
    }

    IFrameworkComponentContext getContext() {
        return this.m_frameworkContext;
    }

    private void validateActive() {
        if (!this.m_isNotFaultTolerant && this.m_faultToleranceStateManager.getState(null) != 2) {
            throw new MFServiceNotActiveException('[' + this.m_faultToleranceRole + "] Agent Manager not active");
        }
    }

    boolean leaseLock() throws Exception {
        long connectTimout = this.m_connectorServer.getConnectTimeout();
        long leaseRequestTimeout = this.getLeaseRequestTimeout();
        long leaseDuration = this.m_faultDetectionInterval + 5000L + connectTimout + leaseRequestTimeout;
        return (Boolean)this.getContext().invoke(this.getDSTarget(), "leaseLock", new Object[]{this.getGlobalID(), this.getVMID(), new Integer((int)(leaseDuration / 1000L))}, LEASELOCK_SIGNATURE, true, leaseRequestTimeout);
    }

    long getLeaseRequestTimeout() {
        int requestTimeout = (int)this.m_connectorServer.getRequestTimeout() >> 2;
        long leaseRequestTimeout = (long)requestTimeout > 10000L ? (long)requestTimeout : 10000L;
        return leaseRequestTimeout;
    }

    void releaseLock() {
        Runnable lockReleaser = new Runnable(){

            @Override
            public void run() {
                try {
                    String[] SIGNATURE = new String[]{String.class.getName(), String.class.getName()};
                    AgentManager.this.getContext().invoke(AgentManager.this.getDSTarget(), "releaseLock", new Object[]{AgentManager.this.getGlobalID(), AgentManager.this.getVMID()}, SIGNATURE, true, 0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.m_context.scheduleTask(lockReleaser, new Date());
    }

    private String getDSTarget() {
        StringBuffer target = new StringBuffer();
        target.append(this.getContext().getComponentName().getDomainName());
        target.append('.');
        target.append("DIRECTORY SERVICE");
        target.append(':').append("ID=");
        target.append("DIRECTORY SERVICE");
        return target.toString();
    }

    private String getVMID() {
        return this.m_vmID;
    }

    public void globalComponentAlreadyExists(String name) {
        if (this.m_isNotFaultTolerant) {
            this.m_context.logMessage("A non-fault tolerant or \"PRIMARY\" Agent Manager appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"PRIMARY\" Agent Manager", 1);
            this.abortContainer();
        } else if (name.startsWith('[' + this.m_faultToleranceRole + ']')) {
            this.m_context.logMessage("A \"" + this.m_faultToleranceRole + "\" Agent Manager appears to be running elsewhere; it must be shutdown prior to starting this container hosting the \"" + this.m_faultToleranceRole + "\" Agent Manager", 1);
            this.abortContainer();
        } else if (this.m_faultToleranceStateManager.getState(null) == 3) {
            this.m_abortFailover = true;
        } else {
            this.m_context.logMessage("An \"Active\" Agent Manager appears to be running elsewhere", 2);
            try {
                this.m_faultToleranceStateManager.requestStateChange((short)2, (short)3, null);
            }
            catch (MFException ex) {
                this.m_context.logMessage("Failed to revert to \"Standby\"; shutting down this container for manual resolution", 1);
                this.abortContainer();
            }
        }
    }

    private void abortContainer() {
        this.m_context.logMessage("Aborting container", 1);
        this.m_frameworkContext.getContainer().shutdown(6);
    }

    static {
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultToleranceRole", String.class.getName(), "The fault tolerant role of the AM (primary or backup) or null if not fault tolerant.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantState", Short.class.getName(), "The current fault tolerant state of this Agent Manager.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("FaultTolerantStateString", String.class.getName(), "The description of the current fault tolerant state of this Agent Manager.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("AllowFailover", Boolean.class.getName(), "When this Agent Manager is in a standby state and this attribute is set to 'false', fault tolerant failover to active will not occur.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("MaxPollingThreads", Integer.class.getName(), "The maximum number of threads that the Agent Manager can create to poll containers for their state.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("MinPollingThreads", Integer.class.getName(), "The minimum number of threads that the Agent Manager will cache for reuse to poll containers for their state.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFile", String.class.getName(), "The directory pathname of the centralized log file. Defaults to {<domain>.log} in the container's working directory.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileSize", Long.class.getName(), "The number of bytes written to the centralized log file. This value gets reset to 0 when the log is cleared or archived.", true, false, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileSizeThreshold", Long.class.getName(), "Once size of the the centralized log file reaches this threshold or for each time the size exceeds this threshold by a further 10%, the Agent Manager will send a warning notification.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFileRolloverSizeThreshold", Long.class.getName(), "If the current centralized log file size equals or exceeds this threshold at midnight, then the Agent Manager will roll over the old contents to an archive file and create a new empty centralized log file.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("logFileRolloverTimeInterval", Integer.class.getName(), "Time interval to rollover the log file contents.", true, true, false));
        MBeanParameterInfo[] mbParamInfos = null;
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("configID", String.class.getName(), "The path to the component collection configuration (either storage or logical)."), new MBeanParameterInfo("operationName", String.class.getName(), "The name of the operation to invoke on each of the containers/components in the collection."), new MBeanParameterInfo("operationParams", Object[].class.getName(), "The parameters to the operation."), new MBeanParameterInfo("operationSignature", String[].class.getName(), "The signature of the operation."), new MBeanParameterInfo("sync", Boolean.class.getName(), "If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result."), new MBeanParameterInfo("timeout", Long.class.getName(), "The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("invoke", "Invokes an operation on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. The return object is an aggregation of return values and/or exceptions wrapped in a <a href=\"../../common/runtime/ICollectiveOpStatus.html\">ICollectiveOpStatus</a>. Returns null if asynchronous execution is requested.", mbParamInfos, Object.class.getName(), 2));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("configID", String.class.getName(), "The path to the component collection configuration (either storage or logical)."), new MBeanParameterInfo("attributeName", String.class.getName(), "The name of the attribute."), new MBeanParameterInfo("attributeValue", Object.class.getName(), "The value of the attribute."), new MBeanParameterInfo("sync", Boolean.class.getName(), "If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result."), new MBeanParameterInfo("timeout", Long.class.getName(), "The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setAttribute", "Sets an attribute on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. Returns null if asynchronous execution is requested.", mbParamInfos, ICollectiveOpStatus.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("configID", String.class.getName(), "The path to the component collection configuration (either storage or logical)."), new MBeanParameterInfo("attributeNames", String[].class.getName(), "The names of the attributes."), new MBeanParameterInfo("attributeValues", Object[].class.getName(), "The values of the attributes."), new MBeanParameterInfo("sync", Boolean.class.getName(), "If false, aynchronously invoke the operation on the collection and return null, otherwise build and return a collective result."), new MBeanParameterInfo("timeout", Long.class.getName(), "The time in milliseconds to wait for all responses to be received. The value should be greater than the request timeout value. The value is ignored if asynchronous execution is specified.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("setAttributes", "Sets attributes on the given component collection. If synchronous execution is requested, returns the return values or exceptions of the individual requests to member of the collection. Returns null if asynchronous execution is requested.", mbParamInfos, ICollectiveOpStatus.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("getCollectiveState", "Gets the runtime state of the whole domain as recorded by the Agent Manager. Returns an array of IContainerState instances.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, IState[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("configID", String.class.getName(), "The configuration ID of the collection for which the status is being sought. Returns an array of IContainerState or IComponentState instances that describe the state of the given collection. If an item in the collection no longer represents a known runtime identity then no runtime status will be provided in the returned array.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getCollectiveState", "Gets the runtime state of the given collection as recorded by the Agent Manager.", mbParamInfos, IState[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("runtimeIds", String[].class.getName(), "The list of the containers runtime identities for which the status is being sought.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getCollectiveState", "Gets the runtime state for the given list of containers as recorded by the Agent Manager. Returns an array of IContainerState instances.", mbParamInfos, IState[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("seconds", Integer.class.getName(), "The minimum time the active role will be suspended.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("suspendActiveRole", "Relinquish the current active role to the the standby. For an active AM, this operation attempts to relinquish the active role to the current standby. The active AM will wait up to the given number of seconds for a standby to takeover the active role; if a standby does not takeover the active role in this period, the AM will continue its active role.", mbParamInfos, Void.class.getName(), 1));
        OPERATION_INFOS.add(new MBeanOperationInfo("clearLogFile", "Clear the centralized log file.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("filename", String.class.getName(), "A valid filename (including path) to save the centralized log file to.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("saveLogFile", "Saves the contents of the centralized log file to the given file name.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("fromPosition", Long.class.getName(), "The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions."), new MBeanParameterInfo("readLength", Long.class.getName(), "The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getLogExtract", "Reads the requested bytes from the centralized log file and returns them as a String.", mbParamInfos, String.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("fromPosition", Long.class.getName(), "The starting position from which to read the log for the given date. If null, then the total log length minus the given readLength is assumed (i.e. the tail of the logging output). The total log length is calculated by summing the size of all log files (current + previous versions."), new MBeanParameterInfo("readLength", Long.class.getName(), "The maximum amount of bytes to read from the given (or assumed) starting position. The max size for this value is 1Mb. If null, 200Kb is assumed.")};
        try {
            LOG_COMPOSITE_TYPE_ITEM_NAMES = new String[]{"LogExtract", "LogFileSize"};
            LOG_COMPOSITE_TYPE = new CompositeType("LogExtract", "An extract from and the length of the centralized log", LOG_COMPOSITE_TYPE_ITEM_NAMES, new String[]{"Log extract String", "Total log size"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG});
        }
        catch (OpenDataException e) {
            e.printStackTrace();
        }
        OPERATION_INFOS.add(new MBeanOperationInfo("getLogExtractAndLogFileSize", "Reads the requested bytes from the centralized log file and returns them as a String encapsulated with the current log size. The current log size is the size of the current log file plus the sum of all available prior versions. When evaluating log output to be read, the current log file and previous versions (due to rollover activity) will be effectively viewed as a single file.", mbParamInfos, CompositeData.class.getName(), 0));
        if (IContainer.QA_MODE) {
            OPERATION_INFOS.add(new MBeanOperationInfo("attemptLogFileRollover", "Attempt a centralized log file rollover (QA mode only).", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        }
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], STARTUP_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Agent/Container startup completed."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], UNREACHABLE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Container unreachable."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[0], FAILOVER_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Standby service has failed over to become the active service."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[1], LOGFAILURE_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Failure to write to the centralized log file."));
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[1], LOGTHRESHOLD_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "The size of the current centralized log has reached or exceeded (by a 10% increment) the configured threshold."));
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mf.am", AgentManager.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
            this.setTraceMask();
        }

        private void setTraceMask() {
            this.setTraceMask(new Integer(AgentManager.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            AgentManager.this.setTraceMask(this.getCurrentMask(), true);
        }
    }

    public class StateListener
    implements IStateListener {
        public void stateChanging(short currentState, short intendedState) {
        }

        public void stateChanged(short previousState, short currentState) {
            block0 : switch (previousState) {
                case 1: {
                    switch (currentState) {
                        case 2: 
                        case 3: {
                            ((AbstractComponent)AgentManager.this).m_context.logMessage("Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 3);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (currentState) {
                        case 2: {
                            ((AbstractComponent)AgentManager.this).m_context.logMessage("Failover to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 2);
                            AgentManager.this.sendFailoverNotification();
                            break;
                        }
                        case 1: {
                            ((AbstractComponent)AgentManager.this).m_context.logMessage("Reverting to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 2);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (currentState) {
                        case 1: {
                            ((AbstractComponent)AgentManager.this).m_context.logMessage("Transition to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 3);
                            break block0;
                        }
                        case 3: {
                            ((AbstractComponent)AgentManager.this).m_context.logMessage("Reverting to state: \"" + IFaultTolerantState.STATE_TEXT[currentState] + '\"', 3);
                        }
                    }
                }
            }
        }

        public void stateChangeFailed(short currentState, short intendedState) {
            ((AbstractComponent)AgentManager.this).m_context.logMessage("Failed to change from " + IFaultTolerantState.STATE_TEXT[currentState] + " to " + IFaultTolerantState.STATE_TEXT[intendedState], 3);
        }
    }

    public class WaitingStandbyStateController
    implements IStateController {
        public boolean changeState() {
            return true;
        }
    }

    public class FromActiveStateController
    implements IStateController {
        public boolean changeState() {
            AgentManager.this.releaseLock();
            AgentManager.this.m_container.removeGlobalComponentSupport(AgentManager.this.getGlobalID(), null);
            AgentManager.this.stopDomainStateMonitor();
            return true;
        }
    }

    public class ToActiveStateController
    implements IStateController {
        public boolean changeState() throws NonRecoverableStateChangeException, RecoverableStateChangeException {
            AgentManager.this.m_abortFailover = false;
            String msgPrefix = '[' + AgentManager.this.m_faultToleranceRole + "] ";
            try {
                AgentManager.this.m_container.addGlobalComponentSupport(AgentManager.this.getGlobalID(), null, (IGlobalComponentListener)AgentManager.this);
            }
            catch (Exception e) {
                AgentManager.this.m_container.removeGlobalComponentSupport(AgentManager.this.getGlobalID(), null);
                AgentManager.this.m_context.logMessage(msgPrefix + "Failed communications initialization, trace follows...", (Throwable)e, 1);
                AgentManager.this.m_container.shutdown(9);
            }
            if (AgentManager.this.m_abortFailover) {
                AgentManager.this.m_container.removeGlobalComponentSupport(AgentManager.this.getGlobalID(), null);
                String message = msgPrefix + "Failover aborted: an active Agent Manager already exists";
                AgentManager.this.m_context.logMessage(message, 1);
                throw new RecoverableStateChangeException(message);
            }
            AgentManager.this.startDomainStateMonitor();
            return true;
        }
    }
}

