/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.manager;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.framework.util.RollingFileLogger;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

class CentralizedLogger {
    private IComponentContext m_context;
    private String m_path;
    private String m_defaultPath;
    private RollingFileLogger m_centralFileLogger;
    private LogWriter m_writer;
    private long m_logFileThreshold = 0x2000000L;
    private long m_logFileRolloverThreshold = 0x400000L;
    private int m_logFileRolloverTimeInterval = 1440;
    private ArrayList m_messageQueue = new ArrayList();
    private Object m_messageQueueSyncObj = new Object();
    private static final String FILELOG_SUFFIX = ".log";
    private static int MAX_BUFFERED_LOG_MESSAGES = Integer.parseInt(System.getProperty("sonicsw.mf.manager.maxBufferedLogMessages", "1000"));
    private static int DROP_BUFFERED_LOG_MESSAGES = Integer.parseInt(System.getProperty("sonicsw.mf.manager.dropBufferedLogMessages", "500"));
    private static CompositeType LOG_COMPOSITE_TYPE;
    private static String[] LOG_COMPOSITE_TYPE_ITEM_NAMES;
    private final SimpleDateFormat m_dateTimeFormatter = new SimpleDateFormat("yy/MM/dd HH:mm:ss");

    CentralizedLogger(IComponentContext context) {
        this.m_context = context;
        this.m_path = this.m_defaultPath = context.getComponentName().getDomainName() + FILELOG_SUFFIX;
        this.configure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logMessage(String message) {
        this.open();
        Object object = this.m_messageQueueSyncObj;
        synchronized (object) {
            if (this.m_messageQueue.size() >= MAX_BUFFERED_LOG_MESSAGES) {
                Object[] messages = this.m_messageQueue.toArray();
                this.m_messageQueue = new ArrayList(MAX_BUFFERED_LOG_MESSAGES);
                int keepBufferedLogMessages = MAX_BUFFERED_LOG_MESSAGES - DROP_BUFFERED_LOG_MESSAGES;
                for (int i = 0; i < keepBufferedLogMessages; ++i) {
                    this.m_messageQueue.add(i, messages[i + keepBufferedLogMessages]);
                }
                String warning = this.createLogMessage("Writing of centralized log messages is too slow; the oldest " + DROP_BUFFERED_LOG_MESSAGES + " messages have been discarded, check remote logs", 2);
                this.m_centralFileLogger.logMessage(warning);
            }
            this.m_messageQueue.add(message);
            this.m_messageQueueSyncObj.notifyAll();
        }
    }

    String getLogExtract(Long fromPosition, Long readLength) {
        this.open();
        if (fromPosition == null) {
            fromPosition = new Long(-1L);
        }
        if (readLength == null) {
            readLength = new Long(-1L);
        }
        try {
            return new String(this.m_centralFileLogger.read(fromPosition.longValue(), readLength.longValue()));
        }
        catch (IOException e) {
            MFRuntimeException mfe = new MFRuntimeException("Failed to read centralized log file");
            mfe.setLinkedException((Exception)e);
            throw mfe;
        }
    }

    CompositeData getLogExtractAndLogFileSize(Long fromPosition, Long readLength) {
        try {
            Object[] itemValues = new Object[]{this.getLogExtract(fromPosition, readLength), new Long(this.m_centralFileLogger.length())};
            return new CompositeDataSupport(LOG_COMPOSITE_TYPE, LOG_COMPOSITE_TYPE_ITEM_NAMES, itemValues);
        }
        catch (OpenDataException e) {
            this.m_context.logMessage("Failed to create centralized log extract, trace follows...", (Throwable)e, 2);
            return null;
        }
    }

    String getLogFile() {
        return new File(this.m_path).getAbsolutePath();
    }

    void setLogFile(String path) throws Exception {
        this.m_path = path == null || path.length() == 0 ? this.m_defaultPath : path;
        if (this.m_centralFileLogger != null) {
            this.m_centralFileLogger.resetLogDirectory(this.m_path);
        }
    }

    Long getLogFileSizeThreshold() {
        return new Long(this.m_logFileThreshold);
    }

    void setLogFileSizeThreshold(Long thresholdSize) {
        RollingFileLogger fileLogger = this.m_centralFileLogger;
        if (thresholdSize != this.m_logFileThreshold && fileLogger != null) {
            fileLogger.setSizeThreshold(thresholdSize.longValue());
        }
        this.m_logFileThreshold = thresholdSize;
    }

    Long getLogFileRolloverSizeThreshold() {
        return new Long(this.m_logFileRolloverThreshold);
    }

    void setLogFileRolloverSizeThreshold(Long thresholdSize) {
        RollingFileLogger fileLogger = this.m_centralFileLogger;
        if (thresholdSize != this.m_logFileRolloverThreshold && fileLogger != null) {
            fileLogger.setRolloverThreshold(thresholdSize.longValue());
        }
        this.m_logFileRolloverThreshold = thresholdSize;
    }

    Integer getLogFileRolloverTimeInterval() {
        return new Integer(this.m_logFileRolloverTimeInterval);
    }

    void setLogFileRolloverTimeInterval(Integer intervalValue) {
        RollingFileLogger fileLogger = this.m_centralFileLogger;
        if (intervalValue != this.m_logFileRolloverTimeInterval && fileLogger != null) {
            fileLogger.set_LogRolloverTimeInterval(intervalValue.intValue());
        }
        this.m_logFileRolloverTimeInterval = intervalValue;
    }

    synchronized void clearLogFile() {
        this.open();
        try {
            this.m_centralFileLogger.clearLogFile();
        }
        catch (IOException e) {
            MFRuntimeException runtimeException = new MFRuntimeException("Failed to clear centralized log file");
            runtimeException.setLinkedException((Exception)e);
            throw runtimeException;
        }
        this.m_context.logMessage("Centralized log file truncated", 3);
    }

    synchronized void saveLogFile(String path) {
        this.open();
        try {
            this.m_centralFileLogger.saveLogFile(path);
        }
        catch (IOException e) {
            MFRuntimeException runtimeException = new MFRuntimeException("Failed to save centralized log file to " + path);
            runtimeException.setLinkedException((Exception)e);
            throw runtimeException;
        }
        this.m_context.logMessage("Centralized log file copied to " + path, 3);
    }

    void attemptLogFileRollover() throws IOException {
        this.open();
        RollingFileLogger fileLogger = this.m_centralFileLogger;
        if (fileLogger == null) {
            return;
        }
        this.m_context.logMessage("Manual rollover attempt of centralized log file initiated", 7);
        fileLogger.attemptLogFileRollover();
    }

    final synchronized void configure() {
        IElement domainElement = this.m_context.getConfiguration("/domain/domain", true);
        IAttributeSet attributes = domainElement.getAttributes();
        try {
            Long logFileSizeThreshold;
            String centralizedLogFile = (String)attributes.getAttribute("CENTRALIZED_LOG_FILE");
            if (centralizedLogFile == null || centralizedLogFile.length() == 0) {
                if (!this.m_path.equals(this.m_defaultPath)) {
                    this.m_path = this.m_defaultPath;
                    if (this.m_centralFileLogger != null) {
                        this.m_centralFileLogger.resetLogDirectory(this.m_path);
                    }
                }
            } else if (!this.m_path.equals(centralizedLogFile)) {
                this.m_path = centralizedLogFile;
                if (this.m_centralFileLogger != null) {
                    this.m_centralFileLogger.resetLogDirectory(this.m_path);
                }
            }
            if ((logFileSizeThreshold = (Long)attributes.getAttribute("LOG_FILE_SIZE_THRESHOLD")) == null) {
                logFileSizeThreshold = new Long(0x2000000L);
            }
            this.setLogFileSizeThreshold(logFileSizeThreshold);
            Long logFileRolloverSizeThreshold = (Long)attributes.getAttribute("LOG_FILE_ROLLOVER_SIZE_THRESHOLD");
            if (logFileRolloverSizeThreshold == null) {
                logFileRolloverSizeThreshold = new Long(0x400000L);
            }
            this.setLogFileRolloverSizeThreshold(logFileRolloverSizeThreshold);
            Integer logFileRolloverTimeInterval = (Integer)attributes.getAttribute("LOG_FILE_ROLLOVER_TIME_INTERVAL");
            if (logFileRolloverTimeInterval == null) {
                logFileRolloverTimeInterval = new Integer(1440);
            }
            this.setLogFileRolloverTimeInterval(logFileRolloverTimeInterval);
        }
        catch (Exception e) {
            this.m_context.logMessage("Failed to configure centralized logging, trace follows...", (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        block5: {
            try {
                if (this.m_centralFileLogger == null) break block5;
                this.m_centralFileLogger.close();
                this.m_centralFileLogger = null;
                Object object = this.m_messageQueueSyncObj;
                synchronized (object) {
                    this.m_messageQueue.clear();
                    this.m_messageQueueSyncObj.notifyAll();
                }
            }
            catch (IOException e) {
                MFRuntimeException mfe = new MFRuntimeException("Failed to close centralized log file");
                mfe.setLinkedException((Exception)e);
                throw mfe;
            }
        }
    }

    long length() {
        this.open();
        return this.m_centralFileLogger.length();
    }

    private void open() {
        try {
            if (this.m_centralFileLogger == null) {
                this.m_centralFileLogger = new RollingFileLogger(this.m_context, this.m_path, this.m_context.getComponentName().getDomainName(), this.m_logFileRolloverTimeInterval);
                this.m_centralFileLogger.setSizeThreshold(this.m_logFileThreshold);
                this.m_centralFileLogger.setRolloverThreshold(this.m_logFileRolloverThreshold);
                this.m_writer = new LogWriter();
                this.m_writer.start();
            }
        }
        catch (IOException e) {
            MFRuntimeException mfe = new MFRuntimeException("Failed to open centralized log file");
            mfe.setLinkedException((Exception)e);
            throw mfe;
        }
    }

    private String createLogMessage(String message, int severityLevel) {
        StringBuffer timestampedMessage = new StringBuffer();
        timestampedMessage.append('[');
        timestampedMessage.append(this.m_dateTimeFormatter.format(new Date(System.currentTimeMillis())));
        timestampedMessage.append("]");
        timestampedMessage.append(" (");
        timestampedMessage.append(Level.LEVEL_TEXT[severityLevel]);
        timestampedMessage.append(") ");
        timestampedMessage.append(message);
        return timestampedMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessages() {
        Object object = this.m_messageQueueSyncObj;
        synchronized (object) {
            if (!this.m_messageQueue.isEmpty()) {
                String message = (String)this.m_messageQueue.remove(0);
                this.m_centralFileLogger.logMessage(message);
            } else {
                while (this.m_messageQueue.isEmpty()) {
                    try {
                        this.m_messageQueueSyncObj.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private class LogWriter
    extends Thread {
        private LogWriter() {
            super("Centralized Logging - Log Writer");
            super.setDaemon(true);
        }

        @Override
        public void run() {
            while (CentralizedLogger.this.m_centralFileLogger != null) {
                try {
                    CentralizedLogger.this.writeMessages();
                }
                catch (NullPointerException e) {
                    if (CentralizedLogger.this.m_centralFileLogger == null) {
                        return;
                    }
                    e.printStackTrace();
                }
            }
        }
    }
}

