/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.manager;

import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentState;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

final class CurrentDomainState {
    private Hashtable m_containerStates = new Hashtable();

    CurrentDomainState(IElement[] initialContainerList) {
        for (int i = 0; i < initialContainerList.length; ++i) {
            this.addContainer((IElement)((IDirElement)initialContainerList[i]));
        }
    }

    void addContainer(IElement containerConfig) {
        if (((IDirElement)containerConfig).isTemplate()) {
            return;
        }
        ContainerIdentity containerID = new ContainerIdentity(containerConfig);
        IElementIdentity containerConfigID = containerID.getConfigIdentity();
        CanonicalName canonicalName = new CanonicalName(containerID.getDomainName(), containerID.getContainerName(), "");
        ContainerState containerState = new ContainerState(canonicalName, containerConfigID);
        containerState.setState((short)0);
        containerState.setContainerHost("<UNKNOWN>");
        containerState.setTimestamp(0L);
        this.m_containerStates.put(canonicalName.getCanonicalName(), new Object[]{containerState});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContainer(String containerConfigID) {
        Hashtable hashtable = this.m_containerStates;
        synchronized (hashtable) {
            Enumeration keys = this.m_containerStates.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object[] value = (Object[])this.m_containerStates.get(key);
                IContainerState containerState = (IContainerState)value[0];
                if (!containerState.getRuntimeIdentity().getConfigIdentity().getName().equals(containerConfigID)) continue;
                this.m_containerStates.remove(key);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IContainerState[] getDomainState() {
        Hashtable hashtable = this.m_containerStates;
        synchronized (hashtable) {
            Collection collection = this.m_containerStates.values();
            Object[] values = collection.toArray();
            IContainerState[] containerStates = new IContainerState[values.length];
            for (int i = 0; i < values.length; ++i) {
                containerStates[i] = (IContainerState)((Object[])values[i])[0];
            }
            return containerStates;
        }
    }

    ContainerState getContainerState(String container) {
        Object[] value = (Object[])this.m_containerStates.get(container);
        if (value == null) {
            return null;
        }
        return (ContainerState)value[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateContainerState(String container, IContainerState newContainerState) {
        Object[] value = (Object[])this.m_containerStates.get(container);
        if (value == null) {
            return;
        }
        Object[] objectArray = value;
        synchronized (value) {
            value[0] = newContainerState;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateContainerState(String container, short state, long timestamp) {
        Object[] value = (Object[])this.m_containerStates.get(container);
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value[0] == null) {
            return false;
        }
        Object[] objectArray = value;
        synchronized (value) {
            ContainerState containerState = (ContainerState)value[0];
            if (state == 1) {
                long containerTimestamp = containerState.getTimeStamp();
                if (timestamp == containerTimestamp || timestamp != 0L && timestamp < containerTimestamp) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return false;
                }
                containerState.setTimestamp(timestamp);
                if (containerState.getState() == 1) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return false;
                }
                containerState.setState((short)1);
                IComponentState[] componentStates = containerState.getComponentStates();
                for (int i = 0; i < componentStates.length; ++i) {
                    ComponentState componentState = (ComponentState)componentStates[i];
                    componentState.setState((short)1);
                    componentState.setLastErrorLevel(0);
                    componentState.setLastErrorDescription("");
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return false;
            }
            if (state == 3) {
                if (timestamp <= containerState.getTimeStamp()) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return false;
                }
                containerState.setTimestamp(timestamp);
                if (containerState.getState() == 3) {
                    // ** MonitorExit[var6_5] (shouldn't be in output)
                    return false;
                }
                containerState.setState((short)3);
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateComponentState(String container, String componentID, short state, String lastError, Integer lastErrorLevel, long timestamp) {
        Object[] value = (Object[])this.m_containerStates.get(container);
        if (value == null) {
            return false;
        }
        Object[] objectArray = value;
        synchronized (value) {
            ContainerState containerState = (ContainerState)value[0];
            if (containerState.getState() == 3) {
                if (timestamp <= containerState.getTimeStamp()) {
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return true;
                }
                containerState.setTimestamp(timestamp);
                IComponentState[] componentStates = containerState.getComponentStates();
                for (int i = 0; i < componentStates.length; ++i) {
                    IComponentIdentity componentIdentity = (IComponentIdentity)componentStates[i].getRuntimeIdentity();
                    if (!componentIdentity.getComponentName().equals(componentID)) continue;
                    this.updateComponentState(componentStates[i], state, lastError, lastErrorLevel);
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return true;
            }
            if (state == 3) {
                if (timestamp <= containerState.getTimeStamp()) {
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return true;
                }
                containerState.setTimestamp(timestamp);
                containerState.setState((short)3);
                IComponentState[] componentStates = containerState.getComponentStates();
                for (int i = 0; i < componentStates.length; ++i) {
                    IComponentIdentity componentIdentity = (IComponentIdentity)componentStates[i].getRuntimeIdentity();
                    if (!componentIdentity.getComponentName().equals(componentID)) continue;
                    this.updateComponentState(componentStates[i], state, lastError, lastErrorLevel);
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return true;
            }
            if (state == 1) {
                if (timestamp <= containerState.getTimeStamp()) {
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return true;
                }
                containerState.setTimestamp(timestamp);
                IComponentState[] componentStates = containerState.getComponentStates();
                for (int i = 0; i < componentStates.length; ++i) {
                    IComponentIdentity componentIdentity = (IComponentIdentity)componentStates[i].getRuntimeIdentity();
                    if (!componentIdentity.getComponentName().equals(componentID)) continue;
                    if (componentStates[i].getState() == state) {
                        // ** MonitorExit[var9_8] (shouldn't be in output)
                        return false;
                    }
                    this.updateComponentState(componentStates[i], state, lastError, lastErrorLevel);
                    // ** MonitorExit[var9_8] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var9_8] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeComponentState(String container, String componentID, long timestamp) {
        Object[] value = (Object[])this.m_containerStates.get(container);
        if (value == null) {
            return;
        }
        Object[] objectArray = value;
        synchronized (value) {
            ContainerState containerState = (ContainerState)value[0];
            if (containerState.getState() == 1) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
            if (timestamp < containerState.getTimeStamp()) {
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return;
            }
            containerState.setTimestamp(timestamp);
            containerState.removeComponentState(componentID);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private void updateComponentState(IComponentState componentState, short state, String lastError, Integer lastErrorLevel) {
        ((ComponentState)componentState).setState(state);
        ((ComponentState)componentState).setLastErrorDescription(lastError);
        ((ComponentState)componentState).setLastErrorLevel(lastErrorLevel.intValue());
    }
}

