/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.manager;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.impl.ContainerState;
import com.sonicsw.mf.framework.manager.AgentManager;
import com.sonicsw.mf.framework.manager.CurrentDomainState;
import com.sonicsw.mf.mgmtapi.runtime.IAgentManagerProxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Stack;

final class DomainStateMonitor
extends Thread {
    private boolean DEBUG_THREADS = false;
    private boolean DEBUG = false;
    private AgentManager m_manager;
    private CurrentDomainState m_domainState;
    private IComponentContext m_context;
    private Integer m_defaultStatusPollInterval = new Integer(60);
    private Integer m_defaultStatusPollTimeout = new Integer(30);
    private static final long MAX_IDLE_DURATION = 5000L;
    private ArrayList m_scheduledStatusChecks = new ArrayList();
    private short m_maxWorkerThreads;
    private short m_minWorkerThreads;
    private short m_workerThreadPoolSize = 0;
    private static Stack s_workerThreadPool = new Stack();
    private static int s_executingWorkerThreads = 0;
    private static volatile IMetricsRegistrar s_metricsRegistrar;
    private static volatile IStatistic s_poolSizeStatistic;
    private static volatile IStatistic s_maxPoolSizeStatistic;
    private static volatile IStatistic s_poolWaitsStatistic;
    private boolean m_run = true;
    private Object m_monitorLockObj = new Object();
    private static boolean s_running;
    public static final String TASK_THREAD_NAME = "Container State Poller ";
    public static final short DEFAULT_MIN_THREADS = 0;
    public static final short DEFAULT_MAX_THREADS = 50;
    public static final short MAX_THREAD_LOWER_BOUND = 20;
    public static final short MAX_THREAD_UPPER_BOUND = 1000;

    DomainStateMonitor(AgentManager manager, CurrentDomainState domainState, IComponentContext context) {
        super("AGENT MANAGER - Domain State Monitor");
        this.m_manager = manager;
        this.m_domainState = domainState;
        this.m_context = context;
        this.m_minWorkerThreads = 0;
        this.m_maxWorkerThreads = (short)50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        s_running = true;
        this.reschedule();
        while (this.m_run) {
            Check check = null;
            Object object = this.m_monitorLockObj;
            synchronized (object) {
                block23: {
                    if (this.DEBUG_THREADS) {
                        System.out.println("DomainStateMonitor.run: count of scheduled status checks = " + this.m_scheduledStatusChecks.size());
                    }
                    if (!this.m_scheduledStatusChecks.isEmpty()) {
                        block22: {
                            check = (Check)this.m_scheduledStatusChecks.get(0);
                            if (this.DEBUG_THREADS) {
                                System.out.println("DomainStateMonitor.run: schedule check for container = " + check.container);
                            }
                            if (check.scheduledTime <= System.currentTimeMillis()) {
                                if (this.DEBUG_THREADS) {
                                    System.out.println("DomainStateMonitor.run: time to check for container = " + check.container);
                                }
                                check.scheduledTime = Long.MAX_VALUE;
                                this.replaceCheck(check);
                                if (this.DEBUG_THREADS) {
                                    System.out.println("DomainStateMonitor.run: ...for container = " + check.container + ", m_run = " + this.m_run);
                                }
                            } else {
                                long interval = check.scheduledTime - System.currentTimeMillis();
                                if (this.DEBUG_THREADS) {
                                    System.out.println("DomainStateMonitor.run: wait for interval = " + interval + " before polling...");
                                }
                                try {
                                    if (interval > 0L) {
                                        this.m_monitorLockObj.wait(interval);
                                    }
                                    continue;
                                }
                                catch (InterruptedException ie) {
                                    if (!this.DEBUG_THREADS) break block22;
                                    this.m_context.logMessage("DomainStateMonitor.run: InterruptedException thrown during wait(interval)...", 7);
                                    ie.printStackTrace();
                                }
                            }
                        }
                        if (this.DEBUG_THREADS) {
                            System.out.println("DomainStateMonitor.run: exiting if block for container = " + check.container);
                        }
                    } else {
                        if (this.DEBUG_THREADS) {
                            System.out.println("DomainStateMonitor.run: no scheduled status checks, sleep for a second...");
                        }
                        try {
                            this.m_monitorLockObj.wait(1000L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            if (!this.DEBUG_THREADS) break block23;
                            this.m_context.logMessage("DomainStateMonitor.run: InterruptedException thrown during wait(1000)...", 7);
                            ie.printStackTrace();
                        }
                    }
                }
                if (this.DEBUG_THREADS) {
                    System.out.println("DomainStateMonitor.run: about to release synch lock on DSM for container = " + check.container);
                }
            }
            if (this.DEBUG_THREADS) {
                System.out.println("DomainStateMonitor.run: get a worker threead for container = " + (check == null ? null : check.container));
            }
            this.assignTask(check);
        }
        s_running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignTask(Runnable task) {
        WorkerThread workerThread = null;
        Stack stack = s_workerThreadPool;
        synchronized (stack) {
            while (workerThread == null) {
                try {
                    workerThread = (WorkerThread)s_workerThreadPool.pop();
                }
                catch (EmptyStackException e) {
                    if (this.m_workerThreadPoolSize == this.m_maxWorkerThreads) {
                        if (s_poolWaitsStatistic != null) {
                            s_poolWaitsStatistic.updateValue(1L);
                        }
                        try {
                            if (this.DEBUG_THREADS) {
                                System.out.println("DomainStateMonitor.assignTask: wait on worker thread pool...");
                            }
                            s_workerThreadPool.wait();
                            if (this.m_run) continue;
                            return;
                        }
                        catch (InterruptedException ie) {
                            if (this.DEBUG_THREADS) {
                                this.m_context.logMessage("DomainStateMonitor.assignTask: InterruptedException thrown during wait on s_workerThreadPool...", 7);
                                ie.printStackTrace();
                            }
                            return;
                        }
                    }
                    this.m_workerThreadPoolSize = (short)(this.m_workerThreadPoolSize + 1);
                    break;
                }
            }
            if (workerThread == null) {
                if (this.DEBUG_THREADS) {
                    System.out.println("DomainStateMonitor.assignTask: assign task to new worker thread: " + task);
                }
                workerThread = new WorkerThread();
                workerThread.task = task;
                workerThread.setDaemon(true);
                workerThread.start();
            } else {
                if (this.DEBUG_THREADS) {
                    System.out.println("DomainStateMonitor.assignTask: assign task to existing worker thread: " + task);
                }
                workerThread.task = task;
            }
            ++s_executingWorkerThreads;
            s_workerThreadPool.notifyAll();
        }
    }

    public short getMaxThreads() {
        return this.m_maxWorkerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxThreads(short maxThreads) {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            if (maxThreads > 1000) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot exceed 1000.");
            }
            if (maxThreads < this.m_minWorkerThreads) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot be less than the minimum scheduler threads.");
            }
            if (maxThreads < 20) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot be less than 20.");
            }
            this.m_maxWorkerThreads = maxThreads;
        }
    }

    public short getMinThreads() {
        return this.m_minWorkerThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinThreads(short minThreads) {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            if (minThreads < 0) {
                throw new IllegalArgumentException("Minimum number of domain state monitor threads cannot be less than 0.");
            }
            if (minThreads > this.m_maxWorkerThreads) {
                throw new IllegalArgumentException("Minimum number of domain state monitor threads must be less than, or equal to, the maximum number of domain state monitor threads.");
            }
            this.m_minWorkerThreads = minThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            this.m_scheduledStatusChecks.clear();
            this.m_run = false;
            this.m_monitorLockObj.notifyAll();
            Stack stack = s_workerThreadPool;
            synchronized (stack) {
                s_workerThreadPool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reschedule() {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            int i;
            IContainerState[] containerStates = this.m_domainState.getDomainState();
            HashSet<String> containers = new HashSet<String>();
            for (int i2 = 0; i2 < containerStates.length; ++i2) {
                containers.add(containerStates[i2].getRuntimeIdentity().getCanonicalName());
            }
            if (this.DEBUG) {
                this.m_context.logMessage("DomainStateMonitor.reschedule(): number of containers=" + containerStates.length, 7);
            }
            Object[] priorChecks = this.m_scheduledStatusChecks.toArray();
            HashSet<String> currentChecks = new HashSet<String>();
            for (i = 0; i < priorChecks.length; ++i) {
                if (containers.contains(((Check)priorChecks[i]).container)) {
                    currentChecks.add(((Check)priorChecks[i]).container);
                    continue;
                }
                this.m_scheduledStatusChecks.remove(priorChecks[i]);
            }
            for (i = 0; i < containerStates.length; ++i) {
                Check newCheck;
                String container = containerStates[i].getRuntimeIdentity().getCanonicalName();
                if (currentChecks.contains(container) || !(newCheck = new Check(0L, container)).updatePollingParams()) continue;
                this.m_scheduledStatusChecks.add(0, newCheck);
            }
        }
    }

    void schedule(final String container) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    IContainerState containerState = DomainStateMonitor.this.m_manager.getContainerState(container, 0L);
                    DomainStateMonitor.this.m_domainState.updateContainerState(container, containerState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.assignTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reschedule(String container) {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            int size = this.m_scheduledStatusChecks.size();
            for (int i = 0; i < size; ++i) {
                Check check = (Check)this.m_scheduledStatusChecks.get(i);
                if (!check.container.equals(container)) continue;
                if (check.scheduledTime != Long.MAX_VALUE) {
                    return;
                }
                this.m_scheduledStatusChecks.remove(i);
                Check newCheck = new Check(0L, check);
                if (!newCheck.updatePollingParams()) continue;
                this.m_scheduledStatusChecks.add(0, newCheck);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleContainerStateNotification(IContainerState containerState, long timestamp) {
        String sourceContainer = containerState.getRuntimeIdentity().getCanonicalName();
        this.m_domainState.updateContainerState(sourceContainer, containerState);
        if (this.DEBUG) {
            this.m_context.logMessage("DomainStateMonitor.handleContainerStateNotification: received container state notification...", 7);
        }
        if ((this.m_manager.m_traceMask & 0x10) > 0) {
            this.m_context.logMessage("Container state notification received: " + sourceContainer + ", state=" + IContainerState.STATE_TEXT[containerState.getState()], 7);
        }
        Check replacementCheck = null;
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            int size = this.m_scheduledStatusChecks.size();
            for (int i = 0; i < size; ++i) {
                Check check = (Check)this.m_scheduledStatusChecks.get(i);
                if (!check.container.equals(sourceContainer)) continue;
                replacementCheck = check;
                break;
            }
            if (replacementCheck == null) {
                if (this.DEBUG) {
                    this.m_context.logMessage("DomainStateMonitor.handleContainerStateNotification: didn't find check for container OR not time to check yet, returning...", 7);
                }
                if (!(replacementCheck = new Check(0L, sourceContainer)).updatePollingParams()) {
                    return;
                }
            }
            replacementCheck.scheduledTime = replacementCheck.pollingParams[0] == 0L ? Long.MAX_VALUE : System.currentTimeMillis() + replacementCheck.pollingParams[0];
            this.replaceCheck(replacementCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceCheck(Check check) {
        Object object = this.m_monitorLockObj;
        synchronized (object) {
            Check existingCheck;
            int i;
            if (this.DEBUG) {
                this.m_context.logMessage("DomainStateMonitor.replaceCheck(): container=" + check.container + ", checkTime=" + new Date(check.scheduledTime), 7);
            }
            int size = this.m_scheduledStatusChecks.size();
            for (i = 0; i < size; ++i) {
                existingCheck = (Check)this.m_scheduledStatusChecks.get(i);
                if (!check.container.equals(existingCheck.container)) continue;
                this.m_scheduledStatusChecks.remove(i);
                break;
            }
            try {
                if (check.scheduledTime == Long.MAX_VALUE) {
                    this.m_scheduledStatusChecks.add(check);
                } else {
                    size = this.m_scheduledStatusChecks.size();
                    for (i = 0; i < size; ++i) {
                        existingCheck = (Check)this.m_scheduledStatusChecks.get(i);
                        if (check.scheduledTime >= existingCheck.scheduledTime) continue;
                        this.m_scheduledStatusChecks.add(i, check);
                        return;
                    }
                    this.m_scheduledStatusChecks.add(check);
                }
            }
            finally {
                this.m_monitorLockObj.notifyAll();
            }
        }
    }

    public static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[]{MetricsFactory.createMetricInfo((IMetricIdentity)IAgentManagerProxy.SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID, (short)0, (String)"Size of thread pool used to poll for container(s) state.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"pool threads"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentManagerProxy.SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID, (short)0, (String)"Maximum size of thread pool used to poll for container(s) state since last metrics reset.", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"pool threads"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentManagerProxy.SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID, (short)0, (String)"Number of times requests for container state had to wait because a pooled thread was not immediately available to service a poll request. Evaluated over the last 30 minutes.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"waits")};
        return infos;
    }

    public static void initMetrics(IMetricsRegistrar metricsRegistrar) {
        s_metricsRegistrar = metricsRegistrar;
        IStatisticProvider[] poolSizeProviders = new IStatisticProvider[]{new IStatisticProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStatistic(ISampledStatistic statistic) {
                if (s_running) {
                    Stack stack = s_workerThreadPool;
                    synchronized (stack) {
                        statistic.updateValue((long)(s_workerThreadPool.size() + s_executingWorkerThreads));
                    }
                } else {
                    statistic.updateValue(0L);
                }
            }

            public void resetStatistic(ISampledStatistic statistic) {
            }
        }};
        s_poolSizeStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])poolSizeProviders, (short)0);
        s_maxPoolSizeStatistic = StatisticsFactory.createStatistic((short)3, (boolean)false, (IStatisticProvider[])poolSizeProviders, (short)0);
        s_poolWaitsStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
    }

    public static void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID)) {
                s_metricsRegistrar.registerMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID, s_poolSizeStatistic);
                continue;
            }
            if (ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID)) {
                s_metricsRegistrar.registerMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID, s_maxPoolSizeStatistic);
                continue;
            }
            if (!ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID)) continue;
            s_poolWaitsStatistic.reset();
            s_metricsRegistrar.registerMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID, s_poolWaitsStatistic);
        }
    }

    public static void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID)) {
                s_metricsRegistrar.unregisterMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_CURRENTPOOLSIZE_METRIC_ID);
                continue;
            }
            if (ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID)) {
                s_metricsRegistrar.unregisterMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_MAXPOOLSIZE_METRIC_ID);
                continue;
            }
            if (!ids[i].equals(IAgentManagerProxy.SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID)) continue;
            s_metricsRegistrar.unregisterMetric(IAgentManagerProxy.SYSTEM_POLLTHREADS_POOLWAITS_METRIC_ID);
        }
    }

    static /* synthetic */ short access$1610(DomainStateMonitor x0) {
        short s = x0.m_workerThreadPoolSize;
        x0.m_workerThreadPoolSize = (short)(s - 1);
        return s;
    }

    static {
        s_running = false;
    }

    private class WorkerThread
    extends Thread {
        String role;
        Runnable task;

        private WorkerThread() {
            super(DomainStateMonitor.TASK_THREAD_NAME);
        }

        public synchronized void setRole(String role) {
            if (this.role != null) {
                throw new IllegalStateException("Cannot reset execution role.");
            }
            this.role = role;
        }

        public synchronized String getRole() {
            return this.role;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                WorkerThread workerThread = this;
                Stack stack = s_workerThreadPool;
                synchronized (stack) {
                    try {
                        if (this.task == null) {
                            WorkerThread workerThread2 = this;
                            s_workerThreadPool.wait(5000L);
                        }
                        if (this.task == null) {
                            if (DomainStateMonitor.this.m_workerThreadPoolSize <= DomainStateMonitor.this.m_minWorkerThreads) {
                                continue;
                            }
                            WorkerThread workerThread3 = this;
                            if (s_workerThreadPool.size() < DomainStateMonitor.this.m_scheduledStatusChecks.size()) {
                                continue;
                            }
                            DomainStateMonitor.access$1610(DomainStateMonitor.this);
                            WorkerThread workerThread4 = this;
                            s_workerThreadPool.remove(this);
                            return;
                        }
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                try {
                    this.task.run();
                }
                catch (Throwable e) {
                    DomainStateMonitor.this.m_context.logMessage("Unhandled task failure, trace follows...", e, 2);
                }
                finally {
                    this.setName("Container State Poller [idle]");
                    this.role = null;
                    this.task = null;
                }
                WorkerThread workerThread5 = this;
                stack = s_workerThreadPool;
                synchronized (stack) {
                    WorkerThread workerThread6 = this;
                    s_workerThreadPool.push(this);
                    WorkerThread workerThread7 = this;
                    s_executingWorkerThreads--;
                    WorkerThread workerThread8 = this;
                    s_workerThreadPool.notifyAll();
                }
            }
        }
    }

    private final class Check
    implements Runnable {
        String container;
        long scheduledTime;
        long[] pollingParams = new long[2];

        private Check(long scheduledTime, String container) {
            long currentTime = System.currentTimeMillis();
            this.scheduledTime = scheduledTime != 0L && scheduledTime < currentTime ? currentTime : scheduledTime;
            this.container = container;
        }

        private Check(long scheduledTime, Check lastCheck) {
            this(scheduledTime, lastCheck.container);
            this.pollingParams = lastCheck.pollingParams;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Thread.currentThread().setName("Container State Poller [" + this.container + ']');
            if (!this.updatePollingParams()) {
                if (DomainStateMonitor.this.DEBUG_THREADS) {
                    DomainStateMonitor.this.m_context.logMessage("DomainStateMonitor.Check.run: UNABLE TO UPDATE POLLING PARAMETERS!!! for container = " + this.container, 7);
                }
                Object object2 = DomainStateMonitor.this.m_monitorLockObj;
                synchronized (object2) {
                    DomainStateMonitor.this.m_scheduledStatusChecks.remove(this);
                }
                return;
            }
            long statusCheckStartTime = System.currentTimeMillis();
            if (DomainStateMonitor.this.DEBUG_THREADS) {
                DomainStateMonitor.this.m_context.logMessage("DomainStateMonitor.Check.run: container = " + this.container + ", pollingParams[0] = " + this.pollingParams[0], 7);
            }
            if (this.pollingParams[0] != 0L) {
                if (DomainStateMonitor.this.DEBUG_THREADS) {
                    DomainStateMonitor.this.m_context.logMessage("DomainStateMonitor.Check.run: container = " + this.container + ", pollingParams[1] = " + this.pollingParams[1], 7);
                }
                try {
                    if ((((DomainStateMonitor)DomainStateMonitor.this).m_manager.m_traceMask & 0x10) > 0) {
                        DomainStateMonitor.this.m_context.logMessage("Polling: " + this.container, 7);
                    }
                    IContainerState containerState = DomainStateMonitor.this.m_manager.getContainerState(this.container, this.pollingParams[1]);
                    DomainStateMonitor.this.m_domainState.updateContainerState(this.container, containerState);
                    if ((((DomainStateMonitor)DomainStateMonitor.this).m_manager.m_traceMask & 0x10) > 0) {
                        DomainStateMonitor.this.m_context.logMessage("Polled container state: " + this.container + ", state=" + IContainerState.STATE_TEXT[containerState.getState()], 7);
                    }
                }
                catch (Exception e) {
                    if ((((DomainStateMonitor)DomainStateMonitor.this).m_manager.m_traceMask & 0x10) > 0) {
                        DomainStateMonitor.this.m_context.logMessage("Polling failed: " + this.container, 7);
                    }
                    try {
                        DomainStateMonitor.this.m_domainState.updateContainerState(this.container, (short)1, statusCheckStartTime);
                    }
                    catch (IllegalArgumentException iae) {
                        Object object3 = DomainStateMonitor.this.m_monitorLockObj;
                        synchronized (object3) {
                            DomainStateMonitor.this.m_scheduledStatusChecks.remove(this);
                        }
                        return;
                    }
                }
                if (!this.updatePollingParams()) {
                    if (DomainStateMonitor.this.DEBUG_THREADS) {
                        DomainStateMonitor.this.m_context.logMessage("DomainStateMonitor.Check.run: UNABLE TO UPDATE POLLING PARAMETERS after poll!!!...for container = " + this.container, 7);
                    }
                    object = DomainStateMonitor.this.m_monitorLockObj;
                    synchronized (object) {
                        DomainStateMonitor.this.m_scheduledStatusChecks.remove(this);
                    }
                    return;
                }
            }
            object = DomainStateMonitor.this.m_monitorLockObj;
            synchronized (object) {
                this.scheduledTime = this.pollingParams[0] == 0L ? Long.MAX_VALUE : statusCheckStartTime + this.pollingParams[0];
                DomainStateMonitor.this.replaceCheck(this);
                DomainStateMonitor.this.m_monitorLockObj.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updatePollingParams() {
            Integer pollInterval = null;
            Integer pollTimeout = null;
            try {
                ContainerState containerState = DomainStateMonitor.this.m_domainState.getContainerState(this.container);
                String configID = containerState.getRuntimeIdentity().getConfigIdentity().getName();
                IElement containerConfig = DomainStateMonitor.this.m_context.getConfiguration(configID, true);
                if (containerConfig == null) {
                    boolean bl = false;
                    return bl;
                }
                IAttributeSet monitoringAttrs = (IAttributeSet)containerConfig.getAttributes().getAttribute("MONITORING");
                if (monitoringAttrs != null) {
                    pollInterval = (Integer)monitoringAttrs.getAttribute("STATUS_POLL_INTERVAL");
                    pollTimeout = (Integer)monitoringAttrs.getAttribute("STATUS_POLL_TIMEOUT");
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (pollInterval == null) {
                    pollInterval = DomainStateMonitor.this.m_defaultStatusPollInterval;
                }
                if (pollTimeout == null) {
                    pollTimeout = DomainStateMonitor.this.m_defaultStatusPollTimeout;
                }
                this.pollingParams[0] = pollInterval * 1000;
                this.pollingParams[1] = pollTimeout * 1000;
            }
            return true;
        }

        public String toString() {
            return "DomainStateMonitor.Check[container=" + this.container + ",scheduledTime=" + this.scheduledTime + ",pollingParams[0]=" + this.pollingParams[0] + ",pollingParams[1]=" + this.pollingParams[1] + "]";
        }
    }
}

