/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.manager;

import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.manager.AgentManager;

class FaultDetector
extends Thread {
    private AgentManager m_am;
    private IFrameworkComponentContext m_context;
    private IStateManager m_stateManager;
    private long m_interval = 5000L;
    private int m_traceMask;
    private boolean m_failoverConditionLogged = false;
    private boolean m_isClosing = false;
    private boolean m_isSuspended = false;

    FaultDetector(AgentManager am) {
        super("AM Fault Detector");
        super.setDaemon(true);
        this.m_am = am;
        this.m_stateManager = am.getFaultToleranceStateManager();
        this.m_context = am.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.m_isClosing) {
            block28: {
                short prePartnerCheckState = this.m_stateManager.getState(null);
                try {
                    if (this.m_isSuspended) {
                        if (this.m_stateManager.getState(null) == 2) {
                            this.handleToWaiting(null);
                        }
                        break block28;
                    }
                    boolean aquiredLock = this.m_am.leaseLock();
                    if (aquiredLock) {
                        if (this.m_stateManager.getState(null) == 3) {
                            this.m_am.releaseLock();
                            long backoffDuration = this.m_interval + this.m_am.getLeaseRequestTimeout();
                            FaultDetector faultDetector = this;
                            synchronized (faultDetector) {
                                this.wait(backoffDuration);
                            }
                            if (this.m_isClosing) {
                                return;
                            }
                            aquiredLock = this.m_am.leaseLock();
                        }
                        if (aquiredLock) {
                            this.handleToActive();
                        }
                    }
                    if (!aquiredLock) {
                        this.handleToStandby(null);
                    }
                }
                catch (RecoverableStateChangeException e) {
                    if ((this.m_traceMask & 0x80) > 0) {
                        this.m_context.logMessage("Recoverable failure during fault tolerant state change, trace follows...", (Throwable)e, 7);
                    }
                }
                catch (NonRecoverableStateChangeException e) {
                    if ((this.m_traceMask & 0x80) > 0) {
                        this.m_context.logMessage("Non-recoverable failure during fault tolerant state change, trace follows...", (Throwable)e, 7);
                    }
                    return;
                }
                catch (Exception e) {
                    if (this.m_stateManager.getState(null) != prePartnerCheckState) continue;
                    try {
                        if (this.m_isClosing) {
                            return;
                        }
                        this.handleToStandby(e);
                    }
                    catch (RecoverableStateChangeException sce) {
                        if ((this.m_traceMask & 0x80) > 0) {
                            this.m_context.logMessage("Recoverable failure during fault tolerant state change, trace follows...", (Throwable)e, 7);
                        }
                    }
                    catch (NonRecoverableStateChangeException sce) {
                        if ((this.m_traceMask & 0x80) > 0) {
                            this.m_context.logMessage("Non-recoverable failure during fault tolerant state change, trace follows...", (Throwable)sce, 7);
                        }
                        return;
                    }
                }
            }
            if (this.m_isClosing) continue;
            FaultDetector faultDetector = this;
            synchronized (faultDetector) {
                try {
                    this.wait(this.m_isSuspended ? 500L : this.m_interval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void setTraceMask(int traceMask) {
        this.m_traceMask = traceMask;
    }

    void setTestInterval(long interval) {
        if (interval < 5000L) {
            throw new IllegalArgumentException("Interval cannot be < 5 seconds");
        }
        if (interval > 60000L) {
            throw new IllegalArgumentException("Interval cannot be > 60 seconds");
        }
        this.m_interval = interval;
    }

    synchronized void close() {
        this.m_isClosing = true;
        this.notifyAll();
    }

    synchronized void suspendActiveState() {
        this.m_isSuspended = true;
        this.notifyAll();
    }

    synchronized void resumeAfterSuspend() {
        this.m_isSuspended = false;
        this.notifyAll();
    }

    private synchronized void handleToActive() throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if ((this.m_traceMask & (0x80 | 1)) > 0) {
            this.m_context.logMessage("Fault tolerant AgentManager successfully acquired lock from DS", 7);
        }
        while (!this.m_context.getContainer().isClosing()) {
            short currentState = this.m_stateManager.getState(null);
            if (!this.validateCurrentState(currentState)) {
                return;
            }
            if (currentState == 2) {
                return;
            }
            if (currentState == 1 && this.m_stateManager.requestStateChange(currentState, (short)2, null)) {
                return;
            }
            if (currentState != 3) continue;
            if (this.m_am.getAllowFailover().booleanValue()) {
                if (this.m_failoverConditionLogged) {
                    this.m_context.logMessage("Failover condition detected, transition to state: \"" + IFaultTolerantState.STATE_TEXT[2] + "\" is now enabled", 3);
                    this.m_failoverConditionLogged = false;
                }
                if (!this.m_stateManager.requestStateChange(currentState, (short)2, null)) continue;
                return;
            }
            if (!this.m_failoverConditionLogged) {
                this.m_context.logMessage("Failover condition detected, however transition to state: \"" + IFaultTolerantState.STATE_TEXT[2] + "\" is not currently enabled", 2);
                this.m_failoverConditionLogged = true;
            }
            return;
        }
    }

    private synchronized void handleToStandby(Exception e) throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if ((this.m_traceMask & (0x80 | 1)) > 0) {
            if (e == null) {
                this.m_context.logMessage("Fault tolerant AgentManager denied lock from DS", 7);
            } else {
                this.m_context.logMessage("Fault tolerant AgentManager denied lock from DS, due to...", (Throwable)e, 7);
            }
        }
        while (!this.m_context.getContainer().isClosing()) {
            short currentState = this.m_stateManager.getState(null);
            if (!this.validateCurrentState(currentState)) {
                return;
            }
            switch (currentState) {
                case 3: {
                    if (this.m_failoverConditionLogged) {
                        this.m_context.logMessage("Failover condition no longer detected", 3);
                        this.m_failoverConditionLogged = false;
                    }
                    return;
                }
                case 2: {
                    this.m_context.logMessage("An \"Active\" Agent Manager appears to be running elsewhere", 2);
                }
            }
            if (!this.m_stateManager.requestStateChange(currentState, (short)3, null)) continue;
            return;
        }
    }

    private synchronized void handleToWaiting(Exception e) throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if ((this.m_traceMask & 0x80) > 0 && !this.m_isSuspended) {
            if (e == null) {
                this.m_context.logMessage("Fault tolerant AgentManager failed to acquire lock from DS", 7);
            } else {
                this.m_context.logMessage("Fault tolerant AgentManager failed to acquire lock from DS, due to...", (Throwable)e, 7);
            }
        }
        while (!this.m_context.getContainer().isClosing()) {
            short currentState = this.m_stateManager.getState(null);
            if (!this.validateCurrentState(currentState)) {
                return;
            }
            if (currentState == 1) {
                return;
            }
            if (!this.m_stateManager.requestStateChange(currentState, (short)1, null)) continue;
            return;
        }
    }

    private boolean validateCurrentState(short currentState) {
        switch (currentState) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        this.m_context.logMessage("Unhandled fault tolerant state: " + currentState, 2);
        return false;
    }
}

