/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.impl.AttributeAssociationTree;
import com.sonicsw.mf.common.config.impl.IChangeRegistration;
import com.sonicsw.mf.common.config.impl.ProcessDeltaNotifications;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public final class ChangeRegistration
implements IChangeRegistration {
    private HashMap m_registrationTable = new HashMap();
    private Object m_lock = new Object();
    private Hashtable m_deltaTable = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAttributeChangeHandler(AttributeName name, IAttributeChangeHandler handler) {
        Object object = this.m_lock;
        synchronized (object) {
            String elementName = name.getElementName();
            if (elementName == null || elementName.length() == 0) {
                throw new IllegalArgumentException("registerHandler: No element name.");
            }
            AttributeAssociationTree elementTable = (AttributeAssociationTree)this.m_registrationTable.get(elementName);
            if (elementTable == null) {
                elementTable = new AttributeAssociationTree();
                this.m_registrationTable.put(elementName, elementTable);
            }
            elementTable.insertPayload(name, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAttributeChangeHandler(AttributeName name) {
        Object object = this.m_lock;
        synchronized (object) {
            String elementName = name.getElementName();
            if (elementName == null || elementName.length() == 0) {
                throw new IllegalArgumentException("registerHandler: No element name.");
            }
            AttributeAssociationTree elementTable = (AttributeAssociationTree)this.m_registrationTable.get(elementName);
            if (elementTable == null) {
                return;
            }
            elementTable.removePayload(name);
            if (elementTable.size() == 0) {
                this.m_registrationTable.remove(elementName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireElementDeletedHandler(String elementName, boolean doNotify) {
        ArrayList notificationsList = new ArrayList();
        Object object = this.m_lock;
        synchronized (object) {
            AttributeAssociationTree elementTable = (AttributeAssociationTree)this.m_registrationTable.get(elementName);
            if (elementTable == null) {
                return;
            }
            ProcessDeltaNotifications.handleElementDeletion(elementTable, notificationsList);
        }
        if (doNotify) {
            ProcessDeltaNotifications.doNotifications(notificationsList);
        }
        this.m_registrationTable.remove(elementName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttributeChangeHandlers(IDeltaElement delta, boolean doNotify) {
        ArrayList notificationsList = new ArrayList();
        Object object = this.m_lock;
        synchronized (object) {
            AttributeAssociationTree elementTable = (AttributeAssociationTree)this.m_registrationTable.get(delta.getIdentity().getName());
            if (elementTable == null) {
                return;
            }
            Object attributes = delta.getDeltaAttributes();
            if (attributes instanceof IAttributeSet) {
                ProcessDeltaNotifications.processDelta((IAttributeSet)attributes, elementTable, notificationsList);
            } else if (attributes instanceof IDeltaAttributeSet) {
                ProcessDeltaNotifications.processDelta((IDeltaAttributeSet)attributes, elementTable, notificationsList);
            }
        }
        if (doNotify) {
            ProcessDeltaNotifications.doNotifications(notificationsList);
        }
    }

    public void setDelta(IDeltaElement delta) {
        this.m_deltaTable.put(Thread.currentThread(), delta);
    }

    public void setDeletedElementName(String deletedElementName) {
        this.m_deltaTable.put(Thread.currentThread(), deletedElementName);
    }

    public void fireAttributeChangeHandlers(boolean doNotify) {
        Object change = this.m_deltaTable.remove(Thread.currentThread());
        if (change == null) {
            throw new IllegalStateException("fireAttributeChangeHandlers can be called only for IElementChange.ELEMENT_UPDATED and IElementChange.ELEMENT_DELETD configuration changes.");
        }
        if (change instanceof IDeltaElement) {
            this.fireAttributeChangeHandlers((IDeltaElement)change, doNotify);
        } else if (change instanceof String) {
            this.fireElementDeletedHandler((String)change, doNotify);
        } else {
            Error error = new Error("Wrong change type.");
            error.printStackTrace();
            throw error;
        }
    }

    public void adjustHandlers() {
        Object change = this.m_deltaTable.remove(Thread.currentThread());
        if (change == null) {
            return;
        }
        if (change instanceof IDeltaElement) {
            this.fireAttributeChangeHandlers((IDeltaElement)change, false);
        } else if (change instanceof String) {
            this.fireElementDeletedHandler((String)change, false);
        } else {
            Error error = new Error("Wrong change type.");
            error.printStackTrace();
            throw error;
        }
    }
}

