/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public final class NextVersionToken
implements INextVersionToken,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 4;
    private HashMap m_ids;

    public NextVersionToken(HashMap ids) {
        this.m_ids = ids;
    }

    public NextVersionToken replaceReferences(IReplaceRef replaceSrvc) {
        HashMap<String, ElementIdentity> newIds = new HashMap<String, ElementIdentity>();
        NextVersionToken newToken = new NextVersionToken(newIds);
        for (String storageName : this.m_ids.keySet()) {
            ElementIdentity oldID = (ElementIdentity)this.m_ids.get(storageName);
            String logicalName = null;
            try {
                logicalName = replaceSrvc.replace(storageName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (logicalName == null) continue;
            ElementIdentity newID = oldID.createClone();
            newID.setName(logicalName);
            newIds.put(logicalName, newID);
        }
        return newToken;
    }

    public NextVersionToken(HashMap ids, NextVersionToken otherToken) {
        this.m_ids = ids;
        if (otherToken == null) {
            return;
        }
        HashMap otherTable = otherToken.getIdsTable();
        for (String elementName : otherTable.keySet()) {
            this.m_ids.put(elementName, otherTable.get(elementName));
        }
    }

    private HashMap getIdsTable() {
        return this.m_ids;
    }

    ElementIdentity getID(String name) {
        Object idObject = this.m_ids.get(name);
        if (idObject == null || !(idObject instanceof ElementIdentity)) {
            throw new IllegalStateException("Invalid token for element \"" + name + "\" was passed to getNextVersion.");
        }
        return (ElementIdentity)idObject;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(4);
        s.writeObject(this.m_ids);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 4) {
            Util.throwSerialVersionMismatch(version, 4);
        }
        this.m_ids = (HashMap)s.readObject();
    }
}

