/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.IXMLFragment;
import com.sonicsw.mf.common.runtime.ICollectiveOpStatus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class CollectiveOpStatus
implements ICollectiveOpStatus,
IXMLFragment,
Serializable {
    private static final long serialVersionUID = 163719925118650399L;
    private static final short m_serialVersion = 1;
    private ArrayList m_results;

    public CollectiveOpStatus(int resultCount) {
        this.m_results = new ArrayList(resultCount);
    }

    public void addResult(String componentName, Object returnValue, Throwable throwable) {
        this.m_results.add(new Object[]{componentName, returnValue, throwable});
    }

    @Override
    public int getCount() {
        return this.m_results.size();
    }

    @Override
    public String getComponentName(int compNum) {
        if (compNum > this.m_results.size()) {
            throw new IllegalArgumentException("Entry [" + compNum + "] does not exist");
        }
        Object[] entry = (Object[])this.m_results.get(compNum);
        return (String)entry[0];
    }

    @Override
    public boolean operationIsSuccessful(int compNum) {
        if (compNum > this.m_results.size()) {
            throw new IllegalArgumentException("Entry [" + compNum + "] does not exist");
        }
        Object[] entry = (Object[])this.m_results.get(compNum);
        return entry[2] == null;
    }

    @Override
    public Object getReturnValue(int compNum) {
        if (compNum > this.m_results.size()) {
            throw new IllegalArgumentException("Entry [" + compNum + "] does not exist");
        }
        Object[] entry = (Object[])this.m_results.get(compNum);
        return entry[1];
    }

    @Override
    public Throwable getThrowable(int compNum) {
        if (compNum > this.m_results.size()) {
            throw new IllegalArgumentException("Entry [" + compNum + "] does not exist");
        }
        Object[] entry = (Object[])this.m_results.get(compNum);
        return (Throwable)entry[2];
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(2);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(1));
        stream.writeUTF("results");
        stream.writeObject(this.m_results);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            case 0: {
                try {
                    Object[][] results = (Object[][])map.get("results");
                    for (int i = 0; i < results.length; ++i) {
                        this.m_results.add(results[i]);
                    }
                    break;
                }
                catch (Exception e) {
                    break;
                }
            }
            default: {
                try {
                    this.m_results = (ArrayList)map.get("results");
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (int i = 0; i < this.m_results.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            Object[] result = (Object[])this.m_results.get(i);
            sb.append('[').append(result[0]).append(']');
            sb.append(result[result[2] == null ? 1 : 2]);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String toXMLFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("<collectiveOpStatus>");
        for (int i = 0; i < this.m_results.size(); ++i) {
            Object[] result = (Object[])this.m_results.get(i);
            sb.append("<result>");
            sb.append("<target>").append(result[0]).append("</target>");
            if (result[2] == null) {
                if (result[1] == null) {
                    sb.append("<return>null</return>");
                } else {
                    sb.append("<return>").append(result[1] instanceof IXMLFragment ? ((IXMLFragment)result[1]).toXMLFragment() : result[1].toString()).append("</return>");
                }
            } else {
                sb.append("<exception>").append(result[2] instanceof IXMLFragment ? ((IXMLFragment)result[2]).toXMLFragment() : result[2].toString()).append("</exception>");
            }
            sb.append("</result>");
        }
        sb.append("</collectiveOpStatus>");
        return sb.toString();
    }
}

