/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.url;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.url.BrokerURL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class SonicRNURL {
    public static final String SONICRN_URL_PREFIX = "sonicrn:///";
    public static final int SONICRN_URL_PREFIX_LENGTH = "sonicrn:///".length();
    private String m_url = "";
    private String m_nodename = "";
    private String m_visibility = "all";
    private String m_acceptorNames = "";
    private static final String VISIBILITY_PARAMETER_NAME = "visibility";
    private static final String ACCEPTOR_PARAMETER_NAME = "acceptor";
    private static boolean m_debug = Boolean.parseBoolean(System.getProperty("DEBUG_SONICRNHANDLER", "false"));
    public static SimpleDateFormat SIMPLE_DATE_FORMAT;
    private static final AttributeName CLUSTER_NODE_NAME_ATTRIBUTE;
    private static final AttributeName BROKER_NODE_NAME_ATTRIBUTE;
    private static final String CLUSTER_MEMBERS_ATTRIBUTE = "CLUSTER_MEMBERS";
    public static final String CLUSTER_CONFIG_ELEMENT_REF_ATTRIBUTE = "CLUSTER_CONFIG_ELEMENT_REF";
    public static final String BROKER_NODENAME_DIRECTORY = "/_MQRuntime/location/";
    public static final String USE_DYNAMIC_HOST_BINDING_ATTRIBUTE = "USE_DYNAMIC_HOST_BINDING";
    public static final String CONFIG_ELEMENT_REFERENCES_ATTRIBUTE = "CONFIG_ELEMENT_REFERENCES";
    private static final String PRIMARY_CONFIG_ATTRIBUTE = "PRIMARY_CONFIG_ELEMENT_REF";
    public static final String BROKER_NAME_ATTRIBUTE = "BROKER_NAME";
    public static final String PRIMARY_KEYWORD = "primary";
    public static final String BACKUP_KEYWORD = "backup";
    public static final String ACCEPTORS_REF_ATTRIBUTE = "ACCEPTOR_CONFIG_ELEMENT_REF";
    public static final String ACCEPTORS_ATTRIBUTE = "ACCEPTORS";
    public static final String ACCEPTOR_URL_ATTRIBUTE = "ACCEPTOR_URL";
    private static final String ACCEPTOR_EXTERNAL_URL_ATTRIBUTE = "ACCEPTOR_EXTERNAL_URL";
    private static final String VISIBILITY_ALL = "all";
    private static final String VISIBILITY_INTERNAL = "internal";
    private static final String VISIBILITY_EXTERNAL = "external";
    private static final String ACCEPTOR_NAME_ATTRIBUTE = "ACCEPTOR_NAME";
    public static final String PUBLIC_HOSTNAME_ATTRIBUTE = "PUBLIC_HOSTNAME";
    public static final String PRIVATE_HOSTNAME_ATTRIBUTE = "PRIVATE_HOSTNAME";
    public static final String PRIMARY_CONFIG_ELEMENT_REF_ATTRIBUTE = "PRIMARY_CONFIG_ELEMENT_REF";
    public static final String BACKUP_CONFIG_ELEMENT_REF_ATTRIBUTE = "BACKUP_CONFIG_ELEMENT_REF";
    public static final String REPLICATION_CONNECTIONS_ELEMENT_REF_ATTRIBUTE = "REPLICATION_CONNECTIONS_ELEMENT_REF";
    public static final String REPLICATION_CONNECTIONS_ATTRIBUTE = "REPLICATION_CONNECTIONS";
    public static final String PRIMARY_ADDR_ATTRIBUTE = "PRIMARY_ADDR";
    public static final String BACKUP_ADDR_ATTRIBUTE = "BACKUP_ADDR";
    public static final String BROKER_CONFIG_ELEMENT_REF_ATTRIBUTE = "BROKER_CONFIG_ELEMENT_REF";
    public static final String MQ_RUNTIME_LOCATION_TYPE = "MQ_RUNTIME_LOCATION";
    public static final String REFERENCE_OBJECT_TYPE = "ReferenceObject";
    public static final String CLASSNAME_ATTRIBUTE = "classname";
    public static final String REF_ADDRESSES_ATTRIBUTE = "RefAdresses";
    public static final String BROKER_LIST_ATTRIBUTE = "brokerList";
    public static final String RESOLVED_BROKER_LIST_ATTRIBUTE = "RESOLVED_BROKER_LIST";

    public static boolean isValid(String url) {
        return SonicRNURL.isValid(url, false);
    }

    public static boolean isValid(String url, boolean strict) {
        if (url == null || url.trim().isEmpty()) {
            return false;
        }
        if (!(url = url.trim()).startsWith(SONICRN_URL_PREFIX)) {
            return false;
        }
        if (!strict) {
            return true;
        }
        SonicRNURL sonicrnUrl = new SonicRNURL(url);
        String nodeName = sonicrnUrl.getNodename();
        return nodeName != null && !nodeName.trim().isEmpty();
    }

    public SonicRNURL(URL url) {
        this(url.toExternalForm().startsWith(SONICRN_URL_PREFIX) ? url.toExternalForm() : url.toExternalForm().replace(":/", ":///"));
    }

    public SonicRNURL(String url) {
        if (!SonicRNURL.isValid(url, false)) {
            throw new IllegalArgumentException("Invalid sonicrn:/// url: " + url);
        }
        this.m_url = url.trim();
        this.parseURL();
    }

    private void parseURL() {
        StringTokenizer urlTokenizer = new StringTokenizer(this.m_url.substring(SONICRN_URL_PREFIX_LENGTH), "?&=");
        this.m_nodename = urlTokenizer.nextToken();
        if (this.m_nodename != null) {
            this.m_nodename = this.m_nodename.trim();
        }
        while (urlTokenizer.hasMoreTokens()) {
            String parameterName = urlTokenizer.nextToken();
            if (parameterName.equals(ACCEPTOR_PARAMETER_NAME)) {
                this.m_acceptorNames = this.m_acceptorNames + (this.m_acceptorNames.length() > 0 ? "," : "") + urlTokenizer.nextToken();
            }
            if (!parameterName.equals(VISIBILITY_PARAMETER_NAME)) continue;
            this.m_visibility = urlTokenizer.nextToken();
        }
        SonicRNURL.debug("SonicRNURL.parseURL parsed " + this.m_url + " into nodename=" + this.m_nodename + " acceptor(s)=" + this.m_acceptorNames + " visibility=" + this.m_visibility);
    }

    public String getURL() {
        return this.m_url;
    }

    public String getNodename() {
        return this.m_nodename;
    }

    public String getVisibility() {
        return this.m_visibility;
    }

    public String getAcceptorName() {
        return this.m_acceptorNames;
    }

    public String resolveURL(IDirectoryAdminService ds) throws IOException {
        ArrayList<IDirElement> brokerElementList = this.findBrokersWithMatchingNodename(ds);
        SonicRNURL.debug("SonicRNURL.resolveURL found " + brokerElementList.size() + " brokers with nodename == " + this.m_nodename);
        String resolved = "";
        for (IDirElement brokerElement : brokerElementList) {
            resolved = this.resolveAcceptorURLs(ds, brokerElement, resolved);
        }
        SonicRNURL.debug("SonicRNURL.resolveURL returning \"" + resolved + "\"");
        return resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void debug(String message) {
        if (m_debug) {
            System.out.print("[");
            SimpleDateFormat simpleDateFormat = SIMPLE_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                System.out.print(SIMPLE_DATE_FORMAT.format(new Date(System.currentTimeMillis())));
            }
            System.out.print("]");
            System.out.println(" " + message);
        }
    }

    private ArrayList<IDirElement> findBrokersWithMatchingNodename(IDirectoryAdminService ds) throws IOException {
        try {
            ArrayList<IDirElement> brokerElementList = this.findClusteredBrokersWithMatchingNodename(ds);
            if (brokerElementList == null) {
                brokerElementList = this.findNonClusteredBrokerWithNodename(ds);
            }
            if (brokerElementList == null) {
                return new ArrayList<IDirElement>();
            }
            int initialBrokerCount = brokerElementList.size();
            for (int i = 0; i < initialBrokerCount; ++i) {
                IDirElement backupBrokerElement;
                IDirElement brokerElement = brokerElementList.get(i);
                IAttributeSet brokerAttributes = brokerElement.getAttributes();
                IAttributeSet brokerFTAttributes = (IAttributeSet)brokerAttributes.getAttribute(CONFIG_ELEMENT_REFERENCES_ATTRIBUTE);
                Reference backupBrokerReference = (Reference)brokerFTAttributes.getAttribute(BACKUP_CONFIG_ELEMENT_REF_ATTRIBUTE);
                if (backupBrokerReference == null || (backupBrokerElement = ds.getElement(backupBrokerReference.getElementName(), false)) == null) continue;
                brokerElementList.add(backupBrokerElement);
            }
            return brokerElementList;
        }
        catch (Throwable t) {
            IOException ioE = new IOException("Unable to find brokers with nodename " + this.m_nodename);
            ioE.initCause(t);
            throw ioE;
        }
    }

    private ArrayList<IDirElement> findClusteredBrokersWithMatchingNodename(IDirectoryAdminService ds) throws IOException {
        ArrayList<IDirElement> matchingBrokers = new ArrayList<IDirElement>();
        try {
            Query query = new Query();
            FromDirectory from = new FromDirectory("/mq/clusters");
            EqualExpression nodenameEqualsExpression = new EqualExpression(CLUSTER_NODE_NAME_ATTRIBUTE, this.m_nodename);
            Where where = new Where(new BooleanExpression[]{nodenameEqualsExpression});
            query.setFrom(from);
            query.setWhere(where);
            IDirElement[] clustersWithMatchingNodename = ds.getElements(query, false);
            if (clustersWithMatchingNodename.length == 0) {
                return null;
            }
            IDirElement clusterElement = clustersWithMatchingNodename[0];
            IAttributeSet clusterAttributes = clusterElement.getAttributes();
            IAttributeSet clusterMemberAttributes = (IAttributeSet)clusterAttributes.getAttribute(CLUSTER_MEMBERS_ATTRIBUTE);
            for (Object clusterMember : clusterMemberAttributes.getAttributes().values()) {
                Reference clusteredMemberReference = (Reference)clusterMember;
                IDirElement brokerElement = ds.getElement(clusteredMemberReference.getElementName(), false);
                if (brokerElement == null) continue;
                matchingBrokers.add(brokerElement);
            }
        }
        catch (Throwable t) {
            IOException ioE = new IOException("Unable to find clusters with nodename " + this.m_nodename);
            ioE.initCause(t);
            throw ioE;
        }
        return matchingBrokers;
    }

    private ArrayList<IDirElement> findNonClusteredBrokerWithNodename(IDirectoryAdminService ds) throws IOException {
        ArrayList<IDirElement> matchingBrokers = new ArrayList<IDirElement>();
        try {
            Query query = new Query();
            FromDirectory from = new FromDirectory("/mq/brokers");
            EqualExpression nodenameEqualsExpression = new EqualExpression(BROKER_NODE_NAME_ATTRIBUTE, this.m_nodename);
            Where where = new Where(new BooleanExpression[]{nodenameEqualsExpression});
            query.setFrom(from);
            query.setWhere(where);
            IDirElement[] brokersWithMatchingNodename = ds.getElements(query, false);
            if (brokersWithMatchingNodename.length == 0) {
                return null;
            }
            IDirElement brokerElement = brokersWithMatchingNodename[0];
            IAttributeSet brokerAttributes = brokerElement.getAttributes();
            IAttributeSet referenceAttributes = (IAttributeSet)brokerAttributes.getAttribute(CONFIG_ELEMENT_REFERENCES_ATTRIBUTE);
            Reference clusterReference = (Reference)referenceAttributes.getAttribute(CLUSTER_CONFIG_ELEMENT_REF_ATTRIBUTE);
            if (clusterReference == null) {
                matchingBrokers.add(brokerElement);
            }
        }
        catch (Throwable t) {
            IOException ioE = new IOException("Unable to find clusters with nodename " + this.m_nodename);
            ioE.initCause(t);
            throw ioE;
        }
        return matchingBrokers;
    }

    private IDirElement getBrokerHostMappingElement(IDirectoryAdminService ds, IDirElement broker) throws IOException {
        try {
            boolean isPrimary = ((IAttributeSet)broker.getAttributes().getAttribute(CONFIG_ELEMENT_REFERENCES_ATTRIBUTE)).getAttribute("PRIMARY_CONFIG_ELEMENT_REF") == null;
            String mappingElementName = BROKER_NODENAME_DIRECTORY + this.m_nodename + '/' + broker.getAttributes().getAttribute(BROKER_NAME_ATTRIBUTE) + '/' + (isPrimary ? PRIMARY_KEYWORD : BACKUP_KEYWORD);
            try {
                IDirElement map = ds.getElement(mappingElementName, false);
                return map;
            }
            catch (DirectoryDoesNotExistException dirE) {
                return null;
            }
        }
        catch (DirectoryServiceException dirE) {
            IOException ioE = new IOException("Unable to get the nodename/brokername element for " + broker.getIdentity().getName());
            ioE.initCause(dirE);
            throw ioE;
        }
    }

    private IDirElement[] getQualifiedAcceptors(IDirectoryAdminService ds, IDirElement broker) throws IOException {
        ArrayList<IDirElement> acceptorsList;
        block7: {
            acceptorsList = new ArrayList<IDirElement>();
            Reference acceptorsReference = (Reference)((IAttributeSet)broker.getAttributes().getAttribute(CONFIG_ELEMENT_REFERENCES_ATTRIBUTE)).getAttribute(ACCEPTORS_REF_ATTRIBUTE);
            if (acceptorsReference != null) {
                try {
                    String acceptorsElementName = acceptorsReference.getElementName();
                    if (acceptorsElementName.startsWith("/NO_STORAGE:")) {
                        return new IDirElement[0];
                    }
                    IDirElement acceptorsElement = ds.getElement(acceptorsElementName, false);
                    if (acceptorsElement == null) break block7;
                    IAttributeSet acceptorRefs = (IAttributeSet)acceptorsElement.getAttributes().getAttribute(ACCEPTORS_ATTRIBUTE);
                    for (Reference acceptorRef : acceptorRefs.getAttributes().values()) {
                        String acceptorType;
                        IDirElement acceptor = ds.getElement(acceptorRef.getElementName(), false);
                        if (acceptor == null || !(acceptorType = acceptor.getIdentity().getType()).equals("MQ_ACCEPTOR_TCPS") && !acceptorType.equals("MQ_ACCEPTOR_TUNNELING")) continue;
                        if (this.m_acceptorNames.length() > 0) {
                            String currentAcceptorName = (String)acceptor.getAttributes().getAttribute(ACCEPTOR_NAME_ATTRIBUTE);
                            StringTokenizer acceptorNames = new StringTokenizer(this.m_acceptorNames, ",");
                            while (acceptorNames.hasMoreTokens()) {
                                if (!currentAcceptorName.equals(acceptorNames.nextToken())) continue;
                                acceptorsList.add(acceptor);
                            }
                            continue;
                        }
                        acceptorsList.add(acceptor);
                    }
                }
                catch (DirectoryServiceException dirE) {
                    IOException ioE = new IOException("Unable to get the acceptors for " + broker.getIdentity().getName());
                    ioE.initCause(dirE);
                    throw ioE;
                }
            }
        }
        IDirElement[] acceptors = new IDirElement[acceptorsList.size()];
        acceptorsList.toArray(acceptors);
        SonicRNURL.debug("SonicRNURL.getQualifiedAcceptors after looking for acceptor names found " + acceptors.length + " acceptors for broker " + broker.getIdentity().getName());
        return acceptors;
    }

    private String resolvePublic(IDirElement acceptor, IDirElement nodeMapping) throws MalformedURLException {
        String publicHost = (String)nodeMapping.getAttributes().getAttribute(PUBLIC_HOSTNAME_ATTRIBUTE);
        if (publicHost.length() != 0) {
            BrokerURL url = new BrokerURL((String)acceptor.getAttributes().getAttribute(ACCEPTOR_URL_ATTRIBUTE), true);
            return url.getBrokerProtocol() + "://" + publicHost + ":" + url.getBrokerPort();
        }
        return null;
    }

    private String resolveAcceptorURLs(IDirectoryAdminService ds, IDirElement broker, String resolved) throws IOException {
        IDirElement[] acceptors;
        IDirElement hostMapping = this.getBrokerHostMappingElement(ds, broker);
        for (IDirElement acceptor : acceptors = this.getQualifiedAcceptors(ds, broker)) {
            String acceptorURLString;
            SonicRNURL.debug("SonicRNURL.resolveAcceptorURLs broker == " + broker.getIdentity().getName() + " acceptor url == " + acceptor.getAttributes().getAttribute(ACCEPTOR_URL_ATTRIBUTE) + " acceptor external url == " + acceptor.getAttributes().getAttribute(ACCEPTOR_EXTERNAL_URL_ATTRIBUTE));
            String externalURL = (String)acceptor.getAttributes().getAttribute(ACCEPTOR_EXTERNAL_URL_ATTRIBUTE);
            if (this.m_visibility.equals(VISIBILITY_ALL) || this.m_visibility.equals(VISIBILITY_EXTERNAL)) {
                String resolvedExternal;
                if (externalURL != null) {
                    resolved = resolved + (resolved.length() > 0 ? "," : "") + externalURL;
                } else if (hostMapping != null && (resolvedExternal = this.resolvePublic(acceptor, hostMapping)) != null) {
                    resolved = resolved + (resolved.length() > 0 ? "," : "") + resolvedExternal;
                }
            }
            if (!this.m_visibility.equals(VISIBILITY_ALL) && !this.m_visibility.equals(VISIBILITY_INTERNAL) || (acceptorURLString = (String)acceptor.getAttributes().getAttribute(ACCEPTOR_URL_ATTRIBUTE)).contains("://:")) continue;
            resolved = resolved + (resolved.length() > 0 ? "," : "") + acceptorURLString;
        }
        SonicRNURL.debug("SonicRNURL.resolveAcceptorURLs broker == " + broker.getIdentity().getName() + " returning solved ==  " + resolved);
        return resolved;
    }

    static {
        CLUSTER_NODE_NAME_ATTRIBUTE = new AttributeName("ROUTING_NODE_NAME");
        BROKER_NODE_NAME_ATTRIBUTE = new AttributeName("BROKER_ROUTING_PARAMETERS").setNextComponent("ROUTING_NODE_NAME");
        SIMPLE_DATE_FORMAT = new SimpleDateFormat();
        SIMPLE_DATE_FORMAT.applyPattern("yy/MM/dd HH:mm:ss");
    }
}

