/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.DSNotStartedException;
import com.sonicsw.mf.common.IBlobSource;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IChunkedBlobStreamer;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceClosedException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.JMSConnectorServer;
import com.sonicsw.mf.framework.agent.SonicURLStreamHandlerFactoryImpl;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.framework.util.ContainerCompatibility;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ContainerDS
implements IChunkedBlobStreamer,
IBlobSource {
    private ContainerImpl m_container;
    private JMSConnectorServer m_connector;
    private DSComponent m_directory;
    private final IContainerIdentity m_containerIdentity;
    private final String m_commType;
    private String m_targetDS;
    private SonicURLStreamHandlerFactoryImpl m_urlStreamHandlerFactory;
    private static final String[] GET_PARTIAL_BLOB_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Integer.class.getName()};
    private static final String[] GET_FS_BLOB_PARTIAL_SIGNATURE = new String[]{String.class.getName(), Boolean.class.getName(), Integer.class.getName()};

    ContainerDS(ContainerImpl container, JMSConnectorServer connector, IContainerIdentity containerIdentity, String commType) {
        this.m_container = container;
        this.m_connector = connector;
        this.m_containerIdentity = containerIdentity;
        this.m_commType = commType;
        this.m_targetDS = new CanonicalName(this.m_containerIdentity.getDomainName(), "DIRECTORY SERVICE", "DIRECTORY SERVICE").getCanonicalName();
    }

    public void setLocalDS(DSComponent directory) {
        this.m_directory = directory;
        if (this.m_urlStreamHandlerFactory != null) {
            this.m_urlStreamHandlerFactory.resetSonicRNHandlerDS();
        }
    }

    IDirectoryAdminService getLocalDS() {
        if (this.m_directory == null) {
            return null;
        }
        return this.m_directory.getDS();
    }

    boolean isLocalDS() {
        return this.m_directory != null;
    }

    void setURLStreamHandlerFactory(SonicURLStreamHandlerFactoryImpl urlStreamHandlerFactory) {
        this.m_urlStreamHandlerFactory = urlStreamHandlerFactory;
    }

    String ping(String pingMessage) throws Exception {
        if (this.m_directory == null) {
            return (String)this.m_connector.invoke(this.m_commType, this.m_targetDS, this.m_targetDS, "ping", new Object[]{pingMessage}, new String[]{String.class.getName()});
        }
        return pingMessage;
    }

    String ping(String containerID, Short[] versionInfo) throws Exception {
        if (this.m_directory == null) {
            return (String)this.m_connector.invoke(this.m_commType, this.m_targetDS, this.m_targetDS, "ping", new Object[]{containerID, versionInfo}, new String[]{String.class.getName(), Short[].class.getName()});
        }
        ContainerCompatibility.addContainer(containerID, versionInfo[0], versionInfo[1], versionInfo[2], versionInfo[3]);
        return "PONG";
    }

    IElement getFSElement(String subscriber, String elementPath) {
        try {
            if (this.m_directory == null) {
                return (IElement)this.dsInvoke("getFSElement", new Object[]{elementPath, Boolean.FALSE}, new String[]{String.class.getName(), Boolean.class.getName()});
            }
            return this.m_directory.getFSElement(elementPath, Boolean.FALSE);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get FS configuration: " + elementPath);
        }
    }

    IElement getElement(String subscriber, String configID) {
        try {
            if (this.m_directory == null) {
                return (IElement)this.dsInvoke("getElement", new Object[]{subscriber, configID}, new String[]{String.class.getName(), String.class.getName()});
            }
            return this.m_directory.getElement(subscriber, configID);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration: " + configID);
        }
    }

    IElement getElementByLogicalName(String subscriber, String logicalName) {
        return this.getElementByLogicalName(subscriber, logicalName, true);
    }

    IElement getElementByLogicalName(String subscriber, String logicalName, boolean retry) {
        try {
            if (this.m_directory == null) {
                return (IElement)this.dsInvoke("getElementByLogicalName", new Object[]{subscriber, logicalName}, new String[]{String.class.getName(), String.class.getName()}, retry);
            }
            return this.m_directory.getElementByLogicalName(subscriber, logicalName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration: " + logicalName);
        }
    }

    IElement[] getElementsByLogicalNames(String subscriber, String[] logicalNames) {
        try {
            if (this.m_directory == null) {
                return (IElement[])this.dsInvoke("getElementsByLogicalNames", new Object[]{subscriber, logicalNames}, new String[]{String.class.getName(), logicalNames.getClass().getName()});
            }
            return this.m_directory.getElementsByLogicalNames(subscriber, logicalNames);
        }
        catch (Exception e) {
            String names = "";
            for (int i = 0; i < logicalNames.length; ++i) {
                names = names + logicalNames[i] + (i + 1 == logicalNames.length ? "" : ",");
            }
            throw this.convertException(e, "Failed to get configurations: " + names);
        }
    }

    IDirIdentity[] listDirectories(String parentDir) {
        try {
            if (this.m_directory == null) {
                return (IDirIdentity[])this.dsInvoke("listDirectories", new Object[]{parentDir}, new String[]{String.class.getName()});
            }
            return this.m_directory.listDirectories(parentDir);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to list directories under parent directory " + parentDir);
        }
    }

    IElementIdentity[] listElements(String dirName) {
        try {
            if (this.m_directory == null) {
                return (IElementIdentity[])this.dsInvoke("listElements", new Object[]{dirName}, new String[]{String.class.getName()});
            }
            return this.m_directory.listElements(dirName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to list elements in directory " + dirName);
        }
    }

    IDirElement[] getAllElements(String dirName) {
        try {
            if (this.m_directory == null) {
                return (IDirElement[])this.dsInvoke("getAllElements", new Object[]{dirName, Boolean.FALSE}, new String[]{String.class.getName(), Boolean.class.getName()});
            }
            return this.m_directory.getAllElements(dirName, Boolean.FALSE);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get the elements in directory " + dirName);
        }
    }

    IIdentity[] listAll(String dirName) {
        try {
            if (this.m_directory == null) {
                return (IIdentity[])this.dsInvoke("listAll", new Object[]{dirName}, new String[]{String.class.getName()});
            }
            return this.m_directory.listAll(dirName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to list elements in directory " + dirName);
        }
    }

    @Override
    public IBlob getBlobByLogicalName(String subscriber, String logicalName) {
        try {
            if (this.m_directory == null) {
                IBlob blob = (IBlob)this.dsInvoke("getBlobByLogicalName", new Object[]{subscriber, logicalName}, new String[]{String.class.getName(), String.class.getName()});
                if (blob == null) {
                    return null;
                }
                boolean isLogical = blob.isLogicalName();
                blob = new Blob(blob.getElement(), blob.getBlobBytes(), this);
                if (isLogical) {
                    blob.setLogical(true);
                }
                return blob;
            }
            return this.m_directory.getBlobByLogicalName(subscriber, logicalName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration: " + logicalName);
        }
    }

    IElement getElementForUpdate(String configID) {
        try {
            if (this.m_directory == null) {
                return (IElement)this.dsInvoke("getElement", new Object[]{configID, Boolean.TRUE}, new String[]{String.class.getName(), Boolean.class.getName()});
            }
            return this.m_directory.getElement(configID, Boolean.TRUE);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration: " + configID);
        }
    }

    String exportDSBootFileString(String dsConfigElement) {
        try {
            if (this.m_directory == null) {
                return (String)this.dsInvoke("exportDSBootFileString", new Object[]{dsConfigElement}, new String[]{String.class.getName()});
            }
            return this.m_directory.exportDSBootFileString(dsConfigElement);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to export to XML the DS configuration from: " + dsConfigElement);
        }
    }

    IElement[] getElements(String subscriber, String[] configIDs) {
        try {
            if (this.m_directory == null) {
                return (IElement[])this.dsInvoke("getElements", new Object[]{subscriber, configIDs}, new String[]{String.class.getName(), configIDs.getClass().getName()});
            }
            return this.m_directory.getElements(subscriber, configIDs);
        }
        catch (Exception e) {
            String configNames = "";
            for (int i = 0; i < configIDs.length; ++i) {
                configNames = configNames + configIDs[i] + (i + 1 == configIDs.length ? "" : ",");
            }
            throw this.convertException(e, "Failed to get configurations: " + configNames);
        }
    }

    IBlob getFSBlob(String subscriber, String elementPath) {
        try {
            if (this.m_directory == null) {
                IBlob blob = (IBlob)this.dsInvoke("getFSBlob", new Object[]{elementPath, Boolean.FALSE}, new String[]{String.class.getName(), Boolean.class.getName()});
                blob = new Blob(blob.getElement(), blob.getBlobBytes(), this);
                blob.setLogical(true);
                return blob;
            }
            return this.m_directory.getFSBlob(elementPath, Boolean.FALSE);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get binary FS attachment: " + elementPath);
        }
    }

    @Override
    public IBlob getBlob(String elementName, boolean forUpdate, int offset) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.dsInvoke("getBlob", new Object[]{elementName, new Boolean(forUpdate), new Integer(offset)}, GET_PARTIAL_BLOB_SIGNATURE);
            return new Blob(blob.getElement(), blob.getBlobBytes(), this);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get binary attachment: " + elementName);
        }
    }

    @Override
    public IBlob getFSBlob(String elementPath, boolean forUpdate, int offset) throws DirectoryServiceException {
        try {
            IBlob blob = (IBlob)this.dsInvoke("getFSBlob", new Object[]{elementPath, new Boolean(forUpdate), new Integer(offset)}, GET_FS_BLOB_PARTIAL_SIGNATURE);
            blob = new Blob(blob.getElement(), blob.getBlobBytes(), this);
            blob.setLogical(true);
            return blob;
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get binary attachment: " + elementPath);
        }
    }

    IBlob getBlob(String subscriber, String configID) {
        try {
            if (this.m_directory == null) {
                IBlob blob = (IBlob)this.dsInvoke("getBlob", new Object[]{subscriber, configID}, new String[]{String.class.getName(), String.class.getName()});
                blob = new Blob(blob.getElement(), blob.getBlobBytes(), this);
                return blob;
            }
            return this.m_directory.getBlob(subscriber, configID);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get binary attachment: " + configID);
        }
    }

    IElement[] getAllElements(String subscriber, String dirName) {
        try {
            if (this.m_directory == null) {
                return (IElement[])this.dsInvoke("getAllElements", new Object[]{subscriber, dirName}, new String[]{String.class.getName(), String.class.getName()});
            }
            return this.m_directory.getAllElements(subscriber, dirName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration: " + dirName);
        }
    }

    Object[] reconcileCache(String containerID, Short[] versionInfo, Long myBackupVersion, IElementIdentity[] identities, HashMap deletedConfigurations, String[] dirNames, HashMap logicalMap) {
        try {
            if (this.m_directory == null) {
                return (Object[])this.m_connector.invoke(this.m_commType, this.m_targetDS, this.m_targetDS, "reconcileCache", new Object[]{containerID, versionInfo, myBackupVersion, identities, deletedConfigurations, dirNames, logicalMap}, new String[]{String.class.getName(), Short[].class.getName(), Long.class.getName(), identities.getClass().getName(), HashMap.class.getName(), String[].class.getName(), HashMap.class.getName()}, this.m_connector.getRequestTimeout() << 2);
            }
            return this.m_directory.reconcileCache(containerID, versionInfo, myBackupVersion, identities, deletedConfigurations, dirNames, logicalMap);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get configuration of updated/new elements.");
        }
    }

    /*
     * Loose catch block
     */
    INextVersionToken setElement(IBasicElement element) {
        block6: while (true) {
            try {
                if (this.m_directory == null) {
                    return (INextVersionToken)this.dsInvoke("setElement", new Object[]{element, null}, new String[]{IBasicElement.class.getName(), IDeltaView.class.getName()});
                }
                return this.m_directory.setElement(element, null);
            }
            catch (DirectoryDoesNotExistException e) {
                String dirname = "";
                StringTokenizer st = new StringTokenizer(element.getIdentity().getName(), "/");
                int i = st.countTokens();
                while (true) {
                    if (i <= 1) continue block6;
                    dirname = dirname + '/' + st.nextToken();
                    try {
                        this.createDirectory(dirname);
                    }
                    catch (DirectoryServiceException dse) {
                    }
                    catch (Exception e1) {
                        throw this.convertException(e1, "Failed to create DS directory: " + dirname);
                    }
                    --i;
                }
            }
            break;
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to set configuration: " + element.getIdentity().getName());
        }
    }

    void deleteElement(String configID) {
        try {
            if (this.m_directory == null) {
                this.dsInvoke("deleteElement", new Object[]{configID, null}, new String[]{String.class.getName(), IDeltaView.class.getName()});
            } else {
                this.m_directory.deleteElement(configID, null);
            }
        }
        catch (DirectoryDoesNotExistException e) {
        }
        catch (DirectoryServiceClosedException closed) {
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to delete configuration: " + configID);
        }
    }

    String storageToLogical(String storageName) {
        try {
            if (this.m_directory == null) {
                return (String)this.dsInvoke("storageToLogical", new Object[]{storageName}, new String[]{String.class.getName()});
            }
            return this.m_directory.storageToLogical(storageName);
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to get logical name for : " + storageName);
        }
    }

    private void createDirectory(String dirName) throws Exception {
        if (this.m_directory == null) {
            this.dsInvoke("createDirectory", new Object[]{dirName}, new String[]{String.class.getName()});
        } else {
            this.m_directory.createDirectory(dirName);
        }
    }

    private MFRuntimeException convertException(Exception e, String msg) {
        if (e instanceof DSNotStartedException) {
            DSNotStartedException dse = (DSNotStartedException)e;
            dse.setLinkedException(new InvokeTimeoutException(e.toString()));
            throw dse;
        }
        MFRuntimeException mfe = null;
        if (e instanceof MFRuntimeException) {
            mfe = (MFRuntimeException)e;
        } else {
            mfe = new MFRuntimeException(msg);
            mfe.setLinkedException(e);
        }
        return mfe;
    }

    private Object dsInvoke(String operation, Object[] params, String[] signature) throws Exception {
        return this.dsInvoke(operation, params, signature, true);
    }

    private Object dsInvoke(String operation, Object[] params, String[] signature, boolean retry) throws Exception {
        Throwable priorException = null;
        while (true) {
            try {
                Object returnValue = this.m_connector.invoke(this.m_commType, this.m_targetDS, this.m_targetDS, operation, params, signature);
                if (priorException != null) {
                    this.m_connector.logMessage("...retry successful", 3);
                }
                return returnValue;
            }
            catch (Exception e) {
                if (this.m_container.isClosing()) {
                    throw e;
                }
                if (ContainerUtil.isCausedByTimeout(e) && Thread.currentThread().getName().startsWith("Container boot thread")) {
                    int traceMask = this.m_connector.getTraceMask();
                    if ((traceMask & 0x20) > 0) {
                        if ((traceMask & 1) > 0) {
                            this.m_connector.logMessage("Timeout while communicating with the Directory Service, retrying...", e, 7);
                        } else {
                            this.m_connector.logMessage("Timeout while communicating with the Directory Service, retrying...", 7);
                        }
                    } else {
                        boolean log = false;
                        if (priorException == null) {
                            log = true;
                        } else if (!e.getClass().isInstance(priorException)) {
                            log = true;
                        } else if (priorException.getMessage() != null && !priorException.getMessage().equals(e.getMessage())) {
                            log = true;
                        } else if (e.getMessage() != null && !e.getMessage().equals(priorException.getMessage())) {
                            log = true;
                        }
                        if (log) {
                            this.m_connector.logMessage("Timeout while communicating with the Directory Service, retrying...", 2);
                        }
                    }
                    if (retry) {
                        priorException = e;
                        continue;
                    }
                    throw e;
                }
                throw e;
            }
            break;
        }
    }

    public void registerInterestInChanges(String subscriber, String logicalName) {
        try {
            if (this.m_directory == null) {
                this.dsInvoke("registerInterestInChanges", new Object[]{subscriber, logicalName}, new String[]{String.class.getName(), String.class.getName()});
            } else {
                this.m_directory.registerInterestInChanges(subscriber, logicalName);
            }
        }
        catch (Exception e) {
            throw this.convertException(e, "Failed to register interest in changes; container: " + subscriber + " element " + logicalName);
        }
    }
}

