/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.framework.INotificationPublisher;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import com.sonicsw.mx.util.FIFO;

public class NotificationPublisher
extends Thread
implements INotificationPublisher {
    private static final int DROPPED_NOTIFICATION_LOGGING_THRESHOLD = 500;
    private ContainerImpl m_container = null;
    private FIFO m_notificationTasks = null;
    private int m_queueSize;
    private int m_25PercentThreshold;
    private int m_50PercentThreshold;
    private boolean m_50PercentThresholdBreachLogged = false;
    private int m_75PercentThreshold;
    private boolean m_75PercentThresholdBreachLogged = false;
    private int m_droppedSinceLastLogged = 0;
    private boolean m_initialDropLogged = false;
    private IMetricsRegistrar m_metricsRegistrar;
    private IStatistic m_awaitingDispatchStatistic;
    private IStatistic m_maxAwaitingDispatchStatistic;
    private IStatistic m_droppedStatistic;
    private boolean m_isClosing = false;

    NotificationPublisher(ContainerImpl container) {
        super("Management Notification Publisher Thread");
        this.setDaemon(true);
        this.m_container = container;
        this.m_notificationTasks = new FIFO();
        this.setQueueSize(100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (!this.m_container.isClosing()) {
            throw new RuntimeException("Connot close publisher unless container is closing!");
        }
        FIFO fIFO = this.m_notificationTasks;
        synchronized (fIFO) {
            this.m_isClosing = true;
            this.m_notificationTasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setQueueSize(int newQueueSize) {
        if (newQueueSize < 0) {
            newQueueSize = 100000;
        }
        if (newQueueSize == 0) {
            this.m_50PercentThreshold = 0;
            this.m_50PercentThresholdBreachLogged = false;
            this.m_75PercentThreshold = 0;
            this.m_75PercentThresholdBreachLogged = false;
        } else {
            this.m_50PercentThreshold = newQueueSize >> 1;
            this.m_25PercentThreshold = this.m_50PercentThreshold >> 1;
            this.m_75PercentThreshold = this.m_50PercentThreshold + this.m_25PercentThreshold;
            boolean log50PercentThresholdBreached = false;
            boolean log75PercentThresholdBreached = false;
            FIFO fIFO = this.m_notificationTasks;
            synchronized (fIFO) {
                int currentSize = this.m_notificationTasks.size();
                if (currentSize > this.m_75PercentThreshold && !this.m_75PercentThresholdBreachLogged) {
                    log75PercentThresholdBreached = true;
                    this.m_50PercentThresholdBreachLogged = true;
                    this.m_75PercentThresholdBreachLogged = true;
                }
                if (currentSize > this.m_50PercentThreshold && !this.m_50PercentThresholdBreachLogged) {
                    log50PercentThresholdBreached = true;
                    this.m_50PercentThresholdBreachLogged = true;
                }
            }
            if (log50PercentThresholdBreached) {
                this.m_container.logMessage(null, "Management notifications dispatch queue is 50% full", 2);
            } else if (log75PercentThresholdBreached) {
                this.m_container.logMessage(null, "Management notifications dispatch queue is 75% full", 2);
            }
        }
        this.m_queueSize = newQueueSize;
    }

    static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[]{MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID, (short)0, (String)"The number of management notifications awaiting dispatch.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"notifications"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID, (short)0, (String)"The maximum number of management notifications awaiting dispatch since last metrics reset.", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"notifications"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID, (short)0, (String)"Number of times a management notification was dropped before dispatch to listeners. Evaluated over the last 30 minutes.", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"notifications")};
        return infos;
    }

    void initMetrics(IMetricsRegistrar metricsRegistrar) {
        this.m_metricsRegistrar = metricsRegistrar;
        IStatisticProvider[] awaitingDispatchProviders = new IStatisticProvider[]{new IStatisticProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStatistic(ISampledStatistic statistic) {
                FIFO fIFO = NotificationPublisher.this.m_notificationTasks;
                synchronized (fIFO) {
                    statistic.updateValue((long)NotificationPublisher.this.m_notificationTasks.size());
                }
            }

            public void resetStatistic(ISampledStatistic statistic) {
            }
        }};
        this.m_awaitingDispatchStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])awaitingDispatchProviders, (short)0);
        this.m_maxAwaitingDispatchStatistic = StatisticsFactory.createStatistic((short)3, (boolean)false, (IStatisticProvider[])awaitingDispatchProviders, (short)0);
        this.m_droppedStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
    }

    void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID, this.m_awaitingDispatchStatistic);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID, this.m_maxAwaitingDispatchStatistic);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID)) continue;
            this.m_droppedStatistic.reset();
            this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID, this.m_droppedStatistic);
        }
    }

    void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_AWAITINGDISPATCH_METRIC_ID);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_MAXAWAITINGDISPATCH_METRIC_ID);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID)) continue;
            this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_NOTIFICATIONS_DROPPED_METRIC_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] taskArray = null;
        long expirationTime = 0L;
        while (!this.m_isClosing) {
            Long notificationExpiration;
            Runnable notificationTask;
            block18: {
                notificationTask = null;
                notificationExpiration = null;
                boolean logNotificationsDeliveryResumed = false;
                try {
                    FIFO fIFO = this.m_notificationTasks;
                    synchronized (fIFO) {
                        if (this.m_notificationTasks.isEmpty()) {
                            if (this.m_isClosing) {
                                return;
                            }
                            this.m_notificationTasks.wait();
                            if (this.m_isClosing) {
                                return;
                            }
                            continue;
                        }
                        taskArray = (Object[])this.m_notificationTasks.remove(0);
                        int currentSize = this.m_notificationTasks.size();
                        if (this.m_queueSize > 0) {
                            if (currentSize < this.m_75PercentThreshold && this.m_initialDropLogged) {
                                this.m_initialDropLogged = false;
                                logNotificationsDeliveryResumed = true;
                            }
                            if (currentSize < this.m_50PercentThreshold) {
                                this.m_75PercentThresholdBreachLogged = false;
                            }
                            if (currentSize < this.m_25PercentThreshold) {
                                this.m_50PercentThresholdBreachLogged = false;
                            }
                        }
                    }
                    if (!logNotificationsDeliveryResumed) break block18;
                    this.m_container.logMessage(null, "...normal management notifications delivery resumed", 2);
                }
                catch (Exception e) {
                    if (this.m_container.isClosing()) {
                        return;
                    }
                    this.m_container.logMessage("Exception while management processing notifications, trace follows... ", e, 1);
                    continue;
                }
            }
            notificationTask = (Runnable)taskArray[0];
            notificationExpiration = (Long)taskArray[1];
            try {
                if (notificationExpiration == null || notificationTask == null) continue;
                expirationTime = notificationExpiration;
                if (this.isExpired(expirationTime)) {
                    if (this.m_droppedStatistic == null) continue;
                    this.m_droppedStatistic.updateValue(1L);
                    continue;
                }
                notificationTask.run();
            }
            catch (Exception e) {
                if (this.m_container.isClosing()) {
                    return;
                }
                this.m_container.logMessage("Failed to send management notification, trace follows... ", e, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueNotificationTask(Runnable notificationTask, long expirationTime) {
        if (notificationTask != null) {
            Object[] taskArray = new Object[]{notificationTask, new Long(expirationTime)};
            boolean log50PercentThresholdBreached = false;
            boolean log75PercentThresholdBreached = false;
            boolean logInitialNotificationDrop = false;
            boolean logNotificationsDropped = false;
            FIFO fIFO = this.m_notificationTasks;
            synchronized (fIFO) {
                if (this.m_queueSize > 0) {
                    int currentSize = this.m_notificationTasks.size();
                    if (currentSize >= this.m_queueSize) {
                        this.m_notificationTasks.remove(0);
                        ++this.m_droppedSinceLastLogged;
                        if (this.m_droppedStatistic != null) {
                            this.m_droppedStatistic.updateValue(1L);
                        }
                        if (this.m_droppedSinceLastLogged == 1 && !this.m_initialDropLogged) {
                            this.m_initialDropLogged = true;
                            logInitialNotificationDrop = true;
                        }
                        if (this.m_droppedSinceLastLogged == 500) {
                            logNotificationsDropped = true;
                            this.m_droppedSinceLastLogged = 0;
                        }
                    } else if (currentSize > this.m_75PercentThreshold && !this.m_75PercentThresholdBreachLogged) {
                        log75PercentThresholdBreached = true;
                        this.m_50PercentThresholdBreachLogged = true;
                        this.m_75PercentThresholdBreachLogged = true;
                    } else if (currentSize > this.m_50PercentThreshold && !this.m_50PercentThresholdBreachLogged) {
                        log50PercentThresholdBreached = true;
                        this.m_50PercentThresholdBreachLogged = true;
                    }
                }
                this.m_notificationTasks.add(taskArray);
                this.m_notificationTasks.notifyAll();
            }
            if (log50PercentThresholdBreached) {
                this.m_container.logMessage(null, "Management notifications dispatch queue is 50% full", 2);
            } else if (log75PercentThresholdBreached) {
                this.m_container.logMessage(null, "Management notifications dispatch queue is 75% full", 2);
            } else if (logInitialNotificationDrop) {
                this.m_container.logMessage(null, "Management notifications will be dropped due to slow/stopped delivery...", 2);
            } else if (logNotificationsDropped) {
                this.m_container.logMessage(null, "500 management notifications dropped due to slow/stopped delivery", 2);
            }
        }
    }

    private boolean isExpired(long expirationTime) {
        boolean expired = false;
        if (System.currentTimeMillis() > expirationTime) {
            expired = true;
        }
        return expired;
    }
}

