/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.UpdateDisallowedOnFailoverException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.framework.agent.ContainerDS;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.agent.cache.CacheClosedException;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.directory.storage.ParentDirDoesNotExistException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

final class RuntimeConfigurationManager {
    private ContainerImpl m_container;
    private IConfigCache m_configCache;
    private ContainerDS m_directory;
    private Hashtable m_runtimeConfigurations = new Hashtable();
    private ArrayList m_queuedDSUpdateTasks = new ArrayList();
    private static final String DS_RUNTIME_TYPE = "MF_RUNTIME";
    private static final String DS_RUNTIME_TYPE_VERSION = "2.0";

    RuntimeConfigurationManager(ContainerImpl container, IConfigCache configCache, ContainerDS directory) {
        this.m_container = container;
        this.m_configCache = configCache;
        this.m_directory = directory;
        new DSUpdater().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDirElement getRuntimeConfiguration(String id, String type, boolean useCacheOnly) {
        String configID = "/_MFRuntime/" + this.m_container.getContainerIdentity().getCanonicalName() + '/' + id + '/' + type;
        IDirElement runtimeConfiguration = (IDirElement)this.m_runtimeConfigurations.get(configID);
        if (runtimeConfiguration == null) {
            try {
                runtimeConfiguration = (IDirElement)this.m_configCache.getCacheView().getElement(configID);
            }
            catch (CacheClosedException e) {
                runtimeConfiguration = ElementFactory.createElement(configID, DS_RUNTIME_TYPE, DS_RUNTIME_TYPE_VERSION);
            }
        }
        if (runtimeConfiguration == null) {
            if (useCacheOnly) {
                runtimeConfiguration = ElementFactory.createElement(configID, DS_RUNTIME_TYPE, DS_RUNTIME_TYPE_VERSION);
                this.setRuntimeConfiguration(runtimeConfiguration, useCacheOnly);
            } else if (this.m_container.getConnectorServer().isConnected()) {
                String currentUserID = TaskScheduler.getCurrentUserID();
                try {
                    if (TaskScheduler.isExecutionThread()) {
                        ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID("Administrator");
                    }
                    runtimeConfiguration = (IDirElement)this.m_directory.getElementForUpdate(configID);
                }
                catch (MFRuntimeException e) {
                    Throwable cause = e.getCause();
                    if (!(cause != null && (cause instanceof DirectoryDoesNotExistException || ContainerUtil.isCausedByTimeout(cause)) || this.m_container.isClosing())) {
                        this.m_container.logMessage(id, "Unexpected failure while obtaining any enabled " + type + " from the Directory Service, trace follows...", cause == null ? e : cause, 2);
                    }
                }
                catch (Exception e) {
                    if (!this.m_container.isClosing()) {
                        this.m_container.logMessage(id, "Unexpected failure while obtaining any enabled " + type + " from the Directory Service, trace follows...", e, 2);
                    }
                }
                finally {
                    if (TaskScheduler.isExecutionThread()) {
                        ((TaskScheduler.ExecutionThread)Thread.currentThread()).setUserID(currentUserID);
                    }
                }
            }
        }
        if (runtimeConfiguration == null) {
            runtimeConfiguration = ElementFactory.createElement(configID, DS_RUNTIME_TYPE, DS_RUNTIME_TYPE_VERSION);
            this.setRuntimeConfiguration(runtimeConfiguration, false);
        }
        runtimeConfiguration.getAttributes().getAttributes();
        return (IDirElement)runtimeConfiguration.createWritableClone();
    }

    void setRuntimeConfiguration(IDirElement element, boolean useCacheOnly) {
        this.setRuntimeConfigurationInCache(element);
        if (!useCacheOnly) {
            this.queueSetRuntimeConfigurationInDS(element);
        }
    }

    private void setRuntimeConfigurationInCache(IDirElement runtimeConfiguration) {
        try {
            block6: {
                this.m_runtimeConfigurations.put(runtimeConfiguration.getIdentity().getName(), runtimeConfiguration);
                try {
                    this.m_configCache.deleteElement(runtimeConfiguration.getIdentity().getName());
                }
                catch (Throwable e) {
                    if (e.getCause() != null && e.getCause() instanceof ParentDirDoesNotExistException) break block6;
                    this.m_container.logMessage(null, "Cache failure, trace follows...", e, 2);
                }
            }
            this.m_configCache.setElement(runtimeConfiguration);
        }
        catch (VersionOutofSyncException e) {
        }
        catch (CacheClosedException e) {
        }
        catch (PersistentCacheException persistentCacheException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueSetRuntimeConfigurationInDS(IDirElement runtimeConfiguration) {
        String configID = runtimeConfiguration.getIdentity().getName();
        SetRuntimeConfigurationInDSTask setRuntimeConfigurationInDSTask = new SetRuntimeConfigurationInDSTask(configID, (IDirElement)runtimeConfiguration.createWritableClone());
        ArrayList arrayList = this.m_queuedDSUpdateTasks;
        synchronized (arrayList) {
            Iterator dsUpdateTasks = this.m_queuedDSUpdateTasks.iterator();
            while (dsUpdateTasks.hasNext()) {
                DSUpdateTask dsUpdateTask = (DSUpdateTask)dsUpdateTasks.next();
                if (!(dsUpdateTask instanceof SetRuntimeConfigurationInDSTask) || !dsUpdateTask.configID.equals(configID)) continue;
                dsUpdateTasks.remove();
            }
            this.m_queuedDSUpdateTasks.add(setRuntimeConfigurationInDSTask);
            this.m_queuedDSUpdateTasks.notifyAll();
        }
    }

    void deleteRuntimeConfiguration(String configID, boolean useCacheOnly) {
        this.deleteRuntimeConfigurationInCache(configID);
        if (!useCacheOnly) {
            this.queueDeleteRuntimeConfigurationInDS(configID);
        }
    }

    private void deleteRuntimeConfigurationInCache(String configID) {
        block2: {
            this.m_runtimeConfigurations.remove(configID);
            try {
                this.m_configCache.deleteElement(configID);
            }
            catch (Throwable e) {
                if (e.getCause() != null && e.getCause() instanceof ParentDirDoesNotExistException) break block2;
                this.m_container.logMessage(null, "Cache failure, trace follows...", e, 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueDeleteRuntimeConfigurationInDS(String configID) {
        DeleteRuntimeConfigurationInDSTask deleteRuntimeConfigurationInDSTask = new DeleteRuntimeConfigurationInDSTask(configID);
        ArrayList arrayList = this.m_queuedDSUpdateTasks;
        synchronized (arrayList) {
            Iterator dsUpdateTasks = this.m_queuedDSUpdateTasks.iterator();
            while (dsUpdateTasks.hasNext()) {
                DSUpdateTask dsUpdateTask = (DSUpdateTask)dsUpdateTasks.next();
                if (!(dsUpdateTask instanceof DeleteRuntimeConfigurationInDSTask) || !dsUpdateTask.configID.equals(configID)) continue;
                dsUpdateTasks.remove();
            }
            this.m_queuedDSUpdateTasks.add(deleteRuntimeConfigurationInDSTask);
            this.m_queuedDSUpdateTasks.notifyAll();
        }
    }

    private final class DSUpdater
    extends Thread {
        private DSUpdater() {
            super("Runtime configuration updater [" + RuntimeConfigurationManager.this.m_container.getContainerIdentity().getCanonicalName() + "]");
            super.setDaemon(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!RuntimeConfigurationManager.this.m_container.isClosing()) {
                DSUpdateTask dsUpdateTask = null;
                ArrayList arrayList = RuntimeConfigurationManager.this.m_queuedDSUpdateTasks;
                synchronized (arrayList) {
                    if (RuntimeConfigurationManager.this.m_queuedDSUpdateTasks.isEmpty()) {
                        try {
                            RuntimeConfigurationManager.this.m_queuedDSUpdateTasks.wait(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        dsUpdateTask = (DSUpdateTask)RuntimeConfigurationManager.this.m_queuedDSUpdateTasks.remove(0);
                    }
                }
                if (dsUpdateTask == null) continue;
                dsUpdateTask.run();
            }
        }
    }

    private final class DeleteRuntimeConfigurationInDSTask
    extends DSUpdateTask {
        private DeleteRuntimeConfigurationInDSTask(String configID) {
            super(configID);
        }

        @Override
        public void run() {
            while (!RuntimeConfigurationManager.this.m_container.isClosing()) {
                if (RuntimeConfigurationManager.this.m_container.getConnectorServer().isConnected()) {
                    try {
                        try {
                            RuntimeConfigurationManager.this.m_directory.deleteElement(((DSUpdateTask)this).configID);
                        }
                        catch (MFRuntimeException e) {
                            Throwable cause = e.getCause();
                            if (ContainerUtil.isCausedByTimeout(cause)) continue;
                            e.printStackTrace();
                        }
                        return;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                }
            }
            return;
        }
    }

    private final class SetRuntimeConfigurationInDSTask
    extends DSUpdateTask {
        IDirElement localRuntimeConfiguration;

        private SetRuntimeConfigurationInDSTask(String configID, IDirElement localRuntimeConfiguration) {
            super(configID);
            this.localRuntimeConfiguration = localRuntimeConfiguration;
        }

        @Override
        public void run() {
            while (!RuntimeConfigurationManager.this.m_container.isClosing()) {
                if (RuntimeConfigurationManager.this.m_container.getConnectorServer().isConnected()) {
                    try {
                        try {
                            IDirElement runtimeConfigurationFromDS = (IDirElement)RuntimeConfigurationManager.this.m_directory.getElementForUpdate(this.localRuntimeConfiguration.getIdentity().getName());
                            if (runtimeConfigurationFromDS == null) {
                                RuntimeConfigurationManager.this.m_directory.setElement(this.localRuntimeConfiguration);
                            } else {
                                this.cloneRuntimeonfiguration(runtimeConfigurationFromDS, this.localRuntimeConfiguration);
                                RuntimeConfigurationManager.this.m_directory.setElement(runtimeConfigurationFromDS.doneUpdate());
                            }
                        }
                        catch (MFRuntimeException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof DirectoryDoesNotExistException) {
                                RuntimeConfigurationManager.this.m_directory.setElement(this.localRuntimeConfiguration);
                            }
                            if (ContainerUtil.isCausedByTimeout(cause)) continue;
                            if (cause instanceof UpdateDisallowedOnFailoverException) {
                                RuntimeConfigurationManager.this.m_container.logMessage(null, "Read-only Directory Service prevented storing of " + this.localRuntimeConfiguration.getIdentity().getName(), 2);
                            }
                            RuntimeConfigurationManager.this.m_container.logMessage(null, "Failed to store " + this.localRuntimeConfiguration.getIdentity().getName() + " in the Directory Service, trace follows...", cause, 2);
                        }
                        return;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                }
            }
            return;
        }

        private void cloneRuntimeonfiguration(IDirElement runtimeConfigurationFromDS, IElement localRuntimeConfiguration) {
            IAttributeSet fromDS = runtimeConfigurationFromDS.getAttributes();
            IAttributeSet toDS = localRuntimeConfiguration.getAttributes();
            try {
                Iterator attributeNames = fromDS.getAttributes().keySet().iterator();
                while (attributeNames.hasNext()) {
                    fromDS.deleteAttribute((String)attributeNames.next());
                }
                this.cloneAttributeSet(fromDS, toDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void cloneAttributeSet(IAttributeSet to, IAttributeSet from) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
            for (Map.Entry entry : from.getAttributes().entrySet()) {
                Object value = entry.getValue();
                if (value instanceof IAttributeSet) {
                    IAttributeSet set = to.createAttributeSet((String)entry.getKey());
                    this.cloneAttributeSet(set, (IAttributeSet)value);
                    continue;
                }
                if (value instanceof IAttributeList) {
                    IAttributeList list = to.createAttributeList((String)entry.getKey());
                    this.cloneAttributeList(list, (IAttributeList)value);
                    continue;
                }
                to.setObjectAttribute((String)entry.getKey(), value);
            }
        }

        private void cloneAttributeList(IAttributeList to, IAttributeList from) throws ReadOnlyException, AttributeSetTypeException, ConfigException {
            for (Object value : from.getItems()) {
                if (value instanceof IAttributeSet) {
                    IAttributeSet set = to.addNewAttributeSetItem();
                    this.cloneAttributeSet(set, (IAttributeSet)value);
                    continue;
                }
                if (value instanceof IAttributeList) {
                    IAttributeList list = to.addNewAttributeListItem();
                    this.cloneAttributeList(list, (IAttributeList)value);
                    continue;
                }
                to.addObjectItem(value);
            }
        }
    }

    private abstract class DSUpdateTask
    implements Runnable {
        private String configID;

        private DSUpdateTask(String configID) {
            this.configID = configID;
        }
    }
}

