/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.MFException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.util.URLUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class SonicfsURLStreamHandler
extends URLStreamHandler {
    private ContainerImpl m_container;
    private String m_protocolPrefix;

    SonicfsURLStreamHandler(ContainerImpl container, String protocolPrefix) {
        this.m_container = container;
        this.m_protocolPrefix = protocolPrefix;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return new Connection(url);
    }

    public class Connection
    extends URLConnection {
        private Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                String path = this.url.getFile();
                if (path != null) {
                    path = URLUtility.decode(path);
                }
                String filePath = SonicfsURLStreamHandler.this.m_protocolPrefix + (path != null ? path.substring(1) : "");
                File file = SonicfsURLStreamHandler.this.m_container.getLocalFile(filePath);
                if (file == null) {
                    throw new FileNotFoundException("Could not read " + filePath);
                }
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (MFException e) {
                IOException ioe = new IOException("Failed to get input stream for " + super.getURL().toExternalForm());
                ioe.initCause(e);
                throw ioe;
            }
            catch (MFRuntimeException e) {
                IOException ioe = new IOException("Failed to get input stream for " + super.getURL().toExternalForm());
                ioe.initCause(e);
                throw ioe;
            }
        }

        @Override
        public String getContentType() {
            return "application/octet-stream";
        }

        @Override
        public boolean getUseCaches() {
            return false;
        }
    }
}

