/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.framework.ITaskScheduler;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.mgmtapi.runtime.IAgentProxy;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;

public final class TaskScheduler
extends Thread
implements ITaskScheduler {
    private ContainerImpl m_container;
    private short m_maxThreads = (short)50;
    private short m_minThreads = 0;
    private ArrayList<Runnable> m_normalPriorityTasks = new ArrayList();
    private ArrayList<Long> m_normalPriorityTaskExpirationTimes = new ArrayList();
    private ArrayList<Runnable> m_higherPriorityTasks = new ArrayList();
    private ArrayList<Long> m_higherPriorityTaskExpirationTimes = new ArrayList();
    private Stack<ExecutionThread> m_executionThreadCache = new Stack();
    private int m_executingThreads = 0;
    private static final long MAX_IDLE_DURATION = 5000L;
    private IMetricsRegistrar m_metricsRegistrar;
    private IStatistic m_poolSizeStatistic;
    private IStatistic m_maxPoolSizeStatistic;
    private IStatistic m_poolWaitsStatistic;
    public static final String TASK_THREAD_NAME = "Task Runner ";
    private boolean m_isClosing = false;
    private Object m_taskSchedulerLockObj = new Object();

    TaskScheduler(ContainerImpl container) {
        super("Task Scheduler");
        this.setDaemon(true);
        this.m_container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (!this.m_container.isClosing()) {
            throw new RuntimeException("Connot close task scheduler unless container is closing!");
        }
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            this.m_isClosing = true;
            this.m_taskSchedulerLockObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long nextObsoleteTaskCleanupTime = System.currentTimeMillis() + 5000L;
        while (!this.m_isClosing) {
            Object object;
            Runnable task = null;
            long expirationTime = 0L;
            Object object2 = this.m_taskSchedulerLockObj;
            synchronized (object2) {
                if (!this.m_higherPriorityTasks.isEmpty()) {
                    task = this.m_higherPriorityTasks.remove(0);
                    expirationTime = this.m_higherPriorityTaskExpirationTimes.remove(0);
                } else if (!this.m_normalPriorityTasks.isEmpty()) {
                    task = this.m_normalPriorityTasks.remove(0);
                    expirationTime = this.m_normalPriorityTaskExpirationTimes.remove(0);
                } else {
                    try {
                        if (this.m_isClosing) {
                            return;
                        }
                        this.m_taskSchedulerLockObj.wait();
                        if (this.m_isClosing) {
                            return;
                        }
                        continue;
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
            if (task == null || expirationTime != 0L && System.currentTimeMillis() > expirationTime) continue;
            if (System.currentTimeMillis() >= nextObsoleteTaskCleanupTime) {
                this.removeObsoleteTasks(this.m_higherPriorityTasks, this.m_higherPriorityTaskExpirationTimes);
                this.removeObsoleteTasks(this.m_normalPriorityTasks, this.m_normalPriorityTaskExpirationTimes);
                nextObsoleteTaskCleanupTime = System.currentTimeMillis() + 5000L;
            }
            ExecutionThread executionThread = null;
            while (executionThread == null) {
                object = this.m_executionThreadCache;
                synchronized (object) {
                    block27: {
                        try {
                            executionThread = this.m_executionThreadCache.pop();
                            if (executionThread != null) {
                                ++this.m_executingThreads;
                            }
                        }
                        catch (EmptyStackException e) {
                            if (this.getTotalPoolSize() == this.m_maxThreads) {
                                if (this.m_poolWaitsStatistic != null) {
                                    this.m_poolWaitsStatistic.updateValue(1L);
                                }
                                try {
                                    this.m_executionThreadCache.wait();
                                }
                                catch (InterruptedException ie) {
                                    return;
                                }
                            }
                            if (executionThread != null) break block27;
                            executionThread = new ExecutionThread();
                            executionThread.setName(TASK_THREAD_NAME + executionThread.hashCode());
                            executionThread.setDaemon(true);
                            executionThread.start();
                            ++this.m_executingThreads;
                        }
                    }
                }
            }
            object = executionThread.getExecutionThreadLockObj();
            synchronized (object) {
                executionThread.m_task = task;
                executionThread.getExecutionThreadLockObj().notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObsoleteTasks(ArrayList<Runnable> taskList, ArrayList<Long> taskExpirationTimeList) {
        long currentTime = System.currentTimeMillis();
        ArrayList<Runnable> obsoleteTasks = new ArrayList<Runnable>();
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            Iterator<Runnable> iterator = taskList.iterator();
            Iterator<Long> taskExpirations = taskExpirationTimeList.iterator();
            while (iterator.hasNext()) {
                Runnable task = iterator.next();
                long expirationTime = taskExpirations.next();
                if (expirationTime == 0L || currentTime <= expirationTime) continue;
                iterator.remove();
                taskExpirations.remove();
                obsoleteTasks.add(task);
            }
        }
        if (!obsoleteTasks.isEmpty()) {
            for (Object e : obsoleteTasks) {
                this.m_container.logMessage(null, "Dropped obsolete task " + e + "; consider changing size of management thread pool, management request timeout or Domain Manager hardware", 2);
            }
        }
    }

    int getMaxThreads() {
        return this.m_maxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxThreads(int maxThreads) {
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            if (maxThreads > 1000) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot exceed 1000.");
            }
            if (maxThreads <= this.m_minThreads) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot be less than the minimum scheduler threads.");
            }
            if (maxThreads < 20) {
                throw new IllegalArgumentException("Maximum scheduler threads cannot be less than 20.");
            }
            this.m_maxThreads = (short)maxThreads;
        }
    }

    int getMinThreads() {
        return this.m_minThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinThreads(int minThreads) {
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            if (minThreads < 0) {
                throw new IllegalArgumentException("Minimum scheduler threads cannot be less than 0.");
            }
            if (minThreads >= this.m_maxThreads) {
                throw new IllegalArgumentException("Minimum scheduler threads must be less than the maximum scheduler threads.");
            }
            this.m_minThreads = (short)minThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTask(Runnable task, boolean higherPriority) {
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            if (higherPriority) {
                this.m_higherPriorityTasks.add(task);
                this.m_higherPriorityTaskExpirationTimes.add(0L);
            } else {
                this.m_normalPriorityTasks.add(task);
                this.m_normalPriorityTaskExpirationTimes.add(0L);
            }
            this.m_taskSchedulerLockObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleTask(Runnable task, boolean higherPriority, long expirationTime) {
        Object object = this.m_taskSchedulerLockObj;
        synchronized (object) {
            if (higherPriority) {
                this.m_higherPriorityTasks.add(task);
                this.m_higherPriorityTaskExpirationTimes.add(expirationTime);
            } else {
                this.m_normalPriorityTasks.add(task);
                this.m_normalPriorityTaskExpirationTimes.add(expirationTime);
            }
            this.m_taskSchedulerLockObj.notifyAll();
        }
    }

    public static String getCurrentRole() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ExecutionThread) {
            return ((ExecutionThread)currentThread).getRole();
        }
        return null;
    }

    public static String getCurrentUserID() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ExecutionThread) {
            return ((ExecutionThread)currentThread).getUserID();
        }
        return null;
    }

    public static boolean isExecutionThread() {
        return Thread.currentThread() instanceof ExecutionThread;
    }

    static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[]{MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID, (short)0, (String)"Size of thread pool used to service transient management tasks.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"pool threads"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID, (short)0, (String)"Maximum size of thread pool used to service transient management tasks since last metrics reset.", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"pool threads"), MetricsFactory.createMetricInfo((IMetricIdentity)IAgentProxy.SYSTEM_THREADS_POOLWAITS_METRIC_ID, (short)0, (String)"Number of times transient management tasks had to wait because a pooled thread was not immediately available to service such tasks. Evaluated over the last 30 minutes.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"waits")};
        return infos;
    }

    void initMetrics(IMetricsRegistrar metricsRegistrar) {
        this.m_metricsRegistrar = metricsRegistrar;
        IStatisticProvider[] poolSizeProviders = new IStatisticProvider[]{new IStatisticProvider(){
            private Object lock = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStatistic(ISampledStatistic statistic) {
                Object object = this.lock;
                synchronized (object) {
                    statistic.updateValue((long)TaskScheduler.this.getTotalPoolSize());
                }
            }

            public void resetStatistic(ISampledStatistic statistic) {
            }
        }};
        this.m_poolSizeStatistic = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])poolSizeProviders, (short)0);
        this.m_maxPoolSizeStatistic = StatisticsFactory.createStatistic((short)3, (boolean)false, (IStatisticProvider[])poolSizeProviders, (short)0);
        this.m_poolWaitsStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
    }

    void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID, this.m_poolSizeStatistic);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID)) {
                this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID, this.m_maxPoolSizeStatistic);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_THREADS_POOLWAITS_METRIC_ID)) continue;
            this.m_poolWaitsStatistic.reset();
            this.m_metricsRegistrar.registerMetric(IAgentProxy.SYSTEM_THREADS_POOLWAITS_METRIC_ID, this.m_poolWaitsStatistic);
        }
    }

    void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(IAgentProxy.SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_THREADS_CURRENTPOOLSIZE_METRIC_ID);
                continue;
            }
            if (ids[i].equals(IAgentProxy.SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_THREADS_MAXPOOLSIZE_METRIC_ID);
                continue;
            }
            if (!ids[i].equals(IAgentProxy.SYSTEM_THREADS_POOLWAITS_METRIC_ID)) continue;
            this.m_metricsRegistrar.unregisterMetric(IAgentProxy.SYSTEM_THREADS_POOLWAITS_METRIC_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTotalPoolSize() {
        Stack<ExecutionThread> stack = this.m_executionThreadCache;
        synchronized (stack) {
            return this.m_executionThreadCache.size() + this.m_executingThreads;
        }
    }

    static /* synthetic */ Stack access$300(TaskScheduler x0) {
        return x0.m_executionThreadCache;
    }

    static /* synthetic */ short access$400(TaskScheduler x0) {
        return x0.m_minThreads;
    }

    static /* synthetic */ ArrayList access$500(TaskScheduler x0) {
        return x0.m_higherPriorityTasks;
    }

    static /* synthetic */ ArrayList access$600(TaskScheduler x0) {
        return x0.m_normalPriorityTasks;
    }

    static /* synthetic */ int access$700(TaskScheduler x0) {
        return x0.m_executingThreads;
    }

    static /* synthetic */ int access$710(TaskScheduler x0) {
        return x0.m_executingThreads--;
    }

    static /* synthetic */ ContainerImpl access$800(TaskScheduler x0) {
        return x0.m_container;
    }

    public class ExecutionThread
    extends Thread {
        String m_userID;
        String m_role;
        Runnable m_task;
        Object m_executionThreadLockObj = new Object();

        private ExecutionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setRole(String role) {
            Object object = this.m_executionThreadLockObj;
            synchronized (object) {
                if (this.m_role != null) {
                    throw new IllegalStateException("Cannot reset execution role.");
                }
                this.m_role = role;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getRole() {
            Object object = this.m_executionThreadLockObj;
            synchronized (object) {
                return this.m_role;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setUserID(String userID) {
            Object object = this.m_executionThreadLockObj;
            synchronized (object) {
                this.m_userID = userID;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getUserID() {
            Object object = this.m_executionThreadLockObj;
            synchronized (object) {
                return this.m_userID;
            }
        }

        public Object getExecutionThreadLockObj() {
            return this.m_executionThreadLockObj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                block34: {
                    localTask = null;
                    var2_2 = this.m_executionThreadLockObj;
                    synchronized (var2_2) {
                        try {
                            if (this.m_task == null) {
                                this.m_executionThreadLockObj.wait(5000L);
                            }
                            if (this.m_task != null) ** GOTO lbl-1000
                            var3_5 = TaskScheduler.access$300(TaskScheduler.this);
                            synchronized (var3_5) {
                                if (TaskScheduler.this.getTotalPoolSize() <= TaskScheduler.access$400(TaskScheduler.this)) {
                                    continue;
                                }
                                if (TaskScheduler.access$300(TaskScheduler.this).size() < TaskScheduler.access$500(TaskScheduler.this).size() + TaskScheduler.access$600(TaskScheduler.this).size()) {
                                    continue;
                                }
                                if (TaskScheduler.access$300(TaskScheduler.this).remove(this)) {
                                    return;
                                }
                                continue;
                            }
lbl-1000:
                            // 1 sources

                            {
                                localTask = this.m_task;
                            }
                        }
                        catch (InterruptedException ie) {
                            if (this.m_task == null) return;
                            if (TaskScheduler.access$700(TaskScheduler.this) <= 0) return;
                            TaskScheduler.access$710(TaskScheduler.this);
                            return;
                        }
                    }
                    try {
                        super.setName("Task Runner " + this.hashCode() + " [" + localTask.getClass().getName() + ']');
                        localTask.run();
                    }
                    catch (MFServiceNotActiveException e) {
                        if ((TaskScheduler.access$800((TaskScheduler)TaskScheduler.this).m_agent.m_traceMask & 32) > 0) {
                            TaskScheduler.access$800(TaskScheduler.this).logMessage(null, "Unhandled task failure due to inactive service, trace follows...", e, 7);
                        }
                    }
                    catch (Throwable e) {
                        if (TaskScheduler.access$800(TaskScheduler.this).isClosing()) {
                            if ((TaskScheduler.access$800((TaskScheduler)TaskScheduler.this).m_agent.m_traceMask & 32) > 0) {
                                TaskScheduler.access$800(TaskScheduler.this).logMessage(null, "Unhandled task failure during shutdown, trace follows...", e, 2);
                            }
                            break block34;
                        }
                        TaskScheduler.access$800(TaskScheduler.this).logMessage(null, "Unhandled task failure, trace follows...", e, 2);
                    }
                    finally {
                        e = this.m_executionThreadLockObj;
                        synchronized (e) {
                            super.setName("Task Runner " + this.hashCode() + " [idle]");
                            this.m_role = null;
                            this.m_task = null;
                            this.m_userID = null;
                        }
                    }
                }
                var2_2 = TaskScheduler.access$300(TaskScheduler.this);
                synchronized (var2_2) {
                    TaskScheduler.access$300(TaskScheduler.this).push(this);
                    if (TaskScheduler.access$700(TaskScheduler.this) > 0) {
                        TaskScheduler.access$710(TaskScheduler.this);
                    }
                    TaskScheduler.access$300(TaskScheduler.this).notifyAll();
                }
            }
        }
    }
}

