/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.cache.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.IElementCache;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.agent.cache.impl.ContentCache;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.ParentDirDoesNotExistException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSStorage;
import java.util.ArrayList;

public final class ElementCache
implements IElementCache {
    private static final int CACHE_STRUCTURE_VERSION = 4;
    private static final String SYSTEM_DIRECTORY_PATH = "/_MFSystem";
    private static final String VERSION_ELEMENT = "version";
    private static final String VERSION_ELEMENT_PATH = "/_MFSystem/version";
    public static final int CACHE_MAX_SIZE_DEFAULT = 10000000;
    public static final int CACHE_MAX_SIZE_MINIMUM = 5000000;
    private IContainer m_container;
    private ContentCache m_cache;
    private IStorage m_storage;
    private ArrayList m_newBatch = null;
    private ArrayList m_deletedBatch = null;
    private static EntityName VERSION_ELEMENT_ENTITY_NAME = null;
    private static EntityName SYSTEM_DIRECTORY_PATH_ENTITY_NAME = null;

    public ElementCache(IContainer container) {
        this.m_container = container;
        this.m_storage = null;
        this.m_cache = new ContentCache(10000000);
    }

    public ElementCache(IContainer container, String hostDir, String password) throws PersistentCacheException {
        this.m_container = container;
        try {
            this.m_storage = new FSStorage(hostDir, "content", "data", password, false);
        }
        catch (StorageException e) {
            this.storageError("Failed to open persistent cache", e);
        }
        try {
            IDirElement versionElement;
            if (!this.m_storage.directoryExists(SYSTEM_DIRECTORY_PATH_ENTITY_NAME)) {
                this.m_storage.createDirectory(SYSTEM_DIRECTORY_PATH_ENTITY_NAME);
            }
            if ((versionElement = this.m_storage.getElement(VERSION_ELEMENT_ENTITY_NAME)) == null) {
                versionElement = ElementFactory.createElement(VERSION_ELEMENT_PATH, VERSION_ELEMENT, "2.0");
                IAttributeSet attributes = versionElement.getAttributes();
                attributes.setIntegerAttribute("VERSION", new Integer(4));
                this.m_storage.setElement(VERSION_ELEMENT_ENTITY_NAME, (IDirElement)versionElement.doneUpdate(), true);
            } else {
                IAttributeSet attributes = versionElement.getAttributes();
                Integer dsVersion = (Integer)attributes.getAttribute("VERSION");
                if (dsVersion != 4) {
                    throw new PersistentCacheException("The cache version mismatches the  version of the software.\nStorage version is: " + dsVersion + ". Software version is: " + 4 + ".");
                }
            }
        }
        catch (StorageException e) {
            throw new PersistentCacheException(e.toString(), e);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString(), e);
        }
        catch (AttributeSetTypeException e) {
            throw new Error(e.toString(), e);
        }
        catch (ConfigException e) {
            throw new Error(e.toString(), e);
        }
        this.m_cache = new ContentCache(10000000);
    }

    private IAttributeSet getStoredAttributes(IDirElement[] stElements, Element element) {
        IElementIdentity wantedElementID = element.getIdentity();
        String wantedElementName = wantedElementID.getName();
        if (stElements == null || stElements.length == 0) {
            element.setDeleted();
            return null;
        }
        IBasicElement targetElement = null;
        for (int i = 0; i < stElements.length; ++i) {
            String elementName = stElements[i].getIdentity().getName();
            IAttributeSet attributes = stElements[i].getAttributes();
            this.m_cache.put(elementName, attributes, ((AttributeSet)attributes).estimateSize());
            if (!elementName.equals(wantedElementName)) continue;
            targetElement = stElements[i];
        }
        if (targetElement == null || !targetElement.getIdentity().equalEntity(wantedElementID)) {
            element.setDeleted();
            return null;
        }
        return targetElement.getAttributes();
    }

    @Override
    public synchronized IAttributeSet getAttributes(Element element) {
        IElementIdentity elementIdentity = element.getIdentity();
        String elementName = elementIdentity.getName();
        IAttributeSet attributes = (IAttributeSet)this.m_cache.get(elementName);
        if (attributes != null) {
            return attributes;
        }
        if (this.m_storage != null) {
            try {
                return this.getStoredAttributes(this.m_storage.getElements(new EntityName(elementName)), element);
            }
            catch (ConfigException e) {
                throw new Error("Cache configuration failure", e);
            }
            catch (StorageException e) {
                this.storageError("Storage failure", e);
            }
        }
        IDirElement[] dsElement = null;
        if (this.m_container == null) {
            return null;
        }
        dsElement = new IDirElement[]{(IDirElement)this.m_container.getConfigurationFromDS(elementName)};
        return this.getStoredAttributes(dsElement, element);
    }

    @Override
    public synchronized void storeAttributes(Element element) {
        AttributeSet attributes = (AttributeSet)element.getAttributes();
        if (this.m_storage != null) {
            if (this.m_newBatch == null) {
                try {
                    this.m_storage.setElement(new EntityName(element.getIdentity().getName()), element, true);
                }
                catch (ConfigException e) {
                    throw new Error("Cache configuration failure", e);
                }
                catch (StorageException e) {
                    this.storageError("Storage failure", e);
                }
            } else {
                this.m_newBatch.add(element);
            }
        }
        this.m_cache.put(element.getIdentity().getName(), attributes, attributes.estimateSize());
    }

    @Override
    public synchronized void removeAttributes(String elementName) {
        if (this.m_storage != null) {
            try {
                if (this.m_deletedBatch == null) {
                    this.m_storage.deleteElement(new EntityName(elementName));
                } else {
                    this.m_deletedBatch.add(new EntityName(elementName));
                }
            }
            catch (ParentDirDoesNotExistException e) {
                throw new Error("Cache directory does not exist", e);
            }
            catch (ConfigException e) {
                throw new Error("Cache configuration failure", e);
            }
            catch (StorageException e) {
                this.storageError("Storage failure", e);
            }
        }
        this.m_cache.remove(elementName);
    }

    @Override
    public synchronized void adjustSize(int newSize) {
        this.m_cache.adjustSize(newSize);
    }

    private void storageError(String message, StorageException e) {
        if (this.m_container == null) {
            throw new Error(message, e);
        }
        this.m_container.logMessage(null, "Storage failure, trace follows...", e, 1);
        this.m_container.logMessage(null, "If the persistent cache appears to be corrupt then the problem can be fixed by deleting the persistent cache directory.", 3);
        this.m_container.shutdown(7);
    }

    void createBatch() {
        if (this.m_storage == null) {
            return;
        }
        if (this.m_newBatch != null) {
            throw new IllegalStateException();
        }
        if (this.m_deletedBatch != null) {
            throw new IllegalStateException();
        }
        this.m_newBatch = new ArrayList();
        this.m_deletedBatch = new ArrayList();
        this.m_cache.suspendSizeLimit();
    }

    synchronized void saveBatch(boolean ok) {
        if (this.m_storage == null) {
            return;
        }
        this.m_cache.restoreSizeLimit();
        this.m_cache.adjustSize();
        if (this.m_newBatch == null) {
            throw new IllegalStateException();
        }
        if (this.m_deletedBatch == null) {
            throw new IllegalStateException();
        }
        if (!ok) {
            this.m_newBatch = null;
            this.m_deletedBatch = null;
            return;
        }
        IDirElement[] newElements = new IDirElement[this.m_newBatch.size()];
        this.m_newBatch.toArray(newElements);
        EntityName[] deletedElements = new EntityName[this.m_deletedBatch.size()];
        this.m_deletedBatch.toArray(deletedElements);
        try {
            this.m_storage.deleteElements(deletedElements);
            this.m_storage.setElements(newElements, true);
        }
        catch (StorageException e) {
            this.storageError("Storage failure", e);
        }
        this.m_newBatch = null;
        this.m_deletedBatch = null;
    }

    static {
        try {
            VERSION_ELEMENT_ENTITY_NAME = new EntityName(VERSION_ELEMENT_PATH);
            SYSTEM_DIRECTORY_PATH_ENTITY_NAME = new EntityName(SYSTEM_DIRECTORY_PATH);
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }
}

