/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import java.io.File;
import java.util.ArrayList;

public abstract class AbstractContainerProcess {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int STANDARD_OUTPUT = 1;
    public static final int STANDARD_ERROR = 2;
    protected ArrayList m_execCommand;
    protected File m_workDir;
    protected Process m_containerProcess;
    private boolean m_isRunning;
    protected String m_containerName;
    protected ILogger m_logger;
    protected String m_outputString;
    protected String m_errorString;

    String getOutput() {
        return this.m_outputString;
    }

    String getError() {
        return this.m_errorString;
    }

    protected abstract void exec() throws Exception;

    public int waitFor() {
        while (true) {
            try {
                int exitCode = this.m_containerProcess.waitFor();
                this.setRunning(false);
                return exitCode;
            }
            catch (InterruptedException e) {
                this.m_containerProcess.destroy();
                continue;
            }
            break;
        }
    }

    protected synchronized void setRunning(boolean running) {
        this.m_isRunning = running;
    }

    protected synchronized boolean isRunning() {
        return this.m_isRunning;
    }

    protected void logMessage(String message, Throwable t, int severityLevel) {
        if (this.m_logger != null) {
            this.m_logger.logMessage(message, t, severityLevel);
        }
    }
}

