/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.util.RollingFileLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

final class CILogger
implements ILogger {
    private RollingFileLogger m_fileLogger;
    public static final PrintStream m_stdout = System.out;
    private String m_id;
    private ArrayList m_pendingMessages = new ArrayList();

    CILogger(String id) {
        this.m_id = id;
    }

    synchronized void initLog(String logFilePath, String containerName) throws Exception {
        this.m_fileLogger = new RollingFileLogger(logFilePath, containerName);
        if (!System.getProperty("sonicsw.mf.devSingleJVM", "false").equals("true")) {
            OutputStream os = new OutputStream(){

                @Override
                public synchronized void write(int b) throws IOException {
                    m_stdout.write(b);
                    CILogger.this.m_fileLogger.write(b);
                }

                @Override
                public synchronized void write(byte[] b, int off, int len) throws IOException {
                    m_stdout.write(b, off, len);
                    CILogger.this.m_fileLogger.write(b, off, len);
                }
            };
            PrintStream ps = new PrintStream(os);
            System.setOut(ps);
            System.setErr(ps);
        }
        if (!this.m_pendingMessages.isEmpty()) {
            Iterator pendingMessages = this.m_pendingMessages.iterator();
            while (pendingMessages.hasNext()) {
                this.m_fileLogger.logMessage((String)pendingMessages.next());
            }
            this.m_pendingMessages = null;
        }
    }

    @Override
    public synchronized void logMessage(String message, Throwable exception, int severityLevel) {
        if (exception != null) {
            message = ContainerUtil.appendThrowableToMessage(message, exception);
        }
        this.logMessage(message, severityLevel);
    }

    @Override
    public synchronized void logMessage(String message, int severityLevel) {
        String timestampedMessage = ContainerUtil.createLogMessage(null, message, severityLevel);
        if (this.m_fileLogger == null) {
            this.m_pendingMessages.add(timestampedMessage);
        } else {
            this.m_fileLogger.logMessage(timestampedMessage);
        }
        m_stdout.println(timestampedMessage);
    }

    void close() {
        if (this.m_fileLogger != null) {
            try {
                this.m_fileLogger.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_fileLogger = null;
        }
    }
}

