/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.util.MFLogger;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.LocalFileManager;
import com.sonicsw.mf.framework.agent.LogicalFile;
import com.sonicsw.mf.framework.agent.cache.ConfigCacheFactory;
import com.sonicsw.mf.framework.agent.cache.IConfigCache;
import com.sonicsw.mf.framework.agent.cache.IConfigCacheView;
import com.sonicsw.mf.framework.agent.cache.LatestVersionMissingException;
import com.sonicsw.mf.framework.agent.cache.PersistentCacheException;
import com.sonicsw.mf.framework.agent.cache.impl.ConfigCache;
import com.sonicsw.mf.framework.agent.ci.CARClasspath;
import com.sonicsw.mf.framework.agent.ci.ConfigureFromCacheException;
import com.sonicsw.mf.framework.agent.ci.DSClasspath;
import com.sonicsw.mf.framework.agent.ci.LaunchConnector;
import com.sonicsw.mf.framework.agent.ci.LauncherInstallManager;
import com.sonicsw.mf.framework.agent.ci.PopulateCacheResources;
import com.sonicsw.mf.framework.agent.ci.SystemProperties;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;

public abstract class ContainerResources {
    static final String FILELOG_SUFFIX = ".log";
    static final String CONFIGURED_JVM_OPTIONS = "_MF_CONFIGURED_JVM_OPTIONS";
    static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String CONTAINER_WORKING_DIR = System.getProperty("user.dir");
    private static final String SONICSW_HOME = System.getProperty("sonicsw.home");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final int CONNECTION_PROP_PREFIX_LENGTH = "connection.".length();
    private static final int CENTRAL_CONNECTION_PROP_PREFIX_LENGTH = "CentralConnection.".length();
    private static final int SYSTEM_PROP_PREFIX_LENGTH = "SystemProperty.".length();
    private static final int REPLICATION_FAILURE_DETECTION_LAUNCH_MIN = 60;
    static final String XARG_BOOT = "-Xbootclasspath:";
    static final String XARG_BOOT_P = "-Xbootclasspath/p:";
    static final String XARG_BOOT_A = "-Xbootclasspath/a:";
    static final String sonicfsPrefix = "sonicfs:///".substring(0, "sonicfs:///".length() - 1);
    private static final String CENTRAL_CONNECTION_ATTR = "CENTRAL_CONNECTION";
    private boolean m_requestToConfigureFromCache;
    private String m_containerINIFileName;
    private LaunchConnector m_connector;
    private IDirectoryAdminService m_ds;
    private LocalFileManager m_localFileManager;
    private Hashtable m_connectionAttributes;
    private String m_logFilePath;
    private boolean m_nonDMContainerWhichConnectToRemoteDS = false;
    private boolean m_mfDirectoryJARMissing = false;
    private boolean m_dsBootFileMissing = false;
    private File m_mfDirectoryJAR;
    private boolean m_centralConnectionUsed = false;
    protected ILogger m_logger;
    protected String m_dsBootFileName;
    protected String m_dsArchivePath;
    protected String m_logicalArchivePath;
    private File m_archiveRoot;
    File m_actionalSDKArchive;
    File m_actionalPlugMakerArchive;
    Class m_localDirectoryServiceClass;
    Object m_localDirectoryService;
    String m_containerID;
    String m_containerName;
    String m_domainName;
    boolean m_useCachedConfig;
    ExtractedContainerConfig m_extractedConfig;
    ExtractedContainerConfig m_bootExtractedConfig;
    int m_traceMask;
    LocalDSParameters m_localDSParam;
    InitInfo m_initInfo;
    String m_cacheHostDirectoryName;
    IConfigCache m_configCache;
    IConfigCacheView m_configCacheView;
    SystemProperties m_systemProps;
    CARClasspath m_classpath;
    DSClasspath m_configClasspath;
    private MFLogger m_pseLogger;

    protected void init(String containerINIFileName) throws Exception {
        boolean INIIsXMLFile;
        if (IContainer.CURRENT_LAUNCHER_VERSION != null) {
            this.logMessage("Using launcher \"" + new File(new File(SONICSW_HOME), IContainer.LAUNCHER_DIR).getAbsolutePath() + "\"", 3);
        }
        System.setProperty("sonicsw.mf.containers_directory", ContainerSetup.findSonicContainersDir(new File(SONICSW_HOME)).getAbsolutePath());
        this.m_containerINIFileName = containerINIFileName;
        File containerINIFile = this.openINIFile(containerINIFileName);
        this.m_requestToConfigureFromCache = Boolean.getBoolean("sonicsw.mf.configureFromCache");
        if (!this.m_requestToConfigureFromCache) {
            File configureFromCacheFile = new File(containerINIFile.getParentFile(), "configure_from_cache");
            this.m_requestToConfigureFromCache = configureFromCacheFile.exists();
            configureFromCacheFile.delete();
        }
        if (this.m_requestToConfigureFromCache) {
            System.setProperty("sonicsw.mf.configureFromCache", "true");
        }
        RandomAccessFile raf = new RandomAccessFile(containerINIFile, "r");
        byte[] bytes = new byte[(int)raf.length()];
        raf.read(bytes);
        raf.close();
        if (IContainer.PASSWORD != null) {
            bytes = ContainerUtil.decryptBytes(bytes, IContainer.PASSWORD);
        }
        if (!(INIIsXMLFile = new String(bytes).startsWith("<?xml")) && !this.checkHomeIsWritable()) {
            throw new Exception("The container doesn't have write permission in \"" + SONICSW_HOME + "\"; Write permission is required for automatic upgrade of the launcher");
        }
        this.m_initInfo = null;
        this.m_initInfo = INIIsXMLFile ? new XmlINI(bytes) : new PropINI(bytes);
        this.m_extractedConfig = this.m_bootExtractedConfig = this.m_initInfo.m_config;
        if (this.m_extractedConfig.m_containerName == null) {
            throw new Exception("The format of \"" + containerINIFile.getAbsolutePath() + "\" is bad");
        }
        this.m_domainName = this.m_extractedConfig.m_domainName;
        this.m_traceMask = this.m_extractedConfig.m_deployTraceMask;
        this.m_containerName = ContainerResources.createContainerFullName(this.m_extractedConfig);
        if (this.m_extractedConfig.m_hostsDS.booleanValue()) {
            boolean launcherUsed;
            boolean bl = launcherUsed = IContainer.CURRENT_LAUNCHER_VERSION != null;
            if (!(launcherUsed || this.m_dsBootFileName != null && this.m_dsBootFileName.length() != 0)) {
                throw new Exception("Container \"" + this.m_containerName + "\" hosts the Directory Service but an XML Directory Service boot file was not passed.");
            }
            if (launcherUsed) {
                this.m_dsBootFileName = "ds.xml";
                if (!new File("ds.xml").exists()) {
                    this.m_dsBootFileMissing = true;
                    this.logMessage("\" " + this.m_containerName + "\" hosts the Directory Service but \"" + "ds.xml" + "\" is missing", 2);
                }
                File launcherDir = new File(SONICSW_HOME, IContainer.LAUNCHER_DIR);
                this.m_mfDirectoryJAR = new File(launcherDir, "lib/MFdirectory.jar");
                if (!this.m_mfDirectoryJAR.exists()) {
                    this.m_mfDirectoryJARMissing = true;
                    this.logMessage("\" " + this.m_containerName + "\" hosts the Directory Service but \"" + this.m_mfDirectoryJAR.getAbsolutePath() + "\" is missing", 2);
                }
                if (this.m_mfDirectoryJARMissing || this.m_dsBootFileMissing) {
                    this.logMessage("Trying to retrieve the missing Directory Service launch file(s) from the peer Directory Service...", 3);
                }
            }
        }
        this.m_localDirectoryService = null;
        this.m_localDSParam = null;
        if (this.m_dsBootFileName != null && this.m_extractedConfig.m_hostsDS.booleanValue() && !this.m_mfDirectoryJARMissing && !this.m_dsBootFileMissing) {
            this.m_localDSParam = new LocalDSParameters(this.m_dsBootFileName);
        }
        File logFile = this.m_extractedConfig.m_logFileName == null ? new File(new File(CONTAINER_WORKING_DIR), this.m_containerName + FILELOG_SUFFIX) : new File(ContainerResources.absoluteFromRelativeToWorkDir(CONTAINER_WORKING_DIR, this.m_extractedConfig.m_logFileName));
        this.m_logFilePath = logFile.getAbsolutePath();
        this.initLogger(this.m_logFilePath, this.m_containerName);
        this.logMessage("Fetching the resources of container \"" + this.m_containerName + '\"', 3);
        boolean doReset = this.detectCacheResetRequest(containerINIFile);
        if (doReset) {
            this.logMessage("Deleting the obsolete cache of container \"" + this.m_containerName + "\"", 3);
        }
        this.cleanupIfNeeded();
        this.createCache(new File(this.m_extractedConfig.m_cacheHostDirectoryName).getAbsolutePath(), this.m_extractedConfig.m_cachePassword, true, doReset);
    }

    private void cleanupIfNeeded() {
        File detectCleanupFile = new File("clean_restart_file");
        if (!detectCleanupFile.exists()) {
            return;
        }
        detectCleanupFile.delete();
        if (IContainer.CURRENT_LAUNCHER_VERSION == null) {
            return;
        }
        this.logMessage("Clean restart was requests. Starting Working Directory cleanup...", 3);
        File wd = new File(CONTAINER_WORKING_DIR);
        String[] wdList = wd.list();
        for (int i = 0; i < wdList.length; ++i) {
            if (wdList[i].endsWith(".sh") || wdList[i].endsWith(".bat") || wdList[i].endsWith(FILELOG_SUFFIX) || wdList[i].equals("container.ini")) continue;
            File fileToDelete = new File(wd, wdList[i]);
            LauncherInstallManager.deleteObsolete(fileToDelete);
            if (!fileToDelete.exists()) {
                this.logMessage("Deleted \"" + fileToDelete.getAbsolutePath() + "\"", 3);
                continue;
            }
            this.logMessage("Failed to delete \"" + fileToDelete.getAbsolutePath() + "\"", 2);
        }
        this.logMessage("...Cleanup is done", 3);
    }

    private boolean detectCacheResetRequest(File containerINIFile) {
        File detectCacheRestFile = new File(containerINIFile.getParentFile(), "reset_cache_file");
        if (detectCacheRestFile.exists()) {
            detectCacheRestFile.delete();
            return true;
        }
        return false;
    }

    public abstract void initLogger(String var1, String var2) throws Exception;

    private void getDSAccessContinuous(IAttributeSet configAttributes, Hashtable connParams) throws Exception {
        Exception priorException = null;
        boolean loggedMsg = false;
        while (true) {
            try {
                this.getRemoteDSAccess(configAttributes, connParams, !loggedMsg);
                if (priorException != null) {
                    this.logMessage("...retry successful", 3);
                }
                return;
            }
            catch (Exception e) {
                this.disconnectDS();
                if (ContainerUtil.isCausedByTimeout(e)) {
                    int traceMask;
                    int n = traceMask = this.m_connector == null ? 0 : this.m_connector.getTraceMask();
                    if ((traceMask & 0x20) > 0) {
                        if ((traceMask & 1) > 0) {
                            this.m_connector.logMessage("Timeout while communicating with the Directory Service, retrying...", e, 7);
                        } else {
                            this.m_connector.logMessage("Timeout while communicating with the Directory Service, retrying...", 7);
                        }
                    } else {
                        boolean log = false;
                        if (priorException == null) {
                            log = true;
                        } else if (!e.getClass().isInstance(priorException)) {
                            log = true;
                        } else if (priorException.getMessage() != null && !priorException.getMessage().equals(e.getMessage())) {
                            log = true;
                        } else if (e.getMessage() != null && !e.getMessage().equals(priorException.getMessage())) {
                            log = true;
                        }
                        if (log) {
                            this.logMessage("Timeout while communicating with the Directory Service, retrying...", 2);
                        }
                    }
                    priorException = e;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void getReplicatedDSAccessContinuous(IAttributeSet configAttributes, Hashtable connParams) throws Exception {
        String peerRole;
        boolean loggedAccessMsg = false;
        boolean loggedActiveMsg = false;
        String string = peerRole = this.m_localDSParam.m_isBackup ? "PRIMARY" : "BACKUP";
        while (true) {
            if (this.getReplicatedLocalDS()) {
                if (loggedAccessMsg) {
                    if (loggedActiveMsg) {
                        this.logMessage("Failed to access " + peerRole + "; Transitioning to \"Active\" state", 3);
                    }
                    this.logMessage("Gained access to the local active Directory Service", 3);
                }
                return;
            }
            if (!loggedActiveMsg) {
                this.logMessage("The " + peerRole + " Directory Service should be active; retrieving configuration from " + peerRole, 3);
                loggedActiveMsg = true;
            }
            try {
                this.getRemoteDSAccess(configAttributes, connParams, !loggedAccessMsg);
                if (loggedAccessMsg) {
                    this.logMessage("...retry successful", 3);
                }
                return;
            }
            catch (Exception e) {
                this.disconnectRemoteDS();
                if (ContainerUtil.isCausedByTimeout(e)) {
                    if (loggedAccessMsg) continue;
                    this.logMessage("Timeout while communicating with the Directory Service, retrying...", 2);
                    loggedAccessMsg = true;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private void getRemoteDSAccess(IAttributeSet configAttributes, Hashtable connParams, boolean logInfo) throws Exception {
        if (connParams != null) {
            this.m_connector = this.createConnector(connParams, true, logInfo);
        } else {
            IAttributeSet connectionAttrsSet = null;
            IAttributeSet centralConnectionAttrsSet = (IAttributeSet)configAttributes.getAttribute(CENTRAL_CONNECTION_ATTR);
            if (centralConnectionAttrsSet != null) {
                connectionAttrsSet = centralConnectionAttrsSet;
                if (!this.m_requestToConfigureFromCache) {
                    System.setProperty("sonicsw.mf.generateCacheFromConnection", "true");
                }
            } else {
                connectionAttrsSet = (IAttributeSet)configAttributes.getAttribute("CONNECTION");
            }
            this.m_connector = this.createConnector(new Hashtable(connectionAttrsSet.getAttributes()), false, logInfo);
        }
        this.createDSProxy(null, this.m_connector, this.m_extractedConfig.m_domainName);
    }

    protected void connectAndGetConfiguration() throws Exception {
        String contName;
        Exception configFromDSFailure = null;
        boolean recoverableFailure = false;
        try {
            if (this.m_localDSParam == null) {
                this.m_nonDMContainerWhichConnectToRemoteDS = true;
                recoverableFailure = true;
                if (this.m_requestToConfigureFromCache) {
                    throw new ConfigureFromCacheException();
                }
                if (this.m_configCacheView.getElement("/_MF_CONFIG_ID_ELEMENT") != null) {
                    this.getRemoteDSAccess(this.m_initInfo instanceof XmlINI ? this.m_initInfo.m_attributes : null, !(this.m_initInfo instanceof XmlINI) ? this.m_initInfo.m_properties : null, true);
                } else {
                    this.getDSAccessContinuous(this.m_initInfo instanceof XmlINI ? this.m_initInfo.m_attributes : null, !(this.m_initInfo instanceof XmlINI) ? this.m_initInfo.m_properties : null);
                }
            } else {
                this.m_pseLogger = new MFLogger(this.m_logger, "pse");
                if (this.m_localDSParam.m_isFaultTolerant.booleanValue()) {
                    this.createReplicatedDSProxy(this.m_localDSParam);
                    this.getReplicatedDSAccessContinuous(this.m_initInfo instanceof XmlINI ? this.m_initInfo.m_attributes : null, !(this.m_initInfo instanceof XmlINI) ? this.m_initInfo.m_properties : null);
                } else {
                    this.createDSProxy(this.m_localDSParam);
                }
            }
            recoverableFailure = true;
            if (this.m_initInfo instanceof XmlINI) {
                this.extractConfigFromDS(this.m_initInfo.m_containerConfID, null, null, false);
            } else {
                this.extractConfigFromDS(this.m_initInfo.m_config.m_containerPath, this.m_initInfo.m_config.m_activationDaemonPath, this.m_initInfo.m_config.m_hostManagerPath, true);
            }
        }
        catch (Error e) {
            this.m_extractedConfig = null;
            throw e;
        }
        catch (Exception e) {
            if (recoverableFailure) {
                configFromDSFailure = e;
                this.extractConfigFromCache();
                this.m_useCachedConfig = true;
                System.setProperty("sonicsw.mf.configureFromCache", "true");
                System.setProperty("sonicsw.mf.generateCacheFromConnection", "false");
            }
            this.m_extractedConfig = null;
            throw e;
        }
        String string = contName = this.m_initInfo instanceof XmlINI ? this.m_containerID : this.m_initInfo.m_config.m_containerPath;
        if (this.m_extractedConfig == null) {
            if (configFromDSFailure == null) {
                throw new Exception("Container configuration " + contName + " was not found in the Directory Service.");
            }
            throw configFromDSFailure;
        }
        this.m_traceMask |= this.m_extractedConfig.m_deployTraceMask.intValue();
        if (this.m_extractedConfig.m_archiveSearchPath == null) {
            throw new Exception("The archive search path is missing.");
        }
        this.storeConfiguredArchivesInCache(this.m_extractedConfig.m_archiveSearchPath);
        if (configFromDSFailure != null) {
            throw configFromDSFailure;
        }
    }

    private File openINIFile(String containerINIFileName) throws Exception {
        File containerINIFile = new File(containerINIFileName);
        if (!(containerINIFile.exists() && containerINIFile.isFile() && containerINIFile.canRead())) {
            String problem = !containerINIFile.exists() ? " not found." : " cannot be read";
            String errMessage = "File " + containerINIFileName + problem;
            this.logMessage(errMessage, 1);
            throw new Exception(errMessage);
        }
        this.logMessage("Open container initialization file \"" + ContainerResources.getCanonicalPath(containerINIFile) + '\"', 3);
        return containerINIFile;
    }

    protected void init(ILogger logger, String domainName, String containerName, String containerID, String containerWorkDirDirectoryName, String cacheHostDirectoryName, String cachePassword, boolean persistentCache) throws Exception {
        this.m_requestToConfigureFromCache = false;
        this.m_logger = logger;
        this.m_domainName = domainName;
        this.m_containerID = containerID;
        this.m_containerName = ContainerResources.createContainerFullName(this.m_domainName, containerName);
        this.createCache(ContainerResources.absoluteFromRelativeToWorkDir(containerWorkDirDirectoryName, cacheHostDirectoryName), cachePassword, persistentCache, false);
    }

    String getNativeLibDirectory() throws Exception {
        return this.m_configCache.getNativeLibDirectory().getAbsolutePath();
    }

    void getConfiguration(IRemoteMBeanServer connector, IDirectoryAdminService ds) throws Exception {
        this.logMessage("Fetching the resources of container \"" + this.m_containerName + "\"...", 3);
        Exception configFromDSFailure = null;
        try {
            this.createDSProxy(ds, connector, this.m_domainName);
            this.extractConfigFromDS(this.m_containerID, null, null, false);
        }
        catch (Exception e) {
            configFromDSFailure = e;
            this.extractConfigFromCache();
        }
        if (this.m_extractedConfig == null) {
            if (configFromDSFailure == null) {
                throw new Exception("Container configuration " + this.m_containerID + " was not found in the Directory Service");
            }
            throw configFromDSFailure;
        }
        this.m_traceMask = this.m_extractedConfig.m_deployTraceMask;
        if (this.m_extractedConfig.m_archiveSearchPath == null) {
            throw new Exception("The archive search path is missing.");
        }
        this.storeConfiguredArchivesInCache(this.m_extractedConfig.m_archiveSearchPath);
        if (configFromDSFailure != null) {
            throw configFromDSFailure;
        }
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    protected String getContainerName() {
        return this.m_containerName;
    }

    public String getDomainName() {
        return this.m_domainName;
    }

    protected File getArchiveRoot() {
        return this.m_archiveRoot;
    }

    protected File getMFDirectory() {
        return this.m_mfDirectoryJAR;
    }

    protected boolean mfDirectoryJARMissing() {
        return this.m_mfDirectoryJARMissing;
    }

    protected boolean mfDSLaunchFilesMissing() {
        return this.m_mfDirectoryJARMissing || this.m_dsBootFileMissing;
    }

    protected String getWorkingDir() {
        return CONTAINER_WORKING_DIR;
    }

    protected ExtractedContainerConfig getExtractedConfig() {
        return this.m_extractedConfig;
    }

    protected boolean useCachedConfig() {
        return this.m_useCachedConfig;
    }

    protected String getLogicalArchivePath() {
        return this.m_logicalArchivePath;
    }

    protected String getJVMHome() throws Exception {
        if (this.m_extractedConfig.m_jvmHome != null) {
            LogicalFile jvmHome = this.m_localFileManager.localFileFromLocation(null, this.m_extractedConfig.m_jvmHome, false, null);
            return jvmHome.getFileName();
        }
        return null;
    }

    protected String getLogFilePath() {
        return this.m_logFilePath;
    }

    protected SystemProperties getSystemProps() {
        return this.m_systemProps;
    }

    protected CARClasspath getClasspath() {
        return this.m_classpath;
    }

    protected void mergePlatformDependentArgs(HashMap platformArgs) {
        platformArgs.putAll(this.m_extractedConfig.m_jvmArgs);
        this.m_extractedConfig.m_jvmArgs = platformArgs;
    }

    private void copyXSDToWorkingDir(String xsdFileName, String workingDir) throws Exception {
        File outFile = new File(workingDir, xsdFileName);
        if (outFile.exists()) {
            return;
        }
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile));
        File srcFile = new File(xsdFileName);
        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(srcFile));
        int readIn = 0;
        while ((readIn = inStream.read()) != -1) {
            outStream.write(readIn);
        }
        outStream.close();
    }

    private boolean checkHomeIsWritable() {
        try {
            File testFile = new File(SONICSW_HOME, "_test_can_write_to_fs");
            new FileOutputStream(testFile).close();
            testFile.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void deployResources() throws Exception {
        String[] combinedList = this.mergeClasspathLists(this.m_systemProps.getSonicfsResources(), this.m_configClasspath.getSonicfsResources());
        new PopulateCacheResources(this.m_ds, this.m_configCache, combinedList, this.m_logger).updateCache();
    }

    protected void mergePlatformProps(HashMap platformPropsMap, boolean dsAccessible) throws Exception {
        SystemProperties platformProps = new SystemProperties(platformPropsMap, this.m_logger, true);
        String[] sonicfsResources = platformProps.getSonicfsResources();
        if (dsAccessible && sonicfsResources.length > 0) {
            try {
                this.logMessage("Fetching platform dependent resources of container \"" + this.m_containerName + "\".", 3);
                new PopulateCacheResources(this.m_ds, this.m_configCache, sonicfsResources, this.m_logger).updateCache();
            }
            catch (Throwable t) {
                this.logMessage("Resource refreshment failed - caused by:", 2);
                this.logMessage("", t, 2);
            }
        }
        platformProps.substituteSonicfsResources(this.getLocalFiles(platformProps.getSonicfsResources()));
        this.m_systemProps.mergePlatformDependentProps(platformProps.getProperties());
    }

    private void disconnectDS() {
        block3: {
            try {
                this.disconnectRemoteDS();
                if (this.m_localDirectoryService != null) {
                    Method closeMethod = this.m_localDirectoryServiceClass.getMethod("close", new Class[0]);
                    closeMethod.invoke(this.m_localDirectoryService, new Object[0]);
                }
            }
            catch (Throwable t) {
                if ((this.m_traceMask & 0x1000) == 0) break block3;
                this.logMessage("Unsuccessful disconnect of local Directory Service after updating the cache of container " + this.m_extractedConfig.m_containerName + " ID: " + this.m_containerID, this.getTargetException(t), 7);
            }
        }
    }

    private void disconnectRemoteDS() {
        try {
            if (this.m_connector != null) {
                this.m_connector.disconnect();
            }
        }
        catch (Exception e) {
            this.logMessage("Unsuccessful disconnect after updating the cache of container " + this.m_extractedConfig.m_containerName + " ID: " + this.m_containerID, this.getTargetException(e), 3);
        }
    }

    private Throwable getTargetException(Throwable e) {
        if (!(e instanceof InvocationTargetException)) {
            return e;
        }
        Throwable targetException = ((InvocationTargetException)e).getTargetException();
        if (targetException == null) {
            targetException = e;
        }
        if (targetException instanceof Exception) {
            return (Exception)targetException;
        }
        return new Exception(targetException.toString());
    }

    private void createClasspathLists() throws Exception {
        this.m_systemProps = new SystemProperties(this.m_extractedConfig.m_systemProps, this.m_logger, false);
        this.m_configClasspath = new DSClasspath(this.m_extractedConfig.m_configClasspath, this.m_logger);
    }

    protected void releaseResources() {
        this.closeCache();
        this.disconnectDS();
    }

    private void closeCache() {
        try {
            if (this.m_configCache != null) {
                this.m_configCache.close();
            }
            this.m_configCache = null;
        }
        catch (PersistentCacheException e) {
            this.logMessage("Failed to close the cache, caused by: ", e, 2);
        }
    }

    private static String absoluteFromRelativeToWorkDir(String containerWorkingDirName, String dirName) {
        if (containerWorkingDirName == null || dirName == null || new File(dirName).isAbsolute()) {
            return dirName;
        }
        return ContainerResources.getCanonicalPath(new File(containerWorkingDirName, dirName));
    }

    static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    static String getCanonicalPath(String fileName) {
        return ContainerResources.getCanonicalPath(new File(fileName));
    }

    private void createCache(String cacheHostDirectoryName, String cachePassword, boolean persistentCache, boolean reset) throws Exception {
        this.m_cacheHostDirectoryName = cacheHostDirectoryName;
        ConfigCache.cleanupCorruptCache(cacheHostDirectoryName, this.m_logger);
        String cacheName = ContainerResources.getCanonicalPath(new File(cacheHostDirectoryName));
        this.logMessage("Cache opened in directory \"" + cacheName + '\"', 3);
        this.m_configCache = reset ? ConfigCacheFactory.createNewCache(cacheHostDirectoryName, cachePassword) : ConfigCacheFactory.createCache(cacheHostDirectoryName, cachePassword);
        this.m_configCacheView = this.m_configCache.getCacheView();
    }

    private void storeConfiguredArchivesInCache(String searchPath) throws Exception {
        if (this.m_extractedConfig == null) {
            return;
        }
        if (this.m_extractedConfig.m_archiveName == null || this.m_extractedConfig.m_archiveName.length() == 0) {
            this.m_extractedConfig = null;
            throw new Exception("The ARCHIVE_NAME attribute is missing from the container's configuration.");
        }
        if (this.m_extractedConfig.m_actionalSDKArchiveName == null || this.m_extractedConfig.m_actionalSDKArchiveName.length() == 0) {
            this.m_extractedConfig = null;
            throw new Exception("The ACTIONAL_SDK_ARCHIVE_NAME attribute is missing from the container's configuration.");
        }
        this.m_localFileManager = new LocalFileManager(this.m_ds, this.m_configCache, this.m_logger, this.m_containerID);
        this.m_localFileManager.setTraceMask(this.m_traceMask);
        String[] tmp = new String[]{null};
        this.m_archiveRoot = this.m_localFileManager.getLocalFile(searchPath, this.m_extractedConfig.m_archiveName, tmp);
        if (this.m_archiveRoot == null) {
            throw new Exception("Could not find \"" + this.m_extractedConfig.m_archiveName + "\" using search path \"" + searchPath + "\"");
        }
        this.m_dsArchivePath = tmp[0];
        this.m_logicalArchivePath = this.m_extractedConfig.m_archiveName;
        if (!this.m_logicalArchivePath.startsWith("/")) {
            this.m_logicalArchivePath = "/" + this.m_logicalArchivePath;
        }
        this.m_actionalSDKArchive = this.m_localFileManager.getLocalFile(searchPath, this.m_extractedConfig.m_actionalSDKArchiveName, new String[1]);
        if (this.m_actionalSDKArchive == null) {
            String actionalSDKArchiveName = this.m_extractedConfig.m_actionalSDKArchiveName;
            this.m_extractedConfig = null;
            throw new Exception(actionalSDKArchiveName + " could not be found on the container's archive search path");
        }
        if (this.m_extractedConfig.m_actionalPlugMakerArchiveName != null && this.m_extractedConfig.m_actionalPlugMakerArchiveName.length() > 0) {
            this.m_actionalPlugMakerArchive = this.m_localFileManager.getLocalFile(searchPath, this.m_extractedConfig.m_actionalPlugMakerArchiveName, new String[1]);
        }
    }

    private void extractConfigFromDS(String containerID, String activationDaemonPath, String hostManagerPath, boolean logicalPath) throws Exception {
        this.m_extractedConfig = this.getContainerConfigurationFromDS(containerID, activationDaemonPath, hostManagerPath, logicalPath);
        if (this.m_extractedConfig != null) {
            this.createClasspathLists();
        }
    }

    private void extractConfigFromCache() throws Exception {
        this.m_extractedConfig = this.getContainerConfigurationFromCache();
        if (this.m_extractedConfig != null) {
            this.createClasspathLists();
        }
    }

    private ExtractedContainerConfig getContainerConfigurationFromCache() throws Exception {
        IElement configIDElement = this.m_configCacheView.getElement("/_MF_CONFIG_ID_ELEMENT");
        if (configIDElement == null) {
            return null;
        }
        IAttributeSet attributes = configIDElement.getAttributes();
        this.m_containerID = (String)attributes.getAttribute("_MF_CONFIG_ID");
        IElement containerConfig = this.m_configCacheView.getElement(this.m_containerID);
        if (containerConfig == null) {
            return null;
        }
        this.m_useCachedConfig = true;
        return this.extractConfigInfo(containerConfig.getAttributes());
    }

    private ExtractedContainerConfig getContainerConfigurationFromDS(String containerPathOrID, String activationDaemonPath, String hostManagerPath, boolean logicalPath) throws Exception {
        if (logicalPath || (this.m_traceMask & 0x1000) != 0) {
            this.logMessage("Getting the container configuration \"" + containerPathOrID + "\" from the Directory Service", 3);
        }
        IElement containerConfig = null;
        if (logicalPath) {
            boolean cannotCreateNewConfig;
            IElement[] elements = this.retryGetElementsByLogicalNames(new String[]{containerPathOrID});
            containerConfig = elements.length > 0 ? elements[0] : null;
            boolean bl = cannotCreateNewConfig = this.m_extractedConfig.m_createIfDoesNotExist == false;
            if (containerConfig == null) {
                if (cannotCreateNewConfig) {
                    throw new Exception("Could not find the configuration of container \"" + containerPathOrID + "\" and there is no CREATE_IF_DOES_NOT_EXIST=true setup in file \"" + this.m_containerINIFileName + "\" to allow automatic creation.");
                }
                if (this.m_extractedConfig.m_hostsDS.booleanValue()) {
                    throw new Exception("Could not find the configuration of container \"" + containerPathOrID + "\" - cannot create a container that hosts the Directory Service.");
                }
                IElement[] contConfigurations = ((DirectoryServiceProxy)this.m_ds).getCreateContainerConfiguration(containerPathOrID, activationDaemonPath, hostManagerPath, this.createDefaultContainerParameters(this.m_extractedConfig), this.m_connectionAttributes);
                containerConfig = contConfigurations[0];
            }
            if (this.m_dsBootFileMissing) {
                this.getBootDSXML(containerConfig);
            }
            this.m_containerID = containerConfig.getIdentity().getName();
            if (elements.length == 0 || elements[0] == null) {
                this.logMessage("Created a new empty container \"" + containerPathOrID + "\" configuration ID \"" + this.m_containerID + '\"', 3);
            }
        } else {
            Long tmp = this.m_configCacheView.getDSBackupVersion();
            long cacheBackupVersion = tmp == null ? 0L : tmp;
            IDirElement[] retArray = this.retryGetElementIfUpdated(cacheBackupVersion, containerPathOrID, (containerConfig = this.m_configCacheView.getElement(containerPathOrID)) != null ? containerConfig.getIdentity() : null);
            if (retArray != null) {
                containerConfig = retArray[0];
            }
            if (containerConfig == null) {
                throw new Exception("Could not find the configuration of container \"" + containerPathOrID + "\".");
            }
            this.m_containerID = containerPathOrID;
        }
        IDirElement dsConfig = null;
        if (this.m_localDSParam != null) {
            if ((this.m_traceMask & 0x1000) != 0) {
                this.logMessage("Getting the Directory Service configuration \"" + this.m_localDSParam.m_configID + "\" from the Directory Service", 7);
            }
            dsConfig = this.m_ds.getElement(this.m_localDSParam.m_configID, false);
        }
        this.cacheConfiguration(containerConfig, dsConfig);
        this.m_useCachedConfig = false;
        return this.extractConfigInfo(containerConfig.getAttributes());
    }

    private void getBootDSXML(IElement containerConfig) throws Exception {
        String dsElementName = ContainerUtil.extractDSConfigIDFromContainerConfig(containerConfig);
        if (dsElementName == null) {
            throw new Exception("The \" HOST_DIRECTORY_ATTRIBUTE\" attribute is configured in \"" + this.m_containerName + "\" but Directory Service component was not found");
        }
        String dsBootContent = this.m_ds.exportDSBootFileString(dsElementName);
        ContainerUtil.encryptAndStore(dsBootContent, "ds.xml", IContainer.PASSWORD);
        this.logMessage("...Retrieved the missing information and generated the ds.xml file", 3);
    }

    private IDirElement[] retryGetElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id) throws Exception {
        try {
            return this.m_ds.getElementIfUpdated(callerBackupVersion, elementName, id);
        }
        catch (Exception e) {
            if (ContainerUtil.isCausedByTimeout(e) && this.m_nonDMContainerWhichConnectToRemoteDS) {
                if (this.m_configCacheView.getElement("/_MF_CONFIG_ID_ELEMENT") != null) {
                    throw e;
                }
                return ((DirectoryServiceProxy)this.m_ds).retryGetElementIfUpdated(callerBackupVersion, elementName, id);
            }
            throw e;
        }
    }

    private IElement[] retryGetElementsByLogicalNames(String[] containerPathOrID) throws Exception {
        try {
            return this.m_ds.getElementsByLogicalNames(containerPathOrID);
        }
        catch (Exception e) {
            if (ContainerUtil.isCausedByTimeout(e) && this.m_nonDMContainerWhichConnectToRemoteDS) {
                if (this.m_configCacheView.getElement("/_MF_CONFIG_ID_ELEMENT") != null) {
                    throw e;
                }
                return ((DirectoryServiceProxy)this.m_ds).retryGetElementsByLogicalNames(containerPathOrID);
            }
            throw e;
        }
    }

    private void cacheConfiguration(IElement containerConfig, IElement dsConfig) throws Exception {
        this.m_configCache.setElement(containerConfig);
        if (dsConfig != null) {
            boolean isDSFT = false;
            boolean isBackup = false;
            this.m_configCache.setElement(dsConfig);
            IAttributeSet dsTopSet = dsConfig.getAttributes();
            IAttributeSet refs = (IAttributeSet)dsTopSet.getAttribute("CONFIG_ELEMENT_REFERENCES");
            if (refs != null) {
                Reference primaryRef;
                Reference connectionsRef = (Reference)refs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
                if (connectionsRef != null) {
                    isDSFT = true;
                    isBackup = false;
                    IDirElement connectionsEl = this.m_ds.getElement(connectionsRef.getElementName(), false);
                    this.m_configCache.setElement(connectionsEl);
                }
                if ((primaryRef = (Reference)refs.getAttribute("PRIMARY_CONFIG_ELEMENT_REF")) != null) {
                    Reference primaryConnectionsRef;
                    isDSFT = true;
                    isBackup = true;
                    IDirElement primaryDS = this.m_ds.getElement(primaryRef.getElementName(), false);
                    this.m_configCache.setElement(primaryDS);
                    IAttributeSet primaryAttrs = primaryDS.getAttributes();
                    IAttributeSet primaryRefs = (IAttributeSet)primaryAttrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
                    if (primaryRefs != null && (primaryConnectionsRef = (Reference)primaryRefs.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
                        IDirElement primaryConnectionsEl = this.m_ds.getElement(primaryConnectionsRef.getElementName(), false);
                        this.m_configCache.setElement(primaryConnectionsEl);
                    }
                }
            }
            if (this.m_localDSParam.m_isFaultTolerant != isDSFT || isDSFT && this.m_localDSParam.m_isBackup != isBackup) {
                String errorString = "The Directory Service boot file doesn't match the Directory Service configuration. ";
                errorString = errorString + ContainerResources.getFTMismatchString("Boot file:", this.m_localDSParam.m_isFaultTolerant, this.m_localDSParam.m_isBackup) + ContainerResources.getFTMismatchString(" Configuration:", isDSFT, isBackup);
                throw new Error(errorString);
            }
        }
        IDirElement configIDElement = ElementFactory.createElement("/_MF_CONFIG_ID_ELEMENT", "_MF_CI_CONFIG_ID_TYPE", "107");
        IAttributeSet attributes = configIDElement.getAttributes();
        attributes.setStringAttribute("_MF_CONFIG_ID", this.m_containerID);
        this.m_configCache.deleteElement("/_MF_CONFIG_ID_ELEMENT");
        this.m_configCache.setElement(configIDElement.doneUpdate());
    }

    private static String getFTMismatchString(String label, boolean ft, boolean isBackup) {
        return label + (ft ? "Fault Tolerant" : "Non Fault Tolerant") + (ft ? (isBackup ? " Role BACKUP. " : " Role PRIMARY. ") : ".");
    }

    private void createDSProxy(IDirectoryAdminService ds, IRemoteMBeanServer connector, String domainName) throws Exception {
        block2: {
            this.m_ds = ds != null ? ds : new DirectoryServiceProxy(connector, new ObjectName(domainName + "." + "DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
            try {
                this.m_ds.getDirectoryServiceVersion();
            }
            catch (Exception e) {
                if (ContainerUtil.isCausedByTimeout(e) && this.m_nonDMContainerWhichConnectToRemoteDS) break block2;
                throw e;
            }
        }
    }

    private void createDSProxy(LocalDSParameters dsParam) throws Exception {
        this.m_localDirectoryServiceClass = Class.forName("com.sonicsw.mf.framework.agent.ci.LocalDirectoryService");
        this.m_localDirectoryService = this.m_localDirectoryServiceClass.newInstance();
        Hashtable<String, Object> directoryEnv = new Hashtable<String, Object>();
        directoryEnv.put("_TRACE_MASK", new Integer(this.m_traceMask));
        if (dsParam.m_hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", dsParam.m_hostDir);
        }
        if (dsParam.m_encryptionPassword != null && dsParam.m_encryptionPassword.length() != 0) {
            directoryEnv.put("PASSWORD", dsParam.m_encryptionPassword);
        }
        try {
            Method getDSMethod = this.m_localDirectoryServiceClass.getMethod("getDS", ILogger.class, String.class, Hashtable.class);
            this.m_ds = (IDirectoryAdminService)getDSMethod.invoke(this.m_localDirectoryService, this.m_logger, dsParam.m_domainName, directoryEnv);
        }
        catch (Exception e) {
            Throwable t = this.getTargetException(e);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception("getDS failed with: " + t.toString());
        }
    }

    private void createReplicatedDSProxy(LocalDSParameters dsParam) throws Exception {
        this.m_localDirectoryServiceClass = Class.forName("com.sonicsw.mf.framework.agent.ci.LocalDirectoryService");
        this.m_localDirectoryService = this.m_localDirectoryServiceClass.newInstance();
        Hashtable<String, Object> directoryEnv = new Hashtable<String, Object>();
        directoryEnv.put("_TRACE_MASK", new Integer(this.m_traceMask));
        if (dsParam.m_hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", dsParam.m_hostDir);
        }
        if (dsParam.m_encryptionPassword != null && dsParam.m_encryptionPassword.length() != 0) {
            directoryEnv.put("PASSWORD", dsParam.m_encryptionPassword);
        }
        directoryEnv.put("RETRY_INTERVAL", dsParam.m_replicationRetryInterval);
        directoryEnv.put("PING_INTERVAL", dsParam.m_replicationPingInterval);
        directoryEnv.put("FAILURE_DETECTION_TIMEOUT", dsParam.m_replicationFailureDetectionTimeout);
        directoryEnv.put("MAX_REPLICATION_LOG_SIZE", dsParam.m_maxReplicationLogSize);
        directoryEnv.put("REPLICATION_TIMEOUT", dsParam.m_replicationTimeout);
        directoryEnv.put("DUAL_ACTIVE_RESOLUTION", dsParam.m_dualActiveResolution);
        directoryEnv.put("REPLICATION_CONNECTIONS", dsParam.m_replConnections);
        if (dsParam.m_replSSLParams != null) {
            directoryEnv.put("SSL_PARAMETERS", dsParam.m_replSSLParams);
        }
        try {
            Method openStorageMethod = this.m_localDirectoryServiceClass.getMethod("openReplicatedStorage", ILogger.class, String.class, Hashtable.class, Boolean.class, Boolean.class);
            openStorageMethod.invoke(this.m_localDirectoryService, this.m_logger, dsParam.m_domainName, directoryEnv, dsParam.m_isBackup ? Boolean.FALSE : Boolean.TRUE, dsParam.m_startActive);
        }
        catch (Throwable e) {
            Throwable t = this.getTargetException(e);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception("openReplicatedStorage failed with: " + t.toString());
        }
    }

    private boolean getReplicatedLocalDS() throws Exception {
        try {
            Method getReplicatedDSMethod = this.m_localDirectoryServiceClass.getMethod("getReplicatedDS", EMPTY_CLASS_ARRAY);
            this.m_ds = (IDirectoryAdminService)getReplicatedDSMethod.invoke(this.m_localDirectoryService, EMPTY_OBJECT_ARRAY);
            return this.m_ds != null;
        }
        catch (Throwable e) {
            Throwable t = this.getTargetException(e);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception("getreplicatedDS failed with: " + t.toString());
        }
    }

    private ExtractedContainerConfig extractConfigInfo(IAttributeSet containerAttrs) throws Exception {
        IAttributeSet systemProps;
        Object tmp;
        IAttributeSet cacheAttrs;
        ExtractedContainerConfig containerConfig = new ExtractedContainerConfig();
        containerConfig.m_logFileName = (String)containerAttrs.getAttribute("LOG_FILE");
        containerConfig.m_domainName = (String)containerAttrs.getAttribute("DOMAIN_NAME");
        if (containerConfig.m_domainName == null) {
            containerConfig.m_domainName = "Domain1";
        }
        containerConfig.m_hostsDS = (Boolean)containerAttrs.getAttribute("HOSTS_DIRECTORY_SERVICE");
        if (containerConfig.m_hostsDS == null) {
            containerConfig.m_hostsDS = new Boolean(false);
        }
        containerConfig.m_containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        containerConfig.m_actionalSDKArchiveName = (String)containerAttrs.getAttribute("ACTIONAL_SDK_ARCHIVE_NAME");
        containerConfig.m_actionalPlugMakerArchiveName = (String)containerAttrs.getAttribute("ACTIONAL_PLUGMAKER_ARCHIVE_NAME");
        containerConfig.m_configClasspath = (String)containerAttrs.getAttribute("CLASSPATH");
        containerConfig.m_archiveSearchPath = (String)containerAttrs.getAttribute("ARCHIVE_SEARCH_PATH");
        containerConfig.m_jvmHome = (String)containerAttrs.getAttribute("JVM_HOME");
        containerConfig.m_archiveName = (String)containerAttrs.getAttribute("ARCHIVE_NAME");
        containerConfig.m_configNativePath = (String)containerAttrs.getAttribute("CONTAINER_NATIVE_LIBRARY_PATH");
        containerConfig.m_deployTraceMask = (Integer)containerAttrs.getAttribute("TRACE_MASK");
        if (containerConfig.m_deployTraceMask == null) {
            containerConfig.m_deployTraceMask = new Integer(0);
        }
        if ((cacheAttrs = (IAttributeSet)containerAttrs.getAttribute("CACHE")) != null) {
            containerConfig.m_cacheHostDirectoryName = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY");
        }
        if (containerConfig.m_cacheHostDirectoryName == null || containerConfig.m_cacheHostDirectoryName.length() == 0 || containerConfig.m_cacheHostDirectoryName.equals(".")) {
            containerConfig.m_cacheHostDirectoryName = "./container.cache";
        }
        if (cacheAttrs != null) {
            containerConfig.m_cachePassword = (String)cacheAttrs.getAttribute("PASSWORD");
        }
        if ((tmp = containerAttrs.getAttribute("JVM_ARGUMENTS")) == null || tmp instanceof String) {
            containerConfig.m_jvmArgs = new HashMap();
            if (tmp != null) {
                containerConfig.m_jvmArgs.put(CONFIGURED_JVM_OPTIONS, tmp);
            }
        } else if (tmp instanceof IAttributeSet) {
            containerConfig.m_jvmArgs = ((IAttributeSet)tmp).getAttributes();
        }
        if ((systemProps = (IAttributeSet)containerAttrs.getAttribute("SYSTEM_PROPERTIES")) != null) {
            HashMap map = systemProps.getAttributes();
            SystemProperties.connectionPropertiesFilter(map, this.m_centralConnectionUsed);
            containerConfig.m_systemProps = map;
        } else {
            containerConfig.m_systemProps = new HashMap();
        }
        return containerConfig;
    }

    private Hashtable createDefaultContainerParameters(ExtractedContainerConfig containerConfig) {
        Hashtable<String, String> containerParams = new Hashtable<String, String>();
        containerParams.put("DOMAIN_NAME", containerConfig.m_domainName);
        containerParams.put("CONTAINER_NAME", containerConfig.m_containerName);
        if (containerConfig.m_logFileName != null) {
            containerParams.put("LOG_FILE", containerConfig.m_logFileName);
        }
        containerParams.put("CACHE_DIRECTORY", containerConfig.m_cacheHostDirectoryName);
        if (containerConfig.m_cachePassword != null) {
            containerParams.put("CACHE_PASSWORD", containerConfig.m_cachePassword);
        }
        return containerParams;
    }

    private ExtractedContainerConfig extractINIInfo(Properties containerAttrs) throws Exception {
        String stValue;
        ExtractedContainerConfig containerConfig = new ExtractedContainerConfig();
        containerConfig.m_logFileName = (String)containerAttrs.get("LOG_FILE");
        containerConfig.m_domainName = (String)containerAttrs.get("DOMAIN_NAME");
        if (containerConfig.m_domainName == null) {
            containerConfig.m_domainName = "Domain1";
        }
        containerConfig.m_hostsDS = new Boolean((String)containerAttrs.get("HOSTS_DIRECTORY_SERVICE"));
        if (containerConfig.m_hostsDS == null) {
            containerConfig.m_hostsDS = new Boolean(false);
        }
        containerConfig.m_containerPath = (String)containerAttrs.get("CONTAINER_PATH");
        if (containerConfig.m_containerPath != null) {
            EntityName pathE = new EntityName(containerConfig.m_containerPath);
            containerConfig.m_containerName = pathE.getBaseName();
        }
        containerConfig.m_activationDaemonPath = (String)containerAttrs.get("ACTIVATION_DAEMON_PATH");
        containerConfig.m_hostManagerPath = (String)containerAttrs.get("HOST_MANAGER_PATH");
        String maskString = (String)containerAttrs.get("TRACE_MASK");
        containerConfig.m_deployTraceMask = maskString != null ? new Integer(maskString) : new Integer(0);
        containerConfig.m_cacheHostDirectoryName = (String)containerAttrs.get("CACHE_DIRECTORY");
        if (containerConfig.m_cacheHostDirectoryName == null || containerConfig.m_cacheHostDirectoryName.length() == 0 || containerConfig.m_cacheHostDirectoryName.equals(".")) {
            containerConfig.m_cacheHostDirectoryName = "./container.cache";
        }
        if ((stValue = (String)containerAttrs.get("CREATE_IF_DOES_NOT_EXIST")) == null) {
            stValue = "false";
        }
        containerConfig.m_createIfDoesNotExist = new Boolean(stValue);
        containerConfig.m_cachePassword = (String)containerAttrs.get("CACHE_PASSWORD");
        return containerConfig;
    }

    private Hashtable filterINIPrefixes(Hashtable table, boolean fromINI) throws Exception {
        String connectionPrefix = "connection.";
        int connectionPrefixLength = CONNECTION_PROP_PREFIX_LENGTH;
        if (fromINI) {
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.regionMatches(true, 0, "CentralConnection.", 0, CENTRAL_CONNECTION_PROP_PREFIX_LENGTH)) continue;
                connectionPrefix = "CentralConnection.";
                connectionPrefixLength = CENTRAL_CONNECTION_PROP_PREFIX_LENGTH;
                if (this.m_requestToConfigureFromCache) break;
                System.setProperty("sonicsw.mf.generateCacheFromConnection", "true");
                break;
            }
        }
        Hashtable<String, Object> connectionFactoryAttributes = new Hashtable<String, Object>();
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (fromINI && key.regionMatches(true, 0, connectionPrefix, 0, connectionPrefixLength)) {
                String stringValue = (String)table.get(key);
                String keyName = key.substring(connectionPrefixLength);
                Object value = stringValue;
                if (keyName.equals("REQUEST_TIMEOUT") || keyName.equals("CONNECT_TIMEOUT") || keyName.equals("SOCKET_CONNECT_TIMEOUT")) {
                    value = new Integer(stringValue);
                }
                connectionFactoryAttributes.put(keyName, value);
                continue;
            }
            if (fromINI) continue;
            connectionFactoryAttributes.put(key, table.get(key));
        }
        return connectionFactoryAttributes;
    }

    private LaunchConnector createConnector(Hashtable connectionAttrs0, boolean fromINI, boolean logInfo) throws Exception {
        Integer socketConnectTimeout;
        Integer connectTimeout;
        Hashtable connectionFactoryEnv = this.filterINIPrefixes(connectionAttrs0, fromINI);
        boolean validateNodeName = this.substituteGenerateCacheConnectionAttrs(connectionFactoryEnv);
        if (connectionFactoryEnv.get("ConnectionURLs") == null) {
            connectionFactoryEnv.put("ConnectionURLs", "tcp://localhost:2506");
        }
        this.m_connectionAttributes = (Hashtable)connectionFactoryEnv.clone();
        connectionFactoryEnv.remove("MANAGEMENT_NODE");
        connectionFactoryEnv.remove("REQUEST_TIMEOUT");
        connectionFactoryEnv.remove("CONNECT_TIMEOUT");
        connectionFactoryEnv.remove("SOCKET_CONNECT_TIMEOUT");
        connectionFactoryEnv.remove("LoadBalancing");
        connectionFactoryEnv.remove("TRY_DS_AM_BACKUPS_ON_FAILURE");
        JMSConnectorAddress address = new JMSConnectorAddress(connectionFactoryEnv);
        String managementNode = (String)this.m_connectionAttributes.get("MANAGEMENT_NODE");
        if (managementNode != null && managementNode.length() > 0) {
            address.setManagementNode(managementNode);
        }
        CanonicalName canonicalName = new CanonicalName(this.m_containerName);
        ContainerIdentity identity = new ContainerIdentity(canonicalName, null);
        LaunchConnector connector = new LaunchConnector(identity, this.m_logger);
        connector.setTraceMask(this.m_traceMask);
        Integer requestTimeout = (Integer)this.m_connectionAttributes.get("REQUEST_TIMEOUT");
        if (requestTimeout != null) {
            connector.setRequestTimeout(requestTimeout * 1000);
        }
        if ((connectTimeout = (Integer)this.m_connectionAttributes.get("CONNECT_TIMEOUT")) != null) {
            connector.setConnectTimeout(connectTimeout * 1000);
        }
        if ((socketConnectTimeout = (Integer)this.m_connectionAttributes.get("SOCKET_CONNECT_TIMEOUT")) != null) {
            connector.setSocketConnectTimeout(socketConnectTimeout * 1000);
        }
        if (logInfo) {
            this.logMessage("Connecting with a connection timeout of " + (connectTimeout == null ? 10 : connectTimeout) + " seconds", 3);
        }
        connector.connect(address, (connectTimeout == null ? 10 : connectTimeout) * 1000, validateNodeName);
        return connector;
    }

    private boolean substituteGenerateCacheConnectionAttrs(Hashtable connectionFactoryEnv) {
        String directURLProp = System.getProperty("sonicsw.mf.cacheGeneration.url");
        String directUSERProp = System.getProperty("sonicsw.mf.cacheGeneration.user");
        String directPASSWORDProp = System.getProperty("sonicsw.mf.cacheGeneration.password");
        if (directURLProp != null) {
            connectionFactoryEnv.put("ConnectionURLs", directURLProp);
        }
        if (directUSERProp != null) {
            connectionFactoryEnv.put("DefaultUser", directUSERProp);
        }
        if (directPASSWORDProp != null) {
            connectionFactoryEnv.put("DefaultPassword", directPASSWORDProp);
        }
        return directURLProp != null;
    }

    void logMessage(String message, int severityLevel) {
        this.m_logger.logMessage(message, severityLevel);
    }

    void logMessage(String message, Throwable t, int severityLevel) {
        this.m_logger.logMessage(message, t, severityLevel);
    }

    private static String createContainerFullName(ExtractedContainerConfig extractedConfig) {
        return ContainerResources.createContainerFullName(extractedConfig.m_domainName, extractedConfig.m_containerName);
    }

    private static String createContainerFullName(String domainName, String containerName) {
        return domainName + "." + containerName;
    }

    private String[] mergeClasspathLists(String[] l1, String[] l2) {
        int i;
        HashSet<String> set = new HashSet<String>();
        for (i = 0; i < l1.length; ++i) {
            set.add(l1[i]);
        }
        for (i = 0; i < l2.length; ++i) {
            set.add(l2[i]);
        }
        if (this.m_dsArchivePath != null) {
            set.add(this.m_dsArchivePath);
        }
        return set.toArray(EMPTY_STRING_ARRAY);
    }

    protected void getLocalFileReferences() throws Exception {
        String cachePath = this.m_dsArchivePath != null ? this.m_dsArchivePath : this.m_logicalArchivePath;
        this.m_classpath = new CARClasspath(this.m_configCacheView.getFileByLogicalName(cachePath, false));
        this.m_systemProps.substituteSonicfsResources(this.getLocalFiles(this.m_systemProps.getSonicfsResources()));
        String[] localFiles = this.getLocalFiles(this.m_configClasspath.getSonicfsResources());
        this.m_configClasspath.substituteSonicfsResources(localFiles);
    }

    String[] getLocalFiles(String[] sonicfsFiles) throws Exception {
        ArrayList<String> fileList = new ArrayList<String>();
        for (int i = 0; i < sonicfsFiles.length; ++i) {
            File localFile;
            block4: {
                localFile = null;
                try {
                    localFile = this.m_configCacheView.getFileByLogicalName(sonicfsFiles[i], false);
                }
                catch (LatestVersionMissingException e) {
                    localFile = this.m_configCacheView.getAvailableFileByLogicalName(sonicfsFiles[i]);
                    if (localFile == null) break block4;
                    this.m_logger.logMessage("Could not get the latest version of \"" + sonicfsPrefix + sonicfsFiles[i] + "\" from the Directory Service - use the latest cache version", 2);
                }
            }
            if (localFile == null) {
                this.m_logger.logMessage("Could not find file \"" + sonicfsPrefix + sonicfsFiles[i] + "\" in the container cache", 2);
                fileList.add(null);
                continue;
            }
            fileList.add(localFile.getAbsolutePath());
        }
        return fileList.toArray(EMPTY_STRING_ARRAY);
    }

    static class ExtractedContainerConfig
    implements Serializable {
        String m_archiveSearchPath;
        String m_domainName;
        String m_containerName;
        String m_containerPath;
        String m_actionalPlugMakerArchiveName;
        String m_actionalSDKArchiveName;
        String m_configClasspath;
        String m_activationDaemonPath;
        String m_hostManagerPath;
        String m_logFileName;
        String m_configNativePath;
        Integer m_deployTraceMask;
        String m_cacheHostDirectoryName;
        String m_cachePassword;
        Boolean m_createIfDoesNotExist;
        Boolean m_hostsDS;
        HashMap m_jvmArgs;
        String m_jvmHome;
        String m_archiveName;
        HashMap m_systemProps;

        ExtractedContainerConfig() {
        }

        ExtractedContainerConfig deepClone() {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(out);
                objectOut.writeObject(this);
                byte[] bytes = out.toByteArray();
                objectOut.close();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream objectIn = new ObjectInputStream(in);
                return (ExtractedContainerConfig)objectIn.readObject();
            }
            catch (Exception e) {
                throw new Error("deepClone failed");
            }
        }
    }

    private class XmlINI
    extends InitInfo {
        XmlINI(byte[] bytes) throws Exception {
            IDirElement containerConfiguration = ElementFactory.importFromXML(new String(bytes), null);
            this.m_attributes = containerConfiguration.getAttributes();
            this.m_config = ContainerResources.this.extractConfigInfo(this.m_attributes);
            this.m_containerConfID = containerConfiguration.getIdentity().getName();
        }
    }

    private class PropINI
    extends InitInfo {
        PropINI(byte[] bytes) throws Exception {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Properties initProps = ContainerUtil.readProperties(stream);
            this.m_config = ContainerResources.this.extractINIInfo(initProps);
            this.m_properties = initProps;
            this.setINISystemProps(this.m_properties);
        }

        private void setINISystemProps(Hashtable table) {
            boolean centralConnectionUsed = false;
            HashMap systemProps = new HashMap();
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                String fullKey = (String)keys.nextElement();
                if (fullKey.regionMatches(true, 0, "SystemProperty.", 0, SYSTEM_PROP_PREFIX_LENGTH)) {
                    String key = fullKey.substring(SYSTEM_PROP_PREFIX_LENGTH);
                    systemProps.put(key, table.get(fullKey));
                    continue;
                }
                if (!fullKey.regionMatches(true, 0, "CentralConnection.", 0, CENTRAL_CONNECTION_PROP_PREFIX_LENGTH)) continue;
                centralConnectionUsed = true;
            }
            ContainerResources.this.m_centralConnectionUsed = centralConnectionUsed && !ContainerResources.this.m_requestToConfigureFromCache;
            SystemProperties.connectionPropertiesFilter(systemProps, ContainerResources.this.m_centralConnectionUsed);
            for (String key : systemProps.keySet()) {
                System.setProperty(key, (String)systemProps.get(key));
            }
        }
    }

    private abstract class InitInfo {
        IAttributeSet m_attributes;
        Hashtable m_properties;
        ExtractedContainerConfig m_config;
        String m_containerConfID;

        private InitInfo() {
        }
    }

    class LocalDSParameters {
        String m_configID;
        String m_domainName;
        String m_hostDir;
        String m_encryptionPassword;
        boolean m_isBackup = false;
        Boolean m_isFaultTolerant = Boolean.FALSE;
        Boolean m_startActive = Boolean.FALSE;
        private Integer m_replicationRetryInterval;
        private Integer m_replicationPingInterval;
        private Integer m_replicationFailureDetectionTimeout;
        private Integer m_maxReplicationLogSize;
        private Integer m_replicationTimeout;
        private Boolean m_dualActiveResolution;
        private HashMap m_replSSLParams;
        private HashMap[] m_replConnections;

        LocalDSParameters(String dsXMLFileName) throws Exception {
            IAttributeSet fsStorage;
            File dsXMLFile = new File(dsXMLFileName);
            ContainerResources.this.logMessage("Open Directory Service boot file \"" + ContainerResources.getCanonicalPath(dsXMLFile) + '\"', 3);
            IDirElement[] dsConfigs = ContainerUtil.importConfigurations(dsXMLFile, IContainer.PASSWORD);
            IBasicElement dsConfiguration = null;
            IDirElement ftConnections = null;
            for (int i = 0; i < dsConfigs.length; ++i) {
                String elType = dsConfigs[i].getIdentity().getType();
                if (elType.equals("MF_DIRECTORY_SERVICE") || elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) {
                    dsConfiguration = dsConfigs[i];
                    continue;
                }
                if (!elType.equals("MF_REPLICATION_CONNECTION")) continue;
                ftConnections = dsConfigs[i];
            }
            this.m_configID = dsConfiguration.getIdentity().getName();
            IAttributeSet dsAttributes = dsConfiguration.getAttributes();
            this.m_domainName = (String)dsAttributes.getAttribute("DOMAIN_NAME");
            if (this.m_domainName == null) {
                this.m_domainName = "Domain1";
            }
            this.m_hostDir = (String)dsAttributes.getAttribute("HOST_DIRECTORY");
            if (this.m_hostDir == null) {
                this.m_hostDir = ".";
            }
            if ((fsStorage = (IAttributeSet)dsAttributes.getAttribute("FILE_SYSTEM_STORAGE")) != null) {
                this.m_encryptionPassword = (String)fsStorage.getAttribute("PASSWORD");
            }
            this.readReplicationParameters(dsAttributes, ftConnections);
            if (dsConfiguration.getIdentity().getType().equals("MF_BACKUP_DIRECTORY_SERVICE")) {
                this.m_isBackup = true;
            }
            if (System.getProperty("sonicsw.mf.DS.startactive", "false").equalsIgnoreCase("true")) {
                this.m_startActive = Boolean.TRUE;
            }
            if (!this.m_startActive.booleanValue()) {
                this.m_startActive = new Boolean(this.testStartActive(false));
            }
        }

        private boolean testStartActive(boolean deleteFile) {
            String testFileName = System.getProperty("_TEST_DSReplication_startActive");
            if (testFileName == null) {
                return false;
            }
            File testFile = new File(testFileName);
            if (!testFile.exists()) {
                return false;
            }
            if (deleteFile) {
                testFile.delete();
            }
            return true;
        }

        private void readReplicationParameters(IAttributeSet dsAttributes, IElement ftConnections) {
            IAttributeSet connectionsSet;
            IAttributeSet tmpSet;
            Boolean backupFailoverReadOnly;
            IAttributeSet replParams = (IAttributeSet)dsAttributes.getAttribute("REPLICATION_PARAMETERS");
            if (replParams == null) {
                IDirElement tmpEl = ElementFactory.createElement("/tmp", "tmp", "tmp");
                IAttributeSet tmpPrimaryAtts = tmpEl.getAttributes();
                try {
                    replParams = tmpPrimaryAtts.createAttributeSet("REPLICATION_PARAMETERS");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Object tmp = null;
            tmp = replParams.getAttribute("RETRY_INTERVAL");
            this.m_replicationRetryInterval = tmp == null ? new Integer(180) : (Integer)tmp;
            tmp = replParams.getAttribute("PING_INTERVAL");
            this.m_replicationPingInterval = tmp == null ? new Integer(30) : (Integer)tmp;
            tmp = replParams.getAttribute("FAILURE_DETECTION_TIMEOUT");
            Integer n = this.m_replicationFailureDetectionTimeout = tmp == null ? new Integer(0) : (Integer)tmp;
            if (this.m_replicationFailureDetectionTimeout < 60) {
                this.m_replicationFailureDetectionTimeout = new Integer(60);
            }
            this.m_maxReplicationLogSize = (tmp = replParams.getAttribute("MAX_REPLICATION_LOG_SIZE")) == null ? new Integer(80) : (Integer)tmp;
            tmp = replParams.getAttribute("REPLICATION_TIMEOUT");
            this.m_replicationTimeout = tmp == null ? new Integer(-1) : (Integer)tmp;
            tmp = replParams.getAttribute("DUAL_ACTIVE_RESOLUTION");
            this.m_dualActiveResolution = tmp == null ? new Boolean(false) : (Boolean)tmp;
            tmp = replParams.getAttribute("BACKUP_FAILOVER_READ_ONLY");
            Boolean bl = backupFailoverReadOnly = tmp == null ? new Boolean(false) : (Boolean)tmp;
            if (backupFailoverReadOnly.booleanValue()) {
                this.m_dualActiveResolution = Boolean.TRUE;
            }
            if ((tmpSet = (IAttributeSet)replParams.getAttribute("SSL_PARAMETERS")) != null) {
                this.m_replSSLParams = (HashMap)tmpSet.getAttributes().clone();
            }
            if (ftConnections != null && (connectionsSet = (IAttributeSet)ftConnections.getAttributes().getAttribute("REPLICATION_CONNECTIONS")) != null) {
                this.m_isFaultTolerant = Boolean.TRUE;
                HashMap connectionsMap = connectionsSet.getAttributes();
                Collection connCol = connectionsMap.values();
                Iterator connIt = connCol.iterator();
                this.m_replConnections = new HashMap[connCol.size()];
                int replConnIndex = 0;
                while (connIt.hasNext()) {
                    IAttributeSet connectionInfo = (IAttributeSet)connIt.next();
                    HashMap<String, Object> connectionMap = new HashMap<String, Object>();
                    Object value = connectionInfo.getAttribute("PROTOCOL");
                    if (value == null) {
                        value = "TCP";
                    }
                    connectionMap.put("PROTOCOL", value);
                    value = connectionInfo.getAttribute("PRIMARY_ADDR");
                    if (value != null) {
                        connectionMap.put("PRIMARY_ADDR", value);
                    }
                    if ((value = connectionInfo.getAttribute("PRIMARY_PORT")) == null) {
                        value = new Integer(22516);
                    }
                    connectionMap.put("PRIMARY_PORT", value);
                    value = connectionInfo.getAttribute("BACKUP_ADDR");
                    if (value != null) {
                        connectionMap.put("BACKUP_ADDR", value);
                    }
                    if ((value = connectionInfo.getAttribute("BACKUP_PORT")) == null) {
                        value = new Integer(22516);
                    }
                    connectionMap.put("BACKUP_PORT", value);
                    value = connectionInfo.getAttribute("WEIGHT");
                    if (value == null) {
                        value = new Integer(1);
                    }
                    connectionMap.put("WEIGHT", value);
                    this.m_replConnections[replConnIndex++] = connectionMap;
                }
            }
        }
    }
}

