/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.agent.ci.ContainerProcess;
import com.sonicsw.mf.framework.agent.ci.StartContainerCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;

public final class GeneratePlatformArguments {
    private static final String PLATFORM_DEPENDENT_ARGS_PROGRAM = "com.sonicsw.mf.framework.agent.ci.PlatformDependentArguments";
    private static final String PROPERTY_PREFIX = "-D";
    private static final int PROPERTY_OFFSET = "-D".length();
    private HashMap m_properties;
    private HashMap m_arguments;

    public GeneratePlatformArguments(String jvmHome, String[] classpathList, String outputFile, ILogger logger) throws Exception {
        for (int i = 0; i < 2 && !this.generateArguments(jvmHome, classpathList, outputFile, logger, i == 0); ++i) {
        }
    }

    boolean generateArguments(String jvmHome, String[] classpathList, String outputFile, ILogger logger, boolean serverOption) throws Exception {
        String execOutput;
        ArrayList jvmCommand = this.generateCcommand(jvmHome, classpathList, outputFile, serverOption);
        ContainerProcess process = new ContainerProcess(jvmCommand, PLATFORM_DEPENDENT_ARGS_PROGRAM, System.getProperty("user.dir"), logger);
        process.exec();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            if (serverOption) {
                return false;
            }
            String errorMsg = "\"com.sonicsw.mf.framework.agent.ci.PlatformDependentArguments\" [" + jvmCommand + "] execution has failed";
            String execError = process.getError();
            if (execError != null && execError.length() > 0) {
                errorMsg = errorMsg + ": " + execError;
            }
            logger.logMessage(errorMsg, 1);
            throw new Exception(errorMsg);
        }
        String execError = process.getError();
        if (execError != null && execError.length() > 0) {
            logger.logMessage(execError, 3);
        }
        if ((execOutput = process.getOutput()) != null && execOutput.length() > 0) {
            logger.logMessage(execOutput, 3);
        }
        this.m_properties = new HashMap();
        this.m_arguments = new HashMap();
        this.readProperties(outputFile, serverOption);
        new File(outputFile).delete();
        return true;
    }

    public HashMap getJVMArguments() {
        return this.m_arguments;
    }

    public HashMap getSystemProprties() {
        return this.m_properties;
    }

    private ArrayList generateCcommand(String jvmHome, String[] classpathList, String outputFile, boolean serverOption) {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(jvmHome + File.separatorChar + "bin" + File.separatorChar + "java" + (File.pathSeparator.equals(";") ? ".exe" : ""));
        if (serverOption) {
            commandList.add("-server");
        }
        commandList.add("-cp");
        String classpath = StartContainerCommand.createClasspathString(classpathList);
        String devClasspath = System.getProperty("sonicsw.mf.devPrivateClasspath");
        if (devClasspath != null) {
            classpath = devClasspath + File.pathSeparator + classpath;
        }
        commandList.add(classpath);
        commandList.add(PLATFORM_DEPENDENT_ARGS_PROGRAM);
        commandList.add(outputFile);
        return commandList;
    }

    private void readProperties(String outfileName, boolean serverOption) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(outfileName)));
        while ((line = reader.readLine()) != null) {
            int eqIndex = line.indexOf(61);
            if (eqIndex == -1) continue;
            String key = line.substring(0, eqIndex);
            String value = line.substring(eqIndex + 1);
            if (key.startsWith(PROPERTY_PREFIX)) {
                this.m_properties.put(key.substring(PROPERTY_OFFSET), value);
                continue;
            }
            if (key.equals("-server") && !serverOption) continue;
            this.m_arguments.put(key, value);
        }
        reader.close();
    }
}

