/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

class HostHelper {
    private ILogger m_logger;
    private boolean m_skipEC2;
    private boolean m_traceEC2;
    private int m_timeout;

    HostHelper(ILogger logger, boolean skipEC2, boolean traceEC2, int timeout) {
        this.m_logger = logger;
        this.m_skipEC2 = skipEC2;
        this.m_traceEC2 = traceEC2;
        this.m_timeout = timeout;
    }

    String getPrivateHost() {
        String result = this.queryEC2Metadata("local-hostname");
        if (result == null) {
            try {
                result = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                this.m_logger.logMessage("Unable to determine private host name (defaulting to \"localhost\"), trace follows...", e, 2);
                result = "localhost";
            }
        }
        return result;
    }

    String getPublicHost() {
        String result = this.queryEC2Metadata("public-hostname");
        return result == null ? "" : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String queryEC2Metadata(String attribute) {
        String result = null;
        if (this.m_skipEC2) {
            if (this.m_traceEC2) {
                this.m_logger.logMessage("Skipping EC2 metadata query for " + attribute, 7);
            }
            return result;
        }
        String urlstr = "http://169.254.169.254/latest/meta-data/" + attribute;
        BufferedReader metadataStream = null;
        try {
            String line;
            URL ec2url = new URL(urlstr);
            URLConnection metadata = ec2url.openConnection();
            metadata.setConnectTimeout(this.m_timeout);
            metadata.setReadTimeout(this.m_timeout);
            metadataStream = new BufferedReader(new InputStreamReader(metadata.getInputStream()));
            while ((line = metadataStream.readLine()) != null) {
                result = line.length() > 0 ? line : result;
            }
            if (this.m_traceEC2) {
                this.m_logger.logMessage("EC2 metadata query '" + urlstr + "' returned '" + result + "'", 7);
            }
        }
        catch (Throwable t) {
            result = null;
            if (!(t instanceof FileNotFoundException)) {
                this.m_skipEC2 = true;
            }
            if (this.m_traceEC2) {
                this.m_logger.logMessage("EC2 metadata query '" + urlstr + "' failed, trace follows...", t, 7);
            }
        }
        finally {
            if (metadataStream != null) {
                try {
                    metadataStream.close();
                }
                catch (Throwable t2) {}
            }
        }
        return result;
    }
}

