/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.jmx.client.CommunicationException;
import com.sonicsw.mf.jmx.client.IConnectionListener;
import com.sonicsw.mf.jmx.client.IExceptionListener;
import com.sonicsw.mf.jmx.client.IOrphanedReplyListener;
import com.sonicsw.mf.jmx.client.IRemoteMBeanServer;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

final class LaunchConnector
implements IRemoteMBeanServer {
    protected ConnectorClient m_connector;
    private IContainerIdentity m_containerIdentity;
    private boolean m_failWhenDisconnected = false;
    private JMSConnectorAddress m_address;
    private String m_serverIdentity;
    private long m_connectTimeout = 10000L;
    private long m_socketConnectTimeout = 5000L;
    private long m_requestTimeout = 30000L;
    private int m_traceMask = 0;
    private IConnectionListener m_connectionListener;
    private ILogger m_logger;

    LaunchConnector(IContainerIdentity containerIdentity, ILogger logger) {
        this.m_containerIdentity = containerIdentity;
        this.m_logger = logger;
    }

    LaunchConnector(ConnectorClient connectorClient) {
        this.m_connector = connectorClient;
    }

    @Override
    public synchronized String connect(JMSConnectorAddress address) {
        return this.connect(address, 0L, false);
    }

    public synchronized String connect(JMSConnectorAddress address, long timeout, boolean validateNodeName) {
        if (this.m_address != null && !address.equals(this.m_address)) {
            throw new IllegalArgumentException("Cannot connect with a different address.");
        }
        if (this.m_connector != null) {
            throw new IllegalStateException("Already connected");
        }
        this.m_connector = new ConnectorClient(this.m_containerIdentity);
        this.m_connector.setRequestTimeout(this.m_requestTimeout);
        this.m_connector.setConnectTimeout(this.m_connectTimeout);
        this.m_connector.setSocketConnectTimeout(this.m_socketConnectTimeout);
        this.m_connector.setTraceMask(this.m_traceMask);
        String managementNode = address.getManagementNode();
        if (managementNode != null && managementNode.length() > 0) {
            this.m_connector.setManagementNode(managementNode);
        }
        this.m_connector.setConnectionListener(new com.sonicsw.mf.comm.IConnectionListener(){
            public String lrn;

            @Override
            public void onFailure(Exception e) {
                if (LaunchConnector.this.m_connectionListener != null) {
                    LaunchConnector.this.m_connectionListener.onFailure(e);
                }
            }

            @Override
            public void onReconnect(String localRoutingNode) {
                this.lrn = localRoutingNode;
                Thread reconnectHandler = new Thread("LaunchConnectorClient - Reconnect Handler"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LaunchConnector launchConnector = LaunchConnector.this;
                        synchronized (launchConnector) {
                            if (LaunchConnector.this.m_connectionListener != null) {
                                LaunchConnector.this.m_connectionListener.onReconnect(lrn);
                            }
                        }
                    }
                };
                reconnectHandler.setDaemon(true);
                reconnectHandler.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisconnect() {
                LaunchConnector launchConnector = LaunchConnector.this;
                synchronized (launchConnector) {
                    if (LaunchConnector.this.m_connectionListener != null) {
                        LaunchConnector.this.m_connectionListener.onDisconnect();
                    }
                }
            }
        });
        try {
            this.m_connector.connect(address.getEnv(), timeout);
        }
        catch (Exception e) {
            if (this.m_connector != null) {
                this.m_connector.close();
                this.m_connector = null;
            }
            JMRuntimeException jmre = new JMRuntimeException(e.getMessage());
            try {
                Method method = jmre.getClass().getMethod("initCause", Throwable.class);
                method.invoke((Object)jmre, e);
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw jmre;
        }
        if (validateNodeName && !this.m_connector.getLocalRoutingNodeName().equals(managementNode)) {
            String message = "Configured management node [" + managementNode + "] does not match connected node [" + this.m_connector.getLocalRoutingNodeName() + "]";
            if (this.m_connector != null) {
                this.m_connector.close();
                this.m_connector = null;
            }
            throw new JMRuntimeException(message);
        }
        this.m_address = address;
        this.m_serverIdentity = address.getServerIdentity();
        return this.m_serverIdentity;
    }

    public IExceptionListener getExceptionListener() {
        return null;
    }

    public synchronized void setExceptionListener(IExceptionListener listener) {
    }

    public IConnectionListener getConnectionListener() {
        return this.m_connectionListener;
    }

    public synchronized void setConnectionListener(IConnectionListener listener) {
        this.m_connectionListener = listener;
    }

    public IOrphanedReplyListener getOrphanedReplyListener() {
        throw new IllegalAccessError();
    }

    public synchronized void setOrphanedReplyListener(IOrphanedReplyListener listener) {
        throw new IllegalAccessError();
    }

    @Override
    public synchronized void disconnect() {
        if (this.m_connector == null) {
            return;
        }
        this.m_connector.closePending();
        this.m_connector.close();
        this.m_connector = null;
    }

    public void setRequestTimeout(long timeout) {
        long l = this.m_requestTimeout = timeout >= 10000L ? timeout : 10000L;
        if (this.m_connector != null) {
            this.m_connector.setRequestTimeout(this.m_requestTimeout);
        }
    }

    public long getRequestTimeout() {
        return this.m_requestTimeout;
    }

    public void setFailWhenDisconnected(boolean failWhenDisconnected) {
        this.m_failWhenDisconnected = failWhenDisconnected;
    }

    public boolean getFailWhenDisconnected() {
        return this.m_failWhenDisconnected;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new IllegalAccessError();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new IllegalAccessError();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName objectName, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public Object getAttribute(ObjectName objectName, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        throw new IllegalAccessError();
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        throw new IllegalAccessError();
    }

    @Override
    public String getDefaultDomain() {
        throw new IllegalAccessError();
    }

    @Override
    public Integer getMBeanCount() {
        throw new IllegalAccessError();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        throw new IllegalAccessError();
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.invoke(objectName, operationName, params, signature, null);
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature, ClassLoader loader) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkNotNull("objectName", objectName);
        this.checkNotNull("operationName", operationName);
        this.checkNotNull("params", params);
        this.checkNotNull("signature", signature);
        this.testConnector();
        this.testFailWhenDisconnected();
        Object returnValue = null;
        ClassLoader existingContextLoader = null;
        try {
            if (loader != null) {
                existingContextLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
            }
            returnValue = this.m_connector.invoke("mf", objectName.getDomain(), objectName.getCanonicalName(), operationName, params, signature);
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (InstanceNotFoundException infe) {
            throw infe;
        }
        catch (ReflectionException re) {
            throw re;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw CommunicationException.create(e, "Failed invoke");
        }
        finally {
            if (loader != null) {
                Thread.currentThread().setContextClassLoader(existingContextLoader);
            }
        }
        return returnValue;
    }

    @Override
    public boolean isConnected() {
        if (this.m_connector == null) {
            return false;
        }
        try {
            return this.m_connector.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String className) throws InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        throw new IllegalAccessError();
    }

    @Override
    public Set queryMBeans(ObjectName objectName, QueryExp query) {
        throw new IllegalAccessError();
    }

    @Override
    public Set queryNames(ObjectName objectName, QueryExp query) {
        throw new IllegalAccessError();
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new IllegalAccessError();
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        throw new IllegalAccessError();
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        throw new IllegalAccessError();
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback, Long timeout) throws InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new IllegalAccessError();
    }

    public void setTraceMask(int maskValue) {
        this.m_traceMask = maskValue;
        if (this.m_connector != null) {
            this.m_connector.setTraceMask(maskValue);
        }
    }

    public int getTraceMask() {
        return this.m_traceMask;
    }

    public void setConnectTimeout(long connectTimeout) {
        long l = this.m_connectTimeout = connectTimeout >= 10000L ? connectTimeout : 10000L;
        if (this.m_connector != null) {
            this.m_connector.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public long getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setSocketConnectTimeout(long socketConnectTimeout) {
        long l = this.m_socketConnectTimeout = socketConnectTimeout >= 0L ? socketConnectTimeout : 0L;
        if (this.m_connector != null) {
            this.m_connector.setSocketConnectTimeout(this.m_socketConnectTimeout);
        }
    }

    public long getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public void logMessage(String message, int severityLevel) {
        if (this.m_logger != null) {
            this.m_logger.logMessage(message, severityLevel);
        }
    }

    public void logMessage(String message, Throwable exception, int severityLevel) {
        if (this.m_logger != null) {
            this.m_logger.logMessage(message, exception, severityLevel);
        }
    }

    private void checkNotNull(String paramName, Object object) {
        if (object == null) {
            IllegalArgumentException e = new IllegalArgumentException(paramName + " must not be null");
            throw new RuntimeOperationsException(e);
        }
    }

    private void testConnector() {
        if (this.m_connector == null) {
            throw new IllegalStateException("Not connected");
        }
    }

    private void testFailWhenDisconnected() {
        if (this.m_failWhenDisconnected && !this.isConnected()) {
            throw CommunicationException.create("Not currently connected");
        }
    }

    @Override
    public String[] getDomains() throws IOException {
        throw new IllegalAccessError();
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new IllegalAccessError();
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new IllegalAccessError();
    }
}

