/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerSetup;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.LauncherInstallManager;
import com.sonicsw.mf.framework.agent.ci.LauncherJARBuilder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public final class LauncherFilesInstaller {
    private static final String EXT_PACK = ".pack";
    private static final String JRE_PROP = "JRE";
    private static final boolean ON_WINDOWS = File.separatorChar == '\\';
    private static final String SONIC_HOME = System.getProperty("sonicsw.home");
    private static final String WINSERVICE_DIR = "winservice";
    private static final String BAT_FILE = ".bat";
    private static final String SH_FILE = ".sh";
    private static final String CAR_MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_VERSION_LABEL = "Implementation-Version: ";
    private static final String CAR_LAUNCHER_FILE_LIST = "launch/maps/car_to_launcher_map";
    private static final String SH_SETUP_SCRIPT = "container_setup/setup.sh";
    private static final String BAT_SETUP_SCRIPT = "container_setup/setup.bat";
    private static final String TEMP_SETUP_SCRIPT = "container_setup/setup.temp";
    private static final String BAT_COMMENT = "REM";
    private static final String SH_COMMENT = "#";
    private static final String TAILOR_MARKER = "$";
    private byte[] m_buffer = new byte[8192];

    public static void main(String[] args) throws Exception {
        String archiveRootPath = args[0];
        if (archiveRootPath == null) {
            throw new Exception("Usage: com.sonicsw.mf.framework.agent.ci.LauncherFilesInstaller <expanded-MFcontainer.car-root-path>");
        }
        File archiveRootDir = new File(archiveRootPath);
        new LauncherFilesInstaller().installLauncherFiles(archiveRootDir, archiveRootDir.getParentFile().getAbsolutePath(), true, false, false);
    }

    public String installLauncherFiles(String archivePath, String sonicHome) throws IOException {
        return this.installLauncherFiles(archivePath, sonicHome, false);
    }

    String installLauncherFiles(String archivePath, String sonicHome, boolean instalMFdirectoryJAR) throws IOException {
        File archiveFile = new File(archivePath);
        String tempDir = System.getProperty("java.io.tmpdir");
        File tempRoot = new File(tempDir, archiveFile.getName());
        if (tempRoot.exists()) {
            this.clearDestination(tempRoot);
        }
        this.expandArchive(archiveFile, tempRoot);
        String version = this.installLauncherFiles(tempRoot, sonicHome, true, true, instalMFdirectoryJAR);
        this.clearDestination(tempRoot);
        return version;
    }

    public String installLauncherFiles(File archiveRoot, File homeDir) throws IOException {
        return this.installLauncherFiles(archiveRoot, homeDir.getAbsolutePath(), true, true, false);
    }

    String installLauncherFiles(File archiveRoot) throws IOException {
        return this.installLauncherFiles(archiveRoot, SONIC_HOME, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String installLauncherFiles(File archiveRoot, String sonicHome, boolean ignoreCurrentVersion, boolean tailorSetupScripts, boolean installMFdirectoryJAR) throws IOException {
        String string;
        LauncherInstallManager launchManager;
        block12: {
            if (IContainer.CURRENT_LAUNCHER_VERSION == null && !ignoreCurrentVersion) {
                return null;
            }
            String carVersion = this.getCarManifestVersion(archiveRoot);
            if (null == carVersion) {
                return null;
            }
            try {
                this.upgradeWDScriptsIfNeeded(sonicHome, IContainer.CURRENT_LAUNCHER_VERSION);
            }
            catch (IOException e) {
                System.err.println("WARNING: Might have failed to upgrade a working directory script");
                e.printStackTrace();
            }
            if (!ignoreCurrentVersion && carVersion.equals(IContainer.CURRENT_LAUNCHER_VERSION)) {
                return null;
            }
            File launcherListFile = new File(archiveRoot, CAR_LAUNCHER_FILE_LIST);
            String launcherDirName = "Launcher/" + carVersion;
            File updatedLauncherPath = new File(sonicHome, launcherDirName);
            File updatesLauncherMFDirJAR = new File(updatedLauncherPath, "lib/MFdirectory.jar");
            File currentLauncherPath = new File(sonicHome, IContainer.LAUNCHER_DIR);
            File currentLauncherMFDirJAR = new File(currentLauncherPath, "lib/MFdirectory.jar");
            launchManager = new LauncherInstallManager(new File(sonicHome), launcherDirName);
            try {
                if (launchManager.startInstall()) {
                    this.copyFiles(launcherListFile, archiveRoot, updatedLauncherPath, ON_WINDOWS);
                    if (currentLauncherMFDirJAR.exists() || installMFdirectoryJAR) {
                        LauncherJARBuilder.createMFdirectoryJAR(archiveRoot, updatesLauncherMFDirJAR);
                    }
                    if (tailorSetupScripts) {
                        this.tailorSetupScripts(updatedLauncherPath, ON_WINDOWS);
                    }
                    if (!ON_WINDOWS) {
                        ContainerSetup.unixChmodSHFilesToExecutables(updatedLauncherPath);
                    }
                }
                string = carVersion;
                if (!tailorSetupScripts) break block12;
                this.deleteFilesOfType(updatedLauncherPath, ON_WINDOWS ? SH_FILE : BAT_FILE);
            }
            catch (Throwable throwable) {
                if (tailorSetupScripts) {
                    this.deleteFilesOfType(updatedLauncherPath, ON_WINDOWS ? SH_FILE : BAT_FILE);
                }
                launchManager.installDone();
                throw throwable;
            }
        }
        launchManager.installDone();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeWDScriptsIfNeeded(String sonicHome, String currentLauncherVersion) throws IOException {
        boolean oldScript;
        File srcScript;
        File targetScript;
        block8: {
            String scriptName = "shutdowncontainer" + (ON_WINDOWS ? BAT_FILE : SH_FILE);
            File launcherDir = new File(sonicHome, "Launcher/" + currentLauncherVersion);
            File templatesDir = new File(launcherDir, "container_templates");
            targetScript = new File(scriptName);
            srcScript = new File(templatesDir, scriptName);
            if (!targetScript.exists()) {
                return;
            }
            oldScript = true;
            try (BufferedReader reader = null;){
                String line;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(targetScript)));
                do {
                    if ((line = reader.readLine()) != null) continue;
                    break block8;
                } while (line.indexOf("Tailored variables") == -1);
                oldScript = false;
            }
        }
        if (!oldScript) {
            return;
        }
        targetScript.delete();
        File currentWD = new File(System.getProperty("user.dir"));
        Properties tailorProps = new Properties();
        Properties pathProps = new Properties();
        tailorProps.setProperty("SONIC_HOME", sonicHome);
        tailorProps.setProperty("WORKING_DIRECTORY", currentWD.getAbsolutePath());
        ContainerSetup.tailorFile(srcScript, targetScript, tailorProps, pathProps, ON_WINDOWS);
        if (!ON_WINDOWS) {
            ArrayList<File> chmodList = new ArrayList<File>();
            chmodList.add(targetScript);
            ContainerSetup.unixChmodSHFilesToExecutables(chmodList);
        }
    }

    private String getCarManifestVersion(File archiveRoot) throws FileNotFoundException, IOException {
        File manifetFile = new File(archiveRoot, CAR_MANIFEST_FILE);
        if (!manifetFile.exists()) {
            throw new IOException("The container Archive's " + manifetFile.getAbsolutePath() + " does not exist");
        }
        Object version = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(manifetFile)));){
            String line;
            while ((line = reader.readLine()) != null) {
                int labelIndex = (line = line.trim()).indexOf(MANIFEST_VERSION_LABEL);
                if (labelIndex == -1) continue;
                String string = line.substring(MANIFEST_VERSION_LABEL.length());
                return string;
            }
            throw new IOException("Could not find the \"Implementation-Version: \" label in \"" + manifetFile.getAbsolutePath() + "\"");
        }
    }

    public static void setManifestVersionInContainerExpandedArchive(File archiveRoot, String testVersion) throws IOException {
        String srcLine;
        File manifetFile = new File(archiveRoot, CAR_MANIFEST_FILE);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(manifetFile)));
        File tmpFile = new File(manifetFile.getAbsolutePath() + ".tmp");
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(tmpFile, false)), true);
        while ((srcLine = reader.readLine()) != null) {
            String newLine = (srcLine = srcLine.trim()).indexOf(MANIFEST_VERSION_LABEL) != -1 ? MANIFEST_VERSION_LABEL + testVersion : srcLine;
            writer.println(newLine);
        }
        reader.close();
        writer.close();
        manifetFile.delete();
        tmpFile.renameTo(manifetFile);
    }

    private void expandArchive(File archiveFile, File tempRoot) throws IOException {
        JarFile jarFile = new JarFile(archiveFile);
        this.clearDestination(tempRoot);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File copyFile = new File(tempRoot, entry.getName());
            if (entry.isDirectory()) {
                if (copyFile.exists() || copyFile.mkdirs()) continue;
                throw new IOException("Could not create " + copyFile.getAbsolutePath());
            }
            this.copyFileFromJAR(jarFile.getInputStream(entry), copyFile);
        }
        jarFile.close();
    }

    private void copyFileFromJAR(InputStream stream0, File jarFile) throws IOException {
        int numRead;
        BufferedInputStream is = new BufferedInputStream(stream0, this.m_buffer.length);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(jarFile), this.m_buffer.length);
        while ((numRead = is.read(this.m_buffer)) > 0) {
            os.write(this.m_buffer, 0, numRead);
        }
        is.close();
        os.close();
    }

    private void tailorSetupScripts(File updatedLauncherPath, boolean windows) throws IOException {
        Properties tailorProps = new Properties();
        tailorProps.put(JRE_PROP, ContainerSetup.JAVA_EXEC);
        this.tailorScript(new File(updatedLauncherPath, SH_SETUP_SCRIPT), new File(updatedLauncherPath, TEMP_SETUP_SCRIPT), tailorProps, false);
        if (ON_WINDOWS) {
            this.tailorScript(new File(updatedLauncherPath, BAT_SETUP_SCRIPT), new File(updatedLauncherPath, TEMP_SETUP_SCRIPT), tailorProps, true);
        }
    }

    private void tailorScript(File srcFile, File tempFile, Properties tailorProps, boolean batFile) throws IOException {
        this.tailorFile(srcFile, tempFile, tailorProps, batFile);
        boolean delOk = srcFile.delete();
        boolean renameOk = tempFile.renameTo(srcFile);
        if (!delOk || !renameOk) {
            throw new IOException("Failed to rename " + tempFile.getAbsolutePath() + " to " + srcFile.getAbsolutePath());
        }
    }

    private void tailorFile(File srcFile, File trgtFile, Properties tailorProps, boolean batFile) throws IOException {
        String srcLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(srcFile)));
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(trgtFile, false)), true);
        while ((srcLine = reader.readLine()) != null) {
            String commentPrefix;
            String string = commentPrefix = batFile ? BAT_COMMENT : SH_COMMENT;
            if (srcLine.toUpperCase().startsWith(commentPrefix)) {
                writer.println(srcLine);
                continue;
            }
            writer.println(this.tailorLine(srcLine, tailorProps));
        }
        reader.close();
        writer.close();
    }

    private String tailorLine(String srcLine, Properties tailorProps) {
        Enumeration<Object> tailorList = tailorProps.keys();
        String resultLine = srcLine;
        while (tailorList.hasMoreElements()) {
            String prop = (String)tailorList.nextElement();
            if (srcLine.indexOf(TAILOR_MARKER + prop + TAILOR_MARKER) == -1) continue;
            String val = (String)tailorProps.get(prop);
            String oldString = TAILOR_MARKER + prop + TAILOR_MARKER;
            int start = srcLine.indexOf(oldString);
            resultLine = srcLine.substring(0, start);
            resultLine = resultLine + val + srcLine.substring(start + oldString.length());
        }
        return resultLine;
    }

    static File findCacheFile(File rootDir, String pathInCache) {
        File cachedFile = new File(rootDir, pathInCache);
        if (!cachedFile.exists()) {
            if (pathInCache.endsWith(EXT_PACK)) {
                int trimmedLength = pathInCache.length() - EXT_PACK.length();
                cachedFile = new File(rootDir, pathInCache = pathInCache.substring(0, trimmedLength));
                if (!cachedFile.exists()) {
                    return null;
                }
                return cachedFile;
            }
            return null;
        }
        return cachedFile;
    }

    private void copyFiles(File launcherListFile, File srcDir, File destDir, boolean windows) throws IOException {
        Properties fileMap = ContainerUtil.readProperties(new FileInputStream(launcherListFile));
        for (String string : fileMap.keySet()) {
            File destParent;
            File srcFile;
            String srcPath = fileMap.getProperty(string);
            if (!windows && this.windowsFile(string) || (srcFile = LauncherFilesInstaller.findCacheFile(srcDir, srcPath)) == null) continue;
            boolean unpack = srcFile.getName().endsWith(EXT_PACK);
            boolean dirCopy = srcFile.isDirectory();
            File destFile = new File(destDir, string);
            File file = destParent = dirCopy ? destFile : destFile.getParentFile();
            if (!destParent.exists() && !destParent.mkdirs()) {
                throw new IOException("Failed to create destination directory " + destDir.getAbsolutePath());
            }
            if (dirCopy) {
                this.copyDirectory(srcFile, destFile);
                continue;
            }
            if (unpack) {
                this.unpack(srcFile, destFile);
                continue;
            }
            this.copyFile(srcFile, destFile);
        }
    }

    private void unpack(File srcFile, File destFile) throws IOException {
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        FileOutputStream fos = new FileOutputStream(destFile);
        JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(fos));
        unpacker.unpack(srcFile, jout);
        jout.close();
    }

    private void clearDestination(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                this.clearDestination(new File(fileToDelete, files[i]));
            }
            fileToDelete.delete();
        } else {
            fileToDelete.delete();
        }
    }

    private void deleteFilesOfType(File directory, String type) {
        String[] files = directory.list();
        for (int i = 0; i < files.length; ++i) {
            File child = new File(directory, files[i]);
            if (files[i].endsWith(type)) {
                child.delete();
                continue;
            }
            if (!child.isDirectory()) continue;
            this.deleteFilesOfType(child, type);
        }
    }

    private boolean windowsFile(String path) {
        return path.startsWith(WINSERVICE_DIR) || path.endsWith(BAT_FILE);
    }

    private void copyDirectory(File srcDir, File destDir) throws IOException {
        String[] files = srcDir.list();
        for (int i = 0; i < files.length; ++i) {
            this.copyFile(new File(srcDir, files[i]), new File(destDir, files[i]));
        }
    }

    private void copyFile(File srcFile, File destFile) throws IOException {
        LauncherFilesInstaller.copyFile(srcFile, destFile, this.m_buffer);
    }

    static void copyFile(File srcFile, File destFile, byte[] buffer) throws IOException {
        int numRead;
        RandomAccessFile src = new RandomAccessFile(srcFile, "r");
        RandomAccessFile dest = new RandomAccessFile(destFile, "rw");
        do {
            if ((numRead = src.read(buffer)) <= 0) continue;
            dest.write(buffer, 0, numRead);
        } while (numRead >= buffer.length);
        src.close();
        dest.close();
    }
}

