/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.util.LockFile;
import java.io.File;
import java.io.IOException;

final class LauncherInstallManager {
    private static final String NOT_COMPLETE_FILE_NAME = "install_is_not_complete";
    File m_homeDir;
    String m_launcherDir;
    File m_installRoot;
    LockFile m_lock;
    File m_incompleteMarker;

    public static void main(String[] args) throws Exception {
        LauncherInstallManager mngr = new LauncherInstallManager(new File("C:/test/inst"), "test8");
        if (mngr.startInstall()) {
            mngr.testInstall(args[0]);
        }
        mngr.installDone();
    }

    void testInstall(String pName) throws Exception {
        new File(this.m_installRoot, "f1" + pName).mkdir();
        System.out.println("Created f1");
        Thread.sleep(2000L);
        new File(this.m_installRoot, "f2" + pName).mkdir();
        Thread.sleep(2000L);
        new File(this.m_installRoot, "f3" + pName).mkdir();
        Thread.sleep(2000L);
        new File(this.m_installRoot, "f4" + pName).mkdir();
        System.out.println("INSTALL DONE");
    }

    LauncherInstallManager(File homeDir, String launcherDir) throws IOException {
        File launcherParent;
        if (!homeDir.exists()) {
            if (!homeDir.mkdirs()) {
                throw new IOException("Sonic home directory \"" + homeDir.getAbsolutePath() + "\" does not exist and cannot be created");
            }
        } else if (!homeDir.isDirectory()) {
            throw new IOException("Sonic home \"" + homeDir.getAbsolutePath() + "\" is not a directory");
        }
        if (!(launcherParent = new File(homeDir, "Launcher/")).exists() && !launcherParent.mkdir()) {
            throw new IOException("Cannot create " + launcherParent.getAbsolutePath());
        }
        this.m_homeDir = homeDir;
        this.m_launcherDir = launcherDir;
        this.m_installRoot = new File(this.m_homeDir, this.m_launcherDir);
        this.m_lock = new LockFile(new File(this.m_homeDir, this.m_launcherDir + ".lock").getAbsolutePath());
        this.m_incompleteMarker = new File(this.m_installRoot, NOT_COMPLETE_FILE_NAME);
    }

    boolean startInstall() throws IOException {
        while (!this.m_lock.lock()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new IOException("LauncherInstallManager.startInstall() was interrupted while waiting on a lock");
            }
        }
        if (!this.m_installRoot.exists() && !this.m_installRoot.mkdir()) {
            throw new IOException("Failed to create launcher directory \"" + this.m_installRoot.getAbsolutePath() + "\"");
        }
        String[] installFiles = this.m_installRoot.list();
        if (installFiles.length == 0) {
            this.m_incompleteMarker.mkdir();
            return true;
        }
        if (this.m_incompleteMarker.exists()) {
            LauncherInstallManager.deleteObsolete(this.m_installRoot);
            if (this.m_installRoot.exists()) {
                throw new IOException("Failed to delete obsolete launcher directory \"" + this.m_installRoot.getAbsolutePath() + "\"");
            }
            if (!this.m_installRoot.mkdir()) {
                throw new IOException("Failed to create launcher directory \"" + this.m_installRoot.getAbsolutePath() + "\"");
            }
            this.m_incompleteMarker.mkdir();
            return true;
        }
        return false;
    }

    void installDone() throws IOException {
        if (this.m_incompleteMarker.exists() && !this.m_incompleteMarker.delete()) {
            throw new IOException("Failed to delete marker directory \"" + this.m_incompleteMarker.getAbsolutePath() + "\"");
        }
        this.m_lock.unlock();
    }

    static void deleteObsolete(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            String[] files = fileToDelete.list();
            for (int i = 0; i < files.length; ++i) {
                LauncherInstallManager.deleteObsolete(new File(fileToDelete, files[i]));
            }
            fileToDelete.delete();
        } else {
            fileToDelete.delete();
        }
    }
}

