/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.odi.Storage;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.framework.directory.DirectoryServiceFactory;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;

public final class LocalDirectoryService {
    private IDirectoryService m_ds = null;
    private Storage m_dsStorage = null;
    private boolean m_closing = false;
    private ILogger m_logger = null;
    private String m_domainName = null;
    private Hashtable m_dsEnv = null;
    private int m_traceMask = 0;
    private DSStateHandler m_stateHandler = null;

    public static void main(String[] args) throws Exception {
        String hostDir = args[0];
        String op = args[1];
        boolean primary = false;
        boolean create = false;
        if (op.equals("primary")) {
            primary = true;
        } else if (op.equals("create")) {
            create = true;
        }
        if (primary) {
            System.out.println("Start as PRIMARY");
        } else if (create) {
            System.out.println("Start as CREATE");
        } else {
            System.out.println("Start as BACKUP");
        }
        HashMap<String, String> commConfig = new HashMap<String, String>();
        commConfig.put("BACKUP_PORT", "2507");
        commConfig.put("PRIMARY_PORT", "2506");
        HashMap[] commConfigs = new HashMap[]{commConfig};
        Hashtable<String, Object> directoryEnv = new Hashtable<String, Object>();
        directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        directoryEnv.put("REPLICATION_CONNECTIONS", commConfigs);
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        directoryEnv.put("DUAL_ACTIVE_RESOLUTION", Boolean.TRUE);
        LocalDirectoryService ld = new LocalDirectoryService();
        if (create) {
            IDirectoryAdminService ds = ld.getDS(new TestLogger(), "Domain1", directoryEnv);
            return;
        }
        ld.openReplicatedStorage(new TestLogger(), "Domain1", directoryEnv, new Boolean(primary), Boolean.FALSE);
        IDirectoryAdminService ds = ld.getReplicatedDS();
        System.out.println("Got ds " + ds);
    }

    public IDirectoryAdminService getDS(ILogger logger, String domainName, String hostDir, String encryptionPassword, Boolean isSharedHostDirectory) throws Exception {
        this.m_logger = logger;
        this.m_domainName = domainName;
        Hashtable<String, Object> directoryEnv = new Hashtable<String, Object>();
        directoryEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        if (hostDir != null) {
            directoryEnv.put("HOST_DIRECTORY_ATTRIBUTE", hostDir);
        }
        if (encryptionPassword != null && encryptionPassword.length() != 0) {
            directoryEnv.put("PASSWORD", encryptionPassword);
        }
        if (isSharedHostDirectory.booleanValue()) {
            directoryEnv.put("IS_SHARED_STORAGE", Boolean.TRUE);
        }
        directoryEnv.put("CI_FIRST_PHASE", Boolean.TRUE);
        DirectoryServiceFactory factory = new DirectoryServiceFactory(directoryEnv);
        this.m_ds = factory.createDirectoryService(domainName, logger);
        return this.m_ds;
    }

    public IDirectoryAdminService getDS(ILogger logger, String domainName, Hashtable dsEnv) throws Exception {
        this.m_logger = logger;
        this.m_domainName = domainName;
        this.m_dsEnv = dsEnv;
        Integer tmp = (Integer)dsEnv.get("_TRACE_MASK");
        if (tmp != null) {
            this.m_traceMask = tmp;
        }
        return this.getDS();
    }

    private IDirectoryAdminService getDS() throws Exception {
        this.m_dsEnv.put("CI_FIRST_PHASE", Boolean.TRUE);
        this.m_dsEnv.put("STORAGE_TYPE_ATTRIBUTE", "PSE_STORAGE");
        DirectoryServiceFactory factory = new DirectoryServiceFactory(this.m_dsEnv);
        this.m_ds = factory.createDirectoryService(this.m_domainName, this.m_logger);
        return this.m_ds;
    }

    public void openReplicatedStorage(ILogger logger, String domainName, Hashtable dsEnv, Boolean isPrimary, Boolean startActive) throws Exception {
        File hostDir;
        this.m_logger = logger;
        this.m_logger.logMessage("Starting Directory Service Replication with the Start Active option " + (startActive != false ? "enabled" : "disabled"), 3);
        this.m_domainName = domainName;
        this.m_dsEnv = dsEnv;
        Integer tmp = (Integer)dsEnv.get("_TRACE_MASK");
        if (tmp != null) {
            this.m_traceMask = tmp;
        }
        if (!(hostDir = new File((String)dsEnv.get("HOST_DIRECTORY_ATTRIBUTE"))).exists()) {
            throw new DirectoryServiceException("Directory Service  host directory \"" + hostDir.getPath() + "\" was not found.");
        }
        File domainDir = new File(hostDir, domainName);
        if (!domainDir.exists() && !domainDir.mkdir()) {
            throw new DirectoryServiceException("Domain directory \"" + domainDir.getPath() + "\" was not found and could not be created.");
        }
        File storageDir = new File(domainDir, "data.odb");
        HashMap<String, Boolean> storageParameters = new HashMap<String, Boolean>();
        storageParameters.put("NO_READ_LOCK", Boolean.TRUE);
        storageParameters.put("REPLICATION_RETRY_INTERVAL", (Boolean)dsEnv.get("RETRY_INTERVAL"));
        storageParameters.put("REPLICATION_PING_INTERVAL", (Boolean)dsEnv.get("PING_INTERVAL"));
        storageParameters.put("REPLICATION_FAILURE_DETECTION_TIMEOUT", (Boolean)dsEnv.get("FAILURE_DETECTION_TIMEOUT"));
        storageParameters.put("MAX_REPLICATION_LOG_SIZE", (Boolean)dsEnv.get("MAX_REPLICATION_LOG_SIZE"));
        storageParameters.put("REPLICATION_TIMEOUT", (Boolean)dsEnv.get("REPLICATION_TIMEOUT"));
        storageParameters.put("REPLICATION_SSL", (Boolean)dsEnv.get("SSL_PARAMETERS"));
        boolean trace = (this.m_traceMask & 0x1000) > 0;
        boolean trace_verbose = (this.m_traceMask & 1) > 0;
        Storage.setReplicationTracing(trace, trace_verbose);
        storageParameters.put("_TEMPORARY_CONNECTION", Boolean.TRUE);
        this.m_stateHandler = new DSStateHandler();
        try {
            this.m_dsStorage = Storage.openStorage(new DSReplicationConroller(), this.m_stateHandler, storageDir.getAbsolutePath(), storageParameters, isPrimary, startActive, (Boolean)dsEnv.get("DUAL_ACTIVE_RESOLUTION"), (HashMap[])dsEnv.get("REPLICATION_CONNECTIONS"));
        }
        catch (Exception e) {
            this.m_logger.logMessage("Failed to open the Directory Service store: " + e.toString(), 1);
            System.exit(4);
        }
    }

    public IDirectoryAdminService getReplicatedDS() throws Exception {
        if (this.m_dsStorage == null || this.m_stateHandler == null) {
            throw new Exception("Storage is not open.");
        }
        return this.getDSWhenReady(this.m_stateHandler);
    }

    private IDirectoryAdminService getDSWhenReady(DSStateHandler stateHandler) throws Exception {
        stateHandler.waitForInitialState();
        if (!stateHandler.m_activationStarted) {
            return null;
        }
        if (stateHandler.waitForActivation()) {
            return this.m_ds;
        }
        if (stateHandler.m_activationFailure != null) {
            if (stateHandler.m_activationFailure instanceof Exception) {
                throw (Exception)stateHandler.m_activationFailure;
            }
            throw new Exception(stateHandler.m_activationFailure.toString());
        }
        throw new Exception("Failed to open the Directory Service");
    }

    public void close() throws Exception {
        if (this.m_ds != null) {
            this.m_ds.close();
        }
        this.m_ds = null;
        if (this.m_dsStorage != null) {
            this.m_dsStorage.close();
        }
        this.m_dsStorage = null;
        if (this.m_stateHandler != null) {
            this.m_stateHandler.close();
        }
    }

    private class DSReplicationConroller
    extends ReplicationController {
        private DSReplicationConroller() {
        }

        @Override
        public boolean allowedToGetActive() {
            return true;
        }
    }

    private class DSStateHandler
    extends ReplicationStateHandler {
        private boolean m_gotInitialState = false;
        private boolean m_activationSucceeded = false;
        private boolean m_activationFailed = false;
        private boolean m_activationStarted = false;
        Throwable m_activationFailure = null;

        private DSStateHandler() {
        }

        @Override
        public void newState(short state) {
            if (state == 5) {
                LocalDirectoryService.this.m_logger.logMessage("Using Deep Synchronization to replicate the Directory Service", 3);
            }
            if (state == 4) {
                LocalDirectoryService.this.m_logger.logMessage("The Directory Service is performing replication synchronization", 3);
            }
            if ((LocalDirectoryService.this.m_traceMask & 0x1000) != 0) {
                LocalDirectoryService.this.m_logger.logMessage("Storage replication state changed to " + DSStateHandler.stateToString(state), 7);
            }
            this.setState(state);
        }

        @Override
        public void shutdownState(String shutdownReason, Exception e) {
            LocalDirectoryService.this.m_logger.logMessage(shutdownReason, e, 1);
            int exitCode = 4;
            if (shutdownReason != null && shutdownReason.indexOf("Both") != -1 && shutdownReason.indexOf("unreplicated") != -1) {
                exitCode = 11;
            }
            System.exit(exitCode);
        }

        @Override
        public void newMessage(String message, boolean warning) {
            LocalDirectoryService.this.m_logger.logMessage(message, warning ? 2 : 3);
        }

        private synchronized void setActivationResult(boolean ok, Throwable failureCause) {
            if (ok) {
                this.m_activationSucceeded = true;
            } else {
                this.m_activationFailed = true;
                this.m_activationFailure = failureCause;
            }
            this.notifyAll();
        }

        private synchronized void close() {
            LocalDirectoryService.this.m_closing = true;
            this.notifyAll();
        }

        private synchronized void setState(short state) {
            this.m_gotInitialState = true;
            this.notifyAll();
            if (state == 2 || state == 1) {
                this.activateInThread();
            }
        }

        private synchronized void waitForInitialState() throws InterruptedException {
            while (!this.m_gotInitialState && !LocalDirectoryService.this.m_closing) {
                this.wait();
            }
        }

        private synchronized boolean waitForActivation() throws InterruptedException {
            while (!(this.m_activationSucceeded || this.m_activationFailed || LocalDirectoryService.this.m_closing)) {
                this.wait();
            }
            return this.m_activationSucceeded;
        }

        private void activateInThread() {
            if (this.m_activationStarted) {
                return;
            }
            this.m_activationStarted = true;
            if (LocalDirectoryService.this.m_closing) {
                return;
            }
            Thread activation = new Thread("com.sonicsw.mf.framework.agent.ci.LocalDirectoryService launcher Fault Tolerant Activation Thread"){

                @Override
                public void run() {
                    try {
                        if (LocalDirectoryService.this.m_closing) {
                            return;
                        }
                        LocalDirectoryService.this.getDS();
                        DSStateHandler.this.setActivationResult(true, null);
                    }
                    catch (Throwable t) {
                        DSStateHandler.this.setActivationResult(false, t);
                    }
                }
            };
            activation.setDaemon(true);
            activation.start();
        }
    }

    static class TestLogger
    implements ILogger {
        TestLogger() {
        }

        @Override
        public void logMessage(String message, Throwable exception, int severityLevel) {
            System.out.println(message + " Cause: ");
            exception.printStackTrace();
        }

        @Override
        public void logMessage(String message, int severityLevel) {
            System.out.println(message);
        }
    }
}

