/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.ContainerResources;
import com.sonicsw.mf.framework.agent.ci.HostHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public final class StartContainerCommand {
    private static boolean ON_WINDOWS = File.separatorChar == '\\';
    private static final String WHITE_SPACE_CHARS = " \t\r\n\f";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    private static final String DEV_JVM_ARGS_PROPERTY = "sonicsw.mf.devJVMArgs";
    private static final String CONTAINER_CLASS = "com.sonicsw.mf.framework.agent.ci.Agent";
    private static final String QUOTE_STRING = "\"";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ContainerResources[] m_deployments;
    private int lastDeploymentIndex;
    private String m_jvmHome;
    private String m_devArgsFileName;
    private String m_nativePath;
    private QuotedItemsList m_execCommand;
    private ILogger m_logger;
    private boolean m_doRestart;

    public StartContainerCommand(ContainerResources[] deployments, String jvmHome, ILogger logger) throws Exception {
        this.m_logger = logger;
        this.m_doRestart = false;
        this.m_deployments = deployments;
        this.m_jvmHome = jvmHome;
        this.lastDeploymentIndex = this.m_deployments.length - 1;
    }

    StartContainerCommand(ContainerResources[] deployments, String jvmHome, ILogger logger, boolean doRestart) throws Exception {
        this.m_logger = logger;
        this.m_doRestart = doRestart;
        this.m_deployments = deployments;
        this.m_jvmHome = jvmHome;
        this.lastDeploymentIndex = this.m_deployments.length - 1;
    }

    public void createExecCommand(boolean doQuote, boolean specifyLibraryPath) throws Exception {
        String publicHost;
        String privateHost;
        HashMap systemProperties;
        String actionalAOPproperty;
        String d64;
        this.m_execCommand = new QuotedItemsList(doQuote);
        this.m_execCommand.add(this.m_jvmHome + File.separatorChar + "bin" + File.separatorChar + "java" + (ON_WINDOWS ? ".exe" : ""));
        if (this.m_doRestart) {
            this.m_execCommand.add("-Dsonicsw.mf.launcher_upgrade_restart=true");
        }
        if (this.m_deployments.length == 1) {
            this.m_execCommand.add("-Dsonicsw.mf.id=" + this.m_deployments[this.lastDeploymentIndex].m_containerName);
        }
        if ((d64 = System.getProperty("sonicsw.mf.dev.d64")) != null && d64.equalsIgnoreCase("true")) {
            this.m_execCommand.add("-d64");
        }
        this.m_execCommand.addAll((Collection)this.extractJVMArgs());
        String[] bootList = this.m_deployments[this.lastDeploymentIndex].m_classpath.getBootClasspath();
        if (bootList.length > 0) {
            this.m_execCommand.add("-Xbootclasspath:" + StartContainerCommand.createClasspathString(bootList));
        }
        if ((bootList = this.m_deployments[this.lastDeploymentIndex].m_classpath.getBootPrependClasspath()).length > 0) {
            this.m_execCommand.add("-Xbootclasspath/p:" + StartContainerCommand.createClasspathString(bootList));
        }
        if ((bootList = this.m_deployments[this.lastDeploymentIndex].m_classpath.getBootAppendClasspath()).length > 0) {
            this.m_execCommand.add("-Xbootclasspath/a:" + StartContainerCommand.createClasspathString(bootList));
        }
        this.m_nativePath = this.generateNativePath(specifyLibraryPath);
        if (specifyLibraryPath) {
            this.m_execCommand.add("-Djava.library.path=" + this.m_nativePath);
        }
        if (this.m_deployments[this.lastDeploymentIndex].m_localDSParam != null && this.m_deployments[this.lastDeploymentIndex].m_localDSParam.m_isFaultTolerant.booleanValue()) {
            String fsSanityProperty = this.m_deployments[this.lastDeploymentIndex].m_localDSParam.m_isBackup ? "-Dsonicsw.mf.ds.backup=true" : "-Dsonicsw.mf.ds.primary=true";
            this.m_execCommand.add(fsSanityProperty);
        }
        if ((actionalAOPproperty = (String)(systemProperties = this.m_deployments[this.lastDeploymentIndex].m_systemProps.getProperties()).get("com.actional.aops")) != null && actionalAOPproperty.length() > 0) {
            if (this.m_deployments[this.lastDeploymentIndex].m_actionalPlugMakerArchive == null) {
                throw new Exception("The ACTIONAL_PLUGMAKER_ARCHIVE_NAME attribute is missing from the container's configuration or the archive could not be found.");
            }
            this.m_execCommand.add("-javaagent:" + this.m_deployments[this.lastDeploymentIndex].m_actionalPlugMakerArchive.getPath());
        }
        systemProperties.remove("sonicsw.mf.id");
        systemProperties.remove("sonicsw.mf.container_archive_root");
        for (String propName : systemProperties.keySet()) {
            String propValue = (String)systemProperties.get(propName);
            if (propValue == null) {
                propValue = "MISSING_FROM_CACHE";
            }
            this.m_execCommand.add("-D" + propName + "=" + propValue);
        }
        String skipEC2 = this.m_execCommand.getProperty("-Dsonicsw.mf.skipEC2Checks");
        String traceEC2 = this.m_execCommand.getProperty("-Dsonicsw.mf.traceEC2Checks");
        String timeoutEC2 = this.m_execCommand.getProperty("-Dsonicsw.mf.timeoutEC2Checks");
        int timeout = 2000;
        try {
            timeout = Integer.parseInt(timeoutEC2);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        HostHelper hostHelper = new HostHelper(this.m_logger, skipEC2 != null && skipEC2.equalsIgnoreCase("true"), traceEC2 != null && traceEC2.equalsIgnoreCase("true"), timeout);
        if (this.m_execCommand.getProperty("-Dsonicsw.mf.privateHost") == null && (privateHost = hostHelper.getPrivateHost()) != null) {
            this.m_execCommand.add("-Dsonicsw.mf.privateHost=" + privateHost);
        }
        if (this.m_execCommand.getProperty("-Dsonicsw.mf.publicHost") == null && (publicHost = hostHelper.getPublicHost()) != null) {
            this.m_execCommand.add("-Dsonicsw.mf.publicHost=" + publicHost);
        }
        ContainerUtil.storeCachePassword(new File(this.m_deployments[this.lastDeploymentIndex].m_cacheHostDirectoryName), this.m_deployments[this.lastDeploymentIndex].m_extractedConfig.m_cachePassword);
        String[] containerClasspathList = this.m_deployments[this.lastDeploymentIndex].m_configClasspath.getSubstitutedResources();
        if (this.m_deployments[this.lastDeploymentIndex].m_actionalSDKArchive.exists()) {
            String[] newList = new String[containerClasspathList.length + 1];
            System.arraycopy(containerClasspathList, 0, newList, 0, containerClasspathList.length);
            newList[newList.length - 1] = this.m_deployments[this.lastDeploymentIndex].m_actionalSDKArchive.getPath();
            containerClasspathList = newList;
        }
        if (containerClasspathList.length > 0) {
            this.m_execCommand.add("-Dsonicsw.mf.containerClasspath=" + StartContainerCommand.createClasspathString(containerClasspathList));
        }
        String[] archiveClasspathList = this.m_deployments[this.lastDeploymentIndex].m_classpath.getLaunchClasspath();
        String[] classpathList = StartContainerCommand.mergeLists(System.getProperty("sonicsw.mf.devPrivateClasspath"), containerClasspathList, archiveClasspathList);
        if (classpathList.length > 0) {
            this.m_execCommand.add("-cp");
            this.m_execCommand.add(StartContainerCommand.createClasspathString(classpathList));
        }
        this.m_execCommand.add(CONTAINER_CLASS);
        this.m_execCommand.add(this.m_deployments[this.lastDeploymentIndex].m_cacheHostDirectoryName);
        String containerNames = this.m_deployments[0].m_containerName;
        String containerIDs = this.m_deployments[0].m_containerID;
        if (this.m_deployments.length > 1) {
            for (int i = 1; i < this.m_deployments.length; ++i) {
                containerNames = containerNames + ',' + this.m_deployments[i].m_containerName;
                containerIDs = containerIDs + ',' + this.m_deployments[i].m_containerID;
            }
        }
        this.m_execCommand.add(containerNames);
        this.m_execCommand.add(containerIDs);
    }

    String getNativePath() {
        return this.m_nativePath;
    }

    private String generateNativePath(boolean appendExistingPath) throws Exception {
        String sonicNativePath = this.m_deployments[this.lastDeploymentIndex].getNativeLibDirectory();
        String configNativePath = this.m_deployments[this.lastDeploymentIndex].m_extractedConfig.m_configNativePath;
        if (configNativePath != null && configNativePath.length() > 0) {
            sonicNativePath = sonicNativePath + File.pathSeparatorChar + configNativePath;
        }
        String systemNativePath = null;
        if (appendExistingPath) {
            systemNativePath = System.getProperty("java.library.path");
        }
        if (systemNativePath != null && systemNativePath.length() > 0) {
            sonicNativePath = sonicNativePath + File.pathSeparatorChar + systemNativePath;
        }
        if (ON_WINDOWS && sonicNativePath != null) {
            sonicNativePath = (sonicNativePath = sonicNativePath.replaceAll(QUOTE_STRING, "")).endsWith("\\") ? sonicNativePath.substring(0, sonicNativePath.length() - 1) : sonicNativePath;
        }
        return sonicNativePath;
    }

    public ArrayList getCommandArray() {
        return this.m_execCommand;
    }

    public String getCommandString() {
        return this.toString(false);
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean withNewline) {
        StringBuffer stBuffer = new StringBuffer();
        for (int i = 0; i < this.m_execCommand.size(); ++i) {
            stBuffer.append((String)this.m_execCommand.get(i));
            if (withNewline) {
                stBuffer.append(IContainer.NEWLINE);
                continue;
            }
            stBuffer.append(' ');
        }
        return stBuffer.toString();
    }

    private ArrayList extractJVMArgs() throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        HashMap jvmArgs = this.m_deployments[this.lastDeploymentIndex].m_extractedConfig.m_jvmArgs;
        String configuredArgs = null;
        boolean serverOption = false;
        if (jvmArgs.containsKey("-server")) {
            jvmArgs.remove("-server");
            serverOption = true;
        }
        if (jvmArgs.containsKey("_MF_CONFIGURED_JVM_OPTIONS")) {
            configuredArgs = (String)jvmArgs.remove("_MF_CONFIGURED_JVM_OPTIONS");
        }
        for (String arg : jvmArgs.keySet()) {
            String value = (String)jvmArgs.get(arg);
            if (value == null) {
                value = "";
            }
            argList.add(arg + value);
        }
        argList.addAll(StartContainerCommand.getOptionList(configuredArgs));
        this.addDevelopmentArgs(argList);
        boolean clientOption = false;
        for (int i = 0; i < argList.size(); ++i) {
            if (!argList.get(i).equals("-client")) continue;
            clientOption = true;
        }
        if (serverOption && !clientOption) {
            argList.add(0, "-server");
        }
        return argList;
    }

    private static ArrayList getOptionList(String src) {
        int lastOptionIndex;
        ArrayList<String> list = new ArrayList<String>();
        if (src == null) {
            return list;
        }
        while ((lastOptionIndex = StartContainerCommand.getLastOptionIndex(src = src.trim())) != -1) {
            list.add(src.substring(lastOptionIndex));
            src = src.substring(0, lastOptionIndex);
        }
        Collections.reverse(list);
        return list;
    }

    private static int getLastOptionIndex(String src) {
        for (int i = src.length() - 1; i >= 0; --i) {
            boolean dashFound;
            boolean bl = dashFound = src.charAt(i) == '-';
            if (!dashFound || i != 0 && WHITE_SPACE_CHARS.indexOf(src.charAt(i - 1)) == -1) continue;
            return i;
        }
        return -1;
    }

    private void addDevelopmentArgs(ArrayList argList) throws IOException {
        this.m_devArgsFileName = System.getProperty(DEV_JVM_ARGS_PROPERTY);
        if (this.m_devArgsFileName == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.m_devArgsFileName)));
        String line = reader.readLine();
        reader.close();
        if (line == null || line.length() == 0) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(line);
        while (tokens.hasMoreElements()) {
            argList.add(tokens.nextToken());
        }
    }

    private static String[] mergeLists(String developmentClasspath, String[] classpathList0, String[] classpathList1) {
        int i;
        String[] merged = new String[classpathList0.length + classpathList1.length + (developmentClasspath != null ? 1 : 0)];
        int startIdx = 0;
        if (developmentClasspath != null) {
            startIdx = 1;
            merged[0] = developmentClasspath;
        }
        for (i = 0; i < classpathList0.length; ++i) {
            merged[i + startIdx] = classpathList0[i];
        }
        i = classpathList0.length;
        for (int count = 0; count < classpathList1.length; ++count) {
            merged[i + startIdx] = classpathList1[count];
            ++i;
        }
        return merged;
    }

    static String createClasspathString(String[] classpathList) {
        StringBuffer classpathString = new StringBuffer();
        for (int i = 0; i < classpathList.length; ++i) {
            if (classpathList[i] == null) continue;
            classpathString.append(classpathList[i]);
            if (i + 1 >= classpathList.length) continue;
            classpathString.append(PATH_SEPARATOR);
        }
        return classpathString.toString();
    }

    private class QuotedItemsList
    extends ArrayList {
        String m_quote;

        QuotedItemsList(boolean doQuote) {
            this.m_quote = doQuote ? StartContainerCommand.QUOTE_STRING : "";
        }

        @Override
        public boolean add(Object item) {
            return super.add(this.m_quote + item.toString() + this.m_quote);
        }

        @Override
        public boolean addAll(Collection c) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
            return c.size() != 0;
        }

        public String getProperty(String propertyName) {
            String matchStr = this.m_quote + propertyName + '=';
            String propertyValue = null;
            for (Object obj : this) {
                String str = (String)obj;
                if (!str.startsWith(matchStr)) continue;
                propertyValue = str.substring(matchStr.length(), str.length() - this.m_quote.length());
                break;
            }
            return propertyValue;
        }
    }
}

