/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.ILogger;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.ci.CILogger;
import com.sonicsw.mf.jmx.client.DirectoryServiceProxy;
import com.sonicsw.mf.jmx.client.JMSConnectorAddress;
import com.sonicsw.mf.jmx.client.JMSConnectorClient;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;

final class StoreFilesUtility {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String MF_FILE = "MF_FILE";
    private String m_containerBootFileName;
    private JMSConnectorClient m_connector;
    private IDirectoryFileSystemService m_ds;
    private static ILogger m_logger = new CILogger("DS File Utility");
    ExtractedContainerConfig m_extractedConfig;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: java com.sonicsw.mf.framework.agent.ci.SetCIConfigUtility containerbootFile copyList");
            System.exit(1);
        }
        try {
            new StoreFilesUtility(args[0], args[1]);
        }
        catch (Throwable t) {
            StoreFilesUtility.logMessage("", t, 1);
            System.exit(1);
        }
    }

    StoreFilesUtility(String containerBootFileName, String listFile) throws Exception {
        File containerBootFile = new File(containerBootFileName);
        this.m_containerBootFileName = containerBootFile.getAbsolutePath();
        if (!(containerBootFile.exists() && containerBootFile.isFile() && containerBootFile.canRead())) {
            String problem = !containerBootFile.exists() ? " not found." : " cannot be read";
            String errMessage = "Bootfile " + containerBootFileName + problem;
            StoreFilesUtility.logMessage(errMessage, 1);
            throw new Exception(errMessage);
        }
        StoreFilesUtility.logMessage("Open container boot file \"" + containerBootFile.getAbsolutePath() + '\"', 3);
        IDirElement containerConfiguration = ContainerUtil.importConfiguration(containerBootFile, IContainer.PASSWORD);
        IAttributeSet configAttributes = containerConfiguration.getAttributes();
        ExtractedContainerConfig bootExtractedConfig = new ExtractedContainerConfig();
        this.extractConfigInfo(configAttributes, bootExtractedConfig);
        StoreFilesUtility.logMessage("Starting to store files...", 3);
        this.createDSProxy(this.createConnector(configAttributes), bootExtractedConfig.m_domainName);
        this.storeFiles(listFile);
        StoreFilesUtility.logMessage("...store complete", 3);
        System.exit(0);
    }

    private void storeFile(String filePath, String dsFolder) throws Exception {
        StoreFilesUtility.logMessage("Store " + filePath + " in " + dsFolder, 3);
        File file = new File(filePath);
        EntityName eFolderName = new EntityName(dsFolder);
        String[] nameComponents = eFolderName.getNameComponents();
        String currentLevel = "";
        for (int i = 0; i < nameComponents.length; ++i) {
            currentLevel = currentLevel + "/" + nameComponents[i];
            this.m_ds.createFolder(currentLevel, true);
        }
        EntityName eDsFilePath = eFolderName.createChild(file.getName());
        IDirElement envelopeElement = this.m_ds.getFSElement(eDsFilePath.getName(), true);
        if (envelopeElement == null) {
            envelopeElement = ElementFactory.createElement(eDsFilePath.getName(), MF_FILE, "107");
        }
        BufferedInputStream bIn = new BufferedInputStream(new FileInputStream(filePath));
        this.m_ds.attachFSBlob(envelopeElement.doneUpdate(), bIn);
    }

    private void storeFiles(String listFileName) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(listFileName)));
        while ((line = reader.readLine()) != null) {
            int eqIndex = line.indexOf(61);
            String dsFolder = line.substring(0, eqIndex);
            String fsFile = line.substring(eqIndex + 1);
            this.storeFile(fsFile, dsFolder);
        }
    }

    private void createDSProxy(JMSConnectorClient connector, String domainName) throws Exception {
        this.m_ds = new DirectoryServiceProxy(connector, new ObjectName(domainName + "." + "DIRECTORY SERVICE:ID=DIRECTORY SERVICE"));
    }

    private void extractConfigInfo(IAttributeSet containerAttrs, ExtractedContainerConfig containerConfig) throws Exception {
        containerConfig.m_domainName = (String)containerAttrs.getAttribute("DOMAIN_NAME");
        if (containerConfig.m_domainName == null) {
            containerConfig.m_domainName = "Domain1";
        }
        containerConfig.m_containerName = (String)containerAttrs.getAttribute("CONTAINER_NAME");
        containerConfig.m_classpath = (String)containerAttrs.getAttribute("CLASSPATH");
        containerConfig.m_deployTraceMask = (Integer)containerAttrs.getAttribute("TRACE_MASK");
        if (containerConfig.m_deployTraceMask == null) {
            containerConfig.m_deployTraceMask = new Integer(0);
        }
        IAttributeSet cacheAttrs = (IAttributeSet)containerAttrs.getAttribute("CACHE");
        containerConfig.m_cacheHostDirectoryName = (String)cacheAttrs.getAttribute("CACHE_DIRECTORY");
        if (containerConfig.m_cacheHostDirectoryName == null) {
            containerConfig.m_cacheHostDirectoryName = "./container.cache";
        }
        containerConfig.m_cachePassword = (String)cacheAttrs.getAttribute("PASSWORD");
        IAttributeSet jvmArgs = (IAttributeSet)containerAttrs.getAttribute("JVM_ARGUMENTS");
        containerConfig.m_jvmArgs = jvmArgs != null ? jvmArgs.getAttributes() : new HashMap();
    }

    private JMSConnectorClient createConnector(IAttributeSet configAttributes) throws Exception {
        Integer socketConnectTimeout;
        Integer connectTimeout;
        IAttributeSet connectionAttrs = (IAttributeSet)configAttributes.getAttribute("CONNECTION");
        Map factoryAttrs = (Map)connectionAttrs.getAttributes().clone();
        factoryAttrs.remove("MANAGEMENT_NODE");
        factoryAttrs.remove("REQUEST_TIMEOUT");
        factoryAttrs.remove("CONNECT_TIMEOUT");
        factoryAttrs.remove("SOCKET_CONNECT_TIMEOUT");
        Hashtable<String, String> env = new Hashtable<String, String>(factoryAttrs);
        if (env.get("ConnectionURLs") == null) {
            env.put("ConnectionURLs", "tcp://localhost:2506");
        }
        JMSConnectorAddress address = new JMSConnectorAddress(env);
        String managementNode = (String)connectionAttrs.getAttribute("MANAGEMENT_NODE");
        if (managementNode != null && managementNode.length() > 0) {
            address.setManagementNode(managementNode);
        }
        JMSConnectorClient connector = new JMSConnectorClient();
        Integer requestTimeout = (Integer)connectionAttrs.getAttribute("REQUEST_TIMEOUT");
        if (requestTimeout != null) {
            connector.setRequestTimeout(requestTimeout * 1000);
        }
        if ((connectTimeout = (Integer)connectionAttrs.getAttribute("CONNECT_TIMEOUT")) != null) {
            connector.setConnectTimeout(connectTimeout * 1000);
        }
        if ((socketConnectTimeout = (Integer)connectionAttrs.getAttribute("SOCKET_CONNECT_TIMEOUT")) != null) {
            connector.setSocketConnectTimeout(socketConnectTimeout * 1000);
        }
        StoreFilesUtility.logMessage("Connecting to the Directory Service", 3);
        connector.connect(address);
        this.m_connector = connector;
        return connector;
    }

    static void logMessage(String message, int severityLevel) {
        m_logger.logMessage(message, severityLevel);
    }

    static void logMessage(String message, Throwable t, int severityLevel) {
        m_logger.logMessage(message, t, severityLevel);
    }

    private static class ExtractedContainerConfig
    implements Serializable {
        String m_domainName = null;
        String m_containerName = null;
        String m_classpath = null;
        Integer m_deployTraceMask = null;
        String m_cacheHostDirectoryName = null;
        String m_cachePassword = null;
        HashMap m_jvmArgs;

        private ExtractedContainerConfig() {
        }

        ExtractedContainerConfig deepClone() {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(out);
                objectOut.writeObject(this);
                byte[] bytes = out.toByteArray();
                objectOut.close();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream objectIn = new ObjectInputStream(in);
                return (ExtractedContainerConfig)objectIn.readObject();
            }
            catch (Exception e) {
                throw new Error("deepClone failed.");
            }
        }
    }
}

