/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent.ci;

import com.sonicsw.mf.common.ILogger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public final class SystemProperties {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String VENDOR = System.getProperty("java.vm.vendor");
    private static final String PASS_THROUGH_PREFIX = "_pass_to_container_jvm";
    private static final String JAVA_PROTOCOL = "java.protocol";
    private static final int JAVA_PROTOCOL_LENGTH = "java.protocol".length();
    private static final String SONIC = "sonic";
    private static final int SONIC_LENGTH = "sonic".length();
    private static String[] EXCLUDE_IF_STARTS_WITH = new String[]{"com.ibm", "console.encoding"};
    private static final HashSet PROPERTY_EXCLUSION_SET = new HashSet();
    private static final HashSet SONIC_FIRST_PHASE_ONLY;
    private HashMap m_properties;
    private String[] m_sonicfsResources;
    private HashMap m_sonicfsMarkers;
    private ILogger m_logger;

    public SystemProperties(HashMap properties0, ILogger logger, boolean addSystemProperties) throws Exception {
        HashMap<Object, Object> properties;
        HashMap<Object, Object> hashMap = properties = addSystemProperties ? new HashMap<Object, Object>(SystemProperties.filterSystemProperties()) : new HashMap();
        if (properties0 != null) {
            properties.putAll(properties0);
        }
        this.m_logger = logger;
        this.m_properties = properties;
        ArrayList<String> sonicfsResources = new ArrayList<String>();
        this.m_sonicfsMarkers = new HashMap();
        if (this.m_properties == null) {
            this.m_properties = new HashMap();
            this.m_sonicfsResources = EMPTY_STRING_ARRAY;
            return;
        }
        Iterator<Object> propKeys = properties.keySet().iterator();
        int count = 0;
        while (propKeys.hasNext()) {
            String key = (String)propKeys.next();
            String propValue = (String)properties.get(key);
            String path = this.getSonicfsPath(propValue);
            if (path == null) continue;
            sonicfsResources.add(path);
            this.m_sonicfsMarkers.put(new Integer(count++), key);
        }
        this.m_sonicfsResources = sonicfsResources.toArray(EMPTY_STRING_ARRAY);
    }

    public void addProps(HashMap properties) {
        if (properties != null) {
            this.m_properties.putAll(properties);
        }
    }

    static void connectionPropertiesFilter(HashMap table, boolean centralConnection) {
        int i;
        ArrayList<String> keepList = new ArrayList<String>();
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : table.keySet()) {
            Boolean centralConnectionPrefix = null;
            if (key.regionMatches(true, 0, "CentralConnection.", 0, "CentralConnection.".length())) {
                centralConnectionPrefix = Boolean.TRUE;
            } else if (key.regionMatches(true, 0, "connection.", 0, "connection.".length())) {
                centralConnectionPrefix = Boolean.FALSE;
            }
            if (centralConnectionPrefix == null) continue;
            if (centralConnection && centralConnectionPrefix.booleanValue() || !centralConnection && !centralConnectionPrefix.booleanValue()) {
                keepList.add(key);
                continue;
            }
            removeList.add(key);
        }
        for (i = 0; i < removeList.size(); ++i) {
            table.remove(removeList.get(i));
        }
        for (i = 0; i < keepList.size(); ++i) {
            String fullKey = (String)keepList.get(i);
            int prefixLengthToRemove = centralConnection ? "CentralConnection.".length() : "connection.".length();
            String key = fullKey.substring(prefixLengthToRemove);
            String value = (String)table.remove(fullKey);
            table.put(key, value);
        }
    }

    void mergePlatformDependentProps(HashMap dependentProperties) {
        dependentProperties.putAll(this.m_properties);
        this.m_properties = dependentProperties;
    }

    String[] getSonicfsResources() {
        return this.m_sonicfsResources;
    }

    HashMap getProperties() {
        return this.m_properties;
    }

    void substituteSonicfsResources(String[] substitutes) {
        for (int i = 0; i < substitutes.length; ++i) {
            this.m_properties.put(this.m_sonicfsMarkers.get(new Integer(i)), substitutes[i]);
        }
    }

    private String getSonicfsPath(String sonicfsPath) throws Exception {
        String dsClasspathPrefix = "sonicfs:///".substring(0, "sonicfs:///".length() - 1);
        if (sonicfsPath.length() > dsClasspathPrefix.length() && sonicfsPath.substring(0, dsClasspathPrefix.length()).equalsIgnoreCase(dsClasspathPrefix)) {
            if (sonicfsPath.charAt(dsClasspathPrefix.length()) != '/') {
                this.logMessage("The container system properties contain an invalid URL: " + sonicfsPath, 1);
                return null;
            }
            return sonicfsPath.substring("sonicfs:///".length() - 1);
        }
        return null;
    }

    void logMessage(String message, int severityLevel) {
        this.m_logger.logMessage(message, severityLevel);
    }

    void logMessage(String message, Throwable t, int severityLevel) {
        this.m_logger.logMessage(message, t, severityLevel);
    }

    private static Properties filterSystemProperties() {
        Properties filtered = new Properties();
        Properties sysProperties = System.getProperties();
        Enumeration<Object> keys = sysProperties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (SystemProperties.passThrough(key, sysProperties.getProperty(key), filtered) || !SystemProperties.inInclusionList(key) && SystemProperties.inExclusionList(key)) continue;
            filtered.setProperty(key, sysProperties.getProperty(key));
        }
        return filtered;
    }

    private static boolean passThrough(String key, String value, Properties filtered) {
        int dotIndx = key.indexOf(".");
        if (dotIndx < 0) {
            return false;
        }
        String firstComponent = key.substring(0, dotIndx);
        if (firstComponent.equalsIgnoreCase(PASS_THROUGH_PREFIX)) {
            String newKey = key.substring(dotIndx + 1);
            filtered.setProperty(newKey, value);
            return true;
        }
        return false;
    }

    private static boolean inExclusionList(String propKey) {
        if (SONIC_FIRST_PHASE_ONLY.contains(propKey)) {
            return true;
        }
        for (int i = 0; i < EXCLUDE_IF_STARTS_WITH.length; ++i) {
            if (!propKey.startsWith(EXCLUDE_IF_STARTS_WITH[i])) continue;
            return true;
        }
        int dotIndx = propKey.indexOf(".");
        String firstComponent = null;
        firstComponent = dotIndx < 0 ? propKey : propKey.substring(0, dotIndx);
        if (VENDOR.regionMatches(true, 0, firstComponent, 0, 3)) {
            return true;
        }
        return PROPERTY_EXCLUSION_SET.contains(firstComponent);
    }

    private static boolean inInclusionList(String propKey) {
        if (SONIC_FIRST_PHASE_ONLY.contains(propKey)) {
            return false;
        }
        if (propKey.regionMatches(true, 0, SONIC, 0, SONIC_LENGTH)) {
            return true;
        }
        return propKey.regionMatches(false, 0, JAVA_PROTOCOL, 0, JAVA_PROTOCOL_LENGTH);
    }

    static {
        PROPERTY_EXCLUSION_SET.add("invokedviajava");
        PROPERTY_EXCLUSION_SET.add("awt");
        PROPERTY_EXCLUSION_SET.add("javax");
        PROPERTY_EXCLUSION_SET.add("java");
        PROPERTY_EXCLUSION_SET.add("sun");
        PROPERTY_EXCLUSION_SET.add("ibm");
        PROPERTY_EXCLUSION_SET.add("path");
        PROPERTY_EXCLUSION_SET.add("file");
        PROPERTY_EXCLUSION_SET.add("user");
        PROPERTY_EXCLUSION_SET.add("os");
        PROPERTY_EXCLUSION_SET.add("line");
        SONIC_FIRST_PHASE_ONLY = new HashSet();
        SONIC_FIRST_PHASE_ONLY.add("sonicsw.mf.generate.sh");
    }
}

