/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.storage.fs;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSStorage;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class FSTransactionManager {
    private static final String NOTES_FILE_NAME = "notes";
    private static final String BEFORE_IMAGE_DIR_NAME = "before_image";
    private File m_tManagerDir;
    private File m_dataDir;
    private File m_beforeImageDir;
    private TransactionNotes m_trNotes;
    private boolean m_doSync;
    private boolean m_transactionOn;

    FSTransactionManager(File tManagerDir, File dataDir, boolean doSync) throws StorageException {
        this.m_tManagerDir = tManagerDir;
        this.m_dataDir = dataDir;
        this.m_beforeImageDir = null;
        this.m_trNotes = null;
        this.m_doSync = doSync;
        this.m_transactionOn = false;
        this.m_beforeImageDir = new File(this.m_tManagerDir, BEFORE_IMAGE_DIR_NAME);
        if (this.m_tManagerDir.exists()) {
            this.m_trNotes = new TransactionNotes(new File(this.m_tManagerDir, NOTES_FILE_NAME), this.m_doSync);
        }
    }

    void startTransaction() throws StorageException {
        if (this.m_transactionOn) {
            throw new Error();
        }
        if (!this.m_tManagerDir.exists() && !this.m_tManagerDir.mkdir()) {
            throw new StorageException("Cannot create the transaction manager directory '" + this.m_tManagerDir.getPath() + "'.");
        }
        if (!this.m_beforeImageDir.exists() && !this.m_beforeImageDir.mkdir()) {
            throw new StorageException("Cannot create the transaction manager directory '" + this.m_beforeImageDir.getPath() + "'.");
        }
        if (this.m_trNotes == null) {
            this.m_trNotes = new TransactionNotes(new File(this.m_tManagerDir, NOTES_FILE_NAME), this.m_doSync);
        }
        this.m_transactionOn = true;
    }

    void newDirectory(String newDirName) throws StorageException {
        if (!this.m_transactionOn) {
            return;
        }
        this.m_trNotes.addNewDirectory(newDirName);
    }

    void deleteDirectory(String deletedDirName) throws StorageException {
        if (!this.m_transactionOn) {
            return;
        }
        this.m_trNotes.addDeletedDirectory(deletedDirName);
    }

    void newElement(String newElementName) throws StorageException {
        if (!this.m_transactionOn) {
            return;
        }
        this.m_trNotes.addNewElement(newElementName);
    }

    void deleteElement(EntityName deletedElementName) throws StorageException {
        File dataImage;
        if (!this.m_transactionOn) {
            return;
        }
        String elementName = deletedElementName.getName();
        if (!this.m_trNotes.addDeletedElement(elementName)) {
            return;
        }
        String dirName = deletedElementName.getParent();
        EntityName dirNameE = this.getParsedName(dirName);
        if (!FSStorage.directoryExists(this.m_beforeImageDir, dirNameE)) {
            FSStorage.createDirectory(this.m_beforeImageDir, dirNameE, true, null);
        }
        if (!(dataImage = new File(this.m_dataDir, elementName.substring(1))).exists()) {
            return;
        }
        File beforeImage = new File(this.m_beforeImageDir, elementName.substring(1));
        try {
            if (!dataImage.renameTo(beforeImage)) {
                throw new StorageException("Failed creating before image for '" + dataImage.getPath() + "'.");
            }
        }
        catch (Exception e) {
            throw new StorageException("Failed creating before image for '" + dataImage.getPath() + "'.", e);
        }
    }

    void commit() throws StorageException {
        String[] deletedElements = this.m_trNotes.getDeletedElements();
        for (int i = 0; i < deletedElements.length; ++i) {
            FSStorage.fileForName(this.m_beforeImageDir, this.getParsedName(deletedElements[i]), false, null).delete();
        }
        this.m_trNotes.reset();
        this.m_transactionOn = false;
    }

    void close() throws StorageException {
        if (this.m_trNotes != null) {
            this.m_trNotes.close();
        }
    }

    void closeFiles() throws StorageException {
        if (this.m_trNotes != null) {
            this.m_trNotes.closeFile();
        }
    }

    void openFiles() throws StorageException {
        if (this.m_trNotes != null) {
            this.m_trNotes.openFile();
        }
    }

    void rollback() throws StorageException {
        int i;
        boolean hasDirEvents;
        if (this.m_trNotes == null) {
            return;
        }
        ArrayList dirEvents = this.m_trNotes.getDirectoryEvents();
        boolean bl = hasDirEvents = dirEvents.size() > 0;
        if (hasDirEvents && !this.m_trNotes.hasDirectoryCreateNotes()) {
            for (int i2 = dirEvents.size() - 1; i2 >= 0; --i2) {
                String dirName = (String)dirEvents.get(i2);
                FSStorage.fileForName(this.m_dataDir, this.getParsedName(dirName), false, null).mkdir();
            }
        }
        String[] newElements = this.m_trNotes.getNewElements();
        for (int i3 = 0; i3 < newElements.length; ++i3) {
            FSStorage.fileForName(this.m_dataDir, this.getParsedName(newElements[i3]), false, null).delete();
        }
        String[] deletedElements = this.m_trNotes.getDeletedElements();
        for (i = 0; i < deletedElements.length; ++i) {
            File beforeImage = new File(this.m_beforeImageDir, deletedElements[i].substring(1));
            if (!beforeImage.exists()) continue;
            File dataImage = new File(this.m_dataDir, deletedElements[i].substring(1));
            dataImage.delete();
            if (beforeImage.renameTo(dataImage)) continue;
            throw new StorageException("rollback: Failed restoring '" + dataImage.getPath() + "'.");
        }
        if (hasDirEvents && this.m_trNotes.hasDirectoryCreateNotes()) {
            for (i = dirEvents.size() - 1; i >= 0; --i) {
                String dirName = (String)dirEvents.get(i);
                FSStorage.fileForName(this.m_dataDir, this.getParsedName(dirName), false, null).delete();
            }
        }
        this.m_trNotes.reset();
        this.m_transactionOn = false;
    }

    private EntityName getParsedName(String name) {
        try {
            return new EntityName(name);
        }
        catch (ConfigException e) {
            throw new Error();
        }
    }

    private class TransactionNotes {
        private static final char DELETED_ELEMENT_TYPE = 'd';
        private static final char DELETED_DIR_TYPE = 'e';
        private static final char NEW_ELEMENT_TYPE = 'n';
        private static final char NEW_DIR_TYPE = 'o';
        private File m_notesFilePath;
        private boolean m_doSync;
        private RandomAccessFile m_notesFile;
        private HashMap m_newElements;
        private HashMap m_deletedElements;
        private ArrayList m_dirEvents;
        private boolean m_createDirEvents;
        private FileDescriptor m_notesDescriptor;

        TransactionNotes(File notesFilePath, boolean doSync) throws StorageException {
            String note;
            this.m_notesFilePath = notesFilePath;
            this.m_doSync = doSync;
            this.m_newElements = new HashMap();
            this.m_deletedElements = new HashMap();
            this.m_dirEvents = new ArrayList();
            this.m_createDirEvents = false;
            this.openFile();
            while ((note = this.readNextNote()) != null && note.length() != 0) {
                char noteType = note.charAt(0);
                if (noteType == 'n') {
                    this.m_newElements.put(note.substring(1), "");
                    continue;
                }
                if (noteType == 'd') {
                    this.m_deletedElements.put(note.substring(1), "");
                    continue;
                }
                if (noteType == 'o') {
                    this.m_createDirEvents = true;
                }
                this.m_dirEvents.add(note.substring(1));
            }
        }

        void close() throws StorageException {
            this.closeFile();
        }

        final void openFile() throws StorageException {
            try {
                this.m_notesFile = new RandomAccessFile(this.m_notesFilePath, "rw");
                this.m_notesDescriptor = this.m_notesFile.getFD();
            }
            catch (Exception e) {
                throw new StorageException(e.toString(), e);
            }
        }

        void closeFile() throws StorageException {
            try {
                if (this.m_notesFile != null) {
                    this.m_notesFile.close();
                }
            }
            catch (Exception e) {
                throw new StorageException(e.toString(), e);
            }
        }

        void reset() throws StorageException {
            this.m_newElements = new HashMap();
            this.m_deletedElements = new HashMap();
            this.m_dirEvents = new ArrayList();
            this.m_createDirEvents = false;
            try {
                this.m_notesFile.setLength(0L);
                if (this.m_doSync) {
                    this.m_notesDescriptor.sync();
                }
            }
            catch (Exception e) {
                throw new StorageException(e.toString(), e);
            }
        }

        String[] getDeletedElements() {
            return this.getElements(this.m_deletedElements);
        }

        String[] getNewElements() {
            return this.getElements(this.m_newElements);
        }

        ArrayList getDirectoryEvents() {
            return this.m_dirEvents;
        }

        boolean hasDirectoryCreateNotes() {
            return this.m_createDirEvents;
        }

        private String[] getElements(HashMap notesTable) {
            String[] result = new String[notesTable.size()];
            Iterator iterator = notesTable.keySet().iterator();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)iterator.next();
            }
            return result;
        }

        private String readNextNote() throws StorageException {
            try {
                return this.m_notesFile.readUTF();
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                throw new StorageException(e.toString(), e);
            }
        }

        void addDeletedDirectory(String dirName) throws StorageException {
            this.addDirectory(dirName, 'e');
        }

        void addNewDirectory(String dirName) throws StorageException {
            this.addDirectory(dirName, 'o');
        }

        void addDirectory(String dirName, char noteType) throws StorageException {
            if (noteType == 'o') {
                if (this.m_dirEvents.size() > 0 && !this.m_createDirEvents) {
                    throw new IllegalStateException("Directory creation & deletion cannot be mixed in a single transaction.");
                }
                this.m_createDirEvents = true;
            }
            this.m_dirEvents.add(dirName);
            try {
                this.m_notesFile.writeUTF(noteType + dirName);
                if (this.m_doSync) {
                    this.m_notesDescriptor.sync();
                }
            }
            catch (IOException e) {
                throw new StorageException(e.toString(), e);
            }
        }

        boolean addDeletedElement(String elementName) throws StorageException {
            return this.addElement(elementName, 'd');
        }

        boolean addNewElement(String elementName) throws StorageException {
            return this.addElement(elementName, 'n');
        }

        boolean addElement(String elementName, char noteType) throws StorageException {
            if (this.hasNoteFor(elementName)) {
                return false;
            }
            if (noteType == 'd') {
                this.m_deletedElements.put(elementName, "");
            } else {
                this.m_newElements.put(elementName, "");
            }
            try {
                this.m_notesFile.writeUTF(noteType + elementName);
                if (this.m_doSync) {
                    this.m_notesDescriptor.sync();
                }
            }
            catch (IOException e) {
                throw new StorageException(e.toString(), e);
            }
            return true;
        }

        private boolean hasNoteFor(String elementName) {
            return this.m_deletedElements.get(elementName) != null || this.m_newElements.get(elementName) != null;
        }
    }
}

