/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.util;

import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.ITaskScheduler;

public final class NotificationForwarder
implements INotificationHandler {
    private IFrameworkComponentContext m_context;
    private ITaskScheduler m_taskScheduler;
    private boolean m_debug = false;

    public NotificationForwarder(IFrameworkComponentContext context) {
        this.m_context = context;
        this.m_taskScheduler = this.m_context.getContainer().getTaskScheduler();
    }

    @Override
    public void handleNotification(final INotification notification) {
        Runnable invoker = new Runnable(){

            @Override
            public void run() {
                try {
                    if (NotificationForwarder.this.m_debug) {
                        NotificationForwarder.this.m_context.logMessage("Forwarding notification [" + notification.getType() + "] received from " + notification.getSourceIdentity().getCanonicalName(), 7);
                    }
                    notification.setAttribute("ForwardedBy", NotificationForwarder.this.m_context.getComponentName().getCanonicalName());
                    NotificationForwarder.this.m_context.sendNotification(notification);
                }
                catch (Exception e) {
                    String message = "Failed to forward notification: " + notification.getType() + " [source=" + notification.getSourceIdentity().getCanonicalName() + "], trace follows...";
                    NotificationForwarder.this.m_context.logMessage(message, e, 2);
                }
            }
        };
        this.m_taskScheduler.scheduleTask(invoker, false);
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }
}

