/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.util;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IMessageLogger;
import com.sonicsw.mf.framework.util.LogFile;
import com.sonicsw.mx.util.Sorter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;

public class RollingFileLogger
implements IMessageLogger {
    private static final boolean DEBUG = false;
    private IComponentContext m_context;
    private String m_logDirectoryPath;
    private String m_baseLogFileName;
    private LogFile m_currentLogFile;
    private long m_sizeThreshold;
    private int m_logRolloverTimeInterval;
    private long m_currentSizeThreshold;
    private long m_lastRecordedLength;
    private int m_physicalCheckCount = 10;
    private static final int PHYSICAL_CHECK_FREQUENCY = 10;
    static int LOG_ROLLOVER_CHECK_INTERVAL = 1440;
    static final int CALC_IN_MINS_FROM_SMC = -1;
    static final int CALC_IN_MINS_FROM_SYSTEM_PROPERTY = 0;
    static final int CALC_IN_HOURS_FROM_SYSTEM_PROPERTY = 1;
    static int CALCULATE_NEXT_ROLLOVER_TIME_IN = -1;
    private RolloverTask m_rolloverTask = null;
    private IOException m_lastIOException = null;
    private final Object m_lock = new Object();
    private static final long MAX_READ_LENGTH = 0x100000L;
    private static final long DEFAULT_READ_LENGTH = 204800L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LOGFAILURE_NOTIFICATION_TYPE = "Failure";
    private static final String LOGTHRESHOLD_NOTIFICATION_TYPE = "Threshold";
    private static final boolean QA_MODE = System.getProperty("sonicsw.mf.qa.abort") != null;

    public RollingFileLogger(String logDirectoryPath, String logFileNamePrefix) throws IOException {
        this(null, logDirectoryPath, logFileNamePrefix, LOG_ROLLOVER_CHECK_INTERVAL);
    }

    public RollingFileLogger(IComponentContext context, String logDirectoryPath, String logFileNamePrefix, int logRolloverTimeInterval) throws IOException {
        this.m_logRolloverTimeInterval = logRolloverTimeInterval;
        int interval = 1440;
        try {
            interval = Integer.getInteger("sonicsw.mf.logRolloverCheckIntervalMinutes");
            interval = interval > 0 && interval <= 1440 ? interval : 1440;
            CALCULATE_NEXT_ROLLOVER_TIME_IN = 0;
        }
        catch (Exception e) {
            try {
                interval = Integer.getInteger("sonicsw.mf.logRolloverCheckIntervalHours");
                interval = interval > 0 && interval <= 24 ? interval : 24;
                CALCULATE_NEXT_ROLLOVER_TIME_IN = 1;
            }
            catch (Exception e1) {
                interval = this.m_logRolloverTimeInterval;
            }
        }
        LOG_ROLLOVER_CHECK_INTERVAL = interval;
        File logFile = new File(logDirectoryPath);
        if (logFile.exists() && logFile.isFile()) {
            System.out.println("Renaming existing container log file \"" + logFile.getPath() + "\" to \"" + new File(logDirectoryPath + ".old\""));
            File renamedLogFile = new File(logDirectoryPath + ".old");
            logFile.renameTo(renamedLogFile);
            if (logFile.exists()) {
                System.out.println("Failed to rename existing container log file");
            }
        }
        this.m_baseLogFileName = logFileNamePrefix + ".log";
        this.m_context = context;
        this.resetLogDirectory(logDirectoryPath);
        if (this.m_context != null) {
            this.m_rolloverTask = new RolloverTask();
            this.m_rolloverTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_rolloverTask != null) {
                    this.m_context.cancelTask(this.m_rolloverTask);
                }
                this.m_currentLogFile.close();
                this.m_currentLogFile = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogFile() throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                File[] archiveLogFiles = this.getArchivedLogFiles(true);
                for (int i = 0; i < archiveLogFiles.length; ++i) {
                    archiveLogFiles[i].delete();
                }
                this.m_currentLogFile.clearLogFile();
                this.m_physicalCheckCount = 10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLogFile(String path) throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                this.m_currentLogFile.saveLogFile(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String logMessage) {
        logMessage = logMessage + LINE_SEPARATOR;
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                try {
                    this.m_currentLogFile.write(logMessage);
                    this.checkSizeThreshold(logMessage.length());
                    this.m_lastIOException = null;
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    this.handleIOExceptionOnWrite(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws InterruptedIOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                try {
                    this.m_currentLogFile.write(new String(new byte[]{(byte)b}));
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    this.handleIOExceptionOnWrite(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] bytes, int offset, int length) throws InterruptedIOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                try {
                    this.m_currentLogFile.write(new String(bytes, offset, length));
                    this.checkSizeThreshold(length);
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    this.handleIOExceptionOnWrite(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return 0L;
                }
                File[] archiveLogFiles = this.getArchivedLogFiles(false);
                long totalLength = 0L;
                for (int i = 0; i < archiveLogFiles.length; ++i) {
                    totalLength += archiveLogFiles[i].length();
                }
                return totalLength += this.m_currentLogFile.length();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetLogDirectory(String logDirectoryPath) throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                File logDirectory = new File(logDirectoryPath);
                if (logDirectory.exists() && !logDirectory.isDirectory()) {
                    throw new IOException("Log path is not a directory: " + logDirectoryPath);
                }
                if (!logDirectory.exists() && !logDirectory.mkdirs()) {
                    throw new IOException("Unable to create log directory: " + logDirectoryPath);
                }
                File newLogFilePath = new File(logDirectory, this.m_baseLogFileName);
                LogFile newLogFile = new LogFile(newLogFilePath.getPath(), false, this.m_context);
                this.m_logDirectoryPath = logDirectoryPath;
                if (this.m_currentLogFile != null) {
                    this.m_context.logMessage("Logging path changed to \"" + newLogFile.getLogPath() + '\"', 3);
                    this.m_currentLogFile.close();
                    LogFile oldLogFile = this.m_currentLogFile;
                    this.m_currentLogFile = newLogFile;
                    this.m_context.logMessage("Logging path changed from \"" + oldLogFile.getLogPath() + '\"', 3);
                } else {
                    this.m_currentLogFile = newLogFile;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRolloverThreshold(long rolloverThreshold) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                this.m_currentLogFile.setRolloverThreshold(rolloverThreshold);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSizeThreshold() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_sizeThreshold;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeThreshold(long sizeThreshold) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_sizeThreshold = sizeThreshold;
                this.m_currentSizeThreshold = sizeThreshold;
                if (this.m_context != null && this.length() > sizeThreshold) {
                    this.sendLogThresholdNotification(this.m_sizeThreshold, this.length());
                }
            }
        }
    }

    private void checkSizeThreshold(int messageLength) {
        if (this.m_context == null) {
            return;
        }
        if (++this.m_physicalCheckCount > 10) {
            this.m_lastRecordedLength = this.length();
            this.m_physicalCheckCount = 0;
        } else {
            this.m_lastRecordedLength += (long)messageLength;
        }
        if (this.m_lastRecordedLength > this.m_currentSizeThreshold) {
            this.m_currentSizeThreshold = (long)((double)this.m_currentSizeThreshold * 1.1);
            if (this.m_lastRecordedLength > this.m_currentSizeThreshold) {
                this.m_currentSizeThreshold = (long)((double)this.m_lastRecordedLength * 1.1);
            }
            this.m_context.logMessage("Container log size threshold exceeded, threshold=" + this.m_sizeThreshold + ", actual=" + this.m_lastRecordedLength, 2);
            this.sendLogThresholdNotification(this.m_sizeThreshold, this.m_lastRecordedLength);
        } else if (this.m_lastRecordedLength < this.m_sizeThreshold) {
            this.m_currentSizeThreshold = this.m_sizeThreshold;
        }
    }

    private void handleIOExceptionOnWrite(IOException e) {
        if (this.m_lastIOException != null && this.m_lastIOException.getMessage().equals(e.getMessage())) {
            return;
        }
        this.m_lastIOException = e;
        if (this.m_context == null) {
            System.err.println("Failed to write to log file: " + this.m_currentLogFile.getLogPath() + ", trace follows...");
            e.printStackTrace();
        } else {
            this.m_context.logMessage("Failed to write to log file: " + this.m_currentLogFile.getLogPath() + ", trace follows...", e, 1);
            this.sendLogFailureNotification(this.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(long fromPosn, long readLength) throws IOException {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return "<log to file disabled>".getBytes();
                }
                if (readLength > 0x100000L) {
                    throw new IllegalArgumentException("Cannot read more than 1.0Mb");
                }
                if (readLength == -1L) {
                    readLength = 204800L;
                }
                long remainderToBeRead = readLength;
                byte[] bytesRead = null;
                long currentLength = this.length();
                if (fromPosn > currentLength) {
                    return new byte[0];
                }
                if (fromPosn == -1L && (remainderToBeRead -= (long)(bytesRead = this.m_currentLogFile.read(fromPosn, readLength)).length) == 0L) {
                    return bytesRead;
                }
                ArrayList<byte[]> bytesReadList = new ArrayList<byte[]>();
                long totalBytesRead = 0L;
                if (bytesRead != null && bytesRead.length > 0) {
                    bytesReadList.add(bytesRead);
                    totalBytesRead += (long)bytesRead.length;
                }
                File[] archiveLogFiles = this.getArchivedLogFiles(true);
                if (fromPosn == -1L) {
                    for (int i = archiveLogFiles.length - 1; i >= 0; --i) {
                        long archiveLogFileLength = archiveLogFiles[i].length();
                        long archiveFromPosn = 0L;
                        long archiveReadLength = remainderToBeRead;
                        if (archiveLogFileLength < remainderToBeRead) {
                            archiveReadLength = archiveLogFileLength;
                        } else {
                            archiveFromPosn = archiveLogFileLength - remainderToBeRead;
                        }
                        LogFile archiveLogFile = new LogFile(archiveLogFiles[i].getPath(), true, this.m_context);
                        byte[] archiveBytes = archiveLogFile.read(archiveFromPosn, archiveReadLength);
                        archiveLogFile.close();
                        if (archiveBytes.length <= 0) continue;
                        bytesReadList.add(0, archiveBytes);
                        totalBytesRead += (long)archiveBytes.length;
                        remainderToBeRead -= (long)archiveBytes.length;
                    }
                } else {
                    long remainderToBeSkipped = fromPosn;
                    for (int i = 0; i < archiveLogFiles.length; ++i) {
                        long archiveLogFileLength = archiveLogFiles[i].length();
                        if (remainderToBeSkipped >= archiveLogFileLength) {
                            remainderToBeSkipped -= archiveLogFileLength;
                            continue;
                        }
                        long archiveFromPosn = remainderToBeSkipped;
                        long archiveReadLength = archiveLogFileLength - remainderToBeSkipped;
                        if (archiveLogFileLength - remainderToBeSkipped > remainderToBeRead) {
                            archiveReadLength = remainderToBeRead;
                        }
                        remainderToBeSkipped = 0L;
                        LogFile archiveLogFile = new LogFile(archiveLogFiles[i].getPath(), true, this.m_context);
                        byte[] archiveBytes = archiveLogFile.read(archiveFromPosn, archiveReadLength);
                        archiveLogFile.close();
                        if (archiveBytes.length > 0) {
                            bytesReadList.add(archiveBytes);
                            totalBytesRead += (long)archiveBytes.length;
                            remainderToBeRead -= (long)archiveBytes.length;
                        }
                        if (remainderToBeRead == 0L) break;
                    }
                    if (remainderToBeRead > 0L) {
                        byte[] currentLogBytes = this.m_currentLogFile.read(remainderToBeSkipped, remainderToBeRead);
                        bytesReadList.add(currentLogBytes);
                        totalBytesRead += (long)currentLogBytes.length;
                    }
                }
                bytesRead = new byte[(int)totalBytesRead];
                int offset = 0;
                for (int i = 0; i < bytesReadList.size(); ++i) {
                    byte[] bytes = (byte[])bytesReadList.get(i);
                    System.arraycopy(bytes, 0, bytesRead, offset, bytes.length);
                    offset += bytes.length;
                }
                return bytesRead;
            }
        }
    }

    private void sendLogThresholdNotification(long thresholdSize, long actualSize) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[1], LOGTHRESHOLD_NOTIFICATION_TYPE, 2);
        notification.setLogType((short)0);
        notification.setAttribute("Directory", this.m_logDirectoryPath);
        notification.setAttribute("BaseFilename", this.m_baseLogFileName);
        notification.setAttribute("ThresholdSize", new Long(thresholdSize));
        notification.setAttribute("ActualSize", new Long(actualSize));
        this.m_context.sendNotification(notification);
    }

    private void sendLogFailureNotification(long sizeAtFailure) {
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[1], LOGFAILURE_NOTIFICATION_TYPE, 1);
        notification.setLogType((short)2);
        notification.setAttribute("SizeAtFailure", new Long(sizeAtFailure));
        this.m_context.sendNotification(notification);
    }

    private File[] getArchivedLogFiles(boolean sort) {
        File logDirectoryPath = new File(this.m_logDirectoryPath);
        final String archiveFilenamePrefix = this.m_baseLogFileName + '.';
        FilenameFilter archiveFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File directory, String filename) {
                return filename.startsWith(archiveFilenamePrefix);
            }
        };
        Object[] archivedLogFiles = logDirectoryPath.listFiles(archiveFilenameFilter);
        if (archivedLogFiles == null) {
            return new File[0];
        }
        return sort ? (File[])Sorter.sort(archivedLogFiles) : archivedLogFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attemptLogFileRollover() throws IOException {
        if (!IContainer.QA_MODE) {
            throw new IllegalAccessError("Manual log file rollover attempt only permissible in QA mode!");
        }
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                this.m_currentLogFile.rollover();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_LogRolloverTimeInterval() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                return this.m_logRolloverTimeInterval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_LogRolloverTimeInterval(int logRolloverTimeInterval) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            Object object = this.m_lock;
            synchronized (object) {
                if (this.m_currentLogFile == null) {
                    return;
                }
                this.m_logRolloverTimeInterval = logRolloverTimeInterval;
            }
        }
    }

    private final class RolloverTask
    implements Runnable {
        private RolloverTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                Object object = RollingFileLogger.this.m_lock;
                synchronized (object) {
                    try {
                        if (RollingFileLogger.this.m_currentLogFile != null) {
                            RollingFileLogger.this.m_currentLogFile.rollover();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.schedule();
                    }
                }
            }
        }

        public void schedule() {
            Calendar nextRolloverAttemptTime = Calendar.getInstance();
            int nextRolloverInMillis = 0;
            if (CALCULATE_NEXT_ROLLOVER_TIME_IN == 1) {
                nextRolloverInMillis = this.getNextRolloverInMillisForHours(nextRolloverAttemptTime, LOG_ROLLOVER_CHECK_INTERVAL);
                this.calcNextRolloverTime(nextRolloverAttemptTime, nextRolloverInMillis);
            } else if (CALCULATE_NEXT_ROLLOVER_TIME_IN == 0) {
                nextRolloverInMillis = this.getRolloverInMillisForMins(nextRolloverAttemptTime, LOG_ROLLOVER_CHECK_INTERVAL);
                this.calcNextRolloverTime(nextRolloverAttemptTime, nextRolloverInMillis);
            } else {
                nextRolloverInMillis = this.getRolloverInMillisForMins(nextRolloverAttemptTime, RollingFileLogger.this.get_LogRolloverTimeInterval());
                this.calcNextRolloverTime(nextRolloverAttemptTime, nextRolloverInMillis);
            }
            RollingFileLogger.this.m_context.scheduleTask(this, nextRolloverAttemptTime.getTime());
        }

        private void calcNextRolloverTime(Calendar nextRolloverAttemptTime, int nextRolloverInMillis) {
            int dstDiff = nextRolloverAttemptTime.get(16);
            nextRolloverAttemptTime.add(13, -nextRolloverAttemptTime.get(13));
            nextRolloverAttemptTime.add(12, -nextRolloverAttemptTime.get(12));
            nextRolloverAttemptTime.add(11, -nextRolloverAttemptTime.get(11));
            nextRolloverAttemptTime.add(14, nextRolloverInMillis);
            nextRolloverAttemptTime.add(14, dstDiff - nextRolloverAttemptTime.get(16));
        }

        private int getRolloverInMillisForMins(Calendar nextRolloverAttemptTime, int logRolloverCheckInterval) {
            return ((nextRolloverAttemptTime.get(11) * 60 + nextRolloverAttemptTime.get(12)) / logRolloverCheckInterval + 1) * logRolloverCheckInterval * 60 * 1000;
        }

        private int getNextRolloverInMillisForHours(Calendar nextRolloverAttemptTime, int logRolloverCheckInterval) {
            return (nextRolloverAttemptTime.get(11) / logRolloverCheckInterval + 1) * logRolloverCheckInterval * 60 * 60 * 1000;
        }
    }
}

