/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.impl;

import com.sonicsw.sdf.AbstractDiagnosticsProvider;
import com.sonicsw.sdf.IDiagnosticsContext;
import com.sonicsw.sdf.impl.HotSpotHeapDump;
import com.sonicsw.sdf.impl.IBMHeapDump;
import java.util.HashMap;

public class JVMHeapDiagnostics
extends AbstractDiagnosticsProvider {
    private static final String SUPPORTED_LIST = "Heap dump generation requires: IBM JVM 1.4.2 (or higher) or HotSpot JVM 1.6 (or higher)";
    private static final String NOT_SUPPORTED_MESSAGE = "Heap dump generation is not supported by this JVM. ";
    private static String[] OPERATIONS;
    private static HashMap DUMP_STATE_PARAM_DESCIPTOR;
    private static HashMap DESCRIBE_PARAM_DESCIPTOR;
    private static HashMap PARAM_DESCRIPTOR;

    JVMHeapDiagnostics() {
        super("jvm.heap");
    }

    void setContext(IDiagnosticsContext diagContext) {
        this.m_diagnosticsContext = diagContext;
    }

    @Override
    public String describe() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("Generates diagnostics JVM heap dumps. ").append(SUPPORTED_LIST).append(NEWLINE);
        if (HotSpotHeapDump.heapDumpSupported()) {
            tmp.append(HotSpotHeapDump.describe());
        } else if (IBMHeapDump.heapDumpSupported()) {
            tmp.append(IBMHeapDump.describe());
        } else {
            tmp.append(NOT_SUPPORTED_MESSAGE);
        }
        return tmp.toString();
    }

    @Override
    public void appendStateDump(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
        if (HotSpotHeapDump.heapDumpSupported()) {
            if (parameters.isEmpty()) {
                HotSpotHeapDump.dumpHeap(buffer, this.m_diagnosticsContext);
            } else {
                HotSpotHeapDump.dumpHeap(buffer, this.m_diagnosticsContext, parameters);
            }
        } else if (IBMHeapDump.heapDumpSupported()) {
            IBMHeapDump.dumpHeap(buffer);
        } else {
            buffer.append(NOT_SUPPORTED_MESSAGE).append(SUPPORTED_LIST);
        }
    }

    @Override
    public HashMap describeParameters(String operationName) {
        return (HashMap)PARAM_DESCRIPTOR.get(operationName);
    }

    @Override
    public void updateTraceLevel(String doiID, HashMap parameters, StringBuffer buffer) {
    }

    @Override
    public String[] getOperations() {
        return OPERATIONS;
    }

    static {
        DUMP_STATE_PARAM_DESCIPTOR = new HashMap();
        DESCRIBE_PARAM_DESCIPTOR = new HashMap();
        PARAM_DESCRIPTOR = new HashMap();
        DUMP_STATE_PARAM_DESCIPTOR.put("overwrite", OP_PARAM_OVERWRITE_DESCRIPTION + " Default to false");
        DUMP_STATE_PARAM_DESCIPTOR.put("output", OP_PARAM_OUTPUT_LOCATION_DESCRIPTION);
        DUMP_STATE_PARAM_DESCIPTOR.put("output_access", OP_PARAM_FILE_ACCESS_DESCRIPTION + " Default to 'rw-------'");
        PARAM_DESCRIPTOR.put("dumpState", DUMP_STATE_PARAM_DESCIPTOR);
        PARAM_DESCRIPTOR.put("describe", DESCRIBE_PARAM_DESCIPTOR);
        OPERATIONS = AbstractDiagnosticsProvider.toOpnameArray(PARAM_DESCRIPTOR);
    }
}

