/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.threads;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ThreadCPUStats {
    private Map<Long, StatEntry> m_stats;

    public ThreadCPUStats(int initialCapacity) {
        this.m_stats = new HashMap<Long, StatEntry>(initialCapacity);
    }

    public void addStat(long threadId, long totalUsage) {
        this.m_stats.put(threadId, new StatEntry(threadId, totalUsage));
    }

    public StatEntry getStat(long threadId) {
        return this.m_stats.get(threadId);
    }

    public Collection<StatEntry> getAllStats() {
        return this.m_stats.values();
    }

    public class StatEntry
    implements Comparable<StatEntry> {
        private long m_threadId;
        private long m_time = System.currentTimeMillis();
        private long m_totalUsage;
        private long m_usageLastPeriod = -1L;
        private long m_percentLastPeriod = -1000000L;

        StatEntry(long threadId, long totalUsage) {
            this.m_threadId = threadId;
            this.m_totalUsage = totalUsage;
        }

        public void computeUsageInLastPeriod(StatEntry oldStat) {
            this.m_usageLastPeriod = this.m_totalUsage - oldStat.m_totalUsage;
            long elapsedTime = this.m_time - oldStat.m_time;
            this.m_percentLastPeriod = elapsedTime <= 0L ? 0L : this.m_usageLastPeriod / elapsedTime;
            this.m_percentLastPeriod = this.m_percentLastPeriod < 0L ? 0L : this.m_percentLastPeriod;
        }

        public long getThreadId() {
            return this.m_threadId;
        }

        public long getTime() {
            return this.m_time;
        }

        public long getTotalUsage() {
            return this.m_totalUsage;
        }

        public long getUsageInLastPeriod() {
            return this.m_usageLastPeriod;
        }

        public float getPercentInLastPeriod() {
            return (float)this.m_percentLastPeriod / 10000.0f;
        }

        @Override
        public int compareTo(StatEntry compareStat) {
            if (this.m_percentLastPeriod == compareStat.m_percentLastPeriod) {
                return 0;
            }
            if (this.m_percentLastPeriod > compareStat.m_percentLastPeriod) {
                return 1;
            }
            return -1;
        }
    }
}

