/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.sdf.threads;

import com.sonicsw.sdf.IDiagnosticsConstants;
import com.sonicsw.sdf.IStateWriter;
import com.sonicsw.sdf.threads.TestStdoutWriter;
import com.sonicsw.sdf.threads.ThreadDump;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadDumpHandler {
    static Object monitor1 = new String("monitor1");
    static Object monitor2 = new String("monitor2");
    static Object monitor3 = new String("monitor3");
    static Lock lock1 = new ReentrantLock();
    static Lock lock2 = new ReentrantLock();
    static Lock lock3 = new ReentrantLock();
    static volatile boolean shutdownRequested;

    public static synchronized void writeThreadDump(IStateWriter writer) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        ThreadDump threadDump = ThreadDump.createThreadDump();
        writer.writeln("Java Thread Dump (thread details collected in " + threadDump.getElapsedTime() + "ms)");
        threadDump.showThreads(writer);
        writer.writeln("" + threadDump.getThreadCount() + " threads");
        writer.writeln();
        if (threadDump.getDeadlockedThreadCount() == 0) {
            writer.writeln("No deadlocks found");
        } else {
            writer.writeln("Found " + threadDump.getDeadlockedThreadCount() + " deadlocked threads...");
            threadDump.showDeadlockedThreads(writer);
        }
        if (threadDump.isCpuUsageEnabled()) {
            if (threadDump.isCpuUsageAvailable()) {
                long period = (threadDump.getStartTime() - threadDump.getPreviousThreadDumpTime()) / 1000L;
                writer.writeln(IDiagnosticsConstants.NEWLINE + "Threads with highest CPU usage over last " + period + " seconds");
                threadDump.showCpuUsage(writer, 10);
            } else {
                writer.writeln(IDiagnosticsConstants.NEWLINE + "Take another thread dump within " + 15L + " minutes to see CPU usage information.");
            }
        }
    }

    public static boolean isLockInfoSupported() {
        return ThreadDump.isLockInfoSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.out.println("Setting up threads for test.");
        System.out.println("\nThere are six deadlocked threads in total: 3 deadlock cycles");
        System.out.println("each involving 2 threads.  A 1.6 JVM should detect all three");
        System.out.println("cycles.  A 1.5 JVM will only detect 1 cycle (2 threads) since");
        System.out.println("two of the deadlocks involve synchronizers.");
        System.out.println("\nOne thread spins, consuming a large amount of CPU.  This should");
        System.out.println("be picked up and reported in the second thread dump if the JVM");
        System.out.println("has CPU monitoring enabled.");
        ThreadDumpHandler.setupTestThreads();
        System.out.println();
        try {
            TestStdoutWriter writer = new TestStdoutWriter();
            System.out.println("\nThread dump 1...");
            ThreadDumpHandler.writeThreadDump(writer);
            System.out.println("\nSleeping for 5 seconds...");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("\nThread dump 2 (may include CPU usage info)...");
            ThreadDumpHandler.writeThreadDump(writer);
        }
        catch (Exception e) {
            System.err.println("Failed to generate thread dump");
            e.printStackTrace();
        }
        finally {
            shutdownRequested = true;
        }
    }

    public static void setupTestThreads() {
        class DeadlockThread
        extends Thread {
            Object lockA = null;
            Object lockB = null;

            public DeadlockThread(String name, Object lockA, Object lockB) {
                super(name);
                this.lockA = lockA;
                this.lockB = lockB;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doDeadlockA() {
                if (this.lockA instanceof Lock) {
                    ((Lock)this.lockA).lock();
                    System.out.println("Thread " + this.getName() + " got lock A (synchronizer).  Sleeping...");
                    try {
                        DeadlockThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.doDeadlockB();
                    ((Lock)this.lockA).unlock();
                } else {
                    Object object = this.lockA;
                    synchronized (object) {
                        System.out.println("Thread " + this.getName() + " got lock A (monitor).  Sleeping...");
                        try {
                            DeadlockThread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.doDeadlockB();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doDeadlockB() {
                if (this.lockB instanceof Lock) {
                    ((Lock)this.lockB).lock();
                    System.out.println("Thread " + this.getName() + " got lock B (synchronizer).  Done.");
                    ((Lock)this.lockB).unlock();
                } else {
                    Object object = this.lockB;
                    synchronized (object) {
                        System.out.println("Thread " + this.getName() + " got lock B (monitor).  Done.");
                    }
                }
            }

            @Override
            public void run() {
                this.doDeadlockA();
            }
        }
        class WaitThread
        extends Thread {
            Object waitObj;

            public WaitThread(String name, Object waitObj) {
                super(name);
                this.waitObj = waitObj;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doWait() {
                Object object = this.waitObj;
                synchronized (object) {
                    System.out.println("Thread " + this.getName() + " waiting...");
                    try {
                        while (!shutdownRequested) {
                            this.waitObj.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            @Override
            public void run() {
                this.doWait();
            }
        }
        class BusyThread
        extends Thread {
            public BusyThread(String name) {
                super(name);
            }

            private void getBusy() {
                int i = 0;
                while (true) {
                    i = i > 100 ? 0 : i + 1;
                }
            }

            @Override
            public void run() {
                this.getBusy();
            }
        }
        class ShortLifeThread
        extends Thread {
            private int m_lifetime;

            public ShortLifeThread(String name, int lifetime) {
                super(name);
                this.m_lifetime = lifetime;
            }

            private void sleepAndTerminate() {
                System.out.println("Thread " + this.getName() + " sleeping for " + this.m_lifetime + " seconds...");
                try {
                    ShortLifeThread.sleep(this.m_lifetime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Thread " + this.getName() + " done.");
            }

            @Override
            public void run() {
                this.sleepAndTerminate();
            }
        }
        Thread[] threads = new Thread[]{new DeadlockThread("Monitor Deadlock Thread 1", monitor1, monitor2), new DeadlockThread("Monitor Deadlock Thread 2", monitor2, monitor1), new DeadlockThread("Synchronizer Deadlock Thread 1", lock1, lock2), new DeadlockThread("Synchronizer Deadlock Thread 2", lock2, lock1), new DeadlockThread("Monitor-Synchronizer Deadlock Thread 1", monitor3, lock3), new DeadlockThread("Monitor-Synchronizer Deadlock Thread 2", lock3, monitor3), new WaitThread("Waiting Thread", new Integer(0)), new BusyThread("Busy Thread"), new ShortLifeThread("Short-Lived Thread", 8)};
        for (int i = 0; i < threads.length; ++i) {
            threads[i].setDaemon(true);
            threads[i].start();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

