/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.logger;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.logger.LogFormatter;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;

class DelimitedTextLogFormatter
implements LogFormatter {
    private static final String ARRAY_DELIMITER = ",";
    private static final String ARRAY_DELIMITER_ALTERNATIVE = ";";
    private static Map formatters = new HashMap();
    private final String textDelimiter;
    private final String arrayDelimiter;

    private DelimitedTextLogFormatter(String textDelimiter) {
        this.textDelimiter = textDelimiter;
        this.arrayDelimiter = ARRAY_DELIMITER.equals(textDelimiter) ? ARRAY_DELIMITER_ALTERNATIVE : ARRAY_DELIMITER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DelimitedTextLogFormatter getInstance(String textDelimiter) {
        Map map = formatters;
        synchronized (map) {
            DelimitedTextLogFormatter formatter = (DelimitedTextLogFormatter)formatters.get(textDelimiter);
            if (formatter == null) {
                formatter = new DelimitedTextLogFormatter(textDelimiter);
                formatters.put(textDelimiter, formatter);
            }
            return formatter;
        }
    }

    @Override
    public Object formatHistoricalMetric(IHistoricalMetric metric) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("source=");
        buffer.append(metric.getSource());
        buffer.append(this.textDelimiter);
        buffer.append("id=");
        buffer.append(metric.getMetricIdentity().getName());
        buffer.append(this.textDelimiter);
        buffer.append("value=");
        buffer.append(metric.getValue());
        buffer.append(this.textDelimiter);
        buffer.append("timestamp=");
        buffer.append(metric.getCurrencyTimestamp());
        return buffer.toString();
    }

    @Override
    public Object formatNotification(INotification notification) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("type=").append(notification.getType());
        buffer.append(this.textDelimiter);
        if (notification instanceof Notification) {
            buffer.append("source=").append(((Notification)notification).getSource());
        } else {
            buffer.append("source=").append(notification.getSourceIdentity().getCanonicalName());
        }
        buffer.append(this.textDelimiter);
        buffer.append("sequenceNumber=");
        buffer.append(notification.getSequenceNumber());
        buffer.append(this.textDelimiter);
        if (notification instanceof Notification) {
            buffer.append("userData=");
            buffer.append(((Notification)notification).getUserData());
            buffer.append(this.textDelimiter);
        }
        buffer.append("timestamp=").append(notification.getTimeStamp());
        Object[] attributes = notification.getAttributes().entrySet().toArray();
        for (int i = 0; i < attributes.length; ++i) {
            buffer.append(this.textDelimiter);
            Map.Entry entry = (Map.Entry)attributes[i];
            buffer.append(entry.getKey()).append('=');
            Object attribute = entry.getValue();
            if (attribute == null || !attribute.getClass().isArray()) {
                buffer.append(attribute);
                continue;
            }
            Object[] attributeArray = (Object[])attribute;
            buffer.append("[");
            for (int j = 0; j < attributeArray.length; ++j) {
                if (j != 0) {
                    buffer.append(this.arrayDelimiter);
                }
                buffer.append(attributeArray[j]);
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

