/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.logger;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IContainerState;
import com.sonicsw.mf.common.runtime.IMonitoredMetrics;
import com.sonicsw.mf.common.runtime.IMonitoredNotifications;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.logger.DelimitedTextLogFormatter;
import com.sonicsw.mf.framework.logger.LogFormatter;
import com.sonicsw.mf.framework.logger.PassthroughLogFormatter;
import com.sonicsw.mf.framework.logger.XmlLogFormatter;
import com.sonicsw.mx.util.IEmptyArray;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;

public class LoggerComponent
extends AbstractFrameworkComponent {
    public String m_configID = null;
    public ICanonicalName m_componentName = null;
    private IMetricsRegistrar m_metricsRegistrar;
    private String m_controlCode = null;
    private String m_collectionsMonitorRuntimeID = null;
    private String m_log4jConfigurationFilePath = null;
    private String m_logFormat = null;
    private String m_logTextDelimiter = null;
    private String[] m_componentCollectionIDs = null;
    private int m_collectionsMonitorPollInterval;
    private int m_maxLookbackPeriod;
    private Object m_lock = new Object();
    private LoggingThread m_loggingThread = null;
    private boolean m_stopping = false;
    private Object m_changeLock = new Object();
    private static final String LOGGER_TRACE_MASK_VALUES = "16=logger failures,32=logger exceptions,64=logger invocations,128=logging cycle";
    public static final int TRACE_LOGGER_FAILURES = 16;
    public static final int TRACE_LOGGER_EXCEPTIONS = 32;
    public static final int TRACE_LOGGER_INVOCATIONS = 64;
    public static final int TRACE_LOGGING_CYCLE = 128;
    public static final int TRACE_DETAIL = 1;
    private static final ArrayList ATTRIBUTE_INFOS = new ArrayList();
    private static final ArrayList OPERATION_INFOS = new ArrayList();
    private static final ArrayList NOTIFICATION_INFOS = new ArrayList();
    private IStatistic m_metricsLoggedPerMinuteStatistic;
    private IStatistic m_notificationsLoggedPerMinuteStatistic;
    private static final String PRODUCT_INFORMATION_ATTR = "PRODUCT_INFORMATION";
    private static final String CONTROL_NUMBER_ATTR = "CONTROL_NUMBER";
    private static final String EVALUATION_MODE_ATTR = "EVALUATION_MODE";
    private static final String COLLECTIONS_MONITOR_RUNTIME_ID_ATTR = "COLLECTIONS_MONITOR_RUNTIME_ID";
    private static final String COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR = "COLLECTIONS_MONITOR_POLL_INTERVAL";
    private static final String MAX_LOOKBACK_PERIOD_ATTR = "MAX_LOOKBACK_PERIOD";
    private static final String LOG4J_CONFIGURATION_FILE_PATH_ATTR = "LOG4J_CONFIGURATION_FILE_PATH";
    private static final String COMPONENT_COLLECTIONS_ATTR = "COMPONENT_COLLECTIONS";
    private static final String LOG_FORMAT_ATTR = "LOG_FORMAT";
    private static final String L0G_TEXT_DELIMITER_ATTR = "L0G_TEXT_DELIMITER";
    private static final String LOGGER_NOTIFICATION_PREFIX = "sonicmf.notification.";
    private static final String LOGGER_METRIC_PREFIX = "sonicmf.metric.";
    private static final String DELIMITED_TEXT_LOG_FORMAT_TYPE = "DELIMITED TEXT";
    private static final String XML_LOG_FORMAT_TYPE = "XML";
    private static final String JAVA_OBJECT_LOG_FORMAT_TYPE = "JAVA OBJECT";
    private static final String LOG_TEXT_DELIMITER_DEFAULT = ",";
    private static final int COLLECTIONS_MONITOR_POLL_INTERVAL_DEFAULT = 30;
    private static final int MAX_LOOKBACK_PERIOD_DEFAULT = 10;
    public static final String GET_STORED_METRICS_METHOD_NAME = "getStoredMetrics";
    public static final String GET_STORED_NOTIFICATIONS_METHOD_NAME = "getStoredNotifications";
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final IMetricIdentity METRICS_LOGGED_PER_MINUTE_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"logger", "metrics", "LoggedPerMinute"});
    public static final IMetricIdentity NOTIFICATIONS_LOGGED_PER_MINUTE_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"logger", "notifications", "LoggedPerMinute"});

    public void init(IComponentContext context) {
        super.init(context);
        this.m_componentName = this.m_context.getComponentName();
        this.readConfiguration(context);
        this.initLog4jEnvironment();
        this.setTraceMask(super.getTraceMask());
        IMetricInfo[] loggerMetricsInfo = LoggerComponent.getMetricsInfo();
        this.m_metricsRegistrar = this.m_context.initMetricsManagement(loggerMetricsInfo);
        this.initMetrics();
        this.m_loggingThread = new LoggingThread();
        this.m_loggingThread.setDaemon(true);
    }

    public synchronized void start() {
        if (this.m_state == 3) {
            return;
        }
        super.start();
        this.m_stopping = false;
        if (this.m_loggingThread == null) {
            this.m_loggingThread = new LoggingThread();
            this.m_loggingThread.setDaemon(true);
        }
        this.m_loggingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.m_stopping) {
            return;
        }
        this.m_stopping = true;
        if (this.m_loggingThread != null) {
            Object object = this.m_loggingThread.getLoggingThreadLockObj();
            synchronized (object) {
                this.m_loggingThread.getLoggingThreadLockObj().notifyAll();
                this.m_loggingThread = null;
            }
        }
        if (this.m_state == 1) {
            return;
        }
        super.stop();
    }

    public void destroy() {
        LogManager.shutdown();
        super.destroy();
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + LOG_TEXT_DELIMITER_DEFAULT + LOGGER_TRACE_MASK_VALUES;
    }

    public void setTraceMask(Integer traceMask) {
        super.setTraceMask(traceMask);
    }

    public String getControlNumber() {
        return this.m_controlCode;
    }

    public void setControlNumber(String controlCode) {
        this.m_controlCode = controlCode;
    }

    public Boolean getEvaluationMode() {
        return Boolean.FALSE;
    }

    public String getCollectionsMonitorRuntimeID() {
        return this.m_collectionsMonitorRuntimeID;
    }

    public void setCollectionsMonitorRuntimeID(String collectionsMonitorRuntimeID) {
        this.m_collectionsMonitorRuntimeID = collectionsMonitorRuntimeID;
    }

    public Integer getCollectionsMonitorPollInterval() {
        return new Integer(this.m_collectionsMonitorPollInterval);
    }

    public void setCollectionsMonitorPollInterval(Integer collectionsMonitorPollInterval) {
        this.m_collectionsMonitorPollInterval = collectionsMonitorPollInterval;
    }

    public Integer getMaxLookbackPeriod() {
        return new Integer(this.m_maxLookbackPeriod);
    }

    public void setMaxLookbackPeriod(Integer maxLookbackPeriod) {
        this.m_maxLookbackPeriod = maxLookbackPeriod;
    }

    public String getLog4jConfigurationFilePath() {
        return this.m_log4jConfigurationFilePath;
    }

    public void setLog4jConfigurationFilePath(String log4jConfigurationFilePath) {
        this.m_log4jConfigurationFilePath = log4jConfigurationFilePath;
    }

    public String getLogFormat() {
        return this.m_logFormat;
    }

    public void setLogFormat(String logFormat) {
        if (logFormat.equalsIgnoreCase(DELIMITED_TEXT_LOG_FORMAT_TYPE) || logFormat.equalsIgnoreCase(XML_LOG_FORMAT_TYPE) || logFormat.equalsIgnoreCase(JAVA_OBJECT_LOG_FORMAT_TYPE)) {
            this.m_logFormat = logFormat;
        }
    }

    public String getLogTextDelimiter() {
        return this.m_logTextDelimiter;
    }

    public void setLogTextDelimiter(String logTextDelimiter) {
        this.m_logTextDelimiter = logTextDelimiter;
    }

    public String[] getComponentCollections() {
        return this.m_componentCollectionIDs;
    }

    public void setComponentCollectionIDs(String[] componentCollectionIDs) {
        this.m_componentCollectionIDs = componentCollectionIDs;
    }

    public void addComponentCollectionName(String componentCollectionID) {
        super.validateOnline();
        if (this.m_componentCollectionIDs == null) {
            this.m_componentCollectionIDs = new String[1];
            this.m_componentCollectionIDs[0] = componentCollectionID;
        } else {
            int size = this.m_componentCollectionIDs.length;
            String[] updatedComponentCollectionIDs = new String[size + 1];
            for (int i = 0; i < size; ++i) {
                updatedComponentCollectionIDs[i] = this.m_componentCollectionIDs[i];
            }
            updatedComponentCollectionIDs[size] = componentCollectionID;
            this.m_componentCollectionIDs = updatedComponentCollectionIDs;
        }
    }

    public Boolean removeComponentCollectionName(String componentCollectionID) {
        super.validateOnline();
        if (this.m_componentCollectionIDs == null) {
            return new Boolean(false);
        }
        int size = this.m_componentCollectionIDs.length;
        if (size == 1 && this.m_componentCollectionIDs[0].equals(componentCollectionID)) {
            return new Boolean(false);
        }
        boolean status = false;
        ArrayList<String> tempList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            if (this.m_componentCollectionIDs[i].equals(componentCollectionID)) {
                status = true;
                continue;
            }
            tempList.add(this.m_componentCollectionIDs[i]);
        }
        if (!status) {
            tempList.clear();
            return new Boolean(false);
        }
        Object[] tempArray = tempList.toArray();
        size = tempArray.length;
        String[] updatedComponentCollectionIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            updatedComponentCollectionIDs[i] = (String)tempArray[i];
        }
        this.m_componentCollectionIDs = updatedComponentCollectionIDs;
        return new Boolean(status);
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        String configID = elementChange.getElement().getIdentity().getName();
        if (!configID.equals(this.m_configID)) {
            return;
        }
        if (elementChange.getChangeType() == 1) {
            IDeltaElement changeElement = (IDeltaElement)elementChange.getElement();
            IDeltaAttributeSet attrs = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
            String[] mods = attrs.getModifiedAttributesNames();
            this.handleChangeLoggerAttrs(mods, attrs);
            mods = attrs.getNewAttributesNames();
            this.handleChangeLoggerAttrs(mods, attrs);
            mods = attrs.getDeletedAttributesNames();
            this.handleDeletedLoggerAttrs(mods);
        }
    }

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public synchronized void enableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(METRICS_LOGGED_PER_MINUTE_METRIC_ID)) {
                if (this.m_metricsLoggedPerMinuteStatistic == null) {
                    this.m_metricsLoggedPerMinuteStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                }
                this.m_metricsRegistrar.registerMetric(METRICS_LOGGED_PER_MINUTE_METRIC_ID, this.m_metricsLoggedPerMinuteStatistic);
            }
            if (!ids[i].equals(NOTIFICATIONS_LOGGED_PER_MINUTE_METRIC_ID)) continue;
            if (this.m_notificationsLoggedPerMinuteStatistic == null) {
                this.m_notificationsLoggedPerMinuteStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            }
            this.m_metricsRegistrar.registerMetric(NOTIFICATIONS_LOGGED_PER_MINUTE_METRIC_ID, this.m_notificationsLoggedPerMinuteStatistic);
        }
    }

    public synchronized void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals(METRICS_LOGGED_PER_MINUTE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(ids[i]);
                this.m_metricsLoggedPerMinuteStatistic = null;
            }
            if (!ids[i].equals(NOTIFICATIONS_LOGGED_PER_MINUTE_METRIC_ID)) continue;
            this.m_metricsRegistrar.unregisterMetric(ids[i]);
            this.m_notificationsLoggedPerMinuteStatistic = null;
        }
    }

    public static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[]{MetricsFactory.createMetricInfo((IMetricIdentity)METRICS_LOGGED_PER_MINUTE_METRIC_ID, (short)10, (String)"Rate at which metrics have been logged.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"metrics logged per minute"), MetricsFactory.createMetricInfo((IMetricIdentity)NOTIFICATIONS_LOGGED_PER_MINUTE_METRIC_ID, (short)10, (String)"Rate at which notifications have been logged.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"notifications logged per minute")};
        return infos;
    }

    private void readConfiguration(IComponentContext context) {
        IElement loggerElement = context.getConfiguration(true);
        if (loggerElement != null) {
            this.m_configID = loggerElement.getIdentity().getName();
            IAttributeSet loggerAttributes = loggerElement.getAttributes();
            this.readBasicAttributes(loggerAttributes, context);
        }
    }

    private void readBasicAttributes(IAttributeSet attributes, IComponentContext context) {
        Object obj = null;
        this.m_collectionsMonitorRuntimeID = (String)attributes.getAttribute(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR);
        this.m_log4jConfigurationFilePath = (String)attributes.getAttribute(LOG4J_CONFIGURATION_FILE_PATH_ATTR);
        obj = attributes.getAttribute(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR);
        this.m_collectionsMonitorPollInterval = obj != null ? (Integer)obj : 30;
        obj = attributes.getAttribute(MAX_LOOKBACK_PERIOD_ATTR);
        this.m_maxLookbackPeriod = obj != null ? (Integer)obj : 10;
        this.m_logFormat = (String)attributes.getAttribute(LOG_FORMAT_ATTR);
        if (this.m_logFormat == null) {
            this.m_logFormat = DELIMITED_TEXT_LOG_FORMAT_TYPE;
        }
        this.m_logTextDelimiter = (obj = attributes.getAttribute(L0G_TEXT_DELIMITER_ATTR)) != null ? (String)obj : LOG_TEXT_DELIMITER_DEFAULT;
        IAttributeSet productInformationAttributes = (IAttributeSet)attributes.getAttribute(PRODUCT_INFORMATION_ATTR);
        if (productInformationAttributes != null) {
            this.m_controlCode = (String)productInformationAttributes.getAttribute(CONTROL_NUMBER_ATTR);
            obj = productInformationAttributes.getAttribute(EVALUATION_MODE_ATTR);
        }
        this.m_componentCollectionIDs = this.readComponentCollectionIDs();
    }

    private String[] readComponentCollectionIDs() {
        IElement loggerElement = this.m_context.getConfiguration(true);
        IAttributeSet loggerAttributes = loggerElement.getAttributes();
        IAttributeSet componentCollectionsSet = (IAttributeSet)loggerAttributes.getAttribute(COMPONENT_COLLECTIONS_ATTR);
        Object[] ids = componentCollectionsSet.getAttributes().values().toArray();
        String[] componentCollectionIDs = new String[ids.length];
        Reference ccRef = null;
        for (int i = 0; i < ids.length; ++i) {
            String name;
            ccRef = (Reference)ids[i];
            String ccCID = ccRef.getElementName();
            IElement configElem = this.m_context.getConfiguration(ccCID, true);
            componentCollectionIDs[i] = name = configElem.getIdentity().getName();
        }
        return componentCollectionIDs;
    }

    private void initMetrics() {
        this.m_metricsLoggedPerMinuteStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
        this.m_notificationsLoggedPerMinuteStatistic = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChangeLoggerAttrs(String[] attributeNames, IDeltaAttributeSet modifiedAttrs) {
        try {
            String collectionsMonitorRuntimeID = null;
            String[] componentCollectionIDs = null;
            Integer collectionsMonitorPollInterval = null;
            Integer maxLookbackPeriod = null;
            String logFormat = null;
            String logTextDelimiter = null;
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].equals(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR)) {
                    collectionsMonitorRuntimeID = (String)modifiedAttrs.getNewValue(COLLECTIONS_MONITOR_RUNTIME_ID_ATTR);
                    continue;
                }
                if (attributeNames[i].equals(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR)) {
                    collectionsMonitorPollInterval = (Integer)modifiedAttrs.getNewValue(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR);
                    continue;
                }
                if (attributeNames[i].equals(MAX_LOOKBACK_PERIOD_ATTR)) {
                    maxLookbackPeriod = (Integer)modifiedAttrs.getNewValue(MAX_LOOKBACK_PERIOD_ATTR);
                    continue;
                }
                if (attributeNames[i].equals(LOG_FORMAT_ATTR)) {
                    logFormat = (String)modifiedAttrs.getNewValue(LOG_FORMAT_ATTR);
                    continue;
                }
                if (attributeNames[i].equals(L0G_TEXT_DELIMITER_ATTR)) {
                    logTextDelimiter = (String)modifiedAttrs.getNewValue(L0G_TEXT_DELIMITER_ATTR);
                    continue;
                }
                if (!attributeNames[i].equals(COMPONENT_COLLECTIONS_ATTR)) continue;
                componentCollectionIDs = this.readComponentCollectionIDs();
            }
            Object object = this.m_changeLock;
            synchronized (object) {
                if (collectionsMonitorRuntimeID != null) {
                    this.m_collectionsMonitorRuntimeID = collectionsMonitorRuntimeID;
                }
                if (componentCollectionIDs != null) {
                    this.m_componentCollectionIDs = componentCollectionIDs;
                }
                if (collectionsMonitorPollInterval != null) {
                    this.m_collectionsMonitorPollInterval = collectionsMonitorPollInterval;
                }
                if (maxLookbackPeriod != null) {
                    this.m_maxLookbackPeriod = maxLookbackPeriod;
                }
                if (logFormat != null) {
                    this.m_logFormat = logFormat;
                }
                if (logTextDelimiter != null) {
                    this.m_logTextDelimiter = logTextDelimiter;
                }
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying LoggerComponent runtime from configuration change, trace follows...", (Throwable)e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDeletedLoggerAttrs(String[] attributeNames) {
        try {
            Object object = this.m_changeLock;
            synchronized (object) {
                for (int i = 0; i < attributeNames.length; ++i) {
                    if (attributeNames[i].equals(COLLECTIONS_MONITOR_POLL_INTERVAL_ATTR)) {
                        this.m_collectionsMonitorPollInterval = 30;
                        continue;
                    }
                    if (attributeNames[i].equals(MAX_LOOKBACK_PERIOD_ATTR)) {
                        this.m_maxLookbackPeriod = 10;
                        continue;
                    }
                    if (!attributeNames[i].equals(L0G_TEXT_DELIMITER_ATTR)) continue;
                    this.m_logTextDelimiter = LOG_TEXT_DELIMITER_DEFAULT;
                }
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying LoggerComponent runtime from configuration change [deletion]", (Throwable)e, 1);
        }
    }

    private void initLog4jEnvironment() {
        URL log4jConfigurationFileURL = null;
        try {
            log4jConfigurationFileURL = new URL(this.m_log4jConfigurationFilePath);
        }
        catch (Exception e) {
            this.m_context.logMessage("Exception occurred while attempting to load log4j configuration file " + this.m_log4jConfigurationFilePath, (Throwable)e, 1);
        }
        if (this.m_log4jConfigurationFilePath.endsWith("xml")) {
            DOMConfigurator.configure((URL)log4jConfigurationFileURL);
        } else {
            PropertyConfigurator.configure((URL)log4jConfigurationFileURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogFormatter getLogFormatter() {
        LogFormatter logFormatter = null;
        Object object = this.m_changeLock;
        synchronized (object) {
            logFormatter = DELIMITED_TEXT_LOG_FORMAT_TYPE.equals(this.m_logFormat) ? DelimitedTextLogFormatter.getInstance(this.m_logTextDelimiter) : (XML_LOG_FORMAT_TYPE.equals(this.m_logFormat) ? XmlLogFormatter.INSTANCE : PassthroughLogFormatter.INSTANCE);
        }
        return logFormatter;
    }

    static {
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ControlNumber", String.class.getName(), "The LoggerComponent License Control Number [required in order to access Logger functionality].", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("EvaluationMode", Boolean.class.getName(), "Flag that indicates if LoggerComponent is running in evaluation-only mode [limited time use].", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("CollectionsMonitorRuntimeID", String.class.getName(), "The runtime ID of the CollectionsMonitor with which this LoggerComponent instance is associated.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("CollectionsMonitorPollInterval", Integer.class.getName(), "The amount of time that the LoggerComponent instance will wait between attempts to poll its associated CollectionMonitor for metrics and notifications data.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("MaxLookbackPeriod", Integer.class.getName(), "The maximum number of threads that the Agent Manager can create to poll containers for their state.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("Log4jConfigurationFilePath", String.class.getName(), "Path to log4j configuration file.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogFormat", String.class.getName(), "Format used to log data [Delimited Text, XML, or Java Object format].", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("LogTextDelimiter", String.class.getName(), "Character [or text] used to delimit log entries [applicable only when using the Delimited Text log format].", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("ComponentCollections", String[].class.getName(), "IDs of Component Collections in which this LoggerComponent is interested.", true, true, false));
        MBeanParameterInfo[] mbParamInfos = null;
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("componentCollectionID", String[].class.getName(), "The ID of a Component Collection to be added to the list of Component Collections in which the LoggerComponent is currently interested.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("addComponentCollectionID", "Adds a Component Collection ID to the list of Component Collections in which the LoggerComponent is currently interested.", mbParamInfos, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("componentCollectionID", String[].class.getName(), "The ID of a Component Collection to be removed from the list of Component Collections in which the LoggerComponent is currently interested.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("removeComponentCollectionID", "Removes a Component Collection ID from the list of Component Collections in which the LoggerComponent is currently interested. A return value of \"false\" indicates that the attempt was unsuccessful [A LoggerComponent must always be configured with at least one Component Collection ID, and an attempt to remove the only remaining ID will fail].", mbParamInfos, Boolean.class.getName(), 1));
    }

    private final class LoggingThread
    extends Thread {
        private boolean m_cmWaitingMessageLogged;
        private Exception m_retrievalFailure;
        private Exception m_metricLogFailure;
        private Exception m_notificationLogFailure;
        private Long m_lastMetricRetrievalTimestamp;
        private Long m_lastNotificationRetrievalTimestamp;
        private Object m_loggingThreadLockObj;
        private final Object[] EMPTY_OBJECT_ARRAY;
        private final String[] EMPTY_STRING_ARRAY;

        private LoggingThread() {
            super("LoggingThread");
            this.m_cmWaitingMessageLogged = false;
            this.m_retrievalFailure = null;
            this.m_metricLogFailure = null;
            this.m_notificationLogFailure = null;
            this.m_lastMetricRetrievalTimestamp = null;
            this.m_lastNotificationRetrievalTimestamp = null;
            this.m_loggingThreadLockObj = new Object();
            this.EMPTY_OBJECT_ARRAY = new Object[0];
            this.EMPTY_STRING_ARRAY = new String[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LoggerComponent.this.m_stopping) {
                return;
            }
            String collectionsMonitorRuntimeID = LoggerComponent.this.m_collectionsMonitorRuntimeID;
            if (!this.performCollectionsMonitorValidation(collectionsMonitorRuntimeID)) {
                Object object = LoggerComponent.this.m_lock;
                synchronized (object) {
                    LoggerComponent.this.stop();
                }
                return;
            }
            if (!this.validateCollectionsMonitorVersion(collectionsMonitorRuntimeID)) {
                LoggerComponent.this.m_context.registerErrorCondition("Invalid CollectionsMonitor Runtime ID specified in LoggerComponent's configuration", 1);
                Object object = LoggerComponent.this.m_lock;
                synchronized (object) {
                    LoggerComponent.this.stop();
                }
                return;
            }
            while (!LoggerComponent.this.m_stopping) {
                block24: {
                    try {
                        Object object = this.m_loggingThreadLockObj;
                        synchronized (object) {
                            this.m_loggingThreadLockObj.wait(LoggerComponent.this.m_collectionsMonitorPollInterval * 1000);
                            if (LoggerComponent.this.m_stopping) {
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!LoggerComponent.this.m_stopping) break block24;
                        return;
                    }
                }
                String[] componentCollectionIDs = null;
                boolean cmChanged = false;
                Object object = LoggerComponent.this.m_changeLock;
                synchronized (object) {
                    componentCollectionIDs = LoggerComponent.this.m_componentCollectionIDs;
                    if (!collectionsMonitorRuntimeID.equals(LoggerComponent.this.m_collectionsMonitorRuntimeID)) {
                        cmChanged = true;
                        collectionsMonitorRuntimeID = LoggerComponent.this.m_collectionsMonitorRuntimeID;
                    }
                }
                if (cmChanged && !this.performCollectionsMonitorValidation(collectionsMonitorRuntimeID)) {
                    object = LoggerComponent.this.m_lock;
                    synchronized (object) {
                        LoggerComponent.this.stop();
                    }
                    return;
                }
                this.logStoredMetrics(collectionsMonitorRuntimeID, componentCollectionIDs);
                this.logStoredNotifications(collectionsMonitorRuntimeID, componentCollectionIDs);
            }
        }

        private boolean isCollectionsMonitorOnline(String cmRuntimeID) throws Exception {
            boolean online = false;
            ObjectName cmObjName = new ObjectName(cmRuntimeID);
            String container = cmObjName.getDomain();
            ObjectName agentObjName = new ObjectName(container + ":ID=AGENT");
            boolean synchronous = true;
            IContainerState containerState = (IContainerState)LoggerComponent.this.m_frameworkContext.invoke(agentObjName.getCanonicalName(), "getContainerState", this.EMPTY_OBJECT_ARRAY, this.EMPTY_STRING_ARRAY, synchronous, 0L);
            if (containerState == null) {
                return false;
            }
            IComponentState[] componentStates = containerState.getComponentStates();
            IComponentState componentState = null;
            String id = cmObjName.getKeyProperty("ID");
            for (int i = 0; i < componentStates.length; ++i) {
                if (!((IComponentIdentity)componentStates[i].getRuntimeIdentity()).getComponentName().equals(id)) continue;
                componentState = componentStates[i];
                break;
            }
            if (componentState != null && componentState.getState() == 3) {
                online = true;
            }
            return online;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForCMToStart(String cmRuntimeID) {
            boolean online = false;
            while (!LoggerComponent.this.m_stopping) {
                try {
                    online = this.isCollectionsMonitorOnline(cmRuntimeID);
                    if (!online) {
                        if (!this.m_cmWaitingMessageLogged) {
                            LoggerComponent.this.m_frameworkContext.logMessage("CollectionsMonitor " + LoggerComponent.this.m_collectionsMonitorRuntimeID + " not yet in ONLINE state; LoggerComponent " + LoggerComponent.this.m_componentName.getComponentName() + " will continue to attempt to contact the CollectionsMonitor...", 3);
                            this.m_cmWaitingMessageLogged = true;
                        }
                        try {
                            Object object = this.m_loggingThreadLockObj;
                            synchronized (object) {
                                this.m_loggingThreadLockObj.wait(LoggerComponent.this.m_collectionsMonitorPollInterval * 1000);
                                if (LoggerComponent.this.m_stopping) {
                                    break;
                                }
                                continue;
                            }
                        }
                        catch (Exception e) {
                            if (!LoggerComponent.this.m_stopping) continue;
                        }
                        break;
                    }
                    if (!online || !this.m_cmWaitingMessageLogged) break;
                    LoggerComponent.this.m_frameworkContext.logMessage("CollectionsMonitor " + LoggerComponent.this.m_collectionsMonitorRuntimeID + " is now ONLINE; LoggerComponent " + LoggerComponent.this.m_componentName.getComponentName() + " has connected to the CollectionsMonitor...", 3);
                    this.m_cmWaitingMessageLogged = false;
                }
                catch (Exception e) {
                    if (LoggerComponent.this.m_stopping) break;
                    LoggerComponent.this.m_frameworkContext.logMessage("Error contacting CollectionsMonitor [" + cmRuntimeID + "], trace follows...", (Throwable)e, 1);
                    break;
                }
            }
            return online;
        }

        private boolean performCollectionsMonitorValidation(String cmRuntimeID) {
            boolean isValid = true;
            isValid = this.validateCollectionsMonitorID(cmRuntimeID);
            if (isValid) {
                isValid = this.validateCollectionsMonitorOnline(cmRuntimeID);
            }
            if (isValid) {
                isValid = this.validateCollectionsMonitorVersion(cmRuntimeID);
            }
            return isValid;
        }

        private boolean validateCollectionsMonitorID(String cmRuntimeID) {
            boolean isValid = true;
            if (cmRuntimeID == null || cmRuntimeID.equals("")) {
                isValid = false;
                LoggerComponent.this.m_context.logMessage("CollectionsMonitor Runtime ID not specified; please update the LoggerComponent's configuration with a valid CollectionsMonitor Runtime ID.", 1);
                LoggerComponent.this.m_context.registerErrorCondition("CollectionsMonitor Runtime ID not specified in LoggerComponent's configuration", 1);
            }
            return isValid;
        }

        private boolean validateCollectionsMonitorOnline(String cmRuntimeID) {
            boolean cmOnline = this.waitForCMToStart(cmRuntimeID);
            if (!cmOnline) {
                if (LoggerComponent.this.m_stopping) {
                    return false;
                }
                LoggerComponent.this.m_context.registerErrorCondition("Error occurred during initial attempt to contact CollectionsMonitor with runtime ID = " + cmRuntimeID, 1);
            }
            return cmOnline;
        }

        private boolean validateCollectionsMonitorVersion(String cmRuntimeID) {
            boolean isValid;
            block9: {
                isValid = false;
                try {
                    Object[] params = new Object[]{};
                    String[] signatures = new String[]{};
                    boolean synchronous = true;
                    MBeanOperationInfo[] operations = null;
                    MBeanInfo info = (MBeanInfo)LoggerComponent.this.m_frameworkContext.invoke(cmRuntimeID, "getMBeanInfo", params, signatures, synchronous, 0L);
                    if (info != null) {
                        operations = info.getOperations();
                    }
                    boolean methodFound = false;
                    int len = 0;
                    if (operations != null) {
                        len = operations.length;
                    }
                    for (int i = 0; i < len; ++i) {
                        if (!operations[i].getName().equals(LoggerComponent.GET_STORED_NOTIFICATIONS_METHOD_NAME)) continue;
                        methodFound = true;
                        break;
                    }
                    if (methodFound) {
                        isValid = true;
                    }
                }
                catch (Exception e) {
                    if ((LoggerComponent.this.m_traceMask & 0x20) <= 0) break block9;
                    if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                        LoggerComponent.this.m_context.logMessage("Exception while checking CollectionsMonitor for existence of \"getStoredMetricsAndNotificationsData\" method; likely that CollectionsMonitor instance is an older version that does not support this method, CollectionsMonitor runtimeID = " + cmRuntimeID, (Throwable)e, 7);
                    }
                    LoggerComponent.this.m_context.logMessage("Exception while checking CollectionsMonitor for existence of \"getStoredMetricsAndNotificationsData\" method; likely that CollectionsMonitor instance is an older version that does not support this method.", (Throwable)e, 7);
                }
            }
            if (!isValid) {
                if ((LoggerComponent.this.m_traceMask & 0x10) > 0 && (LoggerComponent.this.m_traceMask & 1) > 0) {
                    LoggerComponent.this.m_context.logMessage("Invalid CollectionsMonitor specified for this Logger instance [likely that CollectionsMonitor instance is an older version that does not support \"getStoredMetricsAndNotificationsData\" method], CollectionsMonitor runtimeID = " + cmRuntimeID, 7);
                }
                LoggerComponent.this.m_context.logMessage("Invalid CollectionsMonitor Runtime ID specified; please update the LoggerComponent's configuration with the Runtime ID of an existing SonicMQ7.0 [or higher] CollectionsMonitor instance.", 1);
            }
            return isValid;
        }

        private boolean setCMStatusMsgFlags(String cmRuntimeID) {
            boolean statusMsgLogged = false;
            try {
                boolean online = this.isCollectionsMonitorOnline(cmRuntimeID);
                if (!online) {
                    if (!this.m_cmWaitingMessageLogged) {
                        LoggerComponent.this.m_frameworkContext.logMessage("CollectionsMonitor not yet in ONLINE state; LoggerComponent will continue attempts to contact the CollectionsMonitor...", 3);
                        this.m_cmWaitingMessageLogged = true;
                    }
                } else if (this.m_cmWaitingMessageLogged) {
                    LoggerComponent.this.m_frameworkContext.logMessage("CollectionsMonitor now in ONLINE state; LoggerComponent will poll CollectionsMonitor for stored notifications and metrics...", 3);
                    this.m_cmWaitingMessageLogged = false;
                }
                statusMsgLogged = true;
                this.m_retrievalFailure = null;
            }
            catch (Exception e) {
                if ((LoggerComponent.this.m_traceMask & 0x20) > 0 && this.m_retrievalFailure != null && (!e.getClass().isInstance(this.m_retrievalFailure) || e.getMessage().equals(this.m_retrievalFailure.getMessage()))) {
                    if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                        LoggerComponent.this.m_context.logMessage("Exception while attempting to repeatedly contact CollectionsMonitor after initial failure, CollectionsMonitor runtimeID = " + cmRuntimeID, (Throwable)e, 7);
                        this.m_retrievalFailure = e;
                    } else {
                        LoggerComponent.this.m_context.logMessage("Exception while attempting to repeatedly contact CollectionsMonitor after initial failure...", (Throwable)e, 7);
                        this.m_retrievalFailure = e;
                    }
                }
                LoggerComponent.this.m_frameworkContext.logMessage("Error while attempting to contact CollectionsMonitor = " + cmRuntimeID, (Throwable)e, 1);
            }
            return statusMsgLogged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logStoredMetrics(String cmRuntimeID, String[] componentCollectionIDs) {
            boolean getMoreMetrics = true;
            IMonitoredMetrics monitoredMetrics = null;
            while (getMoreMetrics) {
                try {
                    long lookback;
                    Object object = LoggerComponent.this.m_changeLock;
                    synchronized (object) {
                        lookback = LoggerComponent.this.m_maxLookbackPeriod * 60000;
                    }
                    monitoredMetrics = null;
                    Object[] params = new Object[]{componentCollectionIDs, this.m_lastMetricRetrievalTimestamp, new Long(lookback)};
                    String[] signatures = new String[]{"[Ljava.lang.String;", "java.lang.Long", "java.lang.Long"};
                    boolean synchronous = true;
                    long cmElapsedTime = System.currentTimeMillis();
                    monitoredMetrics = (IMonitoredMetrics)LoggerComponent.this.m_frameworkContext.invoke(cmRuntimeID, LoggerComponent.GET_STORED_METRICS_METHOD_NAME, params, signatures, synchronous, 0L);
                    cmElapsedTime = System.currentTimeMillis() - cmElapsedTime;
                    long logElapsedTime = System.currentTimeMillis();
                    try {
                        this.processRetrievedMetrics(monitoredMetrics);
                        logElapsedTime = System.currentTimeMillis() - logElapsedTime;
                        this.m_metricLogFailure = null;
                    }
                    catch (Exception e) {
                        if (monitoredMetrics.getMetrics().length > 0) {
                            this.m_lastMetricRetrievalTimestamp = new Long(monitoredMetrics.getLatestTimestamp());
                        }
                        if ((LoggerComponent.this.m_traceMask & 0x20) <= 0) break;
                        if (this.m_metricLogFailure == null || !e.getClass().isInstance(this.m_metricLogFailure) || e.getMessage().equals(this.m_metricLogFailure.getMessage())) {
                            if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                                LoggerComponent.this.m_context.logMessage("Failure while logging metric to log4j, trace follows...", (Throwable)e, 7);
                            } else {
                                LoggerComponent.this.m_context.logMessage("Failure while logging metric to log4j", 7);
                            }
                        }
                        this.m_metricLogFailure = e;
                        break;
                    }
                    getMoreMetrics = monitoredMetrics.hasMoreDataToRetrieve();
                    if ((LoggerComponent.this.m_traceMask & 0x80) > 0) {
                        StringBuffer traceMessage = new StringBuffer("Retrieve and log metrics: ");
                        traceMessage.append("retrieve duration (millis)=").append(cmElapsedTime).append(", log duration (millis)=").append(logElapsedTime);
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            traceMessage.append(", timestamp1=").append(this.m_lastNotificationRetrievalTimestamp).append(", lookback=").append(lookback);
                            traceMessage.append(", metric count=").append(monitoredMetrics.getMetrics().length).append(", timestamp2=").append(monitoredMetrics.getLatestTimestamp()).append(", more=").append(getMoreMetrics);
                        }
                        LoggerComponent.this.m_context.logMessage(traceMessage.toString(), 7);
                    }
                    if (monitoredMetrics.getMetrics().length > 0) {
                        this.m_lastMetricRetrievalTimestamp = new Long(monitoredMetrics.getLatestTimestamp());
                    }
                    this.m_retrievalFailure = null;
                }
                catch (Exception ex) {
                    getMoreMetrics = false;
                    if (LoggerComponent.this.m_stopping) {
                        return;
                    }
                    if ((LoggerComponent.this.m_traceMask & 0x20) > 0 && (this.m_retrievalFailure == null || !ex.getClass().isInstance(this.m_retrievalFailure) || ex.getMessage().equals(this.m_retrievalFailure.getMessage()))) {
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            LoggerComponent.this.m_context.logMessage("Exception while attempting to retrieve stored metrics by invoking CollectionsMonitor's \"getStoredMetrics\" method, CollectionsMonitor may not be ONLINE - CollectionsMonitor runtimeID = " + cmRuntimeID, (Throwable)ex, 7);
                        }
                        this.m_retrievalFailure = ex;
                    }
                    if (this.setCMStatusMsgFlags(cmRuntimeID)) continue;
                    LoggerComponent.this.m_context.registerErrorCondition("Error occurred while attempting to contact CollectionsMonitor = " + cmRuntimeID, 1);
                    Object object = LoggerComponent.this.m_lock;
                    synchronized (object) {
                        LoggerComponent.this.stop();
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logStoredNotifications(String cmRuntimeID, String[] componentCollectionIDs) {
            boolean getMoreNotifications = true;
            IMonitoredNotifications monitoredNotifications = null;
            while (getMoreNotifications) {
                try {
                    long lookback;
                    Object object = LoggerComponent.this.m_changeLock;
                    synchronized (object) {
                        lookback = LoggerComponent.this.m_maxLookbackPeriod * 60000;
                    }
                    monitoredNotifications = null;
                    Object[] params = new Object[]{componentCollectionIDs, this.m_lastNotificationRetrievalTimestamp, new Long(lookback)};
                    String[] signatures = new String[]{"[Ljava.lang.String;", "java.lang.Long", "java.lang.Long"};
                    boolean synchronous = true;
                    long cmElapsedTime = System.currentTimeMillis();
                    monitoredNotifications = (IMonitoredNotifications)LoggerComponent.this.m_frameworkContext.invoke(cmRuntimeID, LoggerComponent.GET_STORED_NOTIFICATIONS_METHOD_NAME, params, signatures, synchronous, 0L);
                    cmElapsedTime = System.currentTimeMillis() - cmElapsedTime;
                    long logElapsedTime = System.currentTimeMillis();
                    try {
                        this.processRetrievedNotifications(monitoredNotifications);
                        logElapsedTime = System.currentTimeMillis() - logElapsedTime;
                        this.m_notificationLogFailure = null;
                    }
                    catch (Exception e) {
                        if (monitoredNotifications.getNotifications().length > 0) {
                            this.m_lastNotificationRetrievalTimestamp = new Long(monitoredNotifications.getLatestTimestamp());
                        }
                        if ((LoggerComponent.this.m_traceMask & 0x20) <= 0) break;
                        if (this.m_notificationLogFailure == null || !e.getClass().isInstance(this.m_notificationLogFailure) || e.getMessage().equals(this.m_notificationLogFailure.getMessage())) {
                            if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                                LoggerComponent.this.m_context.logMessage("Failure while logging notification to log4j, trace follows...", (Throwable)e, 7);
                            } else {
                                LoggerComponent.this.m_context.logMessage("Failure while logging notification to log4j", 7);
                            }
                        }
                        this.m_notificationLogFailure = e;
                        break;
                    }
                    getMoreNotifications = monitoredNotifications.hasMoreDataToRetrieve();
                    if ((LoggerComponent.this.m_traceMask & 0x80) > 0) {
                        StringBuffer traceMessage = new StringBuffer("Retrieve and log notifications: ");
                        traceMessage.append("retrieve duration (millis)=").append(cmElapsedTime).append(", log duration (millis)=").append(logElapsedTime);
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            traceMessage.append(", timestamp1=").append(this.m_lastNotificationRetrievalTimestamp).append(", lookback=").append(lookback);
                            traceMessage.append(", notification count=").append(monitoredNotifications.getNotifications().length).append(", timestamp2=").append(monitoredNotifications.getLatestTimestamp()).append(", more=").append(getMoreNotifications);
                        }
                        LoggerComponent.this.m_context.logMessage(traceMessage.toString(), 7);
                    }
                    if (monitoredNotifications.getNotifications().length > 0) {
                        this.m_lastNotificationRetrievalTimestamp = new Long(monitoredNotifications.getLatestTimestamp());
                    }
                    this.m_retrievalFailure = null;
                }
                catch (Exception ex) {
                    getMoreNotifications = false;
                    if (LoggerComponent.this.m_stopping) {
                        return;
                    }
                    if ((LoggerComponent.this.m_traceMask & 0x20) > 0 && (this.m_retrievalFailure == null || !ex.getClass().isInstance(this.m_retrievalFailure) || ex.getMessage().equals(this.m_retrievalFailure.getMessage()))) {
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            LoggerComponent.this.m_context.logMessage("Exception while attempting to retrieved stored notifications by invoking CollectionsMonitor's \"getStoredNotifications\" method, CollectionsMonitor may not be ONLINE - CollectionsMonitor runtimeID = " + cmRuntimeID, (Throwable)ex, 7);
                        }
                        this.m_retrievalFailure = ex;
                    }
                    if (this.setCMStatusMsgFlags(cmRuntimeID)) continue;
                    LoggerComponent.this.m_context.registerErrorCondition("Error occurred while attempting to contact CollectionsMonitor = " + cmRuntimeID, 1);
                    Object object = LoggerComponent.this.m_lock;
                    synchronized (object) {
                        LoggerComponent.this.stop();
                    }
                    return;
                }
            }
        }

        private void processRetrievedMetrics(IMonitoredMetrics monitoredMetrics) throws Exception {
            IHistoricalMetric[] metrics = monitoredMetrics.getMetrics();
            int n = metrics.length;
            for (int i = 0; i < n; ++i) {
                this.logMetric(metrics[i]);
            }
        }

        private void processRetrievedNotifications(IMonitoredNotifications monitoredNotifications) throws Exception {
            INotification[] notifications = monitoredNotifications.getNotifications();
            int n = notifications.length;
            for (int i = 0; i < n; ++i) {
                this.logNotification(notifications[i]);
            }
        }

        private void logNotification(INotification notification) {
            try {
                if ((LoggerComponent.this.m_traceMask & 0x40) > 0) {
                    if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                        long timestamp = notification.getTimeStamp();
                        Date timestampDate = new Date(timestamp);
                        LoggerComponent.this.m_context.logMessage("Logging notification with event name: " + notification.getEventName() + ", event type: " + notification.getType() + ", source host: " + notification.getSourceHost() + ", source component: " + notification.getSourceIdentity().getCanonicalName() + ", and timestamp: " + timestampDate.toString(), 7);
                    } else {
                        LoggerComponent.this.m_context.logMessage("Logging notification...", 7);
                    }
                }
                Object logEntry = this.formatNotification(notification);
                int severity = notification.getSeverity();
                String context = LoggerComponent.LOGGER_NOTIFICATION_PREFIX + notification.getType();
                Logger logger = Logger.getLogger((String)context);
                if (severity == 1) {
                    logger.log((Priority)Level.ERROR, logEntry);
                } else if (severity == 2) {
                    logger.log((Priority)Level.WARN, logEntry);
                } else {
                    logger.log((Priority)Level.INFO, logEntry);
                }
                this.updateStatistic(LoggerComponent.this.m_notificationsLoggedPerMinuteStatistic, 1L);
                this.m_notificationLogFailure = null;
            }
            catch (RuntimeException e) {
                if ((LoggerComponent.this.m_traceMask & 0x20) > 0) {
                    if (this.m_notificationLogFailure == null || !e.getClass().isInstance(this.m_notificationLogFailure) || e.getMessage().equals(this.m_notificationLogFailure.getMessage())) {
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            LoggerComponent.this.m_context.logMessage("Failure while logging notification to log4j, trace follows...", (Throwable)e, 7);
                        } else {
                            LoggerComponent.this.m_context.logMessage("Failure while logging notification to log4j", (Throwable)e, 7);
                        }
                    }
                    this.m_notificationLogFailure = e;
                }
                throw e;
            }
        }

        private Object formatNotification(INotification notification) {
            return LoggerComponent.this.getLogFormatter().formatNotification(notification);
        }

        private void logMetric(IHistoricalMetric metric) {
            try {
                if ((LoggerComponent.this.m_traceMask & 0x40) > 0) {
                    if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                        LoggerComponent.this.m_context.logMessage("Logging metric with metric name: " + metric.getMetricIdentity().getAbsoluteName() + ", value: " + metric.getValue() + ", source: " + metric.getSource() + ", and timestamp: " + metric.getCurrencyTimestamp(), 7);
                    } else {
                        LoggerComponent.this.m_context.logMessage("Logging metric...", 7);
                    }
                }
                Object logEntry = this.formatMetric(metric);
                String periodDelimitedContext = LoggerComponent.LOGGER_METRIC_PREFIX + this.canonicalToLog4jFormat(metric.getSource());
                Logger logger = Logger.getLogger((String)periodDelimitedContext);
                logger.log((Priority)Level.INFO, logEntry);
                this.updateStatistic(LoggerComponent.this.m_metricsLoggedPerMinuteStatistic, 1L);
                this.m_metricLogFailure = null;
            }
            catch (RuntimeException e) {
                if ((LoggerComponent.this.m_traceMask & 0x20) > 0) {
                    if (this.m_metricLogFailure == null || !e.getClass().isInstance(this.m_metricLogFailure) || e.getMessage().equals(this.m_metricLogFailure.getMessage())) {
                        if ((LoggerComponent.this.m_traceMask & 1) > 0) {
                            LoggerComponent.this.m_context.logMessage("Failure while logging metric to log4j, trace follows...", (Throwable)e, 7);
                        } else {
                            LoggerComponent.this.m_context.logMessage("Failure while logging metric to log4j", (Throwable)e, 7);
                        }
                    }
                    this.m_metricLogFailure = e;
                }
                throw e;
            }
        }

        private Object formatMetric(IHistoricalMetric metric) {
            return LoggerComponent.this.getLogFormatter().formatHistoricalMetric(metric);
        }

        private String canonicalToLog4jFormat(String canonicalName) {
            int colonIndex = canonicalName.indexOf(":ID=");
            String first = canonicalName.substring(0, colonIndex);
            String second = canonicalName.substring(colonIndex + 4);
            return first + "." + second;
        }

        private void updateStatistic(IStatistic statistic, long value) {
            IStatistic s = statistic;
            if (s != null) {
                s.updateValue(value);
            }
        }

        public Object getLoggingThreadLockObj() {
            return this.m_loggingThreadLockObj;
        }
    }
}

