/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.logger;

import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.logger.LogFormatter;
import java.util.Map;
import javax.management.Notification;

class XmlLogFormatter
implements LogFormatter {
    public static final XmlLogFormatter INSTANCE = new XmlLogFormatter();
    private static final String START_CDATA = "<![CDATA[";
    private static final String END_CDATA = "]]>";

    private XmlLogFormatter() {
    }

    @Override
    public Object formatHistoricalMetric(IHistoricalMetric metric) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<DomainMetric context='").append(metric.getSource()).append("'>");
        buffer.append("<Metric id='").append(metric.getMetricIdentity().getName()).append("'>");
        buffer.append(metric.getValue());
        buffer.append("</Metric>");
        buffer.append("<Timestamp>");
        buffer.append(metric.getCurrencyTimestamp());
        buffer.append("</Timestamp>");
        buffer.append("</DomainMetric>");
        return buffer.toString();
    }

    @Override
    public Object formatNotification(INotification notification) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version='1.0'?>");
        buffer.append("<DomainNotification>");
        buffer.append("<Type>");
        XmlLogFormatter.appendElementContent(buffer, notification.getType());
        buffer.append("</Type>");
        buffer.append("<Source>");
        if (notification instanceof Notification) {
            XmlLogFormatter.appendElementContent(buffer, ((Notification)notification).getSource());
        } else {
            XmlLogFormatter.appendElementContent(buffer, notification.getSourceIdentity().getCanonicalName());
        }
        buffer.append("</Source>");
        buffer.append("<SequenceNumber>");
        buffer.append(notification.getSequenceNumber());
        buffer.append("</SequenceNumber>");
        if (notification instanceof Notification) {
            buffer.append("<UserData>");
            XmlLogFormatter.appendElementContent(buffer, ((Notification)notification).getUserData());
            buffer.append("</UserData>");
        }
        buffer.append("<TimeStamp>");
        buffer.append(notification.getTimeStamp());
        buffer.append("</TimeStamp>");
        Object[] attributes = notification.getAttributes().entrySet().toArray();
        buffer.append("<Attributes>");
        for (int i = 0; i < attributes.length; ++i) {
            Map.Entry entry = (Map.Entry)attributes[i];
            Object attribute = entry.getValue();
            if (attribute == null || !attribute.getClass().isArray()) {
                buffer.append("<Attribute id='").append(entry.getKey()).append("'>");
                XmlLogFormatter.appendElementContent(buffer, attribute);
                buffer.append("</Attribute>");
                continue;
            }
            Object[] attributeArray = (Object[])attribute;
            for (int j = 0; j < attributeArray.length; ++j) {
                buffer.append("<Attribute id='").append(entry.getKey()).append("'>");
                XmlLogFormatter.appendElementContent(buffer, attributeArray[j]);
                buffer.append("</Attribute>");
            }
        }
        buffer.append("</Attributes>");
        buffer.append("</DomainNotification>");
        return buffer.toString();
    }

    private static void appendElementContent(StringBuffer buffer, Object content) {
        if (content == null) {
            buffer.append("null");
        } else {
            String value = content.toString();
            if (value.indexOf("<") != -1 || value.indexOf("&") != -1 || value.indexOf("\"") != -1) {
                buffer.append(START_CDATA).append(value).append(END_CDATA);
            } else {
                buffer.append(value);
            }
        }
    }
}

