/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.dstriggers;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeMetaData;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.ITriggerDSContext;
import com.sonicsw.mf.common.config.IValidationDSContext;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.IValidator;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import com.sonicsw.mf.common.util.ReferentialIntegrity;
import java.util.Iterator;
import java.util.Map;

public final class DeleteTrigger
implements IValidator {
    private static final String[] TYPES_VALIDATED = new String[]{"MF_DOMAIN", "MF_MANAGEMENT_PERMISSIONS", "MF_AUTHENTICATION_GROUP", "MF_AUTHENTICATION_USER", "MF_AUTHENTICATION_DOMAIN", "MF_CONTAINER", "MF_COMPONENT_COLLECTION", "MF_ACTIVATION_DAEMON", "MF_DIRECTORY_SERVICE", "MF_BACKUP_DIRECTORY_SERVICE", "MF_AGENT_MANAGER", "MF_BACKUP_AGENT_MANAGER", "MF_COLLECTION_MONITOR", "MF_GENERIC_COMPONENT", "MF_LOGGER"};
    private static final String RELEASE_VERSION = "107";

    public String getReleaseVersion() {
        return RELEASE_VERSION;
    }

    public String[] getElementTypesValidated() {
        return TYPES_VALIDATED;
    }

    public void onDelete(ITriggerDSContext dsContext, IDirElement[] beforeImages) throws DirectoryServiceException {
        block0: for (int i = 0; i < beforeImages.length; ++i) {
            String type = beforeImages[i].getIdentity().getType();
            if (type.equals("MF_CONTAINER")) {
                ContainerIdentity containerID = new ContainerIdentity((IElement)beforeImages[i]);
                DeleteTrigger.removeContainerFromActivationDaemons(dsContext, beforeImages[i].getIdentity().getName());
                DeleteTrigger.removeContainerFromContainerCollections(dsContext, containerID.getCanonicalName());
                DeleteTrigger.removeContainerComponentsFromComponentCollections(dsContext, containerID.getCanonicalNamePrefix());
                continue;
            }
            if (type.equals("MF_COMPONENT_COLLECTION")) {
                DeleteTrigger.removeCollectionFromCollectionsMonitors(dsContext, beforeImages[i].getIdentity().getName());
                DeleteTrigger.removeCollectionFromLoggers(dsContext, beforeImages[i].getIdentity().getName());
                continue;
            }
            if (type.equals("MF_AUTHENTICATION_DOMAIN")) {
                DeleteTrigger.onDeleteOfAuthDomain(dsContext, beforeImages[i].getIdentity().getName(), beforeImages[i].getAttributes());
                continue;
            }
            for (int j = 6; j < TYPES_VALIDATED.length; ++j) {
                if (!type.equals(TYPES_VALIDATED[j])) continue;
                ReferentialIntegrity.removeComponent((ITriggerDSContext)dsContext, (String)beforeImages[i].getIdentity().getName());
                continue block0;
            }
        }
    }

    public void validate(IValidationDSContext dsContext, IValidationElementChange[] changes) throws Exception {
        for (int i = 0; i < changes.length; ++i) {
            if (changes[i].skipValidation()) continue;
            if (changes[i].getChangeType() == 2) {
                IDirElement beforeImage = (IDirElement)changes[i].getBeforeImage();
                if (beforeImage == null) {
                    return;
                }
                IElementIdentity identity = beforeImage.getIdentity();
                String type = identity.getType();
                if (type.equals("MF_DOMAIN") || type.equals("MF_MANAGEMENT_PERMISSIONS")) {
                    this.onValidateDeleteOfSecurityElements(identity);
                    continue;
                }
                if (type.equals("MF_AUTHENTICATION_GROUP")) {
                    this.onValidateDeleteOfGroup(beforeImage);
                    continue;
                }
                if (!type.equals("MF_AUTHENTICATION_USER")) continue;
                this.onValidateDeleteOfUser(beforeImage);
                continue;
            }
            if (changes[i].getChangeType() != 1) continue;
        }
    }

    private void onValidateDeleteOfSecurityElements(IElementIdentity identity) throws DirectoryServiceException {
        throw new DirectoryServiceException("Failed to delete element \"" + identity.getName() + "\"; deleting of this element is not allowed");
    }

    private void onValidateDeleteOfGroup(IDirElement beforeImage) throws DirectoryServiceException {
        IAttributeSet groupAttrs = beforeImage.getAttributes();
        String groupName = (String)groupAttrs.getAttribute("GROUP_NAME");
        if (groupName.equals("Administrators")) {
            throw new DirectoryServiceException("Failed to delete \"Administrators\" group; deleting of this group is not allowed");
        }
    }

    private void onValidateDeleteOfUser(IDirElement beforeImage) throws DirectoryServiceException {
        IAttributeSet userAttrs = beforeImage.getAttributes();
        String userName = (String)userAttrs.getAttribute("USER_NAME");
        if (userName.equals("Administrator")) {
            throw new DirectoryServiceException("Failed to delete user \"Administrator\"; deleting of this user is not allowed");
        }
    }

    public static void onDeleteOfAuthDomain(ITriggerDSContext ds, String authDescriptorID, IAttributeSet authAtts) throws DirectoryServiceException {
        String domainName = null;
        try {
            domainName = (String)authAtts.getAttribute("DOMAIN_NAME");
            if (domainName == null) {
                domainName = authDescriptorID;
            }
        }
        catch (Exception e) {
            domainName = authDescriptorID;
        }
        IElementIdentity[] ids = ds.listElements("/mq/brokers");
        for (int i = 0; i < ids.length; ++i) {
            IDirElement broker = ds.getElement(ids[i].getName());
            IAttributeSet brokerAtts = broker.getAttributes();
            try {
                String brokerAuth;
                IAttributeSet brokerRefs = (IAttributeSet)brokerAtts.getAttribute("CONFIG_ELEMENT_REFERENCES");
                Reference authRef = (Reference)brokerRefs.getAttribute("AUTHENTICATION_DOMAIN_CONFIG_ELEMENT_REF");
                String string = brokerAuth = authRef != null ? authRef.getElementName() : null;
                if (brokerAuth == null || !brokerAuth.equals(authDescriptorID)) continue;
                throw new DirectoryServiceException("Cannot delete " + domainName + " - used by broker " + brokerAtts.getAttribute("BROKER_NAME"));
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Delete trigger failed on deletion of " + domainName + ": " + e.toString(), (Throwable)e);
            }
        }
        IDirIdentity[] ids1 = ds.listDirectories("/policies");
        for (int i = 0; i < ids1.length; ++i) {
            String descName = null;
            String policyAuth = null;
            String policyName = null;
            try {
                EntityName policyDir = new EntityName(ids1[i].getName());
                EntityName policyDesc = policyDir.createChild("_MQPolicyDescriptor");
                descName = policyDesc.getName();
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Delete trigger failed on deletion of " + domainName + ": " + e.toString(), (Throwable)e);
            }
            try {
                IDirElement descElement = ds.getElement(descName);
                IAttributeSet policyDescAtts = descElement.getAttributes();
                Reference policyAuthRef = (Reference)policyDescAtts.getAttribute("DEFAULT_DOMAIN");
                policyAuth = policyAuthRef != null ? policyAuthRef.getElementName() : null;
                policyName = (String)policyDescAtts.getAttribute("POLICY_NAME");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (policyAuth == null || !policyAuth.equals(authDescriptorID)) continue;
            throw new DirectoryServiceException("Cannot delete " + domainName + " - used by policy " + policyName);
        }
        String authDomain = null;
        try {
            IDirElement domain = ds.getElement("/domain/domain");
            IAttributeSet domainAtts = domain.getAttributes();
            Reference domainAuthRef = (Reference)domainAtts.getAttribute("AUTHENTICATION_DOMAIN");
            authDomain = domainAuthRef != null ? domainAuthRef.getElementName() : null;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (authDomain != null && authDomain.equals(authDescriptorID)) {
            throw new DirectoryServiceException("Cannot delete " + domainName + " - used by management security");
        }
    }

    public static void removeContainerFromActivationDaemons(ITriggerDSContext ds, String containerConfigID) throws DirectoryServiceException {
        if (!ds.directoryExists("/activation")) {
            return;
        }
        try {
            FromDirectory f = new FromDirectory("/activation");
            IDirElement[] elements = ds.getElements(new Query().setFrom((From)f), true);
            block2: for (int i = 0; i < elements.length; ++i) {
                IAttributeSet daemonAtts = elements[i].getAttributes();
                IAttributeMetaData daemonAttsMeta = daemonAtts.getAttributeMetaData("CONTAINERS");
                if (daemonAttsMeta.isFromTemplate()) continue;
                IAttributeSet containers = (IAttributeSet)daemonAtts.getAttribute("CONTAINERS");
                for (Map.Entry entry : containers.getAttributes().entrySet()) {
                    IAttributeSet containerAttrs = (IAttributeSet)entry.getValue();
                    if (!((Reference)containerAttrs.getAttribute("CONTAINER_REF")).getElementName().equals(containerConfigID)) continue;
                    containers.deleteAttribute((String)entry.getKey());
                    ds.setElement((IDeltaElement)elements[i].doneUpdate());
                    continue block2;
                }
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    public static void removeCollectionFromCollectionsMonitors(ITriggerDSContext ds, String collectionConfigID) throws DirectoryServiceException {
        if (!ds.directoryExists("/monitors")) {
            return;
        }
        try {
            FromDirectory f = new FromDirectory("/monitors");
            IDirElement[] elements = ds.getElements(new Query().setFrom((From)f), true);
            block2: for (int i = 0; i < elements.length; ++i) {
                IAttributeSet monitorAtts = elements[i].getAttributes();
                IAttributeMetaData monitorAttsMeta = monitorAtts.getAttributeMetaData("COLLECTIONS");
                if (monitorAttsMeta.isFromTemplate()) continue;
                IAttributeList collections = (IAttributeList)monitorAtts.getAttribute("COLLECTIONS");
                for (int j = collections.getCount(); j > 0; --j) {
                    if (!((Reference)collections.getItem(j - 1)).getElementName().equals(collectionConfigID)) continue;
                    collections.deleteAttributeItem(j - 1);
                    ds.setElement((IDeltaElement)elements[i].doneUpdate());
                    continue block2;
                }
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    public static void removeCollectionFromLoggers(ITriggerDSContext ds, String collectionConfigID) throws DirectoryServiceException {
        if (!ds.directoryExists("/loggers")) {
            return;
        }
        try {
            FromDirectory f = new FromDirectory("/loggers");
            IDirElement[] elements = ds.getElements(new Query().setFrom((From)f), true);
            block2: for (int i = 0; i < elements.length; ++i) {
                IAttributeSet monitorAtts = elements[i].getAttributes();
                IAttributeMetaData monitorAttsMeta = monitorAtts.getAttributeMetaData("COMPONENT_COLLECTIONS");
                if (monitorAttsMeta.isFromTemplate()) continue;
                IAttributeSet collections = (IAttributeSet)monitorAtts.getAttribute("COMPONENT_COLLECTIONS");
                for (Map.Entry entry : collections.getAttributes().entrySet()) {
                    Reference reference = (Reference)entry.getValue();
                    if (!reference.getElementName().equals(collectionConfigID)) continue;
                    String key = (String)entry.getKey();
                    collections.deleteAttribute(key);
                    ds.setElement((IDeltaElement)elements[i].doneUpdate());
                    continue block2;
                }
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    private static void removeContainerFromContainerCollections(ITriggerDSContext ds, String canonicalName) throws DirectoryServiceException {
        if (!ds.directoryExists("/containerCollections")) {
            return;
        }
        try {
            FromDirectory f = new FromDirectory("/containerCollections");
            IDirElement[] elements = ds.getElements(new Query().setFrom((From)f), true);
            block2: for (int i = 0; i < elements.length; ++i) {
                IAttributeSet collectionAtts = elements[i].getAttributes();
                if (collectionAtts.getAttributeMetaData("CONTAINERS").isFromTemplate()) continue;
                IAttributeSet set = (IAttributeSet)collectionAtts.getAttribute("CONTAINERS");
                for (Map.Entry entry : set.getAttributes().entrySet()) {
                    IAttributeSet itemSet = (IAttributeSet)entry.getValue();
                    String id = (String)itemSet.getAttribute("CONTAINER_RUNTIME_ID");
                    if (!id.equals(canonicalName)) continue;
                    set.deleteAttribute((String)entry.getKey());
                    ds.setElement((IDeltaElement)elements[i].doneUpdate());
                    continue block2;
                }
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    private static void removeContainerComponentsFromComponentCollections(ITriggerDSContext ds, String containerNamePrefix) throws DirectoryServiceException {
        if (!ds.directoryExists("/componentCollections")) {
            return;
        }
        try {
            FromDirectory f = new FromDirectory("/componentCollections");
            IDirElement[] elements = ds.getElements(new Query().setFrom((From)f), true);
            for (int i = 0; i < elements.length; ++i) {
                IAttributeSet collectionAtts = elements[i].getAttributes();
                if (collectionAtts.getAttributeMetaData("COMPONENTS").isFromTemplate()) continue;
                IAttributeSet set = (IAttributeSet)collectionAtts.getAttribute("COMPONENTS");
                Iterator iterator = set.getAttributes().entrySet().iterator();
                boolean hasChanges = false;
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    IAttributeSet itemSet = (IAttributeSet)entry.getValue();
                    String id = (String)itemSet.getAttribute("COMPONENT_RUNTIME_ID");
                    if (!id.startsWith(containerNamePrefix)) continue;
                    set.deleteAttribute((String)entry.getKey());
                    hasChanges = true;
                }
                if (!hasChanges) continue;
                ds.setElement((IDeltaElement)elements[i].doneUpdate());
            }
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString(), e);
        }
    }

    public void onUpdate(ITriggerDSContext dsContext, IDirElement[] beforeImages, IDeltaElement[] afterImages) throws DirectoryServiceException {
    }

    public void onCreate(ITriggerDSContext dsContext, IDirElement[] afterImages) throws DirectoryServiceException {
    }
}

