/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.util;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.framework.util.RollingFileLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogFile {
    private static final int MAX_TAIL_LENGTH = 204800;
    private static final long DEFAULT_ROLLOVER_SIZE = 0x100000L;
    private static final long MIN_ROLLOVER_SIZE = 524288L;
    private static final long MAX_ROLLOVER_SIZE = 0x80000000L;
    private static final boolean QA_BEHAVIOR = System.getProperty("sonicsw.mf.qa.abort") != null;
    private String m_path;
    private File m_file;
    private RandomAccessFile m_rwFile;
    private boolean m_isReadOnly = true;
    private boolean m_lastAccessWasRead = false;
    private IComponentContext m_context;
    private long m_rolloverSize = 0x100000L;
    private Buffer m_tail;
    private final SimpleDateFormat m_dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat m_rolloverDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd.HH-mm");

    LogFile(String path, boolean isReadOnly, IComponentContext context) throws IOException {
        this.m_path = path;
        this.m_isReadOnly = isReadOnly;
        this.m_context = context;
        this.init();
    }

    private void init() throws IOException {
        this.m_file = new File(this.m_path);
        this.m_path = this.m_file.getCanonicalPath();
        this.m_rwFile = new RandomAccessFile(this.m_path, this.m_isReadOnly ? "r" : "rw");
        if (!this.m_isReadOnly) {
            this.m_tail = new Buffer();
            byte[] bytes = this.read(-1L, 204800L);
            this.m_tail.appendBytes(bytes);
        }
    }

    synchronized void close() throws IOException {
        this.m_rwFile.close();
        this.m_tail = null;
        this.m_rwFile = null;
    }

    public void clearLogFile() throws IOException {
        this.m_rwFile.setLength(0L);
    }

    public void saveLogFile(String path) throws IOException {
        int bytesRead;
        this.close();
        File newFile = new File(path);
        String canonicalPath = newFile.getCanonicalPath();
        newFile = new File(canonicalPath);
        byte[] buf = new byte[1024];
        FileInputStream in = new FileInputStream(this.m_file);
        FileOutputStream out = new FileOutputStream(newFile);
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
        in.close();
        out.close();
        this.init();
    }

    String getLogPath() {
        return this.m_path;
    }

    synchronized void write(String logMessage) throws IOException {
        if (this.m_rwFile == null) {
            return;
        }
        if (this.m_isReadOnly) {
            throw new IOException("Log file is read-only: " + this.m_path);
        }
        InterruptedIOException interruptedIOException = null;
        try {
            if (this.m_lastAccessWasRead) {
                long writeOffset = this.length();
                this.m_rwFile.seek(writeOffset);
            }
            this.m_rwFile.write(logMessage.getBytes());
        }
        catch (InterruptedIOException e) {
            interruptedIOException = e;
            if (this.m_lastAccessWasRead) {
                long writeOffset = this.length();
                this.m_rwFile.seek(writeOffset);
            }
            this.m_rwFile.write(logMessage.getBytes());
        }
        if (this.m_tail != null) {
            this.m_tail.appendBytes(logMessage.getBytes());
        }
        if (interruptedIOException != null) {
            throw interruptedIOException;
        }
        this.m_lastAccessWasRead = false;
    }

    synchronized byte[] read(long fromPosn, long readLength) throws IOException {
        if (this.m_rwFile == null) {
            return new byte[0];
        }
        this.m_lastAccessWasRead = true;
        long fileLength = this.length();
        if (fromPosn == -1L) {
            fromPosn = fileLength - readLength;
        }
        if (fromPosn < 0L) {
            fromPosn = 0L;
        }
        if (fromPosn + readLength > fileLength) {
            readLength = fileLength - fromPosn;
        }
        if (this.m_tail != null && readLength == 204800L && (fromPosn == -1L || fromPosn > fileLength - 204800L)) {
            return this.m_tail.getBytes();
        }
        this.m_rwFile.seek(fromPosn);
        byte[] bytes = new byte[(int)readLength];
        this.m_rwFile.read(bytes);
        return bytes;
    }

    synchronized File rollover() throws IOException {
        if (this.m_rwFile == null) {
            return null;
        }
        if (this.length() >= this.m_rolloverSize) {
            File archiveFile;
            boolean dailyRollover;
            boolean hourGranularity;
            File currentFile = new File(this.m_path);
            boolean bl = hourGranularity = RollingFileLogger.CALCULATE_NEXT_ROLLOVER_TIME_IN == 1;
            boolean bl2 = hourGranularity ? RollingFileLogger.LOG_ROLLOVER_CHECK_INTERVAL == 24 : (dailyRollover = RollingFileLogger.LOG_ROLLOVER_CHECK_INTERVAL == 1440);
            if (dailyRollover) {
                Date yesterday = new Date(System.currentTimeMillis() - 86400000L);
                archiveFile = new File(this.m_path + '.' + this.m_dateFormatter.format(yesterday));
                if (archiveFile.exists()) {
                    Date today = new Date(System.currentTimeMillis());
                    archiveFile = new File(this.m_path + '.' + this.m_dateFormatter.format(today));
                }
            } else {
                Date rolloverTime = new Date(System.currentTimeMillis());
                archiveFile = new File(this.m_path + '.' + this.m_rolloverDateTimeFormatter.format(rolloverTime));
            }
            if (archiveFile.exists()) {
                File versionedArchiveFile;
                int suffix = 0;
                while ((versionedArchiveFile = new File(archiveFile.getPath() + '.' + ++suffix)).exists()) {
                }
                archiveFile = versionedArchiveFile;
            }
            if (this.m_context != null) {
                this.m_context.logMessage("Log file rollover initiated...", 3);
            }
            this.m_rwFile.close();
            currentFile.renameTo(archiveFile);
            this.m_rwFile = new RandomAccessFile(currentFile.getPath(), "rw");
            if (this.m_context != null) {
                this.m_context.logMessage("...rollover complete, archived log: " + archiveFile.getPath(), 3);
            }
            return archiveFile;
        }
        return null;
    }

    synchronized long length() {
        try {
            return this.m_rwFile.length();
        }
        catch (IOException iOException) {
            return this.m_file.length();
        }
    }

    void setRolloverThreshold(long rolloverThreshold) {
        if (!QA_BEHAVIOR) {
            if (rolloverThreshold < 524288L) {
                throw new IllegalArgumentException("Rollover threshold cannot be less than 0.5Mb");
            }
            if (rolloverThreshold > 0x80000000L) {
                throw new IllegalArgumentException("Rollover threshold cannot be greater than 1.0Gb");
            }
        }
        this.m_rolloverSize = rolloverThreshold;
    }

    private final class Buffer {
        private byte[] tailBytes = new byte[204800];
        private int tailLength = 0;
        private int tailEnd = 0;

        private Buffer() {
        }

        private void appendBytes(byte[] appendBytes) {
            int start1 = 0;
            int length1 = 0;
            int start2 = 0;
            int length2 = 0;
            if (appendBytes.length > 204800) {
                start1 = appendBytes.length - this.tailBytes.length;
                length1 = 204800 - this.tailEnd;
            } else {
                int remainder = 204800 - this.tailEnd;
                int n = length1 = appendBytes.length <= remainder ? appendBytes.length : remainder;
            }
            if (appendBytes.length - length1 > 0) {
                start2 = start1 + length1;
                length2 = appendBytes.length - start1 - length1;
            }
            if (length1 > 0) {
                System.arraycopy(appendBytes, start1, this.tailBytes, this.tailEnd, length1);
                this.tailEnd += length1;
                if (this.tailEnd >= 204800) {
                    this.tailEnd = 0;
                }
            }
            if (length2 > 0) {
                System.arraycopy(appendBytes, start2, this.tailBytes, 0, length2);
                this.tailEnd = length2;
            }
            this.tailLength += appendBytes.length;
            if (this.tailLength > 204800) {
                this.tailLength = 204800;
            }
        }

        private byte[] getBytes() {
            byte[] bytes = new byte[this.tailLength];
            int start = this.tailLength < 204800 ? 0 : this.tailEnd;
            int length = this.tailLength == 204800 ? this.tailLength - this.tailEnd : this.tailEnd;
            System.arraycopy(this.tailBytes, start, bytes, 0, length);
            if (start > 0) {
                System.arraycopy(this.tailBytes, 0, bytes, length, this.tailLength - length);
            }
            return bytes;
        }
    }
}

