/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.util;

import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class StateManager
implements IStateManager {
    private short[] m_managedStates;
    private short m_currentState;
    private Object m_currentStateLock = new Object();
    private HashMap m_stateControllers = new HashMap();
    private HashSet m_stateListeners = new HashSet();

    public StateManager(short[] managedStates, short initialState) {
        this.m_managedStates = managedStates;
        if (!this.isValidState(initialState)) {
            throw new IllegalArgumentException("Invalid state: " + initialState);
        }
        this.m_currentState = initialState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getState(Object obj) {
        Object object = this.m_currentStateLock;
        synchronized (object) {
            return this.m_currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean requestStateChange(short expectedCurrentState, short desiredState, Object obj) throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if (!this.isValidState(desiredState)) {
            throw new IllegalArgumentException("Invalid state: " + desiredState);
        }
        if (expectedCurrentState != this.m_currentState) {
            return false;
        }
        boolean stateChanged = false;
        short preCallState = this.m_currentState;
        this.doStateChange(desiredState);
        try {
            String key = preCallState + "," + desiredState;
            IStateController controller = (IStateController)this.m_stateControllers.get(key);
            stateChanged = controller == null ? true : controller.changeState();
        }
        finally {
            super.notifyAll();
            Iterator iterator = this.m_stateListeners.iterator();
            while (iterator.hasNext()) {
                if (stateChanged) {
                    ((IStateListener)iterator.next()).stateChanged(preCallState, this.m_currentState);
                    continue;
                }
                ((IStateListener)iterator.next()).stateChangeFailed(this.m_currentState, desiredState);
            }
        }
        return stateChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStateChange(short targetState) {
        short oldState = this.m_currentState;
        Object object = this.m_currentStateLock;
        synchronized (object) {
            this.m_currentState = targetState;
        }
        Iterator iterator = this.m_stateListeners.iterator();
        while (iterator.hasNext()) {
            ((IStateListener)iterator.next()).stateChanging(oldState, this.m_currentState);
        }
    }

    public synchronized void registerStateController(IStateController stateController, short fromState, short toState, Object obj) {
        if (!this.isValidState(fromState)) {
            throw new IllegalArgumentException("Invalid state: " + fromState);
        }
        if (!this.isValidState(toState)) {
            throw new IllegalArgumentException("Invalid state: " + toState);
        }
        String key = fromState + "," + toState;
        if (this.m_stateControllers.containsKey(key)) {
            throw new IllegalStateException("State controller for specified state transition already registered");
        }
        this.m_stateControllers.put(key, stateController);
    }

    public synchronized void registerStateListener(IStateListener stateListener, Object obj) {
        this.m_stateListeners.add(stateListener);
    }

    private boolean isValidState(short state) {
        for (int i = 0; i < this.m_managedStates.length; ++i) {
            if (this.m_managedStates[i] != state) continue;
            return true;
        }
        return false;
    }
}

