/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import java.util.StringTokenizer;

public class URLUtility {
    static BitSet encodedInPath = new BitSet(256);

    public static String encodePath(String path) {
        StringBuffer sb = new StringBuffer();
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char c = path.charAt(i);
            if (c == File.separatorChar) {
                sb.append('/');
                continue;
            }
            if (c <= '\u007f') {
                if (encodedInPath.get(c)) {
                    URLUtility.escape(sb, c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c > '\u07ff') {
                URLUtility.escape(sb, (char)(0xE0 | c >> 12 & 0xF));
                URLUtility.escape(sb, (char)(0x80 | c >> 6 & 0x3F));
                URLUtility.escape(sb, (char)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            URLUtility.escape(sb, (char)(0xC0 | c >> 6 & 0x1F));
            URLUtility.escape(sb, (char)(0x80 | c >> 0 & 0x3F));
        }
        return sb.toString();
    }

    public static String decode(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c != '%') {
                ++i;
            } else {
                try {
                    c = URLUtility.unescape(s, i);
                    i += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c2 = URLUtility.unescape(s, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = URLUtility.unescape(s, i);
                                char c3 = URLUtility.unescape(s, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String canonizeString(String file) {
        int i = 0;
        int lim = file.length();
        while ((i = file.indexOf("/../")) >= 0) {
            lim = file.lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = file.substring(0, lim) + file.substring(i + 3);
                continue;
            }
            file = file.substring(i + 3);
        }
        while ((i = file.indexOf("/./")) >= 0) {
            file = file.substring(0, i) + file.substring(i + 2);
        }
        while (file.endsWith("/..")) {
            i = file.indexOf("/..");
            lim = file.lastIndexOf(47, i - 1);
            if (lim >= 0) {
                file = file.substring(0, lim + 1);
                continue;
            }
            file = file.substring(0, i);
        }
        if (file.endsWith("/.")) {
            file = file.substring(0, file.length() - 1);
        }
        return file;
    }

    public static URL[] classpathToURLArray(String path, String delimitor) throws MalformedURLException {
        if (path == null || path.length() == 0) {
            return new URL[0];
        }
        StringTokenizer st = new StringTokenizer(path, delimitor);
        URL[] urls = new URL[st.countTokens()];
        for (int i = 0; i < urls.length; ++i) {
            String token = st.nextToken();
            File file = new File(token);
            urls[i] = file.exists() ? file.toURL() : new URL(token);
        }
        return urls;
    }

    public static URL fileToEncodedURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (!(path = URLUtility.encodePath(path)).startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    private static void escape(StringBuffer s, char c) {
        s.append('%');
        s.append(Character.forDigit(c >> 4 & 0xF, 16));
        s.append(Character.forDigit(c & 0xF, 16));
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    static {
        encodedInPath.set(61);
        encodedInPath.set(59);
        encodedInPath.set(63);
        encodedInPath.set(47);
        encodedInPath.set(35);
        encodedInPath.set(32);
        encodedInPath.set(60);
        encodedInPath.set(62);
        encodedInPath.set(37);
        encodedInPath.set(34);
        encodedInPath.set(123);
        encodedInPath.set(125);
        encodedInPath.set(124);
        encodedInPath.set(92);
        encodedInPath.set(94);
        encodedInPath.set(91);
        encodedInPath.set(93);
        encodedInPath.set(96);
        for (int i = 0; i < 32; ++i) {
            encodedInPath.set(i);
        }
        encodedInPath.set(127);
    }
}

