/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminNotifications;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemNotifications;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.Select;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.ConfigServerFactory;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigBeanFile;
import com.sonicsw.mx.config.IConfigChangeFilter;
import com.sonicsw.mx.config.IConfigChangeListener;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.Cache;
import com.sonicsw.mx.config.impl.ConfigBeanDocument;
import com.sonicsw.mx.config.impl.ConfigBeanFile;
import com.sonicsw.mx.config.impl.ConfigBeanImpl;
import com.sonicsw.mx.config.impl.ConfigBeanPrototype;
import com.sonicsw.mx.config.impl.ConfigChangeDispatcher;
import com.sonicsw.mx.config.impl.ConfigElementImpl;
import com.sonicsw.mx.config.impl.ConfigElementPrototype;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigTypeDocument;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.Util;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ConfigServer
implements IConfigServer {
    protected static final boolean DEBUG = System.getProperty("debug.cl", "false").equalsIgnoreCase("true");
    protected IDirectoryFileSystemService m_ds = null;
    private ConfigChangeDispatcher m_configChangeDispatcher = null;
    private IElementChangeHandler m_typeChangeHandler = null;
    protected Cache m_typeCache = new Cache();
    protected Cache m_elementCache = new Cache();
    protected IConfigServer m_parent = null;
    protected final boolean m_writeable;
    protected boolean m_closed = false;
    protected boolean m_filterDefaults = true;
    protected Map m_listeners = new HashMap();

    public ConfigServer() {
        this.m_writeable = false;
    }

    public ConfigServer(IDirectoryFileSystemService ds, boolean writeable) throws ConfigServiceException {
        this(ds, writeable, true);
    }

    public ConfigServer(IDirectoryFileSystemService ds, boolean writeable, boolean listen) throws ConfigServiceException {
        if (!(ds instanceof IDirectoryAdminService)) {
            throw new ConfigServiceException("cs-connect-failed");
        }
        try {
            this.m_ds = ds;
            this.m_writeable = writeable;
            if (listen) {
                this.registerElementChangeListener();
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            this.m_ds = null;
            throw new ConfigServiceException("cs-connect-failed", e);
        }
    }

    protected void finalize() throws Throwable {
        this.debugPrintln("finalize");
        super.finalize();
    }

    @Override
    public void close() throws ConfigServiceException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean unregisterChangeListener) throws ConfigServiceException {
        if (!this.m_closed) {
            this.m_closed = true;
            ConfigServer configServer = this;
            synchronized (configServer) {
                this.debugPrintln("close");
                if (unregisterChangeListener) {
                    this.unregisterElementChangeListener();
                }
                this.m_ds = null;
                this.m_parent = null;
            }
        }
    }

    @Override
    public IConfigServer connect() throws ConfigServiceException {
        IConfigServer server = ConfigServerFactory.connectConfigServer(this.m_ds, this.isWriteable(), this.isListening());
        ((ConfigServer)server).setServerParent(this);
        return server;
    }

    @Override
    public IConfigServer connectTransacted() throws ConfigServiceException {
        IConfigServer server = ConfigServerFactory.connectTransactedConfigServer(this.m_ds);
        ((ConfigServer)server).setServerParent(this);
        return server;
    }

    protected void setServerParent(IConfigServer parent) {
        this.m_parent = parent;
    }

    public boolean isListening() {
        return this.m_configChangeDispatcher != null;
    }

    @Override
    public boolean isWriteable() {
        return this.m_writeable;
    }

    @Override
    public boolean isTransacted() {
        return false;
    }

    public String getConfigServerURL() {
        return null;
    }

    public void setFilterDefaults(boolean filterDefaults) {
        this.m_filterDefaults = filterDefaults;
    }

    @Override
    public synchronized void storeConfigElements(IConfigElement[] configElements, String[] deleteElements) throws ConfigServiceException {
        ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
        ArrayList<IConfigElement> ceList = new ArrayList<IConfigElement>();
        if (configElements != null) {
            for (int iCE = 0; iCE < configElements.length; ++iCE) {
                ceList.add(configElements[iCE]);
                ceList.addAll(((ConfigElementImpl)configElements[iCE]).getSubElements());
            }
        }
        for (IConfigElement configElement : ceList) {
            if (configElement.isRemoved()) {
                throw new ConfigServiceException("cs-store-ces-already-removed", new Object[]{configElement.getName()});
            }
            if (!configElement.isModified()) continue;
            try {
                configElement.validateComplete();
                if (elements.contains(configElement)) continue;
                elements.add(configElement);
            }
            catch (ConfigServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigServiceException("cs-store-ces-failed", e);
            }
        }
        configElements = elements.toArray(new IConfigElement[elements.size()]);
        this._storeConfigElements(configElements, deleteElements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _storeConfigElements(IConfigElement[] configElements, String[] deleteElements) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-store-ces-not-connected");
        }
        try {
            int i;
            IDSTransaction txn = this.m_ds.createTransaction();
            if (deleteElements != null) {
                for (i = 0; i < deleteElements.length; ++i) {
                    txn.addDeleteElement(deleteElements[i]);
                }
            }
            for (i = 0; i < configElements.length; ++i) {
                if (((ConfigElementImpl)configElements[i]).m_configServer != this) {
                    throw new ConfigServiceException("cs-store-ces-wrong-cs", new Object[]{configElements[i].getName()});
                }
                InputStream blob = null;
                if (((ConfigElementImpl)configElements[i]).m_blob != null) {
                    blob = ((ConfigElementImpl)configElements[i]).m_blob;
                }
                IBasicElement delta = ((ConfigElementImpl)configElements[i]).doneUpdate();
                if (blob != null) {
                    txn.addAttachBlob(delta, blob);
                } else if (delta instanceof IDeltaDirElement) {
                    txn.addUpdateElement((IDeltaDirElement)delta, true);
                } else if (delta instanceof IDirElement) {
                    txn.addCreateElement((IDirElement)delta);
                }
                if (!configElements[i].isMetaAttributesModified()) continue;
                Map metaAttributes = Util.combineToolMetaAttributes((Map)configElements[i].getMetaAttributes());
                txn.addSetAttributes(configElements[i].getName(), Util.mapToHashMap(metaAttributes));
            }
            ConfigServer configServer = this;
            synchronized (configServer) {
                int i2;
                this.debugPrintln("ConfigServer:_storeConfigElements transaction =", txn);
                this.m_ds.executeTransaction(txn);
                for (i2 = 0; i2 < configElements.length; ++i2) {
                    this.elementStored((ConfigElementImpl)configElements[i2]);
                }
                if (deleteElements != null) {
                    for (i2 = 0; i2 < deleteElements.length; ++i2) {
                        this.elementRemoved(deleteElements[i2]);
                    }
                }
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-store-ces-failed", e);
        }
    }

    public synchronized void storeConfigType(IConfigType configType) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-store-ct-not-connected", new Object[]{configType.getName()});
        }
        try {
            IConfigType[] configTypes = new IConfigType[]{configType};
            this.storeConfigTypes(configTypes, null);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-store-ct-failed", new Object[]{configType.getName()}, e);
        }
    }

    public synchronized void storeConfigTypes(IConfigType[] configTypes, String[] deleteTypes) throws ConfigServiceException {
        HashSet<IConfigType> elements = new HashSet<IConfigType>();
        for (int i = 0; i < configTypes.length; ++i) {
            if (((ConfigTypeImpl)configTypes[i]).isRemoved()) {
                throw new ConfigServiceException("cs-store-cts-already-removed", new Object[]{configTypes[i].getName()});
            }
            if (((ConfigTypeImpl)configTypes[i]).isModified()) {
                try {
                    elements.add(configTypes[i]);
                }
                catch (Exception e) {
                    throw new ConfigServiceException("cs-store-cts-failed", e);
                }
            }
            for (ConfigTypeImpl configType : ((ConfigTypeImpl)configTypes[i]).getSubElements()) {
                if (configType.isRemoved()) {
                    throw new ConfigServiceException("cs-store-cts-already-removed", new Object[]{configTypes[i].getName()});
                }
                if (!configType.isModified()) continue;
                try {
                    elements.add(configType);
                }
                catch (Exception e) {
                    throw new ConfigServiceException("cs-store-cts-failed", e);
                }
            }
        }
        configTypes = elements.toArray(new IConfigType[0]);
        this._storeConfigTypes(configTypes, deleteTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _storeConfigTypes(IConfigType[] configTypes, String[] deleteTypes) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-store-cts-not-connected");
        }
        try {
            IBasicElement[] deltas = new IBasicElement[configTypes.length];
            for (int i = 0; i < configTypes.length; ++i) {
                IBasicElement delta = ((ConfigTypeImpl)configTypes[i]).doneUpdate();
                this.createDirectory(((ConfigTypeImpl)configTypes[i]).getDSDirectory());
                deltas[i] = delta;
            }
            ConfigServer configServer = this;
            synchronized (configServer) {
                ((IDirectoryAdminService)this.m_ds).setElements(deltas, deleteTypes, null);
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-store-cts-failed", e);
        }
    }

    protected void refreshElement(IConfigElement configElement) throws ConfigServiceException {
        try {
            ((ConfigElementImpl)configElement).refreshFromDSElement(this.m_ds.getFSElement(configElement.getName(), true, true));
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-refresh-ce-failed", e);
        }
    }

    protected void refreshType(IConfigType configType) throws ConfigServiceException {
        try {
            String dsName = ((ConfigTypeImpl)configType).getDSName();
            IDirElement dirElement = this.m_ds.getFSElement(dsName, true, true);
            ((ConfigTypeImpl)configType).refreshFromDSElement(dirElement, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-refresh-ct-failed", e);
        }
    }

    @Override
    public synchronized void storeConfigElement(IConfigElement configElement) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-store-ce-not-connected", new Object[]{configElement.getName()});
        }
        try {
            IConfigElement[] configElements = new IConfigElement[]{configElement};
            this.storeConfigElements(configElements, null);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-store-ce-failed", new Object[]{configElement.getName()}, e);
        }
    }

    protected IDirElement loadDirElement(String dirElementName) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-de-not-connected", new Object[]{dirElementName});
        }
        try {
            IDirElement element = this.m_ds.getFSElement(dirElementName, this.m_writeable, true);
            if (element == null) {
                this.debugPrintln("loadDirElement for '" + dirElementName + "' > element == null");
            }
            return element;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-de-cant-load-element", new Object[]{dirElementName}, e);
        }
    }

    protected IDirElement loadDirTypeElement(String dirElementName) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-de-not-connected", new Object[]{dirElementName});
        }
        try {
            IDirElement element = ((IDirectoryAdminService)this.m_ds).getElement(dirElementName, this.m_writeable, true);
            if (element == null) {
                this.debugPrintln("loadDirTypeElement for '" + dirElementName + "' > type element == null");
            }
            return element;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-de-cant-load-element", new Object[]{dirElementName}, e);
        }
    }

    protected IConfigElement loadConfigElement(String configElementName, boolean localOnly) throws ConfigServiceException {
        try {
            IConfigElement ce = null;
            ce = (IConfigElement)this.m_elementCache.lookup(configElementName, "");
            if (ce != null) {
                return ce;
            }
            if (localOnly) {
                return null;
            }
            return this.dirElement2ConfigElement(this.loadDirElement(configElementName));
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-ce-failed", new Object[]{configElementName}, e);
        }
    }

    @Override
    public synchronized IConfigElement loadConfigElement(String configElementName) throws ConfigServiceException {
        return this.loadConfigElement(configElementName, false);
    }

    @Override
    public synchronized IConfigElement loadLocalConfigElement(String configElementName) throws ConfigServiceException {
        return this.loadConfigElement(configElementName, true);
    }

    @Override
    public synchronized Set loadConfigElements(Query query) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-ces-not-connected");
        }
        if (query.getSelect() != null) {
            throw new ConfigServiceException("cs-load-ces-query-w-select");
        }
        try {
            IDirElement[] elements = this.m_ds.getFSElements(query, this.m_writeable, true);
            HashSet<IConfigElement> set = new HashSet<IConfigElement>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                IConfigElement configElement = (IConfigElement)this.m_elementCache.lookup(elements[i].getIdentity().getName(), "");
                if (configElement != null) {
                    set.add(configElement);
                    continue;
                }
                set.add(this.dirElement2ConfigElement(elements[i]));
            }
            return set;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-ces-failed", e);
        }
    }

    @Override
    public synchronized Set loadConfigElements(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-ces-not-connected");
        }
        try {
            IDirElement[] elements = this.m_ds.getFSElements(path, this.m_writeable);
            HashSet<IConfigElement> set = new HashSet<IConfigElement>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                IConfigElement configElement = (IConfigElement)this.m_elementCache.lookup(elements[i].getIdentity().getName(), "");
                if (configElement != null) {
                    set.add(configElement);
                    continue;
                }
                set.add(this.dirElement2ConfigElement(elements[i]));
            }
            return set;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-ces-failed", e);
        }
    }

    protected IConfigBean loadConfigBean(String configBeanName, boolean localOnly) throws ConfigServiceException {
        IConfigElement configElement = null;
        try {
            configElement = this.loadConfigElement(configBeanName, localOnly);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-cb-failed", new Object[]{configBeanName}, e);
        }
        if (configElement instanceof IConfigBean) {
            return (IConfigBean)configElement;
        }
        if (configElement == null) {
            return null;
        }
        throw new ConfigServiceException("cs-load-cb-not-cb", new Object[]{configBeanName});
    }

    @Override
    public Set listConfigElements(Query query) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-list-ce-not-connected");
        }
        if (query.getSelect() != null) {
            throw new ConfigServiceException("cs-list-ce-query-w-select");
        }
        try {
            Query identityOnlyQuery = new Query().setFrom(query.getFrom()).setWhere(query.getWhere()).setSelect(new Select(new AttributeName[0]));
            IDirElement[] elements = this.m_ds.getFSElements(identityOnlyQuery, false, true);
            HashSet<String> set = new HashSet<String>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                set.add(elements[i].getIdentity().getName());
            }
            return set;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-list-ce-failed", e);
        }
    }

    @Override
    public synchronized IConfigType loadConfigType(String configBeanTypeName, String version) throws ConfigServiceException {
        return this.loadConfigType(configBeanTypeName, version, false);
    }

    public synchronized IConfigType loadConfigTypeFromLocal(String configBeanTypeName, String version) throws ConfigServiceException {
        return this.loadConfigType(configBeanTypeName, version, true);
    }

    protected IConfigType loadConfigType(String configBeanTypeName, String version, boolean localOnly) throws ConfigServiceException {
        IConfigType configType = (IConfigType)this.m_typeCache.lookup(configBeanTypeName, version);
        if (configType != null) {
            return configType;
        }
        if (localOnly && this.m_parent != null) {
            configType = ((ConfigServer)this.m_parent).loadConfigType(configBeanTypeName, version, localOnly);
        }
        if (configType != null) {
            return configType;
        }
        if (localOnly) {
            return null;
        }
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-ct-not-connected", new Object[]{configBeanTypeName, version});
        }
        try {
            configType = this.dirElement2ConfigType(this.loadDirTypeElement(ConfigTypeImpl.convertTypeName2DSName(configBeanTypeName, version)));
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-ct-failed", new Object[]{configBeanTypeName, version, ConfigTypeImpl.convertTypeName2DSName(configBeanTypeName, version)}, e);
        }
        return configType;
    }

    @Override
    public synchronized Set loadConfigTypes(Query query) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-load-cts-not-connected");
        }
        if (query.getSelect() != null) {
            throw new ConfigServiceException("cs-load-cts-query-w-select");
        }
        try {
            IDirElement[] elements = ((IDirectoryAdminService)this.m_ds).getElements(this.resetFromClause(query), this.m_writeable, true);
            HashSet<IConfigType> set = new HashSet<IConfigType>();
            for (int i = 0; i < elements.length; ++i) {
                IConfigType configType = (IConfigType)this.m_typeCache.lookup(elements[i].getIdentity().getName(), elements[i].getIdentity().getReleaseVersion());
                if (configType != null) {
                    set.add(configType);
                    continue;
                }
                configType = this.dirElement2ConfigType(elements[i]);
                if (configType == null) continue;
                set.add(configType);
            }
            return set;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-load-cts-failed", e);
        }
    }

    @Override
    public synchronized void removeConfigElements(String[] configElements) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-remove-ces-not-connected");
        }
        try {
            int i;
            IDSTransaction txn = this.m_ds.createTransaction();
            for (i = 0; i < configElements.length; ++i) {
                txn.addDeleteElement(configElements[i]);
            }
            this.debugPrintln("ConfigServer:removeConfigElements transaction =", txn);
            this.m_ds.executeTransaction(txn);
            for (i = 0; i < configElements.length; ++i) {
                IConfigElement element = this.loadLocalConfigElement(configElements[i]);
                if (element == null) continue;
                ((ConfigElementImpl)element).setRemoved();
            }
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-remove-ces-failed", e);
        }
    }

    @Override
    public synchronized void removeConfigElement(String configElementName) throws ConfigServiceException {
        try {
            this.removeConfigElements(new String[]{configElementName});
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-remove-ce-failed", new Object[]{configElementName}, e);
        }
    }

    public synchronized void removeConfigType(String configTypeName, String version) throws ConfigServiceException {
        try {
            IConfigType type = this.loadConfigTypeFromLocal(configTypeName, version);
            if (type != null) {
                ((ConfigTypeImpl)type).setRemoved();
            }
            ((IDirectoryAdminService)this.m_ds).deleteElement(ConfigTypeImpl.convertTypeName2DSName(configTypeName, version), null);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-remove-ct-failed", new Object[]{configTypeName, version}, e);
        }
    }

    @Override
    public boolean pathExists(String path) {
        try {
            return this._pathExists(path);
        }
        catch (ConfigServiceException e) {
            return false;
        }
    }

    public boolean _pathExists(String path) throws ConfigServiceException {
        if (path == null) {
            throw new ConfigServiceException("_pathExists needs non-null path parameter");
        }
        if (path.equals("/")) {
            return true;
        }
        try {
            return this.m_ds.getMetaAttributes(path) != null;
        }
        catch (Exception e) {
            throw new ConfigServiceException("_pathExists failure", e);
        }
    }

    @Override
    public void createPath(String path) throws ConfigServiceException {
        this.createPath(path, false);
    }

    @Override
    public void createPath(String path, boolean existingOK) throws ConfigServiceException {
        if (path.charAt(0) != '/') {
            throw new ConfigServiceException("cs-create-path-invalid-path", new Object[]{path});
        }
        try {
            StringTokenizer tokens = new StringTokenizer(path, "/");
            StringBuffer buffer = new StringBuffer();
            while (tokens.countTokens() > 1) {
                buffer.append("/").append(tokens.nextToken());
                this.m_ds.createFolder(buffer.toString(), true);
            }
            buffer.append("/").append(tokens.nextToken());
            this.m_ds.createFolder(buffer.toString(), existingOK);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-path-failed", new Object[]{path}, e);
        }
    }

    @Override
    public void createFolder(String path) throws ConfigServiceException {
        this.createFolder(path, null, false);
    }

    @Override
    public void createFolder(String path, Map metaAttributes, boolean createParentDirs) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-create-folder-not-connected", new Object[]{path});
        }
        try {
            IDSTransaction txn = this.m_ds.createTransaction();
            if (createParentDirs) {
                this.createParentFolders(path, txn);
            }
            txn.addCreateFolder(path);
            if (metaAttributes != null) {
                txn.addSetAttributes(path, Util.mapToHashMap(Util.combineToolMetaAttributes(metaAttributes)));
            }
            this.debugPrintln("ConfigServer:createFolder transaction =", txn);
            this.m_ds.executeTransaction(txn);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-folder-failed", new Object[]{path}, e);
        }
    }

    private void createParentFolders(String path, IDSTransaction txn) {
        int lastSlash = path.lastIndexOf("/", path.length() - 2);
        if (lastSlash > 0) {
            String parentPath = path.substring(0, lastSlash);
            this.createParentFolders(parentPath, txn);
            txn.addCreateFolder(parentPath, true);
        }
    }

    public void createFolder(String directoryName, IDSTransaction txn) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-create-folder-not-connected", new Object[]{directoryName});
        }
        try {
            this.m_ds.listFolders(directoryName);
        }
        catch (DirectoryServiceException e) {
            int lastSlash = directoryName.lastIndexOf("/", directoryName.length() - 2);
            if (lastSlash != -1) {
                this.createFolder(directoryName.substring(0, lastSlash + 1), txn);
                txn.addCreateFolder(directoryName);
            }
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-create-folder-failed", new Object[]{directoryName}, (Exception)((Object)e));
        }
    }

    @Override
    public void deleteFolder(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-delete-folder-not-connected", new Object[]{path});
        }
        try {
            this.m_ds.deleteFolder(path);
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-delete-folder-failed", new Object[]{path}, e);
        }
    }

    public void createDirectory(String directoryName) throws ConfigServiceException {
        block7: {
            if (this.m_ds == null) {
                throw new ConfigServiceException("cs-create-dir-not-connected", new Object[]{directoryName});
            }
            try {
                ((IDirectoryAdminService)this.m_ds).listDirectories(directoryName);
            }
            catch (DirectoryServiceException e) {
                int lastSlash = directoryName.lastIndexOf("/", directoryName.length() - 2);
                if (lastSlash == -1) break block7;
                this.createDirectory(directoryName.substring(0, lastSlash + 1));
                try {
                    ((IDirectoryAdminService)this.m_ds).createDirectory(directoryName);
                }
                catch (DirectoryServiceException createException) {
                    throw new ConfigServiceException("cs-create-dir-failed", new Object[]{directoryName}, (Exception)((Object)createException));
                }
                catch (ConfigurePermissionDeniedException e1) {
                    throw new ConfigServiceException("cs-create-dir-failed", new Object[]{directoryName}, (Exception)((Object)e1));
                }
            }
            catch (ConfigurePermissionDeniedException e) {
                throw new ConfigServiceException("cs-create-dir-failed", new Object[]{directoryName}, (Exception)((Object)e));
            }
        }
    }

    @Override
    public void rename(String oldName, String newName) throws ConfigServiceException {
        try {
            this.m_ds.rename(oldName, newName);
            this.renameCacheElements(oldName, newName);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-rename-failed", new Object[]{oldName, newName}, e);
        }
    }

    protected void renameCacheElements(String oldPrefix, String newPrefix) throws ConfigServiceException {
        for (ConfigElementImpl configElement : this.m_elementCache.getObjects()) {
            if (!configElement.getName().startsWith(oldPrefix)) continue;
            this.getElementCache().remove(configElement.getName(), "");
            configElement.rename(oldPrefix, newPrefix);
            this.getElementCache().add(configElement.getName(), "", configElement);
        }
    }

    @Override
    public Set list(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-list-not-connected", new Object[]{path});
        }
        try {
            HashMap[] entries = this.m_ds.listFSAll(path);
            HashSet<Map> set = new HashSet<Map>(entries.length);
            for (int i = 0; i < entries.length; ++i) {
                set.add(Util.splitToolMetaAttributes((Map)entries[i]));
            }
            return set;
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-list-failed", new Object[]{path}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-list-failed", new Object[]{path}, (Exception)((Object)e));
        }
    }

    @Override
    public Map getMetaAttributes(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-get-meta-attrs-not-connected", new Object[]{path});
        }
        try {
            return Util.splitToolMetaAttributes((Map)this.m_ds.getMetaAttributes(path));
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-get-meta-attrs-failed", new Object[]{path}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-get-meta-attrs-failed", new Object[]{path}, (Exception)((Object)e));
        }
    }

    @Override
    public void setMetaAttributes(String path, Map metaAttributes) throws ConfigServiceException {
        if (metaAttributes == null) {
            throw new ConfigServiceException("cs-set-meta-attrs-is-null", new Object[]{path});
        }
        try {
            this.m_ds.setMetaAttributes(path, Util.mapToHashMap(Util.combineToolMetaAttributes(metaAttributes)));
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-set-meta-attrs-failed", new Object[]{path}, e);
        }
    }

    @Override
    public Set listFolders(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-list-folders-not-connected", new Object[]{path});
        }
        try {
            HashMap[] directories = this.m_ds.listFolders(path);
            HashSet set = new HashSet(directories.length);
            for (int i = 0; i < directories.length; ++i) {
                set.add(directories[i].get("_FOLDER_NAME"));
            }
            return set;
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-list-folders-failed", new Object[]{path}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-list-folders-failed", new Object[]{path}, (Exception)((Object)e));
        }
    }

    @Override
    public Set listConfigElements(String path) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-list-ces-not-connected", new Object[]{path});
        }
        try {
            HashMap[] elements = this.m_ds.listFSElements(path);
            HashSet<String> set = new HashSet<String>(elements.length);
            for (int i = 0; i < elements.length; ++i) {
                IElementIdentity id = (IElementIdentity)elements[i].get("_ELEMENT_IDENTITY");
                if (id == null) continue;
                set.add(id.getName());
            }
            return set;
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-list-ces-failed", new Object[]{path}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-list-ces-failed", new Object[]{path}, (Exception)((Object)e));
        }
    }

    public IBlob getBlob(String name) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-get-blob-not-connected", new Object[]{name});
        }
        try {
            return this.m_ds.getFSBlob(name, this.m_writeable);
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-get-blob-failed", new Object[]{name}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-get-blob-failed", new Object[]{name}, (Exception)((Object)e));
        }
    }

    @Override
    public String storageToLogical(String name) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-storage-to-logical-not-connected", new Object[]{name});
        }
        try {
            return this.m_ds.storageToLogical(name);
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-storage-to-logical-failed", new Object[]{name}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-storage-to-logical-failed", new Object[]{name}, (Exception)((Object)e));
        }
    }

    @Override
    public String logicalToStorage(String name) throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-logical-to-storage-not-connected", new Object[]{name});
        }
        try {
            return this.m_ds.logicalToStorage(name);
        }
        catch (DirectoryServiceException e) {
            throw new ConfigServiceException("cs-logical-to-storage-failed", new Object[]{name}, (Exception)((Object)e));
        }
        catch (ConfigurePermissionDeniedException e) {
            throw new ConfigServiceException("cs-logical-to-storage-failed", new Object[]{name}, (Exception)((Object)e));
        }
    }

    private Query resetFromClause(Query query) {
        if (query.getFrom() instanceof FromDirectory) {
            query.setFrom((From)new FromDirectory("/mx/configTypes"));
        } else if (query.getFrom() instanceof FromElementList) {
            String[] list = ((FromElementList)query.getFrom()).getElementNames();
            String[] newList = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                int indx = list[i].lastIndexOf("/");
                newList[i] = "/mx/configTypes" + list[i].substring(indx);
            }
            query.setFrom((From)new FromElementList(newList));
        }
        return query;
    }

    protected final void registerElementChangeListener() throws ConfigServiceException {
        if (this.m_ds == null) {
            throw new ConfigServiceException("cs-register-escl-not-connected");
        }
        if (this.m_configChangeDispatcher == null && this.m_ds instanceof IDirectoryFileSystemNotifications) {
            this.m_configChangeDispatcher = new ConfigChangeDispatcher(this);
            this.m_ds.registerFSElementChangeHandler((IElementChangeHandler)this.m_configChangeDispatcher);
            this.m_ds.registerNameChangeHandler((INameChangeHandler)this.m_configChangeDispatcher);
        }
        if (this.m_typeChangeHandler == null && this.m_ds instanceof IDirectoryAdminNotifications) {
            this.m_typeChangeHandler = new ConfigTypeChangeHandler(this);
            ((IDirectoryAdminNotifications)this.m_ds).registerElementChangeHandler(this.m_typeChangeHandler);
        }
    }

    protected void unregisterElementChangeListener() throws ConfigServiceException {
        if (this.m_typeChangeHandler != null && this.m_ds instanceof IDirectoryAdminNotifications) {
            try {
                ((IDirectoryAdminNotifications)this.m_ds).unregisterElementChangeHandler(this.m_typeChangeHandler);
                this.m_typeChangeHandler = null;
            }
            catch (Exception e) {
                throw new ConfigServiceException("cs-unregister-escl-failed", e);
            }
        }
        if (this.m_configChangeDispatcher != null && this.m_ds instanceof IDirectoryFileSystemNotifications) {
            try {
                this.m_ds.unregisterFSElementChangeHandler((IElementChangeHandler)this.m_configChangeDispatcher);
                this.m_ds.unregisterNameChangeHandler((INameChangeHandler)this.m_configChangeDispatcher);
                this.m_configChangeDispatcher = null;
            }
            catch (Exception e) {
                throw new ConfigServiceException("cs-unregister-escl-failed", e);
            }
        }
    }

    @Override
    public IConfigElement createConfigElement(String name) throws ConfigServiceException {
        try {
            return new ConfigElementImpl(name, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-ce-failed", new Object[]{name}, e);
        }
    }

    @Override
    public IConfigBean createConfigBean(String name, String type, String version) throws ConfigServiceException {
        return this.createConfigBean(name, type, version, false);
    }

    @Override
    public IConfigBean createConfigBean(String name, String type, String version, boolean isTemplate) throws ConfigServiceException {
        try {
            if (isTemplate) {
                return new ConfigBeanPrototype(name, type, version, this);
            }
            return new ConfigBeanImpl(name, type, version, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-cb-failed", new Object[]{name}, e);
        }
    }

    @Override
    public IConfigBeanFile createConfigBeanFile(String name, String user) throws ConfigServiceException {
        try {
            return new ConfigBeanFile(name, user, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-cbf-failed", new Object[]{name}, e);
        }
    }

    public IConfigType createConfigType(String name, String version) throws ConfigServiceException {
        try {
            return new ConfigTypeImpl(name, version, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-ct-failed", new Object[]{name, version}, e);
        }
    }

    @Override
    public Collection parseConfigTypes(String namespaceURI, String schemaDocURL) throws ConfigServiceException {
        try {
            return ConfigTypeDocument.parse(namespaceURI, schemaDocURL, this, null);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-parse-ct-failed", new Object[]{schemaDocURL}, e);
        }
    }

    @Override
    public IConfigBean parseConfigBean(String beanDocumentURL) throws ConfigServiceException {
        try {
            return ConfigBeanDocument.parse(beanDocumentURL, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-parse-cb-failed", new Object[]{beanDocumentURL}, e);
        }
    }

    @Override
    public String exportConfigBean(String name) throws ConfigServiceException {
        IConfigBean bean = null;
        try {
            bean = this.loadConfigBean(name, false);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-export-cb-does-not-exist", new Object[]{name});
        }
        return this.exportConfigBean(bean);
    }

    @Override
    public String exportConfigBean(IConfigBean bean) {
        return bean.toXML();
    }

    @Override
    public String exportDSBootConfiguration(IConfigElement configElement) {
        try {
            String storageName = this.logicalToStorage(configElement.getName());
            return ((IDirectoryAdminService)this.m_ds).exportDSBootFileString(storageName);
        }
        catch (DirectoryServiceException e) {
            return null;
        }
        catch (ConfigServiceException e) {
            return null;
        }
    }

    @Override
    public String exportContainerBootConfiguration(IConfigElement containerConfigElement, String domainName) throws ConfigServiceException {
        String storageName = this.logicalToStorage(containerConfigElement.getName());
        IDirElement containerDirElement = ElementFactory.createElement((String)storageName, (String)((ConfigElementImpl)containerConfigElement).m_type, (String)((ConfigElementImpl)containerConfigElement).m_version);
        if (containerConfigElement.isPrototypeInstance()) {
            ((ConfigElementImpl)((Object)containerConfigElement.getPrototype())).toAttributeSet(containerDirElement.getAttributes());
        }
        ((ConfigElementImpl)containerConfigElement).toAttributeSet(containerDirElement.getAttributes(), containerConfigElement.isPrototypeInstance());
        return Container.exportContainerBootConfiguration((IElement)containerDirElement, (String)domainName);
    }

    protected Cache getTypeCache() {
        return this.m_typeCache;
    }

    protected Cache getElementCache() {
        return this.m_elementCache;
    }

    protected synchronized ConfigBeanImpl createBeanFromPrototype(ConfigBeanPrototype prototype, String name) throws ConfigServiceException {
        try {
            ConfigBeanImpl res = new ConfigBeanImpl(name, prototype.getConfigType().getName(), prototype.getConfigType().getVersion(), this, true);
            res.m_configPrototype = prototype;
            return res;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-bfp-failed", new Object[]{name, prototype.getName()}, e);
        }
    }

    protected synchronized ConfigElementImpl createElementFromPrototype(ConfigElementPrototype prototype, String name) throws ConfigServiceException {
        try {
            ConfigElementImpl res = new ConfigElementImpl(name, this);
            res.m_configPrototype = prototype;
            return res;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-create-efp-failed", new Object[]{name, prototype.getName()}, e);
        }
    }

    protected void unshareConfigElement(ConfigElementImpl configElement) throws ConfigServiceException {
        try {
            this.storeConfigElement(configElement);
            this.m_ds.unSubclassFSElement(configElement.getName());
            if (configElement.m_configPrototype instanceof ConfigElementPrototype) {
                ((ConfigElementPrototype)configElement.m_configPrototype).removeInstance(configElement);
            } else {
                ((ConfigBeanPrototype)configElement.m_configPrototype).removeInstance(configElement);
            }
            configElement.m_configPrototype = null;
            configElement.refresh();
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-unshare-ce-failed", new Object[]{configElement.getName()}, e);
        }
    }

    protected IConfigType dirElement2ConfigType(IDirElement dirElement) throws ConfigServiceException {
        try {
            if (dirElement != null && dirElement.getIdentity().getType() != null && dirElement.getIdentity().getType().equals("MAConfigBeanTypeType")) {
                return new ConfigTypeImpl(dirElement, this);
            }
            return null;
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-de-2-ct-failed", e);
        }
    }

    protected IConfigElement dirElement2ConfigElement(IDirElement dirElement) throws ConfigServiceException {
        try {
            if (dirElement == null) {
                return null;
            }
            if (dirElement.getIdentity().getType() == null || dirElement.getIdentity().getType().equals("") || dirElement.getIdentity().getType().equals("ConfigElement")) {
                if (dirElement.isTemplate()) {
                    return new ConfigElementPrototype(dirElement, this);
                }
                return new ConfigElementImpl(dirElement, this);
            }
            if (dirElement.getIdentity().getType().equals("MF_FILE")) {
                return new ConfigBeanFile(dirElement, this);
            }
            if (dirElement.getIdentity().getType().equals("MAConfigBeanTypeType")) {
                return null;
            }
            if (dirElement.isTemplate()) {
                return new ConfigBeanPrototype(dirElement, this);
            }
            return new ConfigBeanImpl(dirElement, this);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-de-2-ce-failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfigChangeListener(String configElementName, IConfigChangeListener listener, IConfigChangeFilter filter, Object handback) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        Map map = this.m_listeners;
        synchronized (map) {
            HashSet<ListenerRegistration> listenerReg;
            HashMap<IConfigChangeListener, HashSet<ListenerRegistration>> elementListeners = (HashMap<IConfigChangeListener, HashSet<ListenerRegistration>>)this.m_listeners.get(configElementName);
            if (elementListeners == null) {
                elementListeners = new HashMap<IConfigChangeListener, HashSet<ListenerRegistration>>();
                this.m_listeners.put(configElementName, elementListeners);
            }
            if ((listenerReg = (HashSet<ListenerRegistration>)elementListeners.get(listener)) == null) {
                listenerReg = new HashSet<ListenerRegistration>();
                elementListeners.put(listener, listenerReg);
            }
            listenerReg.add(new ListenerRegistration(listener, filter, handback));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigChangeListener(String configElementName, IConfigChangeListener listener, IConfigChangeFilter filter, Object handback) throws ConfigServiceException {
        Map map = this.m_listeners;
        synchronized (map) {
            Map elementListeners = (Map)this.m_listeners.get(configElementName);
            if (elementListeners == null) {
                throw new ConfigServiceException("listener not registered");
            }
            Set listenerReg = (Set)elementListeners.get(listener);
            if (listenerReg == null) {
                throw new ConfigServiceException("listener not registered");
            }
            listenerReg.remove(new ListenerRegistration(listener, filter, handback));
            if (listenerReg.isEmpty()) {
                elementListeners.remove(listener);
                if (elementListeners.isEmpty()) {
                    this.m_listeners.remove(configElementName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigChangeListener(String configElementName, IConfigChangeListener listener) throws ConfigServiceException {
        Map map = this.m_listeners;
        synchronized (map) {
            Map elementListeners = (Map)this.m_listeners.get(configElementName);
            if (elementListeners == null) {
                throw new ConfigServiceException("listener not registered");
            }
            Set listenerReg = (Set)elementListeners.remove(listener);
            if (listenerReg == null) {
                throw new ConfigServiceException("listener not registered");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendConfigChange(ConfigChange configChange) {
        Map map = this.m_listeners;
        synchronized (map) {
            Map elementListeners = (Map)this.m_listeners.get(configChange.getName());
            if (elementListeners != null) {
                this.dispatchConfigChange(elementListeners, configChange);
            }
            if ((elementListeners = (Map)this.m_listeners.get(null)) != null) {
                this.dispatchConfigChange(elementListeners, configChange);
            }
        }
    }

    protected void dispatchConfigChange(Map elementListeners, ConfigChange configChange) {
        for (Set listenerReg : elementListeners.values()) {
            for (ListenerRegistration registration : listenerReg) {
                if (registration.m_filter != null && !registration.m_filter.isConfigChangeEnabled(configChange)) continue;
                switch (configChange.getChangeType()) {
                    case 0: {
                        registration.m_listener.elementAdded(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 2: {
                        registration.m_listener.elementDeleted(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 3: {
                        registration.m_listener.elementReplaced(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 1: {
                        registration.m_listener.elementUpdated(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 4: {
                        registration.m_listener.folderAdded(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 5: {
                        registration.m_listener.folderDeleted(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 6: {
                        registration.m_listener.rename(new ConfigChange(configChange, registration.m_handback));
                        break;
                    }
                    case 7: {
                        registration.m_listener.metaAttributesChanged(new ConfigChange(configChange, registration.m_handback));
                    }
                }
            }
        }
    }

    @Override
    public synchronized void commit() throws ConfigServiceException {
        throw new ConfigServiceException("cs-commit-not-transacted");
    }

    @Override
    public synchronized void rollback() throws ConfigServiceException {
        throw new ConfigServiceException("cs-rollback-not-transacted");
    }

    @Override
    public synchronized void flush() throws ConfigServiceException {
        throw new ConfigServiceException("cs-flush-not-transacted");
    }

    @Override
    public synchronized IConfigServer subtransaction() throws ConfigServiceException {
        throw new ConfigServiceException("cs-subtransaction-not-transacted");
    }

    protected void elementCreated(ConfigElementImpl configElement) throws ConfigServiceException {
        this.getElementCache().add(configElement.getName(), "", configElement);
        configElement.setDirectoryElementName(configElement.getName());
        configElement.setState((short)1);
    }

    protected void elementLoaded(ConfigElementImpl configElement) throws ConfigServiceException {
        this.getElementCache().add(configElement.getName(), "", configElement);
        configElement.setDirectoryElementName(configElement.getName());
        configElement.setState((short)2);
    }

    protected void elementStored(ConfigElementImpl configElement) throws ConfigServiceException {
        configElement.setDirectoryElementName(configElement.getName());
        configElement.setState((short)2);
    }

    protected void elementRefreshed(ConfigElementImpl configElement) throws ConfigServiceException {
        configElement.setState((short)2);
    }

    protected void elementModified(ConfigElementImpl configElement) throws ConfigServiceException {
        if (!configElement.isNew()) {
            configElement.setState((short)3);
        }
    }

    protected void elementRenamed(String oldName, String newName, ConfigElementImpl configElement) throws ConfigServiceException {
        try {
            if (!configElement.isNew()) {
                this.m_ds.rename(oldName, newName);
            } else {
                configElement.setDirectoryElementName(newName);
            }
            this.getElementCache().add(newName, "", configElement);
            this.getElementCache().remove(oldName, "");
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-element-rename-failed", new Object[]{oldName, newName}, e);
        }
    }

    protected void elementRemoved(ConfigElementImpl configElement) throws ConfigServiceException {
        this.getElementCache().remove(configElement.getName(), "");
        configElement.setState((short)4);
    }

    protected void elementRemoved(String configElementName) throws ConfigServiceException {
        ConfigElementImpl configElement = (ConfigElementImpl)this.getElementCache().lookup(configElementName, "");
        if (configElement != null) {
            this.getElementCache().remove(configElementName, "");
            configElement.setState((short)4);
        }
    }

    @Override
    public IConfigPath[] getReferences(String configElementName) throws ConfigServiceException {
        try {
            AttributeName[] attributeNames = this.m_ds.getReferences(configElementName);
            IConfigPath[] configPaths = new IConfigPath[attributeNames.length];
            for (int i = 0; i < configPaths.length; ++i) {
                configPaths[i] = new ConfigPathImpl(attributeNames[i]);
            }
            return configPaths;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-get-references-failed", new Object[]{configElementName}, e);
        }
    }

    public void revertToTemplate(String configElement, IConfigPath[] attributes) throws ConfigServiceException {
        try {
            AttributeName[] attributeNames = new AttributeName[attributes.length];
            IConfigElement ce = this.loadConfigElement(configElement);
            for (int i = 0; i < attributes.length; ++i) {
                attributeNames[i] = ((ConfigPathImpl)attributes[i]).toAttributeName(ce);
                this.debugPrintln("reverting " + attributeNames[i].toString() + " (" + configElement + ")");
            }
            this.m_ds.revertToTemplate(configElement, attributeNames);
        }
        catch (ConfigServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigServiceException("cs-revert-to-template-failed", e);
        }
    }

    protected void debugPrintln(String message) {
        this.debugPrintln(message, null);
    }

    protected void debugPrintln(String message, IDSTransaction txn) {
        if (!DEBUG) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        if (this.isTransacted()) {
            sb.append("txn");
        }
        sb.append("CL(").append(this.hashCode()).append("): ");
        sb.append(message);
        System.err.println(sb.toString());
        if (txn != null) {
            System.err.print(Util.txnToString(txn));
            this.dumpCache();
        }
    }

    protected void dumpCache() {
        if (!DEBUG) {
            return;
        }
        System.err.println("CL(" + this.hashCode() + "): Cache");
        for (ConfigElementImpl element : this.m_elementCache.getObjects()) {
            System.err.println("    " + element.getName() + " State=" + ConfigElementImpl.STATES_DEBUG[element.getState()]);
        }
    }

    class ListenerRegistration {
        IConfigChangeListener m_listener = null;
        IConfigChangeFilter m_filter = null;
        Object m_handback = null;

        public ListenerRegistration(IConfigChangeListener listener, IConfigChangeFilter filter, Object handback) {
            this.m_listener = listener;
            this.m_filter = filter;
            this.m_handback = handback;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListenerRegistration) {
                ListenerRegistration reg = (ListenerRegistration)obj;
                if (this.m_listener.equals(reg.m_listener) && this.m_filter == null ? reg.m_filter == null : (this.m_filter.equals(reg.m_filter) && this.m_handback == null ? reg.m_handback == null : this.m_handback.equals(reg.m_handback))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.m_listener.hashCode() + (this.m_filter == null ? 0 : this.m_filter.hashCode()) + (this.m_handback == null ? 0 : this.m_handback.hashCode());
        }
    }

    class ConfigTypeChangeHandler
    implements IElementChangeHandler {
        private ConfigServer m_cs;

        public ConfigTypeChangeHandler(ConfigServer cs) {
            this.m_cs = cs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleElementChange(IElementChange ec) {
            ConfigServer configServer = this.m_cs;
            synchronized (configServer) {
                IBasicElement element = ec.getElement();
                String physicalPath = element.getIdentity().getName();
                if (physicalPath.startsWith("/mx") && ec.getChangeType() == 1 && this.hasInitialValue(element)) {
                    try {
                        String iValue = this.getInitialValue(element);
                        int index = physicalPath.lastIndexOf(47);
                        String type = physicalPath.substring(index + 1);
                        String tmp = physicalPath.substring(0, index);
                        String version = tmp.substring(tmp.lastIndexOf(47) + 1);
                        IConfigType configType = this.m_cs.loadConfigTypeFromLocal(type, version);
                        if (configType != null) {
                            ((ConfigTypeImpl)configType).setInitialValues(this.getInitialValue(element), false);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean hasInitialValue(IBasicElement element) {
            IDeltaAttributeSet set;
            Object obj;
            return element instanceof IDeltaElement && (obj = ((IDeltaElement)element).getDeltaAttributes()) instanceof IDeltaAttributeSet && (this.inArray((set = (IDeltaAttributeSet)obj).getDeletedAttributesNames(), "initialValues") || this.inArray(set.getModifiedAttributesNames(), "initialValues") || this.inArray(set.getNewAttributesNames(), "initialValues"));
        }

        private boolean inArray(String[] items, String item) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].equals(item)) continue;
                return true;
            }
            return false;
        }

        private String getInitialValue(IBasicElement element) {
            IDeltaAttributeSet set;
            Object obj;
            String res = null;
            if (element instanceof IDeltaElement && (obj = ((IDeltaElement)element).getDeltaAttributes()) instanceof IDeltaAttributeSet && !this.inArray((set = (IDeltaAttributeSet)obj).getDeletedAttributesNames(), "initialValues")) {
                try {
                    res = set.getNewValue("initialValues").toString();
                }
                catch (NotModifiedAttException e) {
                    // empty catch block
                }
            }
            return res;
        }
    }
}

