/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ma.mgmtapi.config.impl;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtBeanFactory;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.config.impl.MgmtBeanBase;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mx.config.ConfigFactory;
import com.sonicsw.mx.config.ConfigServerUtility;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.IConfigBean;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigServer;
import com.sonicsw.mx.config.TxnConfigServerUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMgmtBeanFactory {
    private HashMap m_registered = new HashMap();
    private TxnConfigServerUtility m_csu = new TxnConfigServerUtility();

    public void connect(String domain, String url, String user, String password) throws MgmtException {
        try {
            this.m_csu.connect(domain, url, user, password, true);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to connect to domain : " + e.getMessage(), e);
        }
    }

    public void connect(IDirectoryFileSystemService dsProxy) throws MgmtException {
        try {
            this.m_csu.connect(dsProxy, true);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to connect to domain : " + e.getMessage(), e);
        }
    }

    public void connect(TxnConfigServerUtility csu) {
        this.m_csu = csu;
    }

    public void disconnect() throws ConfigServiceException {
        this.m_csu.disconnect();
    }

    public String getDomain() {
        return this.m_csu.getDomain();
    }

    public IConfigServer getConfigServer() {
        IConfigServer ret = this.m_csu.getConfigServer();
        if (ret == null) {
            throw new RuntimeException("ConfigServer is not connected");
        }
        return ret;
    }

    public ConfigServerUtility getConfigServerUtility() {
        return this.m_csu;
    }

    public void commit() throws MgmtException {
        try {
            this.getConfigServer().commit();
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to commit changes - " + e.getMessage(), e);
        }
    }

    public void rollback() throws MgmtException {
        try {
            this.getConfigServer().rollback();
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to rollback changes - " + e.getMessage(), e);
        }
    }

    public void flush() throws MgmtException {
        try {
            this.getConfigServer().flush();
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to flush changes - " + e.getMessage(), e);
        }
    }

    public List getFolderNames(String parent) throws MgmtException {
        try {
            return new ArrayList(this.getConfigServer().listFolders(parent));
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to getFolderNames - " + e.getMessage(), e);
        }
    }

    public List getConfigurationNames(String parentFolder) throws MgmtException {
        try {
            Set names = this.getConfigServer().listConfigElements(parentFolder);
            ArrayList<String> list = new ArrayList<String>(0);
            for (String name : names) {
                list.add(name.substring(name.lastIndexOf("/") + 1));
            }
            return list;
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to getConfigurationNames - " + e.getMessage(), e);
        }
    }

    public String[] getFolders(String parentFolder) throws MgmtException {
        try {
            Set dirs = this.getConfigServer().listFolders(parentFolder);
            return dirs.toArray(new String[0]);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to get folders" + e.getMessage(), e);
        }
    }

    public boolean pathExists(String path) {
        return this.getConfigServer().pathExists(path);
    }

    public List listConfigElements(String type) throws MgmtException {
        try {
            Query query = new Query().setFrom((From)new FromElementType(type));
            Set elements = this.getConfigServer().listConfigElements(query);
            ArrayList<String> names = new ArrayList<String>(elements.size());
            if (!elements.isEmpty()) {
                Iterator i = elements.iterator();
                String name = "";
                while (i.hasNext()) {
                    name = (String)i.next();
                    if (name.endsWith("_Default") || name.endsWith("_MFDomainDescriptor") || name.endsWith("_MQPolicyDescriptor")) {
                        name = name.substring(0, name.lastIndexOf("/"));
                    }
                    names.add(name);
                }
            }
            return names;
        }
        catch (Throwable ce) {
            throw new MgmtException("Can't get config elements. Type: " + type, ce);
        }
    }

    public List list(String path) throws MgmtException {
        try {
            Set names = this.getConfigServer().list(path);
            ArrayList<String> list = new ArrayList<String>(0);
            for (HashMap entry : names) {
                String name = null;
                if (entry.containsKey("_FOLDER_NAME")) {
                    name = (String)entry.get("_FOLDER_NAME");
                } else if (entry.containsKey("_ELEMENT_IDENTITY")) {
                    name = ((IElementIdentity)entry.get("_ELEMENT_IDENTITY")).getName();
                }
                if (name == null) continue;
                list.add(name.substring(name.lastIndexOf("/") + 1));
            }
            return list;
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to list  - " + e.getMessage(), e);
        }
    }

    public void createFolder(String path, Map attributes) throws MgmtException {
        try {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.getConfigServer().createFolder(path, attributes, false);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create folder with meta-attributes - " + e.getMessage(), e);
        }
    }

    public void createFolder(String path) throws MgmtException {
        try {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.getConfigServer().createFolder(path);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create folder -" + e.getMessage(), e);
        }
    }

    public void deleteFolder(String path) throws MgmtException {
        try {
            this.getConfigServer().deleteFolder(path);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create folder -" + e.getMessage(), e);
        }
    }

    public void deleteFolderPath(String path) throws MgmtException {
        try {
            this.m_csu.deleteBeanPath(path);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create folder -" + e.getMessage(), e);
        }
    }

    public String[] getConfigurations(String parentFolder) throws MgmtException {
        List list = this.getConfigurationNames(parentFolder);
        return list.toArray(new String[list.size()]);
    }

    public boolean doesConfigurationNameExist(String name, String folder) {
        try {
            List names = this.getConfigurationNames(folder);
            return names.contains(name);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Object lookupValue(IConfigBean bean, Object key) {
        String type = bean.getConfigType().getName();
        String version = bean.getConfigType().getVersion();
        return this.lookupValue(type, version, key);
    }

    public Class lookupReference(String type, String version) {
        return (Class)this.lookupValue(type, version, "_CLASS");
    }

    public Object lookupValue(String type, String version, Object key) {
        Map map = (Map)this.m_registered.get(type);
        return map != null ? map.get(key) : null;
    }

    public List listFolderElements(String type) throws MgmtException {
        return this.listConfigElements(type);
    }

    public List listFolders(String parentFolder) throws MgmtException {
        try {
            Set dirs = this.getConfigServer().listFolders(parentFolder);
            ArrayList result = new ArrayList(dirs.size());
            Iterator i = dirs.iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
            return result;
        }
        catch (Throwable e) {
            throw new MgmtException("Failed listFolders - " + e.getMessage(), e);
        }
    }

    protected void deleteFolders(String path) throws MgmtException {
        List folders = this.getFolders(new ArrayList(), path);
        folders.add(path);
        Iterator iter = folders.iterator();
        while (iter.hasNext()) {
            this.deleteFolder((String)iter.next());
        }
    }

    protected List getFolders(List list, String path) throws MgmtException {
        String[] folders = this.getFolders(path);
        for (int i = 0; i < folders.length; ++i) {
            String folder = folders[i];
            if (!list.contains(folder)) {
                list.add(0, folder);
            }
            this.getFolders(list, folder);
        }
        return list;
    }

    public void setFolderMetaAttributes(String path, Map attributes) throws MgmtException {
        try {
            this.getConfigServer().setMetaAttributes(path, attributes);
        }
        catch (Throwable e) {
            throw new MgmtException("Can't set folder meta-attributes - " + e.getMessage(), e);
        }
    }

    public List loadBeansInDirectory(String dsPath) throws MgmtException {
        ArrayList<IMgmtBeanBase> list = new ArrayList<IMgmtBeanBase>();
        try {
            Set set = this.getConfigServer().loadConfigElements(dsPath);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                try {
                    list.add(this.createBeanObject((IConfigBean)iter.next()));
                }
                catch (Throwable e) {}
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to load beans - " + e.getMessage(), e);
        }
        return list;
    }

    public void saveBean(IMgmtBeanBase bean) throws MgmtException {
        if (bean == null) {
            throw new MgmtException("Attempt to save a null bean");
        }
        try {
            ((MgmtBeanBase)bean).saveBean();
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to save bean - " + e.getMessage(), e);
        }
    }

    public void saveBeans(IMgmtBeanBase[] beans) throws MgmtException {
        try {
            for (int i = 0; i < beans.length; ++i) {
                this.saveBean(beans[i]);
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to save beans - " + e.getMessage(), e);
        }
    }

    public String exportContainerBootConfiguration(IMgmtBeanBase bean, String domainName) throws MgmtException {
        if (bean == null) {
            throw new MgmtException("Attempt to export container boot configuration of a null bean");
        }
        try {
            return this.m_csu.exportContainerBootConfiguration(bean.getConfigBean(), domainName);
        }
        catch (Throwable e) {
            throw new MgmtException(e.getMessage(), e);
        }
    }

    public String exportDSBootConfiguration(IMgmtBeanBase bean) throws MgmtException {
        try {
            return this.m_csu.exportDSBootConfiguration(bean.getConfigBean());
        }
        catch (Throwable e) {
            throw new MgmtException(e.getMessage(), e);
        }
    }

    public IMgmtBeanBase getBean(String viewPath) throws MgmtException {
        IMgmtBeanBase bean = null;
        try {
            IConfigElement cfgBean = this.getConfigServer().loadConfigElement(viewPath);
            bean = this.createBeanObject((IConfigBean)cfgBean);
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to get bean - " + viewPath + "." + e.getMessage(), e);
        }
        return bean;
    }

    public void deleteBean(IMgmtBeanBase bean) throws MgmtException {
        if (bean == null) {
            throw new MgmtException("Attempt to delete a null bean");
        }
        try {
            ((MgmtBeanBase)bean).deleteBean();
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to delete bean - " + e.getMessage(), e);
        }
    }

    public void deleteBeans(IMgmtBeanBase[] beans) throws MgmtException {
        try {
            for (int i = 0; i < beans.length; ++i) {
                this.deleteBean(beans[i]);
            }
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to delete beans - " + e.getMessage(), e);
        }
    }

    public String createUniqueName() {
        return ConfigFactory.createGUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBean(Class cls, String type, String cVersion, String pVersion) {
        String key = type;
        HashMap hashMap = this.m_registered;
        synchronized (hashMap) {
            if (!this.m_registered.containsKey(key)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("_CLASS", cls);
                map.put("_TYPE", type);
                map.put("_C_VERSION", cVersion);
                map.put("_P_VERSION", pVersion);
                this.m_registered.put(key, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerBean(String type, String cVersion, String pVersion, Map register) {
        String key = type;
        HashMap hashMap = this.m_registered;
        synchronized (hashMap) {
            if (!this.m_registered.containsKey(key)) {
                this.m_registered.put(key, register);
            }
        }
    }

    protected void registerBean(Map register) {
        String type = (String)register.get("_TYPE");
        String cVersion = (String)register.get("_C_VERSION");
        String pVersion = (String)register.get("_P_VERSION");
        Class cls = (Class)register.get("_CLASS");
        if (type != null && cVersion != null && cls != null) {
            this.registerBean(type, cVersion, pVersion, register);
        }
    }

    public IMgmtBeanBase createBeanObject(IConfigBean bean) throws MgmtException {
        String version;
        String name = bean.getConfigType().getName();
        Class cls = this.lookupReference(name, version = bean.getConfigType().getVersion());
        if (cls == null) {
            throw new MgmtException("Factory '" + this.getClass().getName() + "' can't create beans of type " + name + " and version " + version);
        }
        try {
            this.checkBeanVersion(cls, version);
            Constructor constr = cls.getConstructor(MgmtBeanFactory.class);
            IMgmtBeanBase base = (IMgmtBeanBase)constr.newInstance(this);
            ((MgmtBeanBase)base).setBean(bean);
            return base;
        }
        catch (Throwable e) {
            throw new MgmtException("Failed to create bean for " + name + " - " + e.getMessage(), e);
        }
    }

    protected String generateNameFromOldName(String[] patterns, String name) {
        String namePath = name.substring(0, name.lastIndexOf(47));
        for (int i = 0; i < patterns.length; ++i) {
            String patternPath = patterns[i].substring(0, patterns[i].lastIndexOf(47));
            if (!patternPath.equals(namePath)) continue;
            return ConfigFactory.generateDSName(patterns[i]);
        }
        return null;
    }

    protected void checkBeanVersion(Class cls, String elVersionStr) throws Exception {
        Field beanAPIVersionField = cls.getField("DS_C_VERSION");
        String beanAPIVersionStr = (String)beanAPIVersionField.get(cls);
        if (elVersionStr.compareTo(beanAPIVersionStr) > 0) {
            throw new MgmtException("Current API release version " + beanAPIVersionStr + " cannot handle greater bean release version " + elVersionStr);
        }
    }
}

