/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.comm.jms;

import com.sonicsw.mf.common.runtime.IStateController;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.IStateManager;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ConnectionStateManager
implements IStateManager {
    private short[] m_connectionStates;
    private short m_currentConnectionState;
    private HashMap m_connectionStateControllers = new HashMap();
    private HashSet m_connectionStateListeners = new HashSet();
    public static final String CONNECTOR_CLIENT_CLASSNAME = "ConnectorClient";
    public static final short CONNECT = 0;
    public static final short CONNECTING = 1;
    public static final short CONNECTED = 2;
    public static final short DISCONNECTING = 3;

    public ConnectionStateManager() {
        this.m_connectionStates = new short[10];
        for (int i = 0; i < this.m_connectionStates.length; i = (int)((short)(i + 1))) {
            this.m_connectionStates[i] = i;
        }
        this.m_currentConnectionState = 0;
    }

    public synchronized short getState(Object obj) {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Method getState(Object obj) of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }
        String str = (String)obj;
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME)) {
            return this.m_currentConnectionState;
        }
        throw new IllegalArgumentException("Attempt to get state of unrecognized object: object name = " + obj.getClass().getName());
    }

    public synchronized boolean requestStateChange(short expectedCurrentState, short desiredState, Object obj) throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Method registerStateChange() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }
        String str = (String)obj;
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME)) {
            return this.requestConnectionStateChange(expectedCurrentState, desiredState, obj);
        }
        return false;
    }

    public synchronized void registerStateController(IStateController stateController, short fromState, short toState, Object obj) {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Method registerStateController() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }
        String str = (String)obj;
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME)) {
            if (!this.isValidState(fromState, CONNECTOR_CLIENT_CLASSNAME)) {
                throw new IllegalArgumentException("Invalid state: " + fromState + ", for 'from' connection state.");
            }
            if (!this.isValidState(toState, CONNECTOR_CLIENT_CLASSNAME)) {
                throw new IllegalArgumentException("Invalid state: " + toState + ", for 'to' connection state.");
            }
            String key = fromState + "," + toState;
            if (this.m_connectionStateControllers.containsKey(key)) {
                throw new IllegalStateException("State controller for specified state transition already registered for connection.");
            }
            this.m_connectionStateControllers.put(key, stateController);
        }
    }

    public synchronized void registerStateListener(IStateListener stateListener, Object obj) {
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Method registerStateListener() of the ConnectionAndServiceStateManager class requires that the input 'obj' argument must refer to an object that is of type 'String', though the formal parameter is of type 'Object'.");
        }
        String str = (String)obj;
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME)) {
            this.m_connectionStateListeners.add(stateListener);
        }
    }

    private boolean isValidState(short state, String str) {
        if (str.equalsIgnoreCase(CONNECTOR_CLIENT_CLASSNAME)) {
            for (int i = 0; i < this.m_connectionStates.length; ++i) {
                if (this.m_connectionStates[i] != state) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Attempt to test state of unrecognized object: object name = " + str);
    }

    private synchronized boolean requestConnectionStateChange(short expectedCurrentState, short desiredState, Object obj) throws NonRecoverableStateChangeException, RecoverableStateChangeException {
        if (!this.isValidState(desiredState, CONNECTOR_CLIENT_CLASSNAME)) {
            throw new IllegalArgumentException("Invalid state: " + desiredState + ", for desired connection state.");
        }
        if (expectedCurrentState != this.m_currentConnectionState) {
            return false;
        }
        Iterator iterator = this.m_connectionStateListeners.iterator();
        while (iterator.hasNext()) {
            ((IStateListener)iterator.next()).stateChanging(this.m_currentConnectionState, desiredState);
        }
        String key = this.m_currentConnectionState + "," + desiredState;
        IStateController controller = (IStateController)this.m_connectionStateControllers.get(key);
        boolean stateChanged = controller == null ? true : controller.changeState();
        iterator = this.m_connectionStateListeners.iterator();
        while (iterator.hasNext()) {
            if (stateChanged) {
                ((IStateListener)iterator.next()).stateChanged(this.m_currentConnectionState, desiredState);
                continue;
            }
            ((IStateListener)iterator.next()).stateChangeFailed(this.m_currentConnectionState, desiredState);
        }
        if (stateChanged) {
            this.m_currentConnectionState = desiredState;
            super.notifyAll();
        }
        return stateChanged;
    }
}

