/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.comm.jms;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.IConnectionListener;
import com.sonicsw.mf.comm.IConnectorClient;
import com.sonicsw.mf.comm.IDurableConnectorConsumer;
import com.sonicsw.mf.comm.IExceptionListener;
import com.sonicsw.mf.comm.INotificationListener;
import com.sonicsw.mf.comm.IOrphanedReplyListener;
import com.sonicsw.mf.comm.IRetryCallback;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.ConnectionStateManager;
import com.sonicsw.mf.comm.jms.DurableConnector;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.MFConnectAbortedException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.MFServiceNotActiveException;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mx.util.LoaderInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnauthorizedClient;
import progress.message.jclient.Constants;
import progress.message.jclient.TopicConnectionFactory;

public class ConnectorClient
implements IConnectorClient,
IDurableConnectorConsumer,
MessageListener {
    private static boolean DEBUG_TRACE_CONNECTION_STATE = false;
    private static boolean DEBUG_TRACE_REQUEST = false;
    private static boolean DEBUG_TRACE_INVOCATION = false;
    private static boolean DEBUG_TRACE_RETRY_CALLBACK = false;
    private static String REQUEST_TIMEOUT_OVERRIDE_PROPERTY = "sonicsw.mf.requestTimeoutOverride";
    private static String REQUEST_TIMEOUT_OVERRIDE = null;
    protected int m_traceMask;
    protected boolean m_logConnectionMessages = false;
    protected String m_domainName;
    protected String m_containerName;
    protected String m_managementNode;
    protected long m_requestTimeout = REQUEST_TIMEOUT_DEFAULT;
    protected long m_connectTimeout = 10000L;
    private int m_deliveryMode = 2;
    private boolean m_isDurable = true;
    protected long m_socketConnectTimeout = 0L;
    private String m_directedSubscriptionSubject;
    private String m_directedReplyToSubject;
    private String m_subscriptionName;
    private String m_connectID;
    private String m_defaultRole;
    private Hashtable m_notificationListeners = new Hashtable();
    protected DurableConnector m_durableConnector;
    protected ConnectionStateManager m_stateManager;
    protected IConsumer m_subscription;
    protected HashMap m_activeRequests = new HashMap();
    protected IExceptionListener m_exceptionListener;
    protected IConnectionListener m_connectionListener;
    protected IOrphanedReplyListener m_orphanedReplyListener;
    protected boolean m_inContainer = false;
    private TopicConnectionFactory m_connectionFactory;
    private IRetryCallback m_retryCallback = null;
    private Object m_requestLock = new Object();
    private RetryCallbackManager m_retryCallbackManager = null;
    private IDurableConnectorFactory m_durableConnectorFactory = new DurableConnectorFactory();
    private ITopicConnectionFactoryFactory m_topicConnectionFactoryFactory = new TopicConnectionFactoryFactory();
    private static boolean m_debugRequestTimeout = false;
    private static boolean m_requestTimeoutPrinted = false;
    private static final ClassLoader m_loader = ConnectorClient.class.getClassLoader();
    public static final long REQUEST_TIMEOUT_DEFAULT = ConnectorClient.getRequestDefaultTimeOut();
    public static final String REQUEST_TIMEOUT_DEFAULT_PROPERTY = "sonicsw.mf.requestTimeoutDefault";
    public static final long REQUEST_TIMEOUT_MINIMUM = 10000L;
    public static final long CONNECT_TIMEOUT_DEFAULT = 10000L;
    public static final long CONNECT_TIMEOUT_MINIMUM = 10000L;
    public static final long SOCKET_CONNECT_TIMEOUT_DEFAULT = 0L;
    public static final long SOCKET_CONNECT_TIMEOUT_MINIMUM = 0L;
    public static final String MF_SUBJECT_ROOT = "SonicMQ.mf.";
    public static final String MF_CONNECTID_PREFIX = "SonicMQ/mf/";
    public static final String MF_DIRECTORY_SERVICE_STR = "DIRECTORY SERVICE";
    public static final String MF_AGENT_MANAGER_STR = "AGENT MANAGER";
    public static final String MF_DIRECTORY_SERVICE_ID = "ID=DIRECTORY SERVICE";
    public static final String MF_AGENT_MANAGER_ID = "ID=AGENT MANAGER";
    private static final int REQUEST_ARRAY_LENGTH = 4;
    public static final int REQUEST_ID_INDEX = 0;
    public static final int REQUEST_TARGET_INDEX = 1;
    public static final int REQUEST_ATTEMPT_COUNT_INDEX = 2;
    public static final int REQUEST_REPLY_MESSAGE_INDEX = 3;
    public static final int MAX_REQUEST_ATTEMPT_COUNT = 3;
    protected static final String JMS_PROPERTY_PREFIX = "JMS_SonicMQ_mf_";
    public static final String JMS_COMMS_TYPE_PROPERTY = "JMS_SonicMQ_mf_comms_type";
    public static final String JMS_CONTENT_TYPE_PROPERTY = "JMS_SonicMQ_mf_content_type";
    public static final short NOTIFICATION_CONTENT_TYPE = 0;
    public static final short REQUEST_CONTENT_TYPE = 1;
    public static final short REPLY_CONTENT_TYPE = 2;
    public static final String JMS_REPLY_TO_PROPERTY = "JMS_SonicMQ_mf_reply_subject";
    public static final String MY_MGMT_NODE_PROPERTY = "JMS_SonicMQ_mf_my_mgmt_node";
    public static final String JMS_ONEWAY_REQUEST_PROPERTY = "JMS_SonicMQ_mf_oneway_request";
    public static final String JMS_LISTENER_ID_PROPERTY = "JMS_SonicMQ_mf_listener_ID";
    public static final String JMS_REQUEST_TARGET_PROPERTY = "JMS_SonicMQ_mf_target";
    public static final String JMS_REQUEST_OPERATION_PROPERTY = "JMS_SonicMQ_mf_operation";
    public static final String JMS_REQUEST_TIMEOUT_PROPERTY = "JMS_SonicMQ_mf_timeout";
    public static final String JMS_REQUEST_RECEIVED_PROPERTY = "JMS_SonicMQ_mf_received";
    public static final String JMS_REQUEST_REPLIED_PROPERTY = "JMS_SonicMQ_mf_replied";
    public static final String NEWLINE = System.getProperty("line.separator");
    private static boolean DISABLE_FT_CLIENT;
    private static String DISABLE_FT_CLIENT_PROPERTY;
    private static String FLOW_TO_DISK;
    private static String FLOW_TO_DISK_PROPERTY;
    private static boolean REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST;
    private static String REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST_PROPERTY;
    private static boolean INFINITE_RETRY;
    private static String INFINITE_RETRY_PROPERTY;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL;

    private static long getRequestDefaultTimeOut() {
        String requestTimeoutDefault = System.getProperty(REQUEST_TIMEOUT_DEFAULT_PROPERTY);
        String overrideTimeOut = System.getProperty(REQUEST_TIMEOUT_OVERRIDE_PROPERTY);
        if (overrideTimeOut != null) {
            return new Long(overrideTimeOut);
        }
        if (requestTimeoutDefault != null) {
            return new Long(requestTimeoutDefault);
        }
        return 30000L;
    }

    public ConnectorClient(String clientType) {
        String ipID = "0_0_0_0";
        try {
            ipID = InetAddress.getLocalHost().getHostAddress().replace('.', '_');
        }
        catch (Throwable e) {
            // empty catch block
        }
        String uniqueID = clientType + '.' + ipID + '.' + new UID().toString();
        this.m_directedReplyToSubject = this.m_directedSubscriptionSubject = MF_SUBJECT_ROOT + uniqueID;
        this.m_subscriptionName = uniqueID = uniqueID.replace('.', '/');
        this.initialize(uniqueID);
        this.m_defaultRole = clientType;
    }

    ConnectorClient(IDurableConnectorFactory durableConnectorFactory, ITopicConnectionFactoryFactory topicConnectionFactoryFactory, String clientType) {
        this(clientType);
        this.m_durableConnectorFactory = durableConnectorFactory;
        this.m_topicConnectionFactoryFactory = topicConnectionFactoryFactory;
    }

    public ConnectorClient(IContainerIdentity containerIdentity) {
        this.m_domainName = containerIdentity.getDomainName();
        this.m_containerName = containerIdentity.getContainerName();
        String uniqueID = this.m_domainName + '.' + this.m_containerName;
        this.m_directedSubscriptionSubject = "SonicMQ.mf.*." + uniqueID;
        this.m_directedReplyToSubject = "SonicMQ.mf.." + uniqueID;
        this.m_subscriptionName = uniqueID = this.m_domainName + '/' + this.m_containerName;
        this.initialize(uniqueID);
        this.m_defaultRole = "MFCLIENT";
    }

    ConnectorClient(IDurableConnectorFactory durableConnectorFactory, ITopicConnectionFactoryFactory topicConnectionFactoryFactory, IContainerIdentity containerIdentity) {
        this(containerIdentity);
        this.m_durableConnectorFactory = durableConnectorFactory;
        this.m_topicConnectionFactoryFactory = topicConnectionFactoryFactory;
    }

    private void initialize(String uniqueID) {
        this.m_logConnectionMessages = Boolean.getBoolean("sonicsw.mf.logConnectionMessages");
        String tr = System.getProperty("enableConnectorClientConnectionTracing");
        if (tr != null && tr.equalsIgnoreCase("true")) {
            DEBUG_TRACE_CONNECTION_STATE = true;
        }
        this.m_connectID = MF_CONNECTID_PREFIX + uniqueID;
    }

    public long getRequestTimeout() {
        return this.m_requestTimeout;
    }

    @Override
    public void setRequestTimeout(long milliseconds) {
        if (REQUEST_TIMEOUT_OVERRIDE == null) {
            this.m_requestTimeout = milliseconds >= 10000L ? milliseconds : 10000L;
            this.setPingInterval();
        }
    }

    private void setPingInterval() {
        int pingInterval = (int)(this.getRequestTimeout() * 9L / 10000L);
        if (pingInterval < 20) {
            pingInterval = 20;
        }
        if (this.m_connectionFactory != null) {
            this.m_connectionFactory.setPingInterval((long)pingInterval);
        }
    }

    public long getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this.m_connectTimeout = milliseconds >= 10000L ? milliseconds : 10000L;
        try {
            if (this.m_connectionFactory != null) {
                this.setSonicMQFaultTolerance(this.m_connectionFactory);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDeliveryMode(int deliveryMode) {
        this.m_deliveryMode = deliveryMode;
    }

    public void setDurable(boolean durable) {
        this.m_isDurable = durable;
    }

    public long getSocketConnectTimeout() {
        return this.m_socketConnectTimeout;
    }

    public void setSocketConnectTimeout(long milliseconds) {
        this.m_socketConnectTimeout = milliseconds <= 0L ? 0L : (milliseconds >= 2000L ? milliseconds : 2000L);
    }

    @Override
    public void setManagementNode(String node) {
        this.m_managementNode = node;
    }

    @Override
    public void connect(Map properties, long timeout) throws Exception {
        if (this.m_durableConnector != null) {
            throw new IllegalStateException("Cannot attempt to connect same connector more than once");
        }
        properties.put("ConnectID", this.m_connectID);
        HashMap factoryProperties = new HashMap(properties);
        this.m_connectionFactory = this.m_topicConnectionFactoryFactory.createConnectionFactory();
        this.setConnectionFactoryProperties(this.m_connectionFactory, factoryProperties);
        try {
            this.m_durableConnector = this.m_durableConnectorFactory.createDurableConnector(this, "Management", timeout);
            this.m_durableConnector.setDeliveryMode(this.m_deliveryMode);
        }
        catch (MFConnectAbortedException cae) {
            if (this.m_durableConnector != null) {
                this.m_durableConnector.cleanup();
            }
            throw cae;
        }
        catch (MFSecurityException se) {
            if (this.m_durableConnector != null) {
                this.m_durableConnector.cleanup();
            }
            if (this.m_connectionListener != null) {
                this.m_connectionListener.onFailure((Exception)((Object)se));
            }
            if (this.m_exceptionListener != null) {
                this.m_exceptionListener.onException((Exception)((Object)se));
            }
            throw se;
        }
        if (Thread.interrupted()) {
            Thread.currentThread().interrupt();
        } else {
            if (timeout > 0L && !this.m_durableConnector.isConnected()) {
                this.m_durableConnector.cleanup();
                throw new ConnectTimeoutException("Timeout occured while attempting to connect");
            }
            try {
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("ConnectorClient.connect: subscription subject = " + this.m_directedSubscriptionSubject + ", subscription name = " + this.m_subscriptionName);
                }
                this.m_subscription = this.m_durableConnector.subscribe(this.m_directedSubscriptionSubject, this.m_isDurable ? this.m_subscriptionName : null, this, null);
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("ConnectorClient.connect: connection successfully established, m_subscription = " + this.m_subscription);
                }
            }
            catch (JMSException e) {
                Exception le = e.getLinkedException();
                if (le != null && (le instanceof ESecurityPolicyViolation || le instanceof ESecurityGeneralException || le instanceof EPasswordExpired || le instanceof EUnauthorizedClient)) {
                    MFSecurityException se = new MFSecurityException("Authentication failure");
                    se.setLinkedException(le);
                    throw se;
                }
                throw e;
            }
        }
    }

    @Override
    public boolean isConnected() {
        if (this.m_durableConnector == null) {
            return false;
        }
        try {
            return this.m_durableConnector.isConnected();
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public IExceptionListener getExceptionListener() {
        return this.m_exceptionListener;
    }

    @Override
    public final void setExceptionListener(IExceptionListener listener) {
        this.m_exceptionListener = listener;
    }

    @Override
    public IConnectionListener getConnectionListener() {
        return this.m_connectionListener;
    }

    @Override
    public final void setConnectionListener(IConnectionListener listener) {
        this.m_connectionListener = listener;
    }

    @Override
    public IOrphanedReplyListener getOrphanedReplyListener() {
        return this.m_orphanedReplyListener;
    }

    @Override
    public void setOrphanedReplyListener(IOrphanedReplyListener listener) {
        this.m_orphanedReplyListener = listener;
    }

    public synchronized void registerRetryCallback(IRetryCallback rcb) {
        if (this.m_retryCallback != null) {
            throw new IllegalArgumentException("Retry callback already registered; only a single callback may be registered");
        }
        this.m_retryCallback = rcb;
        this.m_retryCallbackManager = new RetryCallbackManager();
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.registerRetryCallback: m_retryCallback = " + this.m_retryCallback);
        }
    }

    public synchronized void deregisterRetryCallback() {
        this.m_retryCallback = null;
        this.m_retryCallbackManager = null;
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.deregisterRetryCallback: m_retryCallback = " + this.m_retryCallback);
        }
    }

    @Override
    public void closePending() {
        if (this.m_durableConnector != null) {
            this.m_durableConnector.cleanupPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.m_durableConnector != null) {
            this.m_durableConnector.cleanup();
        }
        this.m_notificationListeners.clear();
        Object object = this.m_activeRequests;
        synchronized (object) {
            Iterator iterator = this.m_activeRequests.values().iterator();
            while (iterator.hasNext()) {
                Object requestArray;
                Object v = requestArray = iterator.next();
                synchronized (v) {
                    requestArray.notifyAll();
                }
            }
            this.m_activeRequests.clear();
        }
        object = this;
        synchronized (object) {
            if (this.m_retryCallback != null) {
                Object object2 = this.m_requestLock;
                synchronized (object2) {
                    if (this.m_retryCallbackManager.waiters > 0) {
                        this.m_retryCallbackManager.callbackAction = (short)0;
                        this.m_requestLock.notifyAll();
                    }
                }
                this.deregisterRetryCallback();
            }
        }
    }

    @Override
    public IConsumer addDirectedNotificationListener(INotificationListener listener) {
        NotificationListenerDelegate delegate = new NotificationListenerDelegate(listener);
        this.m_notificationListeners.put(listener.hashCode(), delegate);
        return delegate;
    }

    @Override
    public Object invoke(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature) throws Exception {
        return this.invoke(commsType, namespace, target, operationName, params, signature, this.m_defaultRole, this.m_requestTimeout);
    }

    @Override
    public Object invoke(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, long timeout) throws Exception {
        return this.invoke(commsType, namespace, target, operationName, params, signature, this.m_defaultRole, timeout);
    }

    @Override
    public Object invoke(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, String role) throws Exception {
        return this.invoke(commsType, namespace, target, operationName, params, signature, role, this.m_requestTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, String role, long requestTimeout) throws Exception {
        while (true) {
            long invokeStart = 0L;
            long invokeRequestBuilt = 0L;
            long invokeRequestSent = 0L;
            long invokeReplyReceived = 0L;
            if (DEBUG_TRACE_INVOCATION) {
                invokeRequestSent = invokeReplyReceived = (invokeStart = System.currentTimeMillis());
                invokeRequestBuilt = invokeReplyReceived;
            }
            BytesMessage requestMessage = null;
            Object[] requestArray = null;
            String requestID = null;
            Object returnValue = null;
            if (requestTimeout <= 0L || REQUEST_TIMEOUT_OVERRIDE != null) {
                requestTimeout = this.m_requestTimeout;
            }
            if (m_debugRequestTimeout && !m_requestTimeoutPrinted) {
                boolean log = this.m_logConnectionMessages;
                this.m_logConnectionMessages = true;
                this.logMessage("ConnectorClient.invoke target == " + target + " using request timeout " + requestTimeout, 3);
                m_requestTimeoutPrinted = true;
                this.m_logConnectionMessages = log;
            }
            long overallTimeout = this.determineOverallTimeoutValue(requestTimeout);
            try {
                try {
                    requestMessage = this.buildRequestMessage(commsType, target, operationName, params, signature);
                }
                catch (Exception e) {
                    if ((this.m_traceMask & 0x20) <= 0) throw e;
                    this.logMessage("Failed to marshal request, trace follows...", e, 7);
                    throw e;
                }
                catch (Error e) {
                    if ((this.m_traceMask & 0x20) <= 0) throw e;
                    this.logMessage("Failed to marshal request, trace follows...", e, 7);
                    throw e;
                }
                requestID = requestMessage.getJMSCorrelationID();
                if (DEBUG_TRACE_INVOCATION) {
                    System.out.println("ConnectorClient.invoke: requestID = " + requestID);
                }
                requestArray = this.buildRequestArray(target, requestID);
                HashMap e = this.m_activeRequests;
                // MONITORENTER : e
                this.m_activeRequests.put(requestID, requestArray);
                // MONITOREXIT : e
                if (DEBUG_TRACE_INVOCATION) {
                    System.out.println("ConnectorClient.invoke: added active request entry for requestID: " + requestID);
                }
                boolean isRequestAttemptComplete22 = false;
                long requestAttemptTimeout = 0L;
                long requestAttemptStartTime = System.currentTimeMillis();
                CanonicalName cName = new CanonicalName(namespace);
                String topicName = this.getNodePrefix(cName) + MF_SUBJECT_ROOT + role + '.' + cName.getDomainName() + '.' + cName.getContainerName();
                while (!isRequestAttemptComplete22) {
                    BytesMessage replyMessage;
                    block60: {
                        Object[] le;
                        Object[] objectArray = requestArray;
                        // MONITORENTER : requestArray
                        requestArray[3] = null;
                        // MONITOREXIT : objectArray
                        if (DEBUG_TRACE_RETRY_CALLBACK) {
                            System.out.println("ConnectorClient.invoke: m_retryCallback = " + this.m_retryCallback);
                        }
                        if (this.m_retryCallback == null && System.currentTimeMillis() > requestAttemptStartTime + overallTimeout) {
                            if ((this.m_traceMask & 0x20) > 0) {
                                this.logMessage("Timeout of synchronous invoke occurred while trying to establish management connection, target - " + operationName + "()", 7);
                            }
                            isRequestAttemptComplete22 = true;
                            this.cleanupRequestArray(requestArray);
                            throw new InvokeTimeoutException("Request timed out while trying to establish management connection, target - " + operationName + "()");
                        }
                        try {
                            requestAttemptTimeout = this.determineOverallTimeoutValue(requestTimeout);
                            if (DEBUG_TRACE_INVOCATION) {
                                System.out.println("ConnectorClient.invoke: operationName = " + operationName + ", role = " + role);
                            }
                            requestMessage.setLongProperty(JMS_REQUEST_TIMEOUT_PROPERTY, requestAttemptTimeout);
                            if (DEBUG_TRACE_INVOCATION) {
                                System.out.println("topic=" + topicName + ", target=" + target + ", operationName=" + operationName + ", replyTo=" + this.getReplyTo());
                            }
                            if (DEBUG_TRACE_INVOCATION) {
                                invokeRequestBuilt = System.currentTimeMillis();
                            }
                            this.m_durableConnector.publish(topicName, (Message)requestMessage, requestAttemptTimeout, requestTimeout, requestArray);
                            if (DEBUG_TRACE_INVOCATION) {
                                invokeRequestSent = System.currentTimeMillis();
                            }
                            if (DEBUG_TRACE_INVOCATION) {
                                System.out.println("ConnectorClient.invoke: published request to topicName: " + topicName);
                            }
                        }
                        catch (InvokeTimeoutException e2) {
                            InvokeTimeoutException invokeTimeoutException;
                            isRequestAttemptComplete22 = this.handleRequestAttemptFailure(target, operationName, e2, cName);
                            if (DEBUG_TRACE_INVOCATION) {
                                System.out.println("ConnectorClient.invoke: request cycle complete = " + isRequestAttemptComplete22);
                            }
                            if (!isRequestAttemptComplete22) continue;
                            if (e2 instanceof InvokeTimeoutCommsException) {
                                invokeTimeoutException = new InvokeTimeoutCommsException(target + " - " + operationName + "()");
                                throw invokeTimeoutException;
                            }
                            invokeTimeoutException = new InvokeTimeoutException(target + " - " + operationName + "()");
                            throw invokeTimeoutException;
                        }
                        catch (JMSException e3) {
                            isRequestAttemptComplete22 = true;
                            le = e3.getLinkedException();
                            if (DEBUG_TRACE_INVOCATION) {
                                le.printStackTrace();
                            }
                            if (le == null) throw e3;
                            if (!(le instanceof ESecurityPolicyViolation || le instanceof ESecurityGeneralException || le instanceof EPasswordExpired)) {
                                if (!(le instanceof EUnauthorizedClient)) throw e3;
                            }
                            MFSecurityException se = new MFSecurityException("Authorization failure");
                            se.setLinkedException((Exception)le);
                            throw se;
                        }
                        catch (Exception e4) {
                            if (!DEBUG_TRACE_INVOCATION) throw e4;
                            e4.printStackTrace();
                            throw e4;
                        }
                        catch (Error e5) {
                            if (!DEBUG_TRACE_INVOCATION) throw e5;
                            e5.printStackTrace();
                            throw e5;
                        }
                        replyMessage = null;
                        try {
                            if (DEBUG_TRACE_INVOCATION) {
                                System.out.println("ConnectorClient.invoke: preparing to wait for reply to requestID: " + requestID);
                            }
                            le = requestArray;
                            // MONITORENTER : requestArray
                            if (requestArray[3] == null) {
                                requestArray.wait(requestAttemptTimeout);
                            }
                            replyMessage = (BytesMessage)requestArray[3];
                            // MONITOREXIT : le
                            if (DEBUG_TRACE_INVOCATION) {
                                invokeReplyReceived = System.currentTimeMillis();
                            }
                            if (replyMessage == null) {
                                if (DEBUG_TRACE_INVOCATION) {
                                    System.out.println("ConnectorClient.invoke: timeout for requestID: " + requestID);
                                }
                                DurableConnector connector = this.m_durableConnector;
                                String message = target + " - " + operationName + "()";
                                InvokeTimeoutException ite = connector == null || !connector.isConnected() ? new InvokeTimeoutCommsException(message) : new InvokeTimeoutException(message);
                                isRequestAttemptComplete22 = this.handleRequestAttemptFailure(target, operationName, ite, cName);
                                if (!isRequestAttemptComplete22) continue;
                                if ((this.m_traceMask & 0x20) <= 0) throw ite;
                                StringBuffer msg = new StringBuffer("Timeout of synchronous invoke occurred");
                                if ((this.m_traceMask & 1) > 0) {
                                    msg.append(", details...");
                                    msg.append("\n\ttarget = ").append(target);
                                    msg.append("\n\trequest = ").append(operationName);
                                }
                                this.logMessage(msg.toString(), 7);
                                throw ite;
                            }
                        }
                        catch (InterruptedException e6) {
                            if (!DEBUG_TRACE_INVOCATION) break block60;
                            System.out.println("ConnectorClient.invoke: InterruptedException thrown while waiting for reply...");
                        }
                    }
                    try {
                        returnValue = this.unpackResponse(replyMessage);
                    }
                    catch (Exception e7) {
                        isRequestAttemptComplete22 = true;
                        if ((this.m_traceMask & 0x20) <= 0) throw e7;
                        this.logMessage("Failed to unmarshal reply, trace follows...", e7, 7);
                        throw e7;
                    }
                    catch (Error e8) {
                        isRequestAttemptComplete22 = true;
                        if ((this.m_traceMask & 0x20) <= 0) throw e8;
                        this.logMessage("Failed to unmarshal reply, trace follows...", e8, 7);
                        throw e8;
                    }
                    if (returnValue instanceof MFServiceNotActiveException) {
                        if (DEBUG_TRACE_INVOCATION) {
                            System.out.println("ConnectorClient.invoke: received MFServiceNotActiveException while publishing service request, set up for next FT attempt, requestID: " + requestID);
                        }
                        if (!(isRequestAttemptComplete22 = this.handleRequestAttemptFailure(target, operationName, (MFRuntimeException)returnValue, cName))) continue;
                        throw new MFServiceNotActiveException("Requested service not in active state, target: " + target);
                    }
                    if (returnValue instanceof Error) {
                        isRequestAttemptComplete22 = true;
                        if ((this.m_traceMask & 0x20) <= 0) throw (Error)returnValue;
                        this.logMessage("Error thrown during attempted operation, trace follows...", (Throwable)returnValue, 7);
                        throw (Error)returnValue;
                    }
                    if (returnValue instanceof Exception) {
                        isRequestAttemptComplete22 = true;
                        if ((this.m_traceMask & 0x20) <= 0) throw (Exception)returnValue;
                        this.logMessage("Exception thrown during attempted operation, trace follows...", (Throwable)returnValue, 7);
                        throw (Exception)returnValue;
                    }
                    if (DEBUG_TRACE_INVOCATION) {
                        System.out.println("ConnectorClient.invoke: successfully received proper response to request, requestID: " + requestID);
                    }
                    isRequestAttemptComplete22 = true;
                    break;
                }
                HashMap isRequestAttemptComplete22 = this.m_activeRequests;
            }
            catch (InvokeTimeoutException e) {
                block61: {
                    try {
                        if (!INFINITE_RETRY) break block61;
                        this.logMessage("Request failure, retrying...", 2);
                        HashMap hashMap = this.m_activeRequests;
                    }
                    catch (Throwable throwable) {
                        HashMap hashMap = this.m_activeRequests;
                        // MONITORENTER : hashMap
                        requestArray = (Object[])this.m_activeRequests.remove(requestID);
                        this.cleanupRequestArray(requestArray);
                        // MONITOREXIT : hashMap
                        throw throwable;
                    }
                    requestArray = (Object[])this.m_activeRequests.remove(requestID);
                    this.cleanupRequestArray(requestArray);
                    // MONITOREXIT : hashMap
                    continue;
                }
                throw e;
            }
            // MONITORENTER : isRequestAttemptComplete22
            requestArray = (Object[])this.m_activeRequests.remove(requestID);
            this.cleanupRequestArray(requestArray);
            // MONITOREXIT : isRequestAttemptComplete22
            if (!DEBUG_TRACE_INVOCATION) return returnValue;
            long invokeDone = System.currentTimeMillis();
            System.out.println("Invoke request for operation " + operationName + ".\n\ttook " + (invokeDone - invokeStart) + " ms." + "\n\tbuilding the request took " + (invokeRequestBuilt - invokeStart) + " ms." + "\n\tsending the request took " + (invokeRequestSent - invokeRequestBuilt) + " ms." + "\n\treceiving the reply took " + (invokeReplyReceived - invokeRequestSent) + " ms." + "\n\tunpacking the reply took " + (invokeDone - invokeReplyReceived) + " ms.");
            return returnValue;
            break;
        }
    }

    public void invokeOneway(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, Long timeout) throws InvokeTimeoutException, Exception {
        this.invokeOneway(commsType, namespace, target, operationName, params, signature, (long)timeout);
    }

    public void invokeOneway(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, long timeout) throws InvokeTimeoutException, Exception {
        this.invokeOneway(commsType, namespace, target, operationName, params, signature, timeout, timeout);
    }

    public void invokeOneway(String commsType, String namespace, String target, String operationName, Object[] params, String[] signature, long timeout, long ttl) throws InvokeTimeoutException, Exception {
        BytesMessage requestMessage = null;
        String requestID = null;
        Object[] requestArray = null;
        CanonicalName cName = new CanonicalName(namespace);
        String topicName = this.getNodePrefix(cName) + MF_SUBJECT_ROOT + this.m_defaultRole + '.' + cName.getDomainName() + '.' + cName.getContainerName();
        requestID = "2";
        requestArray = this.buildRequestArray(target, requestID);
        if (timeout == 0L || REQUEST_TIMEOUT_OVERRIDE != null) {
            timeout = this.m_requestTimeout;
        }
        if (m_debugRequestTimeout && !m_requestTimeoutPrinted) {
            boolean log = this.m_logConnectionMessages;
            this.m_logConnectionMessages = true;
            this.logMessage("ConnectorClient.invoke target == " + target + " using request timeout " + timeout, 3);
            m_requestTimeoutPrinted = true;
            this.m_logConnectionMessages = log;
        }
        try {
            requestMessage = this.buildRequestMessage(commsType, target, operationName, params, signature);
            requestMessage.setBooleanProperty(JMS_ONEWAY_REQUEST_PROPERTY, true);
        }
        catch (Throwable e) {
            if ((this.m_traceMask & 0x20) > 0) {
                this.logMessage("Failed to marshal (oneway) request, trace follows...", e, 7);
            }
            throw new Exception("Failed to marshal (oneway) request.");
        }
        try {
            this.m_durableConnector.publish(topicName, (Message)requestMessage, timeout, ttl, requestArray);
        }
        catch (InvokeTimeoutCommsException e) {
            throw new InvokeTimeoutCommsException(cName + " : " + operationName + "()");
        }
        catch (InvokeTimeoutException e) {
            throw new InvokeTimeoutException(cName + " : " + operationName + "()");
        }
        catch (Throwable e) {
            if ((this.m_traceMask & 0x20) > 0) {
                this.logMessage("Failed to publish (oneway) request, trace follows...", e, 7);
            }
            throw new Exception("Failed to publish (oneway) request: " + e);
        }
    }

    public void dumpRequestArray(Object[] requestArray) {
        System.out.println("ConnectorClient.dumpRequestArray: ");
        System.out.println("ConnectorClient.dumpRequestArray: requestID = " + requestArray[0]);
        System.out.println("ConnectorClient.dumpRequestArray: reply message = " + requestArray[3]);
        System.out.println("ConnectorClient.dumpRequestArray: target = " + requestArray[1]);
        System.out.println("ConnectorClient.dumpRequestArray: request attempt count = " + requestArray[2]);
    }

    private void cleanupRequestArray(Object[] requestArray) {
        if (requestArray != null) {
            for (int i = 0; i < requestArray.length; ++i) {
                requestArray[i] = null;
            }
        }
    }

    @Override
    public int getTraceMask() {
        return this.m_traceMask;
    }

    @Override
    public void setTraceMask(int traceMask) {
        this.m_traceMask = traceMask;
        if (this.m_traceMask < 0) {
            this.m_traceMask = 0;
        }
    }

    @Override
    public String getLocalRoutingNodeName() {
        int index;
        String node = null;
        if (this.m_durableConnector != null) {
            node = this.m_durableConnector.getLocalRoutingNodeName();
        }
        if (node == null && this.m_containerName != null && (index = this.m_containerName.indexOf(64)) > 0 && ++index < this.m_containerName.length()) {
            node = this.m_containerName.substring(index);
        }
        return node;
    }

    @Override
    public boolean isConnectionEnterpriseEnabled() {
        if (this.m_durableConnector != null) {
            return this.m_durableConnector.isConnectionEnterpriseEnabled();
        }
        return false;
    }

    public String getReplyTo() {
        StringBuffer sb = new StringBuffer();
        String localRoutingNodeName = this.getLocalRoutingNodeName();
        if (localRoutingNodeName != null) {
            sb.append(localRoutingNodeName).append("::");
        }
        sb.append(this.m_directedReplyToSubject);
        return sb.toString();
    }

    public static String getPseudoContainerID(String globalID, String instanceID) {
        StringBuffer pseudoContainerID = new StringBuffer();
        if (instanceID != null) {
            pseudoContainerID.append('[');
            pseudoContainerID.append(instanceID);
            pseudoContainerID.append(']');
        }
        pseudoContainerID.append(globalID);
        return pseudoContainerID.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BytesMessage buildRequestMessage(String commsType, String target, String operationName, Object[] params, String[] signature) throws Exception {
        progress.message.jimpl.BytesMessage requestMessage = null;
        String requestID = new UID().toString();
        requestMessage = new progress.message.jimpl.BytesMessage();
        requestMessage.setJMSCorrelationID(requestID);
        if (this.m_managementNode != null) {
            requestMessage.setStringProperty(MY_MGMT_NODE_PROPERTY, this.m_managementNode);
        }
        requestMessage.setStringProperty(JMS_REPLY_TO_PROPERTY, this.getReplyTo());
        requestMessage.setStringProperty(JMS_COMMS_TYPE_PROPERTY, commsType);
        requestMessage.setShortProperty(JMS_CONTENT_TYPE_PROPERTY, (short)1);
        requestMessage.setStringProperty(JMS_REQUEST_TARGET_PROPERTY, target);
        requestMessage.setStringProperty(JMS_REQUEST_OPERATION_PROPERTY, operationName);
        if (DEBUG_TRACE_INVOCATION) {
            System.out.println("ConnectorClient.buildInvokeRequest: replyTo = " + requestMessage.getStringProperty(JMS_REPLY_TO_PROPERTY) + ", MY_MGMT_NODE = " + requestMessage.getStringProperty(MY_MGMT_NODE_PROPERTY) + ", target = " + requestMessage.getStringProperty(JMS_REQUEST_TARGET_PROPERTY) + ", operation = " + requestMessage.getStringProperty(JMS_REQUEST_OPERATION_PROPERTY) + " for requestID = " + requestID);
        }
        requestMessage.writeBoolean(signature.length == 0);
        if (signature.length > 0) {
            ByteArrayOutputStream arrayOut;
            ByteArrayOutputStream byteArrayOutputStream = arrayOut = new ByteArrayOutputStream(5120);
            synchronized (byteArrayOutputStream) {
                ObjectOutputStream out = new ObjectOutputStream(arrayOut);
                out.writeObject(signature);
                out.writeObject(params);
                out.flush();
                requestMessage.writeInt(arrayOut.size());
                requestMessage.writeBytes(arrayOut.toByteArray());
                out.close();
            }
        }
        return requestMessage;
    }

    protected String getNodePrefix(CanonicalName cName) {
        String targetContainer = cName.getContainerName();
        int index = targetContainer.indexOf(64);
        if (index > 0 && ++index < targetContainer.length()) {
            return targetContainer.substring(index) + "::";
        }
        if (this.m_managementNode != null) {
            return this.m_managementNode + "::";
        }
        return "";
    }

    @Override
    public void logMessage(String message, int severityLevel) {
        if (this.m_logConnectionMessages) {
            StringBuffer timestampedMessage = new StringBuffer();
            timestampedMessage.append('[');
            timestampedMessage.append(DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis())));
            timestampedMessage.append("]");
            timestampedMessage.append(" (");
            timestampedMessage.append(Level.LEVEL_TEXT[severityLevel]);
            timestampedMessage.append(") ");
            timestampedMessage.append(message);
            System.err.println(timestampedMessage.toString());
            System.err.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String message, Throwable exception, int severityLevel) {
        ByteArrayOutputStream out;
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(NEWLINE);
        ByteArrayOutputStream byteArrayOutputStream = out = new ByteArrayOutputStream(128);
        synchronized (byteArrayOutputStream) {
            PrintWriter writer = new PrintWriter(out, true);
            this.printStackTrace(exception, writer);
            byte[] data = out.toByteArray();
            try {
                out.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            buffer.append(new String(data));
        }
        this.logMessage(buffer.toString(), severityLevel);
    }

    @Override
    public synchronized TopicConnectionFactory getConnectionFactory() {
        return this.m_connectionFactory;
    }

    public synchronized boolean isInContainer() {
        return this.m_inContainer;
    }

    private void setSonicMQFaultTolerance(TopicConnectionFactory tcFactory) throws RuntimeException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (!DISABLE_FT_CLIENT) {
            Boolean b = Boolean.TRUE;
            Method setter = null;
            setter = TopicConnectionFactory.class.getMethod("setFaultTolerant", b.getClass());
            setter.invoke((Object)tcFactory, b);
            Integer timeout = (int)this.m_connectTimeout / 1000;
            setter = TopicConnectionFactory.class.getMethod("setFaultTolerantReconnectTimeout", timeout.getClass());
            setter.invoke((Object)tcFactory, timeout);
            setter = TopicConnectionFactory.class.getMethod("setInitialConnectTimeout", timeout.getClass());
            setter.invoke((Object)tcFactory, timeout);
        }
    }

    private void setConnectionFactoryProperties(TopicConnectionFactory factory, Map factoryProperties) throws NoSuchMethodException, NoSuchFieldException, InvocationTargetException, IllegalAccessException {
        int val;
        String monitorInterval = System.getProperty("monitorInterval");
        if (monitorInterval != null && (val = Integer.parseInt(monitorInterval)) >= 0) {
            factory.setMonitorInterval(Integer.valueOf(val));
        }
        Method setter = null;
        factory.setLoadBalancing(true);
        for (Map.Entry entry : factoryProperties.entrySet()) {
            try {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (name.equals("ConnectionURLs")) {
                    value = this.fixupURLs((String)value);
                }
                if (name.startsWith("LoadBalancing")) {
                    name = "LoadBalancingBoolean";
                }
                if (name.startsWith("EnableCompression")) {
                    name = "EnableCompressionBoolean";
                }
                setter = factory.getClass().getMethod("set" + name, value.getClass());
                setter.invoke((Object)factory, value);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException("The TopicConnectionFactory class does not have a '" + (String)entry.getKey() + "' " + entry.getValue().getClass().getName() + " property.");
            }
        }
        factory.setSequential(true);
        factory.setPersistentDelivery(true);
        factory.setInitialConnectTimeout(Integer.valueOf((int)this.m_connectTimeout / 1000));
        factory.setSocketConnectTimeout(Integer.valueOf((int)this.m_socketConnectTimeout));
        this.setPingInterval();
        this.setSonicMQFaultTolerance(factory);
        Field flowToDiskOn = Constants.class.getField("FLOW_TO_DISK_ON");
        Field flowToDiskOff = Constants.class.getField("FLOW_TO_DISK_OFF");
        Field flowToDiskUseBrokerSetting = Constants.class.getField("FLOW_TO_DISK_USE_BROKER_SETTING");
        int onVal = flowToDiskOn.getInt(null);
        int offVal = flowToDiskOff.getInt(null);
        int useBrokerVal = flowToDiskUseBrokerSetting.getInt(null);
        int flowToDiskVal = onVal;
        if (FLOW_TO_DISK != null && (flowToDiskVal = Integer.parseInt(FLOW_TO_DISK)) != onVal && flowToDiskVal != offVal && flowToDiskVal != useBrokerVal) {
            flowToDiskVal = onVal;
        }
        factory.setFlowToDisk(Integer.valueOf(flowToDiskVal));
    }

    public long determineOverallTimeoutValue(long requestTimeout) {
        if (this.m_durableConnector.isConnected()) {
            return requestTimeout;
        }
        return requestTimeout + this.m_connectTimeout;
    }

    public Object[] buildRequestArray(String target, String requestID) {
        if (DEBUG_TRACE_REQUEST) {
            System.out.println("ConnectorClient.buildRequestArr: target = " + target + ", requestID: " + requestID);
        }
        Object[] requestArray = new Object[4];
        requestArray[0] = requestID;
        requestArray[3] = null;
        requestArray[1] = target;
        requestArray[2] = (short)1;
        return requestArray;
    }

    private boolean handleRequestAttemptFailure(String target, String operationName, MFRuntimeException e, CanonicalName cName) throws InvokeTimeoutException, RuntimeException {
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.handleRequestAttemptFailure: m_retryCallback = " + this.m_retryCallback);
        }
        if (this.m_retryCallback == null) {
            return true;
        }
        return this.testRetryCallback(cName, operationName, (Exception)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testRetryCallback(CanonicalName cName, String operationName, Exception e) throws InvokeTimeoutException, RuntimeException {
        Object object;
        boolean requestCycleComplete = false;
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.testRetryCallback: cName = " + cName.getCanonicalName());
        }
        Object lock = this.m_requestLock;
        RetryCallbackManager manager = this.m_retryCallbackManager;
        boolean performCallback = false;
        try {
            Object object2 = lock;
            synchronized (object2) {
                manager.waiters++;
                if (manager.waiters == 1) {
                    performCallback = true;
                }
            }
            if (performCallback) {
                short callbackAction = this.performCallback(cName, e);
                Object object3 = lock;
                synchronized (object3) {
                    manager.callbackAction = callbackAction;
                    lock.notifyAll();
                }
            }
            object2 = lock;
            synchronized (object2) {
                while (manager.callbackAction == -1) {
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException ie) {
                        if (!DEBUG_TRACE_RETRY_CALLBACK) continue;
                        System.out.println("ConnectorClient.testRetryCallback: InterruptedException ignored");
                    }
                }
            }
            object = lock;
        }
        catch (Throwable throwable) {
            Object object4 = lock;
            synchronized (object4) {
                try {
                    boolean bl = requestCycleComplete = manager.callbackAction == 0;
                    if (DEBUG_TRACE_RETRY_CALLBACK) {
                        System.out.println("ConnectorClient.testRetryCallback: callbackAction = " + manager.callbackAction + ", requestCycleComplete = " + requestCycleComplete);
                    }
                }
                finally {
                    manager.waiters--;
                    if (manager.waiters == 0) {
                        manager.callbackAction = (short)-1;
                    }
                }
            }
            throw throwable;
        }
        synchronized (object) {
            try {
                boolean bl = requestCycleComplete = manager.callbackAction == 0;
                if (DEBUG_TRACE_RETRY_CALLBACK) {
                    System.out.println("ConnectorClient.testRetryCallback: callbackAction = " + manager.callbackAction + ", requestCycleComplete = " + requestCycleComplete);
                }
            }
            finally {
                manager.waiters--;
                if (manager.waiters == 0) {
                    manager.callbackAction = (short)-1;
                }
            }
        }
        return requestCycleComplete;
    }

    private short performCallback(CanonicalName cName, Exception e) {
        String targetName;
        short[] acceptableReturnValues = null;
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.performCallback: cName = " + cName.getCanonicalName());
        }
        acceptableReturnValues = new short[]{0, 1};
        String currentConnectionURLs = this.getConnectionFactory().getConnectionURLs();
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.performCallback: current connection URLs = " + currentConnectionURLs);
        }
        String string = targetName = cName.getContainerName().endsWith(cName.getComponentName()) ? cName.getContainerName() : cName.getCanonicalName();
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.performCallback: formulated targetName = " + targetName);
        }
        short callbackAction = this.m_retryCallback.onRequestFailure(targetName, currentConnectionURLs, e, acceptableReturnValues);
        if (DEBUG_TRACE_RETRY_CALLBACK) {
            System.out.println("ConnectorClient.handleCallback: returned action = " + callbackAction);
        }
        if (callbackAction < 0 || callbackAction > 2) {
            throw new RuntimeException("Invalid action specified for retry of failed request: request will be cancelled.");
        }
        return callbackAction;
    }

    private void printStackTrace(Throwable exception, PrintWriter writer) {
        exception.printStackTrace(writer);
        if (exception instanceof InvocationTargetException) {
            this.printStackTrace(((InvocationTargetException)exception).getTargetException(), writer);
        }
    }

    public void onMessage(Message message) {
        block12: {
            if (DEBUG_TRACE_REQUEST) {
                System.out.println("ConnectorClient.onMessage: reply received...");
            }
            if (this.isRedelivered(message)) {
                return;
            }
            try {
                short contentType = message.getShortProperty(JMS_CONTENT_TYPE_PROPERTY);
                switch (contentType) {
                    case 2: {
                        if (DEBUG_TRACE_REQUEST) {
                            System.out.println("ConnectorClient.onMessage: reply received, BytesMessage...");
                        }
                        this.handleReplyMessage((BytesMessage)message);
                        break;
                    }
                    case 0: {
                        if (DEBUG_TRACE_REQUEST) {
                            System.out.println("ConnectorClient.onMessage: reply received, DirectedNotification...");
                        }
                        this.handleDirectedNotification(message);
                        break;
                    }
                    case 1: {
                        this.logMessage("Request content type " + message.getJMSDestination().toString(), 2);
                        break;
                    }
                    default: {
                        if (DEBUG_TRACE_REQUEST) {
                            System.out.println("ConnectorClient.onMessage: reply received, unknown content type...");
                        }
                        this.logMessage("Unknown message content type: " + contentType, 2);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                if ((this.m_traceMask & 0x20) <= 0) break block12;
                this.logMessage("Failed to identify message content type, trace follows", e, 7);
            }
        }
    }

    protected boolean isRedelivered(Message message) {
        try {
            return message.getJMSRedelivered();
        }
        catch (JMSException e) {
            if ((this.m_traceMask & 0x20) > 0) {
                this.logMessage("Bad MF JMS message redelivered (dropping message), trace follows...", e, 7);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleReplyMessage(BytesMessage message) {
        String requestID = null;
        try {
            requestID = message.getJMSCorrelationID();
            Object[] requestArray = null;
            Object[] objectArray = this.m_activeRequests;
            synchronized (this.m_activeRequests) {
                requestArray = (Object[])this.m_activeRequests.get(requestID);
                if (DEBUG_TRACE_REQUEST) {
                    System.out.println("ConnectorClient.handleReplyMessage: requestArray = " + Arrays.toString(requestArray) + " for requestID:" + requestID);
                }
                if (requestArray == null) {
                    IOrphanedReplyListener listener = this.m_orphanedReplyListener;
                    if (listener == null) return;
                    this.handleOrphanedReplyMessage(listener, message);
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var4_6] (shouldn't be in output)
                objectArray = requestArray;
                synchronized (requestArray) {
                    requestArray[3] = message;
                    requestArray.notifyAll();
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    if (!DEBUG_TRACE_REQUEST) return;
                    System.out.println("ConnectorClient.handleReplyMessage: notified waiter of requestArray object...");
                    return;
                }
            }
        }
        catch (JMSException e) {
            if ((this.m_traceMask & 0x20) <= 0) return;
            this.logMessage("Failed to identify reply ID, trace follows...", e, 7);
            return;
        }
        catch (Throwable e) {
            if ((this.m_traceMask & 0x20) <= 0) return;
            this.logMessage("Failed to handle reply, trace follows...", e, 7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unpackResponse(BytesMessage replyMessage) throws Exception {
        ByteArrayInputStream arrayIn;
        if (replyMessage == null || replyMessage.readBoolean()) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        byte[] bytes = new byte[replyMessage.readInt()];
        replyMessage.readBytes(bytes);
        ByteArrayInputStream byteArrayInputStream = arrayIn = new ByteArrayInputStream(bytes);
        synchronized (byteArrayInputStream) {
            ObjectInputStream in = null;
            in = this.m_containerName != null || loader == null || loader == m_loader ? new ObjectInputStream(arrayIn) : new LoaderInputStream((InputStream)arrayIn, loader);
            return in.readObject();
        }
    }

    private void handleOrphanedReplyMessage(IOrphanedReplyListener listener, BytesMessage replyMessage) {
        Object returnValue;
        long requestReplied;
        long requestReceived;
        String operationName;
        String target;
        block4: {
            target = null;
            operationName = null;
            requestReceived = 0L;
            requestReplied = 0L;
            returnValue = null;
            try {
                target = replyMessage.getStringProperty(JMS_REQUEST_TARGET_PROPERTY);
                operationName = replyMessage.getStringProperty(JMS_REQUEST_OPERATION_PROPERTY);
                requestReceived = replyMessage.getLongProperty(JMS_REQUEST_RECEIVED_PROPERTY);
                requestReplied = replyMessage.getLongProperty(JMS_REQUEST_REPLIED_PROPERTY);
                returnValue = this.unpackResponse(replyMessage);
            }
            catch (Exception e) {
                if ((this.m_traceMask & 0x20) <= 0) break block4;
                this.logMessage("Failed to unmarshal orphaned reply, trace follows...", e, 7);
            }
        }
        if (returnValue instanceof Exception) {
            listener.onFailure(target, operationName, (Exception)returnValue, requestReceived, requestReplied);
        } else {
            listener.onSuccess(target, operationName, returnValue, requestReceived, requestReplied);
        }
    }

    private void handleDirectedNotification(Message message) {
        block2: {
            try {
                Integer listenerHash = message.getIntProperty(JMS_LISTENER_ID_PROPERTY);
                NotificationListenerDelegate delegate = (NotificationListenerDelegate)this.m_notificationListeners.get(listenerHash);
                delegate.onMessage(message);
            }
            catch (Throwable e) {
                if ((this.m_traceMask & 0x20) <= 0) break block2;
                this.logMessage("Failed to identify notification listener (dropping notification), trace follows...", e, 7);
            }
        }
    }

    @Override
    public void onFailure(Exception e) {
        this.close();
        if (this.m_connectionListener != null) {
            this.m_connectionListener.onFailure(e);
        }
        if (this.m_exceptionListener != null) {
            this.m_exceptionListener.onException(e);
        }
    }

    @Override
    public void onReconnect(String localRoutingNode) {
        if (this.m_connectionListener != null) {
            this.m_connectionListener.onReconnect(localRoutingNode);
        }
    }

    @Override
    public void onDisconnect() {
        if (this.m_connectionListener != null) {
            this.m_connectionListener.onDisconnect();
        }
    }

    private String fixupURLs(String urls) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(urls, ", ");
        InetAddress localAddr = null;
        try {
            localAddr = InetAddress.getLocalHost();
            InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            localAddr = null;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            if (i > 0) {
                sb.append(',');
            }
            String url = st.nextToken();
            String host = "";
            int index = url.indexOf("://");
            if (index > -1) {
                sb.append(url.substring(0, index + 3));
                url = url.substring(index + 3);
            }
            String string = host = (index = url.indexOf(":")) < 0 ? url : url.substring(0, index);
            if (REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST) {
                try {
                    if (localAddr != null && localAddr.equals(InetAddress.getByName(host))) {
                        host = "localhost";
                    }
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            sb.append(host);
            if (index > -1) {
                sb.append(url.substring(index));
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        DISABLE_FT_CLIENT_PROPERTY = "sonicsw.mf.disableFTClient";
        FLOW_TO_DISK_PROPERTY = "sonicsw.mf.flowToDisk";
        REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST_PROPERTY = "sonicsw.mf.replaceIPAddressOrHostNameWithLocalHost";
        INFINITE_RETRY_PROPERTY = "sonicsw.mf.infiniteRetry";
        DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
            }
        };
        String disableFTClient = System.getProperty(DISABLE_FT_CLIENT_PROPERTY, "false");
        DISABLE_FT_CLIENT = disableFTClient != null && disableFTClient.equals("true");
        FLOW_TO_DISK = System.getProperty(FLOW_TO_DISK_PROPERTY);
        String replaceWithLocalHost = System.getProperty(REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST_PROPERTY, "false");
        REPLACE_IPADDRESS_OR_HOSTNAME_WITH_LOCALHOST = replaceWithLocalHost.equalsIgnoreCase("true");
        String infiniteRetry = System.getProperty(INFINITE_RETRY_PROPERTY, "false");
        INFINITE_RETRY = infiniteRetry != null && infiniteRetry.equals("true");
        REQUEST_TIMEOUT_OVERRIDE = System.getProperty(REQUEST_TIMEOUT_OVERRIDE_PROPERTY);
        String debugTimeout = System.getProperty("debug.request.timeout");
        if (debugTimeout != null) {
            m_debugRequestTimeout = new Boolean(debugTimeout);
        }
    }

    private final class RetryCallbackManager {
        private int waiters = 0;
        private short callbackAction = (short)-1;

        private RetryCallbackManager() {
        }
    }

    private class NotificationListenerDelegate
    implements MessageListener,
    IConsumer {
        INotificationListener listener;

        private NotificationListenerDelegate(INotificationListener listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            block5: {
                try {
                    ByteArrayInputStream arrayIn;
                    BytesMessage notificationMessage = (BytesMessage)message;
                    byte[] bytes = new byte[notificationMessage.readInt()];
                    notificationMessage.readBytes(bytes);
                    ByteArrayInputStream byteArrayInputStream = arrayIn = new ByteArrayInputStream(bytes);
                    synchronized (byteArrayInputStream) {
                        ObjectInputStream in = new ObjectInputStream(arrayIn);
                        final INotification notification = (INotification)in.readObject();
                        final Object handback = in.readObject();
                        new Thread(){

                            @Override
                            public void run() {
                                NotificationListenerDelegate.this.listener.handleNotification(notification, handback);
                            }
                        }.start();
                        in.close();
                    }
                }
                catch (Throwable e) {
                    if ((ConnectorClient.this.m_traceMask & 0x20) <= 0) break block5;
                    ConnectorClient.this.logMessage("Failed to read notification, trace follows...", e, 7);
                }
            }
        }

        public void close() {
            ConnectorClient.this.m_notificationListeners.remove(this);
        }
    }

    static interface ITopicConnectionFactoryFactory {
        public TopicConnectionFactory createConnectionFactory() throws JMSException;
    }

    static interface IDurableConnectorFactory {
        public DurableConnector createDurableConnector(IDurableConnectorConsumer var1, String var2, long var3) throws InterruptedException;
    }

    private class DurableConnectorFactory
    implements IDurableConnectorFactory {
        private DurableConnectorFactory() {
        }

        @Override
        public DurableConnector createDurableConnector(IDurableConnectorConsumer consumer, String consumerType, long timeout) throws InterruptedException {
            return new DurableConnector(consumer, consumerType, timeout);
        }
    }

    private class TopicConnectionFactoryFactory
    implements ITopicConnectionFactoryFactory {
        private TopicConnectionFactoryFactory() {
        }

        @Override
        public TopicConnectionFactory createConnectionFactory() throws JMSException {
            return new TopicConnectionFactory();
        }
    }
}

