/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.comm.jms;

import com.sonicsw.mf.comm.IConnectionListener;
import com.sonicsw.mf.comm.IDurableConnectorConsumer;
import com.sonicsw.mf.comm.IGlobalComponentListener;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.comm.jms.ConnectionStateManager;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.comm.jms.MessageSizeValidator;
import com.sonicsw.mf.common.IConsumer;
import com.sonicsw.mf.common.MFConnectAbortedException;
import com.sonicsw.mf.common.MFRuntimeException;
import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.MgmtMsgTooBigException;
import com.sonicsw.mf.common.runtime.IStateListener;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import progress.message.client.EAnonymousConnectionDisallowed;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EInvalidApplicationId;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.client.EInvalidUserId;
import progress.message.client.ENetworkFailure;
import progress.message.client.EParameterIsNull;
import progress.message.client.EPasswordExpired;
import progress.message.client.ESecurityGeneralException;
import progress.message.client.ESecurityPolicyViolation;
import progress.message.client.EUnauthorizedClient;
import progress.message.client.EUnknownBrokerHost;
import progress.message.client.EUserAlreadyConnected;
import progress.message.jclient.ConnectionStateChangeListener;
import progress.message.jclient.TopicConnection;
import progress.message.jclient.TopicSession;
import progress.message.jimpl.Connection;

public class DurableConnector {
    private static boolean DEBUG_TRACE_CONNECTION_STATE = false;
    private static final boolean DEBUG_TRACE_PUBLISH = false;
    private static final boolean DEBUG_TRACE_SUBSCRIBE = false;
    private IDurableConnectorConsumer m_consumer;
    private String m_consumerType;
    private String m_localRoutingNodeName;
    private boolean m_connectionEnterpriseEnabled;
    private ConnectionProxy m_connectionProxy;
    private ConnectThread m_connectThread;
    private Object m_connectThreadLockObj = new Object();
    private boolean connectThreadLocked = true;
    private long m_lastPublishTime = System.currentTimeMillis();
    private boolean m_isCleanupPending = false;
    private Exception m_lastConnectionException;
    private boolean m_connectionRetryLogged = false;
    private int m_deliveryMode = 2;
    private JMSException m_permanentFailureException;
    private ConnectionStateManager m_stateManager;
    private MessageSizeValidator m_msgSizeValidator;
    public static final long DURABLE_SUBSCRIPTION_TTL;
    private static final long DURABLE_SUBSCRIPTION_TTL_DEFAULT = 0x6DDD00L;
    private static final String DURABLE_SUBSCRIPTION_TTL_PROPERTY = "sonicsw.mf.durableSubscriptionTTL";
    private static final String SKIP_INITIAL_CONNECT_PROPERTY = "sonicsw.mf.skipInitialConnect";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DurableConnector(IDurableConnectorConsumer consumer, String consumerType, long timeout) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        String tr = System.getProperty("enableDurableConnectorConnectionTracing");
        if (tr != null && tr.equalsIgnoreCase("true")) {
            DEBUG_TRACE_CONNECTION_STATE = true;
        }
        this.m_consumer = consumer;
        this.m_consumerType = consumerType;
        this.m_msgSizeValidator = new MessageSizeValidator(this.m_consumer);
        this.m_stateManager = new ConnectionStateManager();
        this.m_stateManager.registerStateListener(new ConnectionStateListener(), "ConnectorClient");
        TopicConnection connection = null;
        try {
            String skipInitialConnect = System.getProperty(SKIP_INITIAL_CONNECT_PROPERTY, "false");
            if ("false".equalsIgnoreCase(skipInitialConnect)) {
                connection = this.initialConnect();
            }
        }
        catch (BadParamConnectionException e) {
            MFRuntimeException re = new MFRuntimeException(e.getMessage());
            if (e.getLinkedException() != null) {
                re.setLinkedException(e.getLinkedException());
            }
            throw re;
        }
        catch (JMSException e) {
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector: JMSException thrown during attempt to establish initial connection: " + e.getMessage());
            }
            this.logFailure((Exception)((Object)e));
        }
        this.m_connectionProxy = new ConnectionProxy(connection);
        if (connection != null) {
            try {
                this.m_connectionProxy.setupContext(connection);
            }
            catch (JMSException je) {
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("JMSException thrown during initial attempt to establish connection context, je = " + je.getMessage());
                }
                this.m_permanentFailureException = je;
                this.m_connectionProxy.cleanup();
                RuntimeException rte = new RuntimeException("JMSException encountered while trying to establish initial connection context");
                rte.initCause(je);
                throw rte;
            }
        }
        this.m_connectThread = new ConnectThread(this.m_connectionProxy);
        Object object = this.m_connectThreadLockObj;
        synchronized (object) {
            this.m_connectThread.start();
            if (this.m_consumer.getClass().equals(ConnectorClient.class) && connection == null) {
                try {
                    if (timeout == 0L) {
                        while (this.connectThreadLocked) {
                            this.m_connectThreadLockObj.wait(timeout);
                        }
                    } else {
                        long waitTime = timeout - (System.currentTimeMillis() - startTime);
                        while (waitTime > 0L && this.connectThreadLocked) {
                            this.m_connectThreadLockObj.wait(waitTime);
                            waitTime = timeout - (System.currentTimeMillis() - startTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                    this.cleanup();
                    throw new MFConnectAbortedException("Connect attempt to management broker interrupted.");
                }
                finally {
                    this.connectThreadLocked = true;
                }
            }
        }
    }

    public void setDeliveryMode(int deliveryMode) {
        this.m_deliveryMode = deliveryMode;
    }

    public void cleanupPending() {
        this.m_isCleanupPending = true;
    }

    public final void cleanup() {
        this.cleanupPending();
        if (this.m_connectThread != null) {
            this.m_connectThread.cleanup();
        }
        if (this.m_connectionProxy != null) {
            this.m_connectionProxy.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void publish(String subject, Message message, long timeout, long ttl, Object[] requestArray) throws JMSException, MgmtMsgTooBigException {
        traceEx = null;
        timeoutAtTime = System.currentTimeMillis() + timeout;
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                publisher = this.m_connectionProxy.getTopicPublisher();
                if (System.currentTimeMillis() >= timeoutAtTime) {
                    throw publisher == null ? new InvokeTimeoutCommsException(subject) : new InvokeTimeoutException(subject);
                }
                replyTo = message.getStringProperty("JMS_SonicMQ_mf_reply_subject");
                if (replyTo != null) {
                    message.setStringProperty("JMS_SonicMQ_mf_reply_subject", this.m_localRoutingNodeName + "::" + replyTo.substring(index += (index = replyTo.indexOf("::")) == -1 ? 1 : 2));
                }
                this.m_msgSizeValidator.validate(message, subject);
                index = requestArray;
                synchronized (index) {
                    if (requestArray[3] != null) {
                        return;
                    }
                }
                index = publisher;
                synchronized (index) {
                    publisher.publish((Topic)new progress.message.jimpl.Topic(subject, true), message, this.m_deliveryMode, publisher.getPriority(), ttl);
                }
                this.m_lastPublishTime = System.currentTimeMillis();
            }
            catch (JMSException e) {
                if (e.getLinkedException() instanceof EUnauthorizedClient) {
                    throw e;
                }
                if (this.m_isCleanupPending) {
                    return;
                }
                if (this.m_connectionProxy != null) {
                    this.m_connectionProxy.onException(e);
                }
                var12_11 = this;
                synchronized (var12_11) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException ie1) {
                        // empty catch block
                    }
                }
                if (!this.m_isCleanupPending) ** GOTO lbl-1000
                return;
            }
            catch (NullPointerException npe) {
                if (this.m_permanentFailureException != null) {
                    throw this.m_permanentFailureException;
                }
                if (this.m_isCleanupPending) {
                    return;
                }
                var12_11 = this;
                synchronized (var12_11) {
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException ie2) {
                        // empty catch block
                    }
                    continue;
                }
                if (!this.m_isCleanupPending) continue;
                return;
            }
            break;
        }
    }

    public IConsumer subscribe(String subject, String subscriptionName, MessageListener msgListener, IGlobalComponentListener globalComponentListener) throws JMSException {
        Subscription subscription = new Subscription(subject, subscriptionName, msgListener, globalComponentListener);
        if (this.m_connectionProxy != null) {
            this.m_connectionProxy.subscribe(subscription);
        }
        return subscription;
    }

    Thread getConnectThread() {
        return this.m_connectThread;
    }

    String getLocalRoutingNodeName() {
        String localRoutingNodeName = null;
        short currentConnectionState = this.m_stateManager.getState("ConnectorClient");
        switch (currentConnectionState) {
            case 2: {
                localRoutingNodeName = this.m_localRoutingNodeName;
                break;
            }
            default: {
                localRoutingNodeName = null;
            }
        }
        return localRoutingNodeName;
    }

    public boolean isConnectionEnterpriseEnabled() {
        return this.m_connectionEnterpriseEnabled;
    }

    public boolean isConnected() {
        short currentState = this.m_stateManager.getState("ConnectorClient");
        return currentState == 2;
    }

    private synchronized boolean logFailure(Exception currentException) {
        if (currentException instanceof JMSException && ((JMSException)((Object)currentException)).getLinkedException() != null) {
            currentException = ((JMSException)((Object)currentException)).getLinkedException();
        }
        Exception lastException = this.m_lastConnectionException;
        boolean retryLogged = this.m_connectionRetryLogged;
        boolean log = false;
        if (lastException == null) {
            log = true;
        } else if (!currentException.getClass().getName().equals(lastException.getClass().getName())) {
            log = true;
        } else if (currentException.getMessage() != null && !currentException.getMessage().equals(lastException.getMessage())) {
            log = true;
        }
        if (this.m_isCleanupPending) {
            return false;
        }
        if (log) {
            if ((this.m_consumer.getTraceMask() & 0x40) > 0) {
                this.m_consumer.logMessage(this.m_consumerType + " connect failure, trace follows...", currentException, 7);
            } else {
                StringBuffer sb = new StringBuffer(this.m_consumerType + " connect failure: ");
                if (currentException instanceof EUnknownBrokerHost) {
                    sb.append(currentException.getMessage());
                } else if (currentException instanceof ENetworkFailure) {
                    sb.append(currentException.getMessage());
                } else {
                    sb.append(currentException.toString());
                }
                this.m_consumer.logMessage(sb.toString(), 2);
            }
            retryLogged = true;
            this.m_consumer.logMessage("..." + this.m_consumerType.toLowerCase() + " connect failed, retrying...", 3);
        } else if (retryLogged && (this.m_consumer.getTraceMask() & 0x40) > 0) {
            this.m_consumer.logMessage("..." + this.m_consumerType.toLowerCase() + " connect retry failed, retrying...", 7);
        }
        this.m_lastConnectionException = currentException;
        this.m_connectionRetryLogged = retryLogged;
        return log;
    }

    private void unsubscribe(Subscription subscription) {
        ConnectionProxy connectionProxy = this.m_connectionProxy;
        if (connectionProxy != null) {
            try {
                connectionProxy.unsubscribe(subscription);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public progress.message.jclient.Connection getConnection() {
        return this.m_connectionProxy.getTopicConnection();
    }

    private TopicConnection initialConnect() throws JMSException, BadParamConnectionException {
        short currentState = this.m_stateManager.getState("ConnectorClient");
        if (currentState == 0) {
            try {
                this.m_stateManager.requestStateChange(currentState, (short)1, "ConnectorClient");
            }
            catch (RecoverableStateChangeException sce) {
            }
            catch (NonRecoverableStateChangeException sce) {}
        } else {
            throw new RuntimeException("Unexpected connection state before connect attempt; connection state == " + currentState);
        }
        if (DEBUG_TRACE_CONNECTION_STATE) {
            System.out.println("DurableConnector.initialConnect: just before invoking createTopicConnection, currentState = " + this.m_stateManager.getState("ConnectorClient"));
        }
        TopicConnection connection = null;
        try {
            block32: {
                connection = (TopicConnection)this.m_consumer.getConnectionFactory().createTopicConnection();
                currentState = this.m_stateManager.getState("ConnectorClient");
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.initialConnect: after createTopicConnection, currentState = " + currentState);
                }
                if (currentState == 1) {
                    try {
                        this.m_stateManager.requestStateChange(currentState, (short)2, "ConnectorClient");
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.initialConnect: after requesting state change, current conn State = " + this.m_stateManager.getState("ConnectorClient"));
                        }
                        break block32;
                    }
                    catch (RecoverableStateChangeException sce) {
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.initialConnect: there's no way that we should be here...");
                        }
                        break block32;
                    }
                    catch (NonRecoverableStateChangeException sce) {
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.initialConnect: there's no way that we should be here...");
                        }
                        break block32;
                    }
                }
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.initialConnect: a RuntimeException before connect attempt...");
                }
                throw new RuntimeException("Unexpected connection state after successful connect attempt; connection state == " + currentState);
            }
            this.m_localRoutingNodeName = connection.getRoutingNodeName();
            this.m_connectionEnterpriseEnabled = connection.isEnterpriseEnabled();
            this.m_consumer.logMessage(this.m_consumerType + " connection (re)established (" + ((Connection)connection).getZConnection().getSocket().toString() + ')', 3);
            this.m_lastConnectionException = null;
            this.m_connectionRetryLogged = false;
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector.initialConnect: before exiting method, currentState = " + this.m_stateManager.getState("ConnectorClient"));
            }
        }
        catch (JMSException je) {
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector.initialConnect: during createTopicConnection attempt, JMSException thrown, je = " + je.getMessage());
            }
            Exception e = je.getLinkedException();
            String classname = "";
            if (e != null) {
                classname = e.getClass().getName();
            }
            if (e == null || e instanceof EInvalidSubjectSyntax || e instanceof EParameterIsNull || e instanceof EInvalidUserId || e instanceof EInvalidApplicationId || e instanceof EUserAlreadyConnected || !classname.startsWith("progress.message")) {
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.initialConnect: reset to initial state, e = " + e);
                }
                currentState = this.m_stateManager.getState("ConnectorClient");
                this.resetConnectionStateOnException(currentState);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (e instanceof EUserAlreadyConnected) {
                    throw new BadParamConnectionException("User already connected", e);
                }
                throw new BadParamConnectionException(e == null ? "Unknown connection setup failure; connection state=" + currentState : (e.getMessage() == null || e.getMessage().length() == 0 ? "" : e.getMessage() + "; ") + "connection state=" + currentState, e);
            }
            if (e instanceof ESecurityPolicyViolation || e instanceof ESecurityGeneralException || e instanceof EPasswordExpired || e instanceof EUnauthorizedClient || e instanceof EAnonymousConnectionDisallowed) {
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.initialConnect: doubt that we are here..., e = " + e);
                }
                currentState = this.m_stateManager.getState("ConnectorClient");
                this.resetConnectionStateOnException(currentState);
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                MFSecurityException securityException = new MFSecurityException("Failed to connect to the management broker due to authentication failure; connection state=" + currentState);
                securityException.setLinkedException(e);
                throw securityException;
            }
            currentState = this.m_stateManager.getState("ConnectorClient");
            this.resetConnectionStateOnException(currentState);
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector.initialConnect: simply rethrowing the exception...");
            }
            throw je;
        }
        return connection;
    }

    private TopicConnection subsequentConnect() throws JMSException, BadParamConnectionException {
        TopicConnection connection = (TopicConnection)this.m_consumer.getConnectionFactory().createTopicConnection();
        this.m_localRoutingNodeName = connection.getRoutingNodeName();
        this.m_connectionEnterpriseEnabled = connection.isEnterpriseEnabled();
        return connection;
    }

    private void resetConnectionStateOnException(short currentState) {
        if (currentState == 1) {
            try {
                this.m_stateManager.requestStateChange(currentState, (short)0, "ConnectorClient");
            }
            catch (RecoverableStateChangeException sce) {
            }
            catch (NonRecoverableStateChangeException sce) {}
        } else if (currentState == 2) {
            try {
                this.m_stateManager.requestStateChange(currentState, (short)0, "ConnectorClient");
            }
            catch (RecoverableStateChangeException sce) {
            }
            catch (NonRecoverableStateChangeException sce) {}
        } else if (currentState == 0) {
            try {
                this.m_stateManager.requestStateChange(currentState, (short)0, "ConnectorClient");
            }
            catch (RecoverableStateChangeException sce) {
            }
            catch (NonRecoverableStateChangeException nonRecoverableStateChangeException) {}
        } else {
            throw new RuntimeException("Unexpected connection state after unsuccessful connect attempt; connection state=" + currentState);
        }
    }

    static {
        String durableSubscriptionTTL = System.getProperty(DURABLE_SUBSCRIPTION_TTL_PROPERTY);
        DURABLE_SUBSCRIPTION_TTL = durableSubscriptionTTL == null ? 0x6DDD00L : Long.parseLong(durableSubscriptionTTL);
    }

    public final class ConnectionStateListener
    implements IStateListener {
        public void stateChanging(short currentState, short intendedState) {
            if ((DurableConnector.this.m_consumer.getTraceMask() & 0x80) > 0) {
                DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection state changing from state=" + currentState + " to state= " + intendedState, 7);
            }
        }

        public void stateChanged(short previousState, short currentState) {
            if ((DurableConnector.this.m_consumer.getTraceMask() & 0x80) > 0) {
                DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection state successfully changed from state=" + previousState + " to state= " + currentState, 7);
            }
        }

        public void stateChangeFailed(short currentState, short intendedState) {
            if ((DurableConnector.this.m_consumer.getTraceMask() & 0x80) > 0) {
                DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection state failed to change from state=" + currentState + " to state= " + intendedState, 7);
            }
        }
    }

    private final class ConnectionProxy
    implements ExceptionListener,
    ConnectionStateChangeListener {
        private TopicConnection connection;
        private ProxyExceptionListener proxyExceptionListener;
        private ProxyConnectionStateChangeListener proxyConnectionStateChangeListener;
        private javax.jms.TopicSession session;
        private TopicPublisher publisher;
        private HashMap subscriptions = new HashMap();
        private boolean isActive = true;

        private ConnectionProxy(TopicConnection connection) {
            this.connection = connection;
        }

        public TopicConnection getTopicConnection() {
            return this.connection;
        }

        public TopicPublisher getTopicPublisher() {
            return this.publisher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setupContext(TopicConnection connection) throws JMSException {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                if (this.proxyExceptionListener != null) {
                    this.proxyExceptionListener.deactivate();
                }
                if (this.proxyConnectionStateChangeListener != null) {
                    this.proxyConnectionStateChangeListener.active = false;
                }
                this.proxyExceptionListener = new ProxyExceptionListener();
                this.proxyConnectionStateChangeListener = new ProxyConnectionStateChangeListener();
                this.connection = connection;
                this.session = null;
                this.session = this.connection.createTopicSession(false, 3);
                this.createSubscriptions();
                TopicPublisher publisher = this.session.createPublisher(null);
                publisher.setDeliveryMode(DurableConnector.this.m_deliveryMode);
                connection.setExceptionListener((ExceptionListener)this.proxyExceptionListener);
                connection.setConnectionStateChangeListener((ConnectionStateChangeListener)new ProxyConnectionStateChangeListener());
                this.publisher = publisher;
                this.isActive = true;
            }
        }

        private void cleanup() {
            this.resetForReconnectAttempt();
            this.isActive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetForReconnectAttempt() {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                Connection connection;
                if (this.proxyExceptionListener != null) {
                    this.proxyExceptionListener.deactivate();
                }
                if (this.proxyConnectionStateChangeListener != null) {
                    this.proxyConnectionStateChangeListener.active = false;
                }
                if ((connection = (Connection)this.connection) != null) {
                    if (connection.getConnectionState() < 2) {
                        try {
                            connection.stop();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        Object[] subscriptions = this.subscriptions.keySet().toArray();
                        for (int i = 0; i < subscriptions.length; ++i) {
                            Subscription subscription = (Subscription)subscriptions[i];
                            Object[] details = (Object[])this.subscriptions.get(subscription);
                            try {
                                ((TopicSubscriber)details[1]).close();
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (subscription.subscriptionName == null) continue;
                            try {
                                ((javax.jms.TopicSession)details[0]).unsubscribe(subscription.subscriptionName);
                                continue;
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.publisher = null;
                this.session = null;
                this.connection = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribe(Subscription subscription) throws JMSException {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                if (this.isActive) {
                    this.subscriptions.put(subscription, new Object[]{null, null});
                    if (this.session != null) {
                        this.createSubscriptions();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unsubscribe(Subscription subscription) {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                Object[] details;
                if (this.isActive && (details = (Object[])this.subscriptions.remove(subscription)) != null) {
                    try {
                        ((TopicSubscriber)details[1]).close();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        ((javax.jms.TopicSession)details[0]).unsubscribe(subscription.subscriptionName);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createSubscriptions() throws JMSException {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                String subscriptionName = null;
                IGlobalComponentListener globalComponentListener = null;
                boolean stopped = false;
                try {
                    if (this.session != null) {
                        this.connection.stop();
                        stopped = true;
                    }
                    Object[] entries = this.subscriptions.entrySet().toArray();
                    for (int i = 0; i < entries.length; ++i) {
                        Map.Entry entry = (Map.Entry)entries[i];
                        Subscription subscription = (Subscription)entry.getKey();
                        Object[] details = (Object[])entry.getValue();
                        javax.jms.TopicSession session = (javax.jms.TopicSession)details[0];
                        TopicSubscriber subscriber = (TopicSubscriber)details[1];
                        if (subscriber != null) {
                            if (session == this.session) continue;
                            try {
                                subscriber.close();
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        if (this.session == null) continue;
                        subscriptionName = subscription.subscriptionName;
                        globalComponentListener = subscription.globalComponentListener;
                        if (subscription.subscriptionName == null) {
                            subscriber = this.session.createSubscriber(subscription.topic);
                        } else {
                            try {
                                subscriber = ((TopicSession)this.session).createDurableSubscriber(subscription.topic, subscription.subscriptionName, DURABLE_SUBSCRIPTION_TTL);
                            }
                            catch (JMSException e) {
                                Exception le = e.getLinkedException();
                                if (le != null && le instanceof EUserAlreadyConnected && globalComponentListener != null) {
                                    StringTokenizer st = new StringTokenizer(subscriptionName, "/");
                                    st.nextToken();
                                    globalComponentListener.globalComponentAlreadyExists(st.nextToken());
                                    details[0] = null;
                                    details[1] = null;
                                    continue;
                                }
                                throw e;
                            }
                        }
                        subscriber.setMessageListener(subscription.listener);
                        details[0] = this.session;
                        details[1] = subscriber;
                    }
                }
                catch (JMSSecurityException e) {
                    throw e;
                }
                catch (JMSException e) {
                    Exception le = e.getLinkedException();
                    if (le != null && le instanceof EUserAlreadyConnected) {
                        DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + "connection: Identity already in use: " + subscriptionName, 1);
                        DurableConnector.this.m_consumer.logMessage("Aborting container", 1);
                        throw e;
                    }
                    return;
                }
                finally {
                    if (this.session != null && stopped) {
                        this.connection.start();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isConnected() {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                return this.publisher != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onException(JMSException exception, TopicConnection exceptionProducer) {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                if (exceptionProducer == null || exceptionProducer != this.connection) {
                    return;
                }
                this.onException(exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException exception) {
            DurableConnector durableConnector = DurableConnector.this;
            synchronized (durableConnector) {
                if (this.connection == null) {
                    return;
                }
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("ConnectionProxy.onException: JMSException, e = " + exception.getMessage());
                }
                if (!DurableConnector.this.m_isCleanupPending) {
                    Throwable currentException = exception;
                    if (exception.getLinkedException() != null) {
                        currentException = exception.getLinkedException();
                    }
                    DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection dropped", 2);
                    if ((DurableConnector.this.m_consumer.getTraceMask() & 0x40) > 0) {
                        DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection failure, trace follows...", currentException, 7);
                    }
                    DurableConnector.this.m_consumer.logMessage("...trying to reconnect...", 3);
                }
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.ConnectionProxy.onException: before update, current state = " + DurableConnector.this.m_stateManager.getState("ConnectorClient"));
                }
                this.updateConnectionState();
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.ConnectionProxy.onException: after update, current state = " + DurableConnector.this.m_stateManager.getState("ConnectorClient"));
                }
                DurableConnector.this.notifyAll();
            }
            Exception e = exception.getLinkedException();
            if (exception instanceof IllegalStateException || e != null && (e instanceof EConnectionLimitExceeded || e instanceof ENetworkFailure || e instanceof IOException)) {
                IConnectionListener listener = DurableConnector.this.m_consumer.getConnectionListener();
                if (listener != null) {
                    listener.onDisconnect();
                }
            } else {
                DurableConnector.this.m_consumer.onFailure((Exception)((Object)exception));
            }
        }

        public void connectionStateChanged(int state) {
            if (state == 0) {
                DurableConnector.this.m_localRoutingNodeName = this.connection.getRoutingNodeName();
                DurableConnector.this.m_connectionEnterpriseEnabled = ((Connection)this.connection).getZConnection().isEnterpriseEdition();
            }
        }

        private void updateConnectionState() {
            short currentConnState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector.ConnectionProxy.updateConnectionState: currentConnState = " + currentConnState);
            }
            boolean success = false;
            switch (currentConnState) {
                case 0: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    try {
                        success = DurableConnector.this.m_stateManager.requestStateChange(currentConnState, (short)0, "ConnectorClient");
                        if (!success) break;
                        DurableConnector.this.m_connectionProxy.resetForReconnectAttempt();
                        break;
                    }
                    catch (RecoverableStateChangeException nrsce) {
                        break;
                    }
                    catch (NonRecoverableStateChangeException nonRecoverableStateChangeException) {
                        // empty catch block
                    }
                }
            }
            if (DEBUG_TRACE_CONNECTION_STATE) {
                System.out.println("DurableConnector.ConnectionProxy.updateConnectionState: prior to return, currentConnState = " + DurableConnector.this.m_stateManager.getState("ConnectorClient"));
            }
        }

        private class ProxyConnectionStateChangeListener
        implements ConnectionStateChangeListener {
            private boolean active = true;

            private ProxyConnectionStateChangeListener() {
            }

            public void connectionStateChanged(int state) {
                if (this.active) {
                    ConnectionProxy.this.connectionStateChanged(state);
                }
            }
        }

        private class ConnException {
            private JMSException m_exception;
            private TopicConnection m_connectionProducer;

            ConnException(JMSException exception, TopicConnection connectionProducer) {
                this.m_exception = exception;
                this.m_connectionProducer = connectionProducer;
            }
        }

        private class ProxyExceptionListener
        implements ExceptionListener {
            private final int MAX_LIST_SIZE = 50;
            private volatile boolean m_activeObject = true;
            private ArrayList m_exceptionList = new ArrayList();

            ProxyExceptionListener() {
                Thread exceptionProcessor = new Thread("com.sonicsw.mf.comm.jms.ConnectionProxy.ProxyExceptionListener Exception Processor thread"){

                    @Override
                    public void run() {
                        while (ProxyExceptionListener.this.m_activeObject) {
                            ProxyExceptionListener.this.processExceptions();
                        }
                    }
                };
                exceptionProcessor.setDaemon(true);
                exceptionProcessor.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(JMSException exception) {
                ProxyExceptionListener proxyExceptionListener = this;
                synchronized (proxyExceptionListener) {
                    if (this.m_activeObject) {
                        this.m_exceptionList.add(new ConnException(exception, ConnectionProxy.this.connection));
                        if (this.m_exceptionList.size() >= 50) {
                            this.m_exceptionList.remove(0);
                        }
                        this.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void processExceptions() {
                ConnException connException = null;
                ProxyExceptionListener proxyExceptionListener = this;
                synchronized (proxyExceptionListener) {
                    while (this.m_exceptionList.isEmpty()) {
                        try {
                            this.wait();
                            if (this.m_activeObject) continue;
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                    connException = (ConnException)this.m_exceptionList.remove(0);
                }
                if (this.m_activeObject) {
                    ConnectionProxy.this.onException(connException.m_exception, connException.m_connectionProducer);
                }
            }

            private synchronized void deactivate() {
                this.m_activeObject = false;
                this.notifyAll();
            }

            public void finalize() {
                this.deactivate();
            }
        }
    }

    private final class ConnectThread
    extends Thread {
        private boolean needsToConnect;
        private boolean isActive;

        private ConnectThread(ConnectionProxy connectionProxy) {
            super("Durable Connect [" + DurableConnector.this.m_consumerType + "]");
            this.isActive = true;
            this.needsToConnect = connectionProxy.getTopicConnection() == null;
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TopicConnection connection = null;
            ConnectionProxy connProxy = null;
            while (this.stayConnected()) {
                boolean needToSetProxy = false;
                if (this.needsToConnect) {
                    needToSetProxy = true;
                    short currentConnState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                    if (DEBUG_TRACE_CONNECTION_STATE) {
                        System.out.println("DurableConnector.ConnectThread.run: currentConnState = " + currentConnState);
                    }
                    connection = null;
                    try {
                        switch (currentConnState) {
                            case 0: {
                                if (DEBUG_TRACE_CONNECTION_STATE) {
                                    System.out.println("DurableConnector.ConnectThread.run: create connection, current connection state = " + currentConnState);
                                }
                                connection = this.createConnection(currentConnState);
                                connProxy = DurableConnector.this.m_connectionProxy;
                                break;
                            }
                            default: {
                                if (DEBUG_TRACE_CONNECTION_STATE) {
                                    System.out.println("DurableConnector.ConnectThread.run: Unexpected connection state during connect attempt, current connection state = " + currentConnState);
                                }
                                if ((DurableConnector.this.m_consumer.getTraceMask() & 0x80) > 0) {
                                    DurableConnector.this.m_consumer.logMessage("Unexpected " + DurableConnector.this.m_consumerType.toLowerCase() + " connection state during connect attempt, state=" + currentConnState, 7);
                                }
                                throw new RuntimeException("Unexpected " + DurableConnector.this.m_consumerType.toLowerCase() + " connection state encountered while attempting to establish connection in background, state=" + currentConnState);
                            }
                        }
                    }
                    catch (BadParamConnectionException e) {
                        Thread failureHandler = new Thread("Durable Connector - Failure Handler"){

                            @Override
                            public void run() {
                                if (DurableConnector.this.m_isCleanupPending) {
                                    return;
                                }
                                DurableConnector.this.m_consumer.onFailure((Exception)((Object)e));
                            }
                        };
                        failureHandler.setDaemon(true);
                        failureHandler.start();
                        return;
                    }
                    catch (MFSecurityException e) {
                        Thread securityHandler = new Thread("Durable Connector - Security Failure Handler"){

                            @Override
                            public void run() {
                                if (DurableConnector.this.m_isCleanupPending) {
                                    return;
                                }
                                DurableConnector.this.m_consumer.onFailure((Exception)((Object)e));
                            }
                        };
                        securityHandler.setDaemon(true);
                        securityHandler.start();
                        return;
                    }
                    catch (JMSException je) {
                        short currConnState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.ConnectThread.run: JMS exception thrown, curr connection state = " + currConnState + ", je = " + je.getMessage());
                        }
                        DurableConnector.this.resetConnectionStateOnException(currConnState);
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.ConnectThread.run: after reset on exception, current conn state = " + currConnState);
                        }
                        if (DurableConnector.this.m_isCleanupPending) break;
                        Thread disconnectThread = new Thread("Durable Connector - Disconnect Handler"){

                            @Override
                            public void run() {
                                if (DurableConnector.this.m_isCleanupPending) {
                                    return;
                                }
                                DurableConnector.this.m_consumer.onDisconnect();
                            }
                        };
                        disconnectThread.setDaemon(true);
                        disconnectThread.start();
                    }
                    if (DEBUG_TRACE_CONNECTION_STATE) {
                        System.out.println("DurableConnector.ConnectThread.run: connection = " + connection + ", curr conn state = " + DurableConnector.this.m_stateManager.getState("ConnectorClient") + ", needToSetProxy = " + needToSetProxy);
                    }
                    if (connection == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                } else {
                    needToSetProxy = false;
                }
                if (needToSetProxy) {
                    try {
                        connProxy.setupContext(connection);
                    }
                    catch (JMSException e) {
                        if (DEBUG_TRACE_CONNECTION_STATE) {
                            System.out.println("DurableConnector.ConnectThread.run: JMSException thrown while trying to establish context, connection state = " + DurableConnector.this.m_stateManager.getState("ConnectorClient") + ", e = " + e.getMessage());
                        }
                        JMSException ex = e;
                        final Exception le = e.getLinkedException();
                        if (le != null) {
                            if (DEBUG_TRACE_CONNECTION_STATE) {
                                System.out.println("DurableConnector.ConnectThread.run: Linked exception message = " + le.getMessage());
                            }
                            if (le instanceof EUserAlreadyConnected || le instanceof EUnauthorizedClient) {
                                if (!(le instanceof EUserAlreadyConnected)) {
                                    DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + "connection: Unauthorized access", 1);
                                }
                                DurableConnector.this.m_permanentFailureException = e;
                                Thread duplicateHandler = new Thread("Durable Connector - Duplicate Handler"){

                                    @Override
                                    public void run() {
                                        DurableConnector.this.m_consumer.onFailure(le);
                                    }
                                };
                                duplicateHandler.setDaemon(true);
                                duplicateHandler.start();
                                return;
                            }
                            DurableConnector.this.logFailure(le);
                            short currentState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                            DurableConnector.this.resetConnectionStateOnException(currentState);
                            continue;
                        }
                        if (ex instanceof IllegalStateException) {
                            DurableConnector.this.logFailure((Exception)((Object)ex));
                            short currentState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                            DurableConnector.this.resetConnectionStateOnException(currentState);
                            continue;
                        }
                        DurableConnector.this.m_permanentFailureException = e;
                        final String errMsg = e.getMessage();
                        Thread duplicateHandler = new Thread("Durable Connector - Duplicate Handler", (Exception)((Object)ex)){
                            final /* synthetic */ Exception val$ex;
                            {
                                this.val$ex = exception;
                                super(x0);
                            }

                            @Override
                            public void run() {
                                DurableConnector.this.m_consumer.logMessage(errMsg, this.val$ex, 1);
                                DurableConnector.this.m_consumer.onFailure(this.val$ex);
                            }
                        };
                        duplicateHandler.setDaemon(true);
                        duplicateHandler.start();
                        return;
                    }
                    finally {
                        Object object = DurableConnector.this.m_connectThreadLockObj;
                        synchronized (object) {
                            DurableConnector.this.connectThreadLocked = false;
                            DurableConnector.this.m_connectThreadLockObj.notifyAll();
                        }
                        object = DurableConnector.this;
                        synchronized (object) {
                            DurableConnector.this.notifyAll();
                            continue;
                        }
                    }
                }
                Object e = DurableConnector.this.m_connectThreadLockObj;
                synchronized (e) {
                    DurableConnector.this.connectThreadLocked = false;
                    DurableConnector.this.m_connectThreadLockObj.notifyAll();
                }
                e = DurableConnector.this;
                synchronized (e) {
                    DurableConnector.this.notifyAll();
                }
                short currConnState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                if (currConnState == 2) {
                    Thread reconnectHandler = new Thread("Durable Connector - Reconnect Handler"){

                        @Override
                        public void run() {
                            if (DurableConnector.this.m_isCleanupPending) {
                                return;
                            }
                            DurableConnector.this.m_consumer.onReconnect(DurableConnector.this.m_localRoutingNodeName);
                        }
                    };
                    reconnectHandler.setDaemon(true);
                    reconnectHandler.start();
                }
                DurableConnector durableConnector = DurableConnector.this;
                synchronized (durableConnector) {
                    block89: {
                        try {
                            this.needsToConnect = this.isConnectAttemptRequired();
                            if (!this.needsToConnect) {
                                DurableConnector.this.wait();
                                if (DEBUG_TRACE_CONNECTION_STATE) {
                                    System.out.println("DurableConnector.ConnectorThread.run: ConnectThread notified, current connection state = " + DurableConnector.this.m_stateManager.getState("ConnectorClient"));
                                }
                                if (!this.stayConnected()) {
                                    break;
                                }
                                this.needsToConnect = this.isConnectAttemptRequired();
                            }
                            if (DEBUG_TRACE_CONNECTION_STATE) {
                                System.out.println("DurableConnector.ConnectorThread.run: lost connection, need to reconnect = " + this.needsToConnect);
                            }
                        }
                        catch (InterruptedException ie) {
                            if ((DurableConnector.this.m_consumer.getTraceMask() & 0x80) > 0) {
                                DurableConnector.this.m_consumer.logMessage("InterruptedException thrown while " + DurableConnector.this.m_consumerType.toLowerCase() + " ConnectThread waiting, state=" + DurableConnector.this.m_stateManager.getState("ConnectorClient"), 7);
                            }
                            if (!DEBUG_TRACE_CONNECTION_STATE) break block89;
                            System.out.println("DurableConnector.ConnectorThread.run: InterruptedException thrown while ConnectThread waiting, state=" + DurableConnector.this.m_stateManager.getState("ConnectorClient"));
                        }
                    }
                }
            }
            if (DurableConnector.this.m_connectionProxy != null) {
                DurableConnector.this.m_connectionProxy.cleanup();
            }
        }

        private TopicConnection createConnection(short currentState) throws JMSException {
            try {
                DurableConnector.this.m_stateManager.requestStateChange(currentState, (short)1, "ConnectorClient");
            }
            catch (RecoverableStateChangeException sce) {
            }
            catch (NonRecoverableStateChangeException sce) {
                // empty catch block
            }
            TopicConnection connection = null;
            try {
                connection = DurableConnector.this.subsequentConnect();
                short currentConnState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                if (currentConnState == 1) {
                    try {
                        DurableConnector.this.m_stateManager.requestStateChange(currentConnState, (short)2, "ConnectorClient");
                    }
                    catch (RecoverableStateChangeException sce) {
                    }
                    catch (NonRecoverableStateChangeException sce) {}
                } else {
                    throw new RuntimeException("Unexpected connection state after successful connect attempt; connection state == " + currentConnState);
                }
                DurableConnector.this.m_consumer.logMessage(DurableConnector.this.m_consumerType + " connection (re)established (" + ((Connection)connection).getZConnection().getSocket().toString() + ')', 3);
                DurableConnector.this.m_lastConnectionException = null;
                DurableConnector.this.m_connectionRetryLogged = false;
            }
            catch (JMSException je) {
                if (DEBUG_TRACE_CONNECTION_STATE) {
                    System.out.println("DurableConnector.createConnection: JMSException, linked exception....je.msg = " + je.getMessage());
                }
                Exception e = je.getLinkedException();
                if (je instanceof IllegalStateException) {
                    this.handleIllegalStateException((IllegalStateException)je);
                    return null;
                }
                if (e != null && (e instanceof ENetworkFailure || e instanceof EConnectionLimitExceeded)) {
                    DurableConnector.this.logFailure((Exception)((Object)je));
                    try {
                        DurableConnector.this.m_stateManager.requestStateChange((short)1, (short)0, "ConnectorClient");
                    }
                    catch (RecoverableStateChangeException sce) {
                    }
                    catch (NonRecoverableStateChangeException sce) {
                        // empty catch block
                    }
                    return connection;
                }
                this.handleConnectException(je);
            }
            return connection;
        }

        private void handleConnectException(JMSException je) throws JMSException {
            Exception e = je.getLinkedException();
            String classname = "";
            if (e != null) {
                classname = e.getClass().getName();
            }
            if (e == null || e instanceof EInvalidSubjectSyntax || e instanceof EParameterIsNull || e instanceof EInvalidUserId || e instanceof EInvalidApplicationId || e instanceof EUserAlreadyConnected || !classname.startsWith("progress.message")) {
                short currentState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                DurableConnector.this.resetConnectionStateOnException(currentState);
                throw new BadParamConnectionException(e == null ? "Unknown connection setup failure; connection state = " + currentState : e.getMessage() + "; connection state = " + currentState, e);
            }
            if (e instanceof ESecurityPolicyViolation || e instanceof ESecurityGeneralException || e instanceof EPasswordExpired || e instanceof EUnauthorizedClient || e instanceof EAnonymousConnectionDisallowed) {
                short currentState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
                DurableConnector.this.resetConnectionStateOnException(currentState);
                MFSecurityException securityException = new MFSecurityException("Failed to connect to the management broker due to authentication failure; connection state=" + currentState);
                securityException.setLinkedException(e);
                throw securityException;
            }
            throw je;
        }

        private void handleIllegalStateException(IllegalStateException ex) {
            DurableConnector.this.logFailure((Exception)ex);
            short currentState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
            DurableConnector.this.resetConnectionStateOnException(currentState);
        }

        private boolean stayConnected() {
            return this.isActive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            block9: {
                Object object = DurableConnector.this.m_connectThreadLockObj;
                synchronized (object) {
                    this.isActive = false;
                    DurableConnector.this.connectThreadLocked = false;
                    DurableConnector.this.m_connectThreadLockObj.notifyAll();
                }
                object = DurableConnector.this;
                synchronized (object) {
                    DurableConnector.this.notifyAll();
                }
                try {
                    this.join(2000L);
                }
                catch (InterruptedException ie) {
                    if (!DEBUG_TRACE_CONNECTION_STATE) break block9;
                    System.out.println("DurableConnector.ConnectThread.cleanup: InterruptedException thrown while joined...");
                }
            }
            if (this.isAlive()) {
                this.interrupt();
            }
        }

        private boolean isConnectAttemptRequired() {
            short currentConnectionState = DurableConnector.this.m_stateManager.getState("ConnectorClient");
            boolean connectAttemptRequired = false;
            switch (currentConnectionState) {
                case 2: {
                    if (DurableConnector.this.m_connectionProxy.isConnected()) break;
                    connectAttemptRequired = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 0: {
                    connectAttemptRequired = true;
                    break;
                }
                case 3: {
                    connectAttemptRequired = false;
                    break;
                }
            }
            return connectAttemptRequired;
        }
    }

    private final class Subscription
    implements IConsumer {
        Topic topic;
        String subscriptionName;
        private MessageListener listener;
        IGlobalComponentListener globalComponentListener;

        private Subscription(String subject, String subscriptionName, MessageListener listener, IGlobalComponentListener globalComponentListener) {
            try {
                this.topic = new progress.message.jimpl.Topic(subject, true);
            }
            catch (JMSException e) {
                MFRuntimeException re = new MFRuntimeException();
                re.setLinkedException((Exception)((Object)e));
                throw re;
            }
            this.subscriptionName = subscriptionName;
            this.listener = listener;
            this.globalComponentListener = globalComponentListener;
        }

        public void close() {
            DurableConnector.this.unsubscribe(this);
        }
    }

    private static final class BadParamConnectionException
    extends JMSException {
        private BadParamConnectionException(String msg, Exception e) {
            super(msg);
            super.setLinkedException(e);
        }
    }
}

